/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.scanner;

import in.gov.uidai.ec.escapi.ScannerInfo;
import in.gov.uidai.ec.escapi.StationInfoStoreException;
import in.gov.uidai.ec.icas.preference.IOucDataStore;
import in.gov.uidai.ec.ui.ControllerBase;
import in.gov.uidai.ec.ui.enrol.document.DocumentUtils;
import in.gov.uidai.ec.ui.enrol.document.IDocumentsPreference;
import in.gov.uidai.ec.ui.enrol.universalClient.scanner.ScannerConfigViewPeer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.JComboBox;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScannerConfigController
extends ControllerBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScannerConfigController.class);
    private final IOucDataStore oucDataStore;
    private final ScannerConfigViewPeer viewElements;
    private final IDocumentsPreference docPref;

    public ScannerConfigController(ScannerConfigViewPeer viewElements) {
        super(viewElements.view);
        this.viewElements = viewElements;
        this.oucDataStore = viewElements.oucDataStore;
        this.docPref = viewElements.docPref;
        this.init();
    }

    private void init() {
        try {
            this.loadScannerList();
            ScannerInfo scannerInfo = this.oucDataStore.getScannerInfo();
            String scanMode = scannerInfo.getLastMode();
            if (StringUtils.isBlank((String)scanMode)) {
                this.docPref.setLastSelectedScanMode("BLACK");
                scannerInfo.setLastMode("BLACK");
                this.oucDataStore.setScannerInfo(scannerInfo);
            }
            this.addActionListener(this.viewElements.connectBut, (ActionEvent e) -> {
                this.onScannerSelect();
                ((ActionListener)this.viewElements.evtCtxt.getEventListener("closeWin", ActionListener.class)).actionPerformed(e);
            });
            this.addActionListener(this.viewElements.refreshBut, (ActionEvent e) -> this.onScannerListRefresh());
        }
        catch (IOException e2) {
            LOGGER.error("Failed to get last selected mode from OTA Update Client due to : ", (Throwable)e2);
            this.showSimpleError(this.viewElements.scannerList, "Failed to get last selected mode from OTA Update Client. Please make sure OTA Update Client is running.", new Object[0]);
        }
        catch (StationInfoStoreException e3) {
            LOGGER.error("Failed to get last selected mode from OTA Update Client due to : ", (Throwable)e3);
            this.showSimpleError(this.viewElements.scannerList, "Failed to get last selected mode from OTA Update Client.", new Object[0]);
        }
    }

    private void loadScannerList() throws IOException, StationInfoStoreException {
        ScannerInfo scannerInfo;
        this.viewElements.scannerList.removeAllItems();
        this.viewElements.scannerList.addItem("Select");
        String[] deviceList = DocumentUtils.getInstance().getScannerDeviceList();
        if (deviceList != null) {
            Arrays.stream(deviceList).forEach(device -> this.viewElements.scannerList.addItem((String)device));
        }
        if (StringUtils.isNotBlank((String)(scannerInfo = this.oucDataStore.getScannerInfo()).getLastScanner())) {
            this.viewElements.scannerList.setSelectedItem(scannerInfo.getLastScanner());
        }
        this.onScannerSelect();
    }

    public void onScannerSelect() {
        String scanner = (String)this.viewElements.scannerList.getSelectedItem();
        this.clearFieldError(this.viewElements.scannerList);
        if (StringUtils.equalsIgnoreCase((String)scanner, (String)"Select")) {
            this.showFieldError(this.viewElements.scannerList, "Select any available scanner from the list");
            return;
        }
        try {
            ScannerInfo scannerInfo = this.oucDataStore.getScannerInfo();
            String lastSelectedScanner = scannerInfo.getLastScanner();
            if (StringUtils.isBlank((String)lastSelectedScanner) || !lastSelectedScanner.equalsIgnoreCase(scanner)) {
                this.docPref.setLastSelectedScanner(scanner);
                this.viewElements.docPref.setLastSelectedScanner(scanner);
                scannerInfo.setLastScanner(scanner);
                this.oucDataStore.setScannerInfo(scannerInfo);
            }
        }
        catch (IOException e) {
            this.showInfoUC(this.viewElements.scannerList, "Failed to get last selected scanner from OTA Update Client. Please make sure OTA Update Client is running.");
        }
        catch (StationInfoStoreException e) {
            this.showInfoUC(this.viewElements.scannerList, "Failed to get last selected scanner from OTA Update Client.");
        }
    }

    public void onScannerListRefresh() {
        JComboBox<String> scannerList = this.viewElements.scannerList;
        scannerList.removeAllItems();
        scannerList.addItem("Select");
        String[] deviceList = DocumentUtils.getInstance().getScannerDeviceList();
        if (deviceList != null) {
            Arrays.stream(deviceList).forEach(scannerList::addItem);
        } else {
            this.showInfoUC(this.viewElements.refreshBut, "Failed to get device list. Please try again.");
        }
        this.onScannerSelect();
    }
}

