/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.supervisor;

import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class SupervisorAuthConfirmationPanel {
    private final EnrollmentService enrollmentService;
    protected JPanel mainPanel;
    protected JTextArea messageArea;
    protected JButton copyButton;

    public SupervisorAuthConfirmationPanel(EnrollmentService enrollmentService) {
        this.enrollmentService = enrollmentService;
        this.initComponents();
    }

    private void initComponents() {
        this.mainPanel = new JPanel(new BorderLayout(10, 10));
        this.mainPanel.setBackground(Color.WHITE);
        this.mainPanel.setPreferredSize(new Dimension(472, 150));
        String messageText = "You will be redirected to your browser to complete supervisor authentication.\nIf you are not redirected automatically, please copy the URL and open it in your browser.";
        this.messageArea = new JTextArea(messageText);
        this.messageArea.setWrapStyleWord(true);
        this.messageArea.setLineWrap(true);
        this.messageArea.setEditable(false);
        this.messageArea.setOpaque(false);
        this.messageArea.setFocusable(false);
        this.messageArea.setFont(new Font("SansSerif", 0, 14));
        this.messageArea.setForeground(Color.decode("#34495E"));
        this.messageArea.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 12));
        this.copyButton = new JButton("Copy URL");
        this.copyButton.setFont(new Font("SansSerif", 0, 12));
        this.copyButton.addActionListener(e -> {
            String url = this.enrollmentService.getSupervisorAuthUrl();
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(url), null);
            JOptionPane.showMessageDialog(this.mainPanel, "URL copied to clipboard!", "Copied", 1);
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.setOpaque(false);
        buttonPanel.add(this.copyButton);
        this.mainPanel.add((Component)this.messageArea, "Center");
        this.mainPanel.add((Component)buttonPanel, "South");
    }
}

