/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.viewPeer;

import in.gov.uidai.ec.biometrics.device.IClientDeviceManager;
import in.gov.uidai.ec.biometrics.postcap.IBioxDataProvider;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.BiometricsExceptionDetail;
import in.gov.uidai.ec.swing.shared.NavigationPanel;
import in.gov.uidai.ec.swing.shared.ViewUtils;
import in.gov.uidai.ec.ui.enrol.EnrolViewPeer;
import in.gov.uidai.ec.ui.enrol.fingerprint.FingerPrintPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.button.ButtonPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.controllers.FingerPrintControllerUC;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysTab;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.swing.ExplicitFocusTraversalPolicy;
import in.gov.uidai.swing.TransparentBox;
import in.gov.uidai.swing.l10n.L10nDecorator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;

public class FingerPrintTabViewPeerUC
implements IViewElementComposite {
    private final ILiteView view;
    private final EnrollmentService enrollmentService;
    private final IResourceBundleContext clientRbCtx;
    private final IUIPreference uiPref;
    private final IClientDeviceManager cdm;
    private final IBioxDataProvider bdp;
    public IEventContext evtCtxt;
    public FingerPrintPanel fingerPrintPanel;
    public NavigationPanel navigationPanel;
    public ButtonPanel buttonPanel;
    private TransparentBox fingerPrintTabView;
    private JTabbedPane tabbedPane;
    private int tabIndex;

    public FingerPrintTabViewPeerUC(EnrolViewPeer enrolViewPeer) {
        this.evtCtxt = enrolViewPeer.evtCtxt;
        this.cdm = enrolViewPeer.cdm;
        this.clientRbCtx = enrolViewPeer.clientRbCtxt;
        this.uiPref = enrolViewPeer.uiPref;
        this.enrollmentService = enrolViewPeer.enrollmentService;
        this.view = enrolViewPeer.getView();
        this.tabbedPane = enrolViewPeer.getTabbedPane();
        this.bdp = enrolViewPeer.bdp;
    }

    public void prepare() {
        this.fingerPrintPanel = new FingerPrintPanel(this.clientRbCtx, this.uiPref, this.cdm, this.bdp, this.enrollmentService);
        this.navigationPanel = new NavigationPanel(this.clientRbCtx, this.uiPref);
        this.buttonPanel = new ButtonPanel();
        this.fingerPrintTabView = new TransparentBox((LayoutManager)new BorderLayout(5, 5));
        this.fingerPrintTabView.add((Component)this.fingerPrintPanel.create(), (Object)"Center");
        this.fingerPrintTabView.add((Component)this.buttonPanel.create(new Component[0]), (Object)"South");
        ExplicitFocusTraversalPolicy eftp = new ExplicitFocusTraversalPolicy((Container)this.fingerPrintTabView);
        this.fingerPrintPanel.addToFocusTraversalPolicy(eftp);
        eftp.addComponent((Component)this.buttonPanel.cancelButton).addComponent((Component)this.buttonPanel.previousButton).addComponent((Component)this.buttonPanel.nextButton);
        new FingerPrintControllerUC(this.view, this, this.enrollmentService, this.uiPref.getMaxCaptureAttempts(5), this.tabIndex);
    }

    public void renderFingerTab() {
        this.tabbedPane.addTab(this.clientRbCtx.getMessage((Object)LabelKeysTab.FINGER, new Object[0]), this.toSwing());
        this.tabbedPane.setTabComponentAt(this.tabIndex, this.createFingerTabLabel());
    }

    private JLabel createFingerTabLabel() {
        String ICON_PATH = this.isTabEnable() ? "res/images/tab-error.png" : "res/images/tab-ok-disable.png";
        ImageIcon icon = ViewUtils.getImageIcon(this.getClass(), ICON_PATH);
        JLabel label = new JLabel(this.clientRbCtx.getMessage((Object)LabelKeysTab.FINGER, new Object[0]));
        new L10nDecorator(this.clientRbCtx, this.uiPref.getApplicationLocalize(false)).localize(label, (Object)LabelKeysTab.FINGER, new Object[0]);
        if (icon != null) {
            label.setIcon(icon);
        }
        label.setForeground(Color.WHITE);
        this.tabbedPane.setEnabledAt(this.tabIndex, true);
        return label;
    }

    private boolean isTabEnable() {
        BiometricsExceptionDetail fingerException = this.enrollmentService.getBiometricsException().getExceptionDetail();
        return !fingerException.isBothThumbsExceptionApplied() || !fingerException.isRightSlapExceptionApplied() || !fingerException.isLeftSlapExceptionApplied();
    }

    public int getTabIndex() {
        return this.tabIndex;
    }

    public void setTabIndex(int tabIndex) {
        this.tabIndex = tabIndex;
    }

    public JComponent toSwing() {
        return this.fingerPrintTabView;
    }
}

