/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.viewPeer;

import in.gov.uidai.ec.biometrics.device.IClientDeviceManager;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.biometricsauth.BiometricsAuthService;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.swing.shared.NavigationPanel;
import in.gov.uidai.ec.swing.shared.ViewUtils;
import in.gov.uidai.ec.ui.biometricsauth.BiometricsRDAuthController;
import in.gov.uidai.ec.ui.biometricsauth.BiometricsRDAuthPanel;
import in.gov.uidai.ec.ui.enrol.EnrolViewPeer;
import in.gov.uidai.ec.ui.enrol.photograph.ExceptionPhotoPanel;
import in.gov.uidai.ec.ui.enrol.photograph.PhotoPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.button.ButtonPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.controllers.PhotographControllerUC;
import in.gov.uidai.ec.ui.enrol.universalClient.viewPeer.ReviewTabViewPeerUC;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysTab;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.swing.ExplicitFocusTraversalPolicy;
import in.gov.uidai.swing.NucleusLayout;
import in.gov.uidai.swing.TransparentBox;
import in.gov.uidai.swing.bio.player.AbstractPreviewPlayer;
import in.gov.uidai.swing.bio.player.PreviewPlayer2;
import in.gov.uidai.swing.l10n.L10nDecorator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class PhotographTabViewPeerUC
implements IViewElementComposite {
    public final EnrollmentService enrollmentService;
    public final IUIPreference uiPref;
    private final ILiteView view;
    private final IResourceBundleContext clientRbCtxt;
    private final IClientDeviceManager cdm;
    private final boolean isUpdateEnrollment;
    private final boolean isPhotographCaptureEnabled;
    private final boolean isRdBasedUpdate;
    public IEventContext evtCtxt;
    public PhotoPanel photoPanel;
    public ExceptionPhotoPanel exceptionPhotoPanel;
    public NavigationPanel navigationPanel;
    public ButtonPanel buttonPanel;
    public BiometricsRDAuthPanel bioPanel;
    public BiometricsAuthService biometricsAuthService;
    private TransparentBox photographPanel;
    private final JTabbedPane tabbedPane;
    private int tabIndex;
    public ReviewTabViewPeerUC reviewTabUC;

    public PhotographTabViewPeerUC(EnrolViewPeer enrolViewPeer) {
        this.clientRbCtxt = enrolViewPeer.clientRbCtxt;
        this.evtCtxt = enrolViewPeer.evtCtxt;
        this.uiPref = enrolViewPeer.uiPref;
        this.cdm = enrolViewPeer.cdm;
        this.view = enrolViewPeer.getView();
        this.tabbedPane = enrolViewPeer.getTabbedPane();
        this.enrollmentService = enrolViewPeer.enrollmentService;
        this.biometricsAuthService = enrolViewPeer.biometricsAuthService;
        this.isUpdateEnrollment = this.enrollmentService.isUpdateEnrollment();
        this.isPhotographCaptureEnabled = this.enrollmentService.isPhotographCaptureEnabled();
        this.isRdBasedUpdate = this.enrollmentService.isRDBasedUpdate();
        this.reviewTabUC = enrolViewPeer.getReviewTabUC();
    }

    public void prepare() {
        this.bioPanel = new BiometricsRDAuthPanel(this.clientRbCtxt, this.uiPref, this.cdm);
        PreviewPlayer2 previewPlayer = new PreviewPlayer2();
        this.photoPanel = new PhotoPanel(this.clientRbCtxt, this.uiPref, this.cdm, (AbstractPreviewPlayer)previewPlayer, this.enrollmentService);
        this.exceptionPhotoPanel = new ExceptionPhotoPanel(this.clientRbCtxt, this.uiPref, this.cdm, (AbstractPreviewPlayer)previewPlayer, this.isUpdateEnrollment);
        this.buttonPanel = new ButtonPanel();
        TransparentBox centerPanel = new TransparentBox((LayoutManager)new NucleusLayout(5, 5));
        centerPanel.setBorder((Border)new EmptyBorder(5, 5, 5, 5));
        centerPanel.add((Component)previewPlayer, (Object)"Center");
        centerPanel.add((Component)this.photoPanel.create());
        if (!this.isPhotographCaptureEnabled) {
            this.photoPanel.getPhotoField().setEnabled(false);
        }
        centerPanel.add((Component)this.exceptionPhotoPanel.create());
        this.exceptionPhotoPanel.getExceptionPhotoField().setVisible(this.isPhotographCaptureEnabled);
        centerPanel.setOpaque(true);
        centerPanel.setBackground(Color.GRAY);
        this.photographPanel = new TransparentBox((LayoutManager)new BorderLayout(5, 5));
        this.photographPanel.add((Component)centerPanel, (Object)"Center");
        this.photographPanel.add((Component)this.buttonPanel.create(new Component[0]), (Object)"South");
        this.addTraversal();
        if (this.isRdBasedUpdate) {
            new BiometricsRDAuthController(this.view, this.bioPanel, this.biometricsAuthService);
        }
        new PhotographControllerUC(this.view, this);
    }

    private void addTraversal() {
        new ExplicitFocusTraversalPolicy((Container)this.photographPanel).addComponent((Component)this.photoPanel.getPhotoField()).addComponent((Component)this.exceptionPhotoPanel.getExceptionPhotoField()).addComponent((Component)this.buttonPanel.cancelButton).addComponent((Component)this.buttonPanel.previousButton).addComponent((Component)this.buttonPanel.nextButton);
    }

    public void renderPhotoTab() {
        this.tabbedPane.addTab(this.clientRbCtxt.getMessage((Object)LabelKeysTab.PHOTO, new Object[0]), this.toSwing());
        this.tabbedPane.setTabComponentAt(this.tabIndex, this.createPhotoTabLabel());
    }

    private JLabel createPhotoTabLabel() {
        String ICON_PATH_ERROR = "res/images/tab-error.png";
        ImageIcon icon = ViewUtils.getImageIcon(this.getClass(), ICON_PATH_ERROR);
        JLabel label = new JLabel(this.clientRbCtxt.getMessage((Object)LabelKeysTab.PHOTO, new Object[0]));
        new L10nDecorator(this.clientRbCtxt, this.uiPref.getApplicationLocalize(false)).localize(label, (Object)LabelKeysTab.PHOTO, new Object[0]);
        if (icon != null) {
            label.setIcon(icon);
        }
        label.setForeground(Color.WHITE);
        this.tabbedPane.setEnabledAt(this.tabIndex, true);
        return label;
    }

    public JComponent toSwing() {
        return this.photographPanel;
    }

    public int getTabIndex() {
        return this.tabIndex;
    }

    public void setTabIndex(int tabIndex) {
        this.tabIndex = tabIndex;
    }
}

