/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.viewPeer;

import in.gov.uidai.ec.icas.preference.IOucDataStore;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.document.DocumentType;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.swing.FixedWidthTopDownTile;
import in.gov.uidai.ec.swing.shared.ViewUtils;
import in.gov.uidai.ec.ui.enrol.EnrolViewPeer;
import in.gov.uidai.ec.ui.enrol.operator.NoticeBoardPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.button.ButtonPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.common.CommonUtilsUC;
import in.gov.uidai.ec.ui.enrol.universalClient.common.ReferenceSections;
import in.gov.uidai.ec.ui.enrol.universalClient.controllers.ReferenceControllerUC;
import in.gov.uidai.ec.ui.enrol.universalClient.reference.ReferencePanel;
import in.gov.uidai.ec.ui.enrol.universalClient.viewPeer.FingerPrintTabViewPeerUC;
import in.gov.uidai.ec.ui.enrol.universalClient.viewPeer.IrisTabViewPeerUC;
import in.gov.uidai.ec.ui.enrol.universalClient.viewPeer.PhotographTabViewPeerUC;
import in.gov.uidai.ec.ui.enrol.universalClient.viewPeer.ReviewTabViewPeerUC;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysTab;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.litef.devapi.GenericEventHandler;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.devapi.IEventContextAware;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.swing.l10n.L10nDecorator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class ReferenceTabViewPeerUC
implements IViewElementComposite,
IEventContextAware {
    protected final ILiteView liteView;
    protected EnrollmentService enrollmentService;
    protected JTabbedPane tabbedPane;
    protected IResourceBundleContext enrolRbctx;
    protected IEventContext evtCtxt;
    protected IUIPreference uiPref;
    protected PhotographTabViewPeerUC photoTab;
    protected FingerPrintTabViewPeerUC fingerTab;
    protected IrisTabViewPeerUC irisTab;
    protected ReviewTabViewPeerUC reviewTab;
    private int tabIndex;
    private JComponent refUCpanel;
    private ReferencePanel referencePanel;
    protected ButtonPanel buttonPanel;
    protected final IOucDataStore oucDataStore;

    public ReferenceTabViewPeerUC(EnrolViewPeer enrolViewPeer, IEventContext eventContext, EnrollmentService enrollmentService) {
        this.enrolRbctx = enrolViewPeer.enrolRbCtxt;
        this.evtCtxt = eventContext;
        this.uiPref = enrolViewPeer.uiPref;
        this.liteView = enrolViewPeer.getView();
        this.tabbedPane = enrolViewPeer.getTabbedPane();
        this.photoTab = enrolViewPeer.getPhotoTabUC();
        this.fingerTab = enrolViewPeer.getFingerTabUC();
        this.irisTab = enrolViewPeer.getIrisTabUC();
        this.reviewTab = enrolViewPeer.getReviewTabUC();
        this.oucDataStore = enrolViewPeer.oucDataStore;
        this.enrollmentService = enrollmentService;
    }

    public void prepare() {
        CommonUtilsUC.setFontsAndIcon();
        FixedWidthTopDownTile mainTile = new FixedWidthTopDownTile();
        mainTile.setWidth(this.enrollmentService.getIsPobRequired() ? 1400 : 1050);
        mainTile.setScrollable(true);
        mainTile.setPadding(5, 0, 5, 0);
        mainTile.prepare();
        mainTile.setFocus();
        this.referencePanel = new ReferencePanel(this.enrolRbctx, this.enrollmentService);
        this.buttonPanel = new ButtonPanel();
        mainTile.addTopComponent(this.referencePanel.create());
        mainTile.setBottomComponent(this.buttonPanel.create(new Component[0]));
        this.refUCpanel = mainTile.toSwing();
        new ReferenceControllerUC(this);
    }

    @GenericEventHandler(value="show_digilocker_and_manualscan_popup")
    public void showDigilockerAndManualPopup(boolean isDigilockerDocument, DocumentType docType) {
        new Thread(() -> SwingUtilities.invokeLater(() -> {
            JDialog actionDialog = new JDialog((Frame)null, "Select Document Source", true);
            actionDialog.setDefaultCloseOperation(2);
            actionDialog.setIconImage(new BufferedImage(1, 1, 2));
            JPanel contentPanel = new JPanel(new BorderLayout());
            contentPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
            actionDialog.setContentPane(contentPanel);
            JPanel headerPanel = new JPanel(new BorderLayout());
            headerPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            JLabel headerLabel = new JLabel("Available Document Source, Please Select");
            headerLabel.setHorizontalAlignment(0);
            headerLabel.setFont(new Font("SansSerif", 1, 18));
            headerLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            headerPanel.add((Component)headerLabel, "Center");
            contentPanel.add((Component)headerPanel, "North");
            JPanel buttonPanel = new JPanel(new FlowLayout(1, 30, 15));
            Dimension buttonSize = new Dimension(150, 40);
            JButton btnDigilocker = new JButton("Digilocker Fetch");
            btnDigilocker.setPreferredSize(buttonSize);
            btnDigilocker.setFont(new Font("SansSerif", 0, 16));
            JButton btnManualScan = new JButton("Manual Scan");
            btnManualScan.setPreferredSize(buttonSize);
            btnManualScan.setFont(new Font("SansSerif", 0, 16));
            if (isDigilockerDocument) {
                btnDigilocker.setEnabled(true);
                btnDigilocker.setToolTipText("Digilocker fetch is available");
                btnManualScan.setEnabled(false);
                btnManualScan.setToolTipText("Manual scan is disabled");
            } else {
                btnDigilocker.setEnabled(false);
                btnDigilocker.setToolTipText("Digilocker fetch is disabled");
                btnManualScan.setEnabled(true);
                btnManualScan.setToolTipText("Manual scan is available");
            }
            btnDigilocker.addActionListener(evt -> {
                this.getEvtCtxt().fireGenericEvent("open_digilocker", new Object[]{evt, docType});
                actionDialog.dispose();
            });
            btnManualScan.addActionListener(evt -> {
                this.getEvtCtxt().fireGenericEvent("set_attach_or_scan", new Object[]{evt, docType, "scan_document"});
                actionDialog.dispose();
            });
            buttonPanel.add(btnDigilocker);
            buttonPanel.add(btnManualScan);
            contentPanel.add((Component)buttonPanel, "Center");
            actionDialog.pack();
            actionDialog.setLocationRelativeTo(null);
            actionDialog.setVisible(true);
        })).start();
    }

    public JComponent toSwing() {
        return this.refUCpanel;
    }

    public int getTabIndex() {
        return this.tabIndex;
    }

    public void setTabIndex(int tabIndex) {
        this.tabIndex = tabIndex;
    }

    public ReferencePanel getReferencePanel() {
        return this.referencePanel;
    }

    public void renderReferencesTab() {
        if (this.enrollmentService.getIsPobRequired() && !this.enrollmentService.getDocManager().getBroadCastMessages().isEmpty()) {
            NoticeBoardPanel nbPanel = this.referencePanel.getDocumentUploadPanel().getNoticeBoardPanel();
            nbPanel.setBulletLines(this.enrollmentService.getDocManager().getBroadCastMessages());
        }
        this.tabbedPane.addTab(this.enrolRbctx.getMessage((Object)LabelKeysTab.REF, new Object[0]), this.toSwing());
        this.tabbedPane.setTabComponentAt(this.tabIndex, this.createReferenceLabel());
    }

    public PhotographTabViewPeerUC getPhotoTab() {
        return this.photoTab;
    }

    public FingerPrintTabViewPeerUC getFingerTab() {
        return this.fingerTab;
    }

    public IrisTabViewPeerUC getIrisTab() {
        return this.irisTab;
    }

    public ReviewTabViewPeerUC getReviewTab() {
        return this.reviewTab;
    }

    public IOucDataStore getOucDataStore() {
        return this.oucDataStore;
    }

    public ILiteView getLiteView() {
        return this.liteView;
    }

    public EnrollmentService getEnrollmentService() {
        return this.enrollmentService;
    }

    public IResourceBundleContext getEnrolRbctx() {
        return this.enrolRbctx;
    }

    public IEventContext getEvtCtxt() {
        return this.evtCtxt;
    }

    public JComponent getRefUCpanel() {
        return this.refUCpanel;
    }

    public ButtonPanel getButtonPanel() {
        return this.buttonPanel;
    }

    private JLabel createReferenceLabel() {
        String ICON_PATH = "res/images/tab-error.png";
        if (this.enrollmentService.getReferences().isValid()) {
            ICON_PATH = "res/images/tab-ok.png";
        }
        ImageIcon icon = ViewUtils.getImageIcon(this.getClass(), ICON_PATH);
        JLabel label = new JLabel(this.enrolRbctx.getMessage((Object)LabelKeysTab.REF, new Object[0]));
        new L10nDecorator(this.enrolRbctx, this.uiPref.getApplicationLocalize(false)).localize(label, (Object)LabelKeysTab.REF, new Object[0]);
        if (icon != null) {
            label.setIcon(icon);
        }
        label.setForeground(Color.WHITE);
        this.tabbedPane.setEnabledAt(this.tabIndex, true);
        return label;
    }

    public void populateEventContext(IEventContext evtCtxt) {
        this.evtCtxt = evtCtxt;
    }

    public ReferenceSections getReferenceSections() {
        return this.referencePanel.getReferenceSections();
    }
}

