/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.viewPeer;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.oauthapi.token.TokenManager;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.swing.FixedWidthTopDownTile;
import in.gov.uidai.ec.ui.enrol.EnrolViewPeer;
import in.gov.uidai.ec.ui.enrol.universalClient.button.ButtonPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.common.CommonUtilsUC;
import in.gov.uidai.ec.ui.enrol.universalClient.controllers.ReviewControllerUC;
import in.gov.uidai.ec.ui.enrol.universalClient.review.NewReviewPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.viewPeer.PhotographTabViewPeerUC;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysTab;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.swing.l10n.L10nDecorator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javafx.embed.swing.JFXPanel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;

public class ReviewTabViewPeerUC
implements IViewElementComposite {
    protected final ILiteView liteView;
    protected EnrollmentService enrollmentService;
    protected JTabbedPane tabbedPane;
    protected IResourceBundleContext enrolRbctx;
    protected IEventContext evtCtxt;
    protected IUIPreference uiPref;
    protected PhotographTabViewPeerUC photoTab;
    private JComponent reviewUCpanel;
    protected NewReviewPanel newReviewPanel;
    private int tabIndex;
    protected ButtonPanel buttonPanel;
    private JFXPanel jfxPanel;
    private TokenManager supTokenManager;

    public ReviewTabViewPeerUC(EnrolViewPeer enrolViewPeer, IEventContext eventContext, TokenManager supTokenManager) {
        this.enrolRbctx = enrolViewPeer.enrolRbCtxt;
        this.enrollmentService = enrolViewPeer.enrollmentService;
        this.supTokenManager = supTokenManager;
        this.evtCtxt = eventContext;
        this.uiPref = enrolViewPeer.uiPref;
        this.liteView = enrolViewPeer.getView();
        this.tabbedPane = enrolViewPeer.getTabbedPane();
        this.photoTab = enrolViewPeer.getPhotoTabUC();
        this.jfxPanel = enrolViewPeer.getJfxPanel();
    }

    public void prepare() {
        FixedWidthTopDownTile mainTile = new FixedWidthTopDownTile();
        mainTile.setWidth(1050);
        mainTile.setScrollable(true);
        mainTile.setPadding(5, 0, 5, 0);
        mainTile.prepare();
        JLabel title = new JLabel();
        title.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 18.0f));
        title.setText(this.enrolRbctx.getMessage((Object)LabelKeysTab.REVIEW, new Object[0]));
        this.buttonPanel = new ButtonPanel();
        this.newReviewPanel = new NewReviewPanel(this.enrolRbctx, this.enrollmentService, this.jfxPanel);
        mainTile.addTopComponent(title);
        mainTile.addTopComponent(this.newReviewPanel.create());
        mainTile.setBottomComponent(this.buttonPanel.create(new Component[0]));
        this.buttonPanel.nextButton.setText("Confirm");
        this.tabbedPane.addChangeListener(e -> this.adjustTabHeight());
        this.adjustTabHeight();
        this.reviewUCpanel = mainTile.toSwing();
        new ReviewControllerUC(this, this.tabIndex, this.supTokenManager);
    }

    public void renderReviewTabUC() {
        this.tabbedPane.addTab(this.enrolRbctx.getMessage((Object)LabelKeysTab.REVIEW, new Object[0]), this.toSwing());
        this.tabbedPane.setTabComponentAt(this.tabIndex, this.createReviewTabLabel());
    }

    private JLabel createReviewTabLabel() {
        JLabel label = new JLabel(this.enrolRbctx.getMessage((Object)LabelKeysTab.REVIEW, new Object[0]));
        new L10nDecorator(this.enrolRbctx, this.uiPref.getApplicationLocalize(false)).localize(label, (Object)LabelKeysTab.REVIEW, new Object[0]);
        label.setForeground(Color.WHITE);
        this.tabbedPane.setEnabledAt(this.tabIndex, true);
        return label;
    }

    private void adjustTabHeight() {
        int index = this.tabbedPane.getSelectedIndex();
        if (index != -1) {
            Component tab = this.tabbedPane.getComponentAt(index);
            int maxHeight = tab.getPreferredSize().height;
            this.tabbedPane.setPreferredSize(new Dimension(this.tabbedPane.getPreferredSize().width, maxHeight + 25));
            this.tabbedPane.revalidate();
        }
    }

    public JComponent toSwing() {
        return this.reviewUCpanel;
    }

    public void setTabIndex(int tabIndex) {
        this.tabIndex = tabIndex;
    }

    public ILiteView getLiteView() {
        return this.liteView;
    }

    public EnrollmentService getEnrollmentService() {
        return this.enrollmentService;
    }

    public IResourceBundleContext getEnrolRbctx() {
        return this.enrolRbctx;
    }

    public IEventContext getEvtCtxt() {
        return this.evtCtxt;
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public NewReviewPanel getNewReviewPanel() {
        return this.newReviewPanel;
    }

    public ButtonPanel getButtonPanel() {
        return this.buttonPanel;
    }
}

