/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.updatecount;

import in.gov.uidai.ec.service.enrollment.model.FieldUpdateCount;
import in.gov.uidai.ec.swing.CustomRoundedBorder;
import in.gov.uidai.ec.ui.enrol.operator.UpdateType;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FieldUpdateCountPanel
extends JPanel
implements IViewElementComposite {
    private static final String FORMATTER = "%d";
    private final JLabel updateLimitsLabel;
    private final JLabel updateLabel;
    private final UpdateType transactionType;
    private static final Color customBlue = new Color(19, 126, 178);
    private boolean enabled;
    private boolean selected;
    private final CustomRoundedBorder roundedBorderBlue = new CustomRoundedBorder(customBlue, 12, false);
    private final CustomRoundedBorder roundedBorderGray = new CustomRoundedBorder(Color.gray, 12, false);
    private final CustomRoundedBorder roundedFilledBorder = new CustomRoundedBorder(customBlue, 12, true);

    public FieldUpdateCountPanel(UpdateType transactionType) {
        this.setLayout(new GridLayout(1, 2));
        this.transactionType = transactionType;
        this.enabled = true;
        this.selected = false;
        this.updateLabel = new JLabel(transactionType.getText());
        this.updateLabel.setForeground(customBlue);
        this.updateLabel.setFont(new Font("Segoe UI", 1, 14));
        this.add(this.updateLabel);
        this.updateLimitsLabel = new JLabel();
        this.updateLimitsLabel.setForeground(Color.gray);
        this.updateLimitsLabel.setFont(new Font("Segoe UI", 1, 14));
        this.add(this.updateLimitsLabel);
        this.setBorder(this.roundedBorderBlue);
        this.setCursor(new Cursor(12));
    }

    public UpdateType getTransactionType() {
        return this.transactionType;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void update(FieldUpdateCount fieldUpdateCount) {
        if (fieldUpdateCount != null) {
            this.setEnabled(fieldUpdateCount.updateAllowed());
            this.updateLimitsLabel.setText(this.format(fieldUpdateCount.getUpdateLimit() - fieldUpdateCount.getUpdatesAvailed()));
        }
    }

    @Override
    public void setEnabled(boolean b) {
        if (this.enabled != b) {
            this.enabled = b;
            if (this.enabled) {
                this.setBorder(this.roundedBorderBlue);
                this.setBackground(Color.WHITE);
                this.updateLabel.setForeground(customBlue);
                this.updateLimitsLabel.setForeground(Color.GRAY);
                this.setCursor(new Cursor(12));
            } else {
                this.setBorder(this.roundedBorderGray);
                this.setBackground(Color.WHITE);
                this.updateLabel.setForeground(Color.GRAY);
                this.updateLimitsLabel.setForeground(Color.GRAY);
                this.setCursor(new Cursor(0));
            }
        }
    }

    public void setSelected(boolean b) {
        if (this.enabled && this.selected != b) {
            this.selected = b;
            if (this.selected) {
                this.setBorder(this.roundedFilledBorder);
                this.updateLabel.setForeground(Color.WHITE);
                this.updateLimitsLabel.setForeground(Color.WHITE);
            } else {
                this.setBorder(this.roundedBorderBlue);
                this.updateLabel.setForeground(customBlue);
                this.updateLimitsLabel.setForeground(Color.gray);
            }
        }
    }

    private String format(int i) {
        if (i < 0) {
            return " ";
        }
        return String.format(FORMATTER, i) + " Update(s) Left";
    }
}

