/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.updatecount;

import in.gov.uidai.ec.service.enrollment.model.FieldsUpdateCount;
import in.gov.uidai.ec.ui.enrol.EnrollmentControllerBase;
import in.gov.uidai.ec.ui.enrol.IEnrolConstants;
import in.gov.uidai.ec.ui.enrol.INavigationConstants;
import in.gov.uidai.ec.ui.enrol.operator.UpdateType;
import in.gov.uidai.ec.ui.enrol.updatecount.FieldUpdateCountPanel;
import in.gov.uidai.ec.ui.enrol.updatecount.IUpdateCountTabConstants;
import in.gov.uidai.ec.ui.enrol.updatecount.UpdateCountTabViewPeer;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class UpdateCountController
extends EnrollmentControllerBase
implements IUpdateCountTabConstants,
IEnrolConstants,
INavigationConstants {
    private final UpdateCountTabViewPeer view;

    protected UpdateCountController(UpdateCountTabViewPeer view) {
        super(view.liteView, view.enrollmentService, 6, view.getTabIndex());
        this.view = view;
        this.initView();
    }

    private void initView() {
        this.enrollmentService.addOnTabTransitionListeners(this::onTabTransition);
        this.enrollmentService.addOnViewLoadCompleteListeners(this::onViewLoadComplete);
        this.enrollmentService.addDisableTabListeners(e -> super.updateTabInteractionState(false));
        this.view.updateCountsPanel.getFieldUpdateTypePanels().forEach(this::addMouseClickListener);
        this.view.updateCountsPanel.getFieldUpdateTypePanels().forEach(field -> {
            if (field.getTransactionType() == UpdateType.POB || field.getTransactionType() == UpdateType.POR || field.getTransactionType() == UpdateType.POF) {
                field.setEnabled(false);
            }
        });
        super.addActionListener(this.view.consentPanel.nextBut, this::onNextButtonClick);
        FieldsUpdateCount fieldsUpdateCount = this.enrollmentService.getFieldsUpdateCount();
        fieldsUpdateCount.getLanguage().updateField(false);
        fieldsUpdateCount.getName().updateField(false);
        fieldsUpdateCount.getAddress().updateField(false);
        fieldsUpdateCount.getDob().updateField(false);
        fieldsUpdateCount.getGender().updateField(false);
        fieldsUpdateCount.getMobile().updateField(false);
        fieldsUpdateCount.getEmail().updateField(false);
        fieldsUpdateCount.getBio().updateField(false);
        fieldsUpdateCount.getActivationAadhaar().updateField(false);
        fieldsUpdateCount.addValidityChangeListener(this::updateTabValidityState);
    }

    private void addMouseClickListener(final FieldUpdateCountPanel clickedField) {
        clickedField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                UpdateCountController.this.selectField(clickedField);
                FieldsUpdateCount fieldsUpdateCount = UpdateCountController.this.enrollmentService.getFieldsUpdateCount();
                switch (clickedField.getTransactionType()) {
                    case NAME: {
                        fieldsUpdateCount.getName().updateField(clickedField.isSelected());
                        break;
                    }
                    case DOB: {
                        fieldsUpdateCount.getDob().updateField(clickedField.isSelected());
                        break;
                    }
                    case GENDER: {
                        fieldsUpdateCount.getGender().updateField(clickedField.isSelected());
                        break;
                    }
                    case ADDRESS: {
                        fieldsUpdateCount.getAddress().updateField(clickedField.isSelected());
                        break;
                    }
                    case MOBILE: {
                        fieldsUpdateCount.getMobile().updateField(clickedField.isSelected());
                        break;
                    }
                    case EMAIL: {
                        fieldsUpdateCount.getEmail().updateField(clickedField.isSelected());
                        break;
                    }
                    case BIO_UPDATE: {
                        fieldsUpdateCount.getBio().updateField(clickedField.isSelected());
                        break;
                    }
                    case REACTIVATE: {
                        fieldsUpdateCount.getActivationAadhaar().updateField(clickedField.isSelected());
                        break;
                    }
                    case POI: {
                        fieldsUpdateCount.getPoi().updateField(clickedField.isSelected());
                        break;
                    }
                    case POA: {
                        fieldsUpdateCount.getPoa().updateField(clickedField.isSelected());
                        break;
                    }
                    case POB: {
                        fieldsUpdateCount.getPob().updateField(clickedField.isSelected());
                        break;
                    }
                    case POR: {
                        fieldsUpdateCount.getPor().updateField(clickedField.isSelected());
                        break;
                    }
                    case POF: {
                        fieldsUpdateCount.getPof().updateField(clickedField.isSelected());
                    }
                }
            }
        });
    }

    private void selectField(FieldUpdateCountPanel clickedField) {
        if (clickedField.isEnabled()) {
            if (this.view.selectedFields.isEmpty()) {
                this.view.selectedFields.add(clickedField);
                clickedField.setSelected(true);
            } else if (this.view.selectedFields.contains(clickedField)) {
                this.view.selectedFields.remove(clickedField);
                clickedField.setSelected(false);
            } else if (clickedField.getTransactionType().getType().equals((Object)UpdateType.Type.OU)) {
                this.view.selectedFields.forEach(e -> e.setSelected(false));
                this.view.selectedFields.clear();
                this.clearUpdateFileds();
                this.view.selectedFields.add(clickedField);
                clickedField.setSelected(true);
            } else if (clickedField.getTransactionType().getType().equals((Object)UpdateType.Type.DOU)) {
                if (this.view.selectedFields.stream().allMatch(field -> field.getTransactionType().getType().equals((Object)UpdateType.Type.DOU))) {
                    this.view.selectedFields.add(clickedField);
                    clickedField.setSelected(true);
                } else {
                    this.view.selectedFields.forEach(field -> field.setSelected(false));
                    this.view.selectedFields.clear();
                    this.clearUpdateFileds();
                    this.view.selectedFields.add(clickedField);
                    clickedField.setSelected(true);
                }
            } else if (this.view.selectedFields.stream().anyMatch(field -> field.getTransactionType().getType().equals((Object)UpdateType.Type.DOU))) {
                this.view.selectedFields.forEach(field -> field.setSelected(false));
                this.view.selectedFields.clear();
                this.clearUpdateFileds();
                this.view.selectedFields.add(clickedField);
                clickedField.setSelected(true);
            } else if (this.view.selectedFields.get(0).getTransactionType().getType().equals((Object)UpdateType.Type.DU) || this.view.selectedFields.get(0).getTransactionType().getType().equals((Object)UpdateType.Type.BU)) {
                this.view.selectedFields.add(clickedField);
                clickedField.setSelected(true);
            } else {
                this.view.selectedFields.get(0).setSelected(false);
                this.view.selectedFields.clear();
                this.clearUpdateFileds();
                this.view.selectedFields.add(clickedField);
                clickedField.setSelected(true);
            }
        }
    }

    private void clearUpdateFileds() {
        FieldsUpdateCount fieldsUpdateCount = this.enrollmentService.getFieldsUpdateCount();
        fieldsUpdateCount.getLanguage().updateField(false);
        fieldsUpdateCount.getName().updateField(false);
        fieldsUpdateCount.getAddress().updateField(false);
        fieldsUpdateCount.getDob().updateField(false);
        fieldsUpdateCount.getGender().updateField(false);
        fieldsUpdateCount.getMobile().updateField(false);
        fieldsUpdateCount.getEmail().updateField(false);
        fieldsUpdateCount.getBio().updateField(false);
        fieldsUpdateCount.getActivationAadhaar().updateField(false);
        fieldsUpdateCount.getPoa().updateField(false);
        fieldsUpdateCount.getPoi().updateField(false);
        fieldsUpdateCount.getPob().updateField(false);
        fieldsUpdateCount.getPof().updateField(false);
        fieldsUpdateCount.getPor().updateField(false);
    }

    private void onTabTransition(Object o) {
        int tabIndex = (Integer)o;
        if (tabIndex == 6) {
            this.updateFieldState();
        }
    }

    private void updateFieldState() {
    }

    private void onViewLoadComplete(Object o) {
        this.updateTabValidityState(true);
    }

    @Override
    public void onNextButtonClick(ActionEvent evt) {
        if (this.enrollmentService.isOnlineUpdate()) {
            if (this.isSelected()) {
                this.enrollmentService.setDemoUpdate(this.isDemoUpdate());
                this.enrollmentService.setBiometricUpdate(this.isBioUpdate());
                this.enrollmentService.setDocumentUpdate(this.isDocumentUpdate());
                this.enableButtons(false);
                ((ActionListener)this.view.evtCtxt.getEventListener("generate sid", ActionListener.class)).actionPerformed(evt);
            } else {
                L10nOptionPaneBuilder.getInstance().showWarningUC((Object)"Please select any update to continue", (Component)evt.getSource());
            }
        }
    }

    private boolean isSelected() {
        return !this.view.selectedFields.isEmpty();
    }

    private boolean isDocumentUpdate() {
        return this.view.selectedFields.stream().anyMatch(fieldUpdateCountPanel -> fieldUpdateCountPanel.getTransactionType().getType().equals((Object)UpdateType.Type.DOU));
    }

    private boolean isDemoUpdate() {
        return this.view.selectedFields.stream().anyMatch(fieldUpdateCountPanel -> fieldUpdateCountPanel.getTransactionType().getType().equals((Object)UpdateType.Type.DU));
    }

    private boolean isBioUpdate() {
        return this.view.selectedFields.stream().anyMatch(fieldUpdateCountPanel -> fieldUpdateCountPanel.getTransactionType().getType().equals((Object)UpdateType.Type.BU));
    }

    private void enableButtons(boolean enable) {
        this.view.updateCountsPanel.getFieldUpdateTypePanels().forEach(fieldUpdateCountPanel -> fieldUpdateCountPanel.setEnabled(enable));
    }
}

