/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.updatecount;

import in.gov.uidai.ec.icas.preference.IOucDataStore;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.oauthapi.OnlineGatewayException;
import in.gov.uidai.ec.oauthapi.exception.ErrorCodes;
import in.gov.uidai.ec.oauthapi.token.TokenManager;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.FieldUpdateCount;
import in.gov.uidai.ec.service.enrollment.model.FieldsUpdateCount;
import in.gov.uidai.ec.service.mbu.MbuRequirement;
import in.gov.uidai.ec.service.pincode.IPinCodeService;
import in.gov.uidai.ec.swing.FixedWidthTopDownTile;
import in.gov.uidai.ec.swing.shared.HeaderPanel;
import in.gov.uidai.ec.swing.shared.ViewUtils;
import in.gov.uidai.ec.ui.enrol.operator.TransactionTypesViewPeer;
import in.gov.uidai.ec.ui.enrol.operator.UpdateTransactionTypePanel;
import in.gov.uidai.ec.ui.enrol.operator.UpdateType;
import in.gov.uidai.ec.ui.enrol.updatecount.ConsentPanel;
import in.gov.uidai.ec.ui.enrol.updatecount.FieldUpdateCountPanel;
import in.gov.uidai.ec.ui.enrol.updatecount.UpdateCountController;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysHeader;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysTab;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.swing.ExplicitFocusTraversalPolicy;
import in.gov.uidai.swing.l10n.L10nDecorator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;

public class UpdateCountTabViewPeer
implements IViewElementComposite {
    protected final ILiteView liteView;
    protected EnrollmentService enrollmentService;
    protected IResourceBundleContext enrolRbctx;
    protected IUIPreference uiPref;
    protected UpdateTransactionTypePanel updateCountsPanel;
    protected List<FieldUpdateCountPanel> selectedFields;
    private JComponent ucPanel;
    protected IEventContext evtCtxt;
    protected ConsentPanel consentPanel;
    protected IPinCodeService postOfficeDataService;
    protected JTabbedPane tabbedPane;
    protected IOucDataStore iOucDataStore;
    private int tabIndex;
    private UpdateCountController updateCountController;
    protected TokenManager consentToken;

    public UpdateCountTabViewPeer(TransactionTypesViewPeer viewPeer, int tabIndex) {
        this.enrollmentService = viewPeer.getEnrollmentService();
        this.liteView = viewPeer.getView();
        this.enrolRbctx = viewPeer.getEnrolRbCtxt();
        this.evtCtxt = viewPeer.getEvtCtxt();
        this.uiPref = viewPeer.getUiPref();
        this.postOfficeDataService = viewPeer.getPostOfficeDataService();
        this.tabbedPane = viewPeer.getTabbedPane();
        this.iOucDataStore = viewPeer.getOucDataStore();
        this.tabIndex = tabIndex;
        this.consentToken = viewPeer.consentTokenManager;
    }

    public void prepare() {
        this.updateCountsPanel = new UpdateTransactionTypePanel();
        this.selectedFields = new ArrayList<FieldUpdateCountPanel>();
        HeaderPanel headerPanel = new HeaderPanel(this.enrolRbctx, this.uiPref, this.enrollmentService.isOnlineUpdate());
        this.consentPanel = new ConsentPanel(this.enrolRbctx, this.uiPref, this.evtCtxt);
        FixedWidthTopDownTile mainTile = new FixedWidthTopDownTile();
        mainTile.setWidth(1300);
        mainTile.setScrollable(true);
        mainTile.setPadding(5, 0, 5, 0);
        mainTile.prepare();
        this.insertLimits();
        mainTile.addTopComponent(Box.createVerticalStrut(10));
        mainTile.addTopComponent(headerPanel.create(LabelKeysHeader.UPDATE_COUNTS.toString()));
        mainTile.addTopComponent(this.updateCountsPanel.create());
        mainTile.setBottomComponent(this.consentPanel.create());
        this.ucPanel = mainTile.toSwing();
        this.addTraversalUE();
        this.updateCountController = new UpdateCountController(this);
    }

    private List<String> prepareBroadCastList() {
        try {
            ArrayList<String> broadCastMessages = new ArrayList<String>();
            this.addMbuStatusMessage(broadCastMessages);
            return broadCastMessages;
        }
        catch (Exception e) {
            throw OnlineGatewayException.getClientExceptionFromEnum((ErrorCodes)ErrorCodes.UC_MBU_001, (String)this.enrollmentService.getTransactionId(), (Exception)e);
        }
    }

    private void addMbuStatusMessage(List<String> broadCastMessages) {
        MbuRequirement requirement = this.enrollmentService.getMbuStatus().getMbuRequirement();
        int mbuType = this.enrollmentService.getMbuStatus().getMbuType();
        if (requirement == MbuRequirement.REQUIRED_FREE || requirement == MbuRequirement.REQUIRED_PAID) {
            String base = requirement == MbuRequirement.REQUIRED_FREE ? "Mandatory FREE Biometric Update Available" : "Mandatory Biometric Update Available";
            String typeSuffix = "";
            broadCastMessages.add(base + typeSuffix);
        } else {
            broadCastMessages.add("No FREE Updates Available");
        }
    }

    private void addTraversalUE() {
        ExplicitFocusTraversalPolicy eftp = new ExplicitFocusTraversalPolicy((Container)this.ucPanel);
        eftp.addComponent((Component)this.consentPanel.nextBut);
    }

    public int getTabIndex() {
        return this.tabIndex;
    }

    public void setTabIndex(int tabIndex) {
        this.tabIndex = tabIndex;
    }

    public JComponent toSwing() {
        return this.ucPanel;
    }

    public ConsentPanel getConsentPanel() {
        return this.consentPanel;
    }

    public UpdateCountController getUpdateCountController() {
        return this.updateCountController;
    }

    public void renderUpdateCountTab() {
        this.tabbedPane.addTab(this.enrolRbctx.getMessage((Object)LabelKeysTab.UPDATE_COUNT, new Object[0]), this.toSwing());
        this.tabbedPane.setTabComponentAt(2, this.createUpdateCountLabel());
    }

    private void insertLimits() {
        FieldsUpdateCount fieldsUpdateCount = this.enrollmentService.getFieldsUpdateCount();
        HashMap<UpdateType, FieldUpdateCount> fieldUpdatesMap = new HashMap<UpdateType, FieldUpdateCount>();
        fieldUpdatesMap.put(UpdateType.NAME, fieldsUpdateCount.getName());
        fieldUpdatesMap.put(UpdateType.DOB, fieldsUpdateCount.getDob());
        fieldUpdatesMap.put(UpdateType.GENDER, fieldsUpdateCount.getGender());
        fieldUpdatesMap.put(UpdateType.ADDRESS, fieldsUpdateCount.getAddress());
        fieldUpdatesMap.put(UpdateType.MOBILE, fieldsUpdateCount.getMobile());
        fieldUpdatesMap.put(UpdateType.EMAIL, fieldsUpdateCount.getEmail());
        fieldUpdatesMap.put(UpdateType.BIO_UPDATE, fieldsUpdateCount.getBio());
        fieldUpdatesMap.put(UpdateType.REACTIVATE, fieldsUpdateCount.getActivationAadhaar());
        fieldUpdatesMap.put(UpdateType.POI, fieldsUpdateCount.getPoi());
        fieldUpdatesMap.put(UpdateType.POA, fieldsUpdateCount.getPoa());
        fieldUpdatesMap.put(UpdateType.POR, fieldsUpdateCount.getPor());
        fieldUpdatesMap.put(UpdateType.POB, fieldsUpdateCount.getPob());
        fieldUpdatesMap.put(UpdateType.POF, fieldsUpdateCount.getPof());
        this.updateCountsPanel.getFieldUpdateTypePanels().forEach(fieldUpdateCountPanel -> fieldUpdateCountPanel.update((FieldUpdateCount)fieldUpdatesMap.get((Object)fieldUpdateCountPanel.getTransactionType())));
    }

    private JLabel createUpdateCountLabel() {
        String ICON_PATH = "res/images/tab-error.png";
        ImageIcon icon = ViewUtils.getImageIcon(this.getClass(), ICON_PATH);
        JLabel label = new JLabel(this.enrolRbctx.getMessage((Object)LabelKeysTab.UPDATE_COUNT, new Object[0]));
        new L10nDecorator(this.enrolRbctx, this.uiPref.getApplicationLocalize(false)).localize(label, (Object)LabelKeysTab.UPDATE_COUNT, new Object[0]);
        if (icon != null) {
            label.setIcon(icon);
        }
        label.setForeground(Color.WHITE);
        this.tabbedPane.setEnabledAt(this.tabIndex, true);
        return label;
    }
}

