/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.findaadhaar;

import in.gov.uidai.ec.ecmpapi.EcmpApiService;
import in.gov.uidai.ec.ecmpapi.xml.docarchival.DocArchivalDataReadReq;
import in.gov.uidai.ec.ecmpapi.xml.docarchival.DocArchivalGetDocumentDetailsAPIResponse;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.verification.VerificationService;
import in.gov.uidai.ec.ui.findaadhaar.IGetAadhaarTabConstants;
import in.gov.uidai.ec.ui.main.UnsavedTracker;
import in.gov.uidai.ec.ui.shared.VerificationGuard;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysMainWin;
import in.gov.uidai.litef.devapi.EventHandler;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.devapi.IEventContextAware;
import in.gov.uidai.litef.devapi.ILiteEvent;
import in.gov.uidai.litef.devapi.ILiteScaffold;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.litef.devapi.IOnScreenDisplay;
import in.gov.uidai.litef.devapi.IOnScreenDisplayAware;
import in.gov.uidai.litef.devapi.IViewElement;
import in.gov.uidai.litef.devapi.ScaffoldPlacement;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class FindAadhaarControl
implements IOnScreenDisplayAware,
IEventContextAware,
IGetAadhaarTabConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(FindAadhaarControl.class);
    private EnrollmentService enrollmentService;
    private UnsavedTracker tracker;
    private IOnScreenDisplay osd;
    private IEventContext evtCtxt;
    private VerificationGuard verificationGuard;
    private EcmpApiService ecmpApiService;
    DocArchivalGetDocumentDetailsAPIResponse docArchivalGetDocumentDetailsAPIResponse;

    public void setEnrollmentService(EnrollmentService enrollmentService) {
        this.enrollmentService = enrollmentService;
    }

    public void setEcmpApiService(EcmpApiService ecmpApiService) {
        this.ecmpApiService = ecmpApiService;
    }

    public void setUnsavedTracker(UnsavedTracker tracker) {
        this.tracker = tracker;
    }

    public void setVerificationGuard(VerificationGuard verificationGuard) {
        this.verificationGuard = verificationGuard;
    }

    public void populateOnScreenDisplay(IOnScreenDisplay osd) {
        this.osd = osd;
    }

    public void populateEventContext(IEventContext ctxt) {
        this.evtCtxt = ctxt;
    }

    @EventHandler(name="eID_duAADHAR", method="actionPerformed")
    public void onDemoGraphicsUpdate(ILiteEvent evt) {
        LOGGER.debug("demographic update selected");
        this.displayUIdWindow();
        this.enrollmentService.clearEnrollmentState();
        this.initiateAadhaarSearch(evt, false, false);
    }

    @EventHandler(name="eID_eAADHAR", method="actionPerformed")
    public void onPrintAadhaar(ILiteEvent evt) {
        LOGGER.debug("print aadhaar tab selected");
        this.initiateAadhaarSearch(evt, true, false);
    }

    @EventHandler(name="eID_docUpdate", method="actionPerformed")
    public void onDemoDocUpdate(ILiteEvent evt) {
        this.enrollmentService.clearEnrollmentState();
        LOGGER.debug("demographic doc update selected");
        this.showDocUpdatePopupMessage();
        this.displayUIdWindow();
        this.initiateAadhaarSearch(evt, false, true);
    }

    public void initiateAadhaarSearch(ILiteEvent evt, Boolean isPrintAadhar, Boolean isDocUpdate) {
        if (!this.verificationGuard.verifyOnStartUp(VerificationService.Type.StartUp, evt) || isPrintAadhar.booleanValue() && !this.tracker.selectPrintAadhaar(evt) || !isPrintAadhar.booleanValue() && !this.tracker.selectEnrol(evt)) {
            return;
        }
        if (isPrintAadhar.booleanValue()) {
            if (this.enrollmentService.isSessionInitialed()) {
                this.enrollmentService.setOnlineUpdate(false);
            }
        } else if (isDocUpdate.booleanValue()) {
            this.enrollmentService.initiateUpdateEnrollment(false, isDocUpdate.booleanValue(), false);
        } else {
            this.enrollmentService.initiateUpdateEnrollment(true, isDocUpdate.booleanValue(), false);
        }
        ILiteScaffold scaffold = this.osd.getScaffold(this.osd.recompose(evt.getScaffoldId(), "eaadhaarView"));
        if (isDocUpdate.booleanValue()) {
            ((IViewElement)scaffold.getElementMap().get("hID_MainWin_Header")).set("text", (Object)(isPrintAadhar != false ? LabelKeysMainWin.LIFECYCLE_PRINTAADHAAR : LabelKeysMainWin.LIFECYCLE_UPDATE_DOCUMENT_ONLINE));
        } else {
            ((IViewElement)scaffold.getElementMap().get("hID_MainWin_Header")).set("text", (Object)(isPrintAadhar != false ? LabelKeysMainWin.LIFECYCLE_PRINTAADHAAR : LabelKeysMainWin.LIFECYCLE_UPDATE_ONLINE));
        }
        if (this.enrollmentService.isOnlineUpdate() && this.enrollmentService.getSid() != null) {
            this.enrollmentService.cancelProcess(this.enrollmentService.getSid());
        }
    }

    @EventHandler(name="eID_Online_Enrol", method="actionPerformed")
    public void onlineEnrolment(ILiteEvent evt) {
        this.evtCtxt.fireGenericEvent("hID_Enrol", new Object[]{evt, false, true, true, true});
    }

    private void showDocUpdatePopupMessage() {
        StringBuilder message = new StringBuilder("<html><font size=3>");
        message.append("This feature will only allow Document Update.<br> No changes to aadhaar account will be possible.<br> To update Aadhaar, please use Update Flow.");
        message.append("</font></html>").toString();
        JOptionPane.showMessageDialog(null, message, "Aadhaar Message", 2);
    }

    @EventHandler(name="resident_login", method="actionPerformed")
    public void initiate(ILiteEvent evt) {
        if (!this.verificationGuard.verifyOnStartUp(VerificationService.Type.StartUp, evt) || !this.tracker.selectEnrol(evt)) {
            return;
        }
        this.displayUIdWindow();
    }

    @EventHandler(name="residentUidPopupButton", method="actionPerformed")
    public void residentUidPopupButton(ILiteEvent evt) throws IOException, ParserConfigurationException, SAXException {
        ILiteView view = this.osd.getView(evt.getViewId());
        IViewElement resUidElement = (IViewElement)view.getElementMap().get("resUid");
        String residentUid = (String)resUidElement.get("value");
        IViewElement validElement = (IViewElement)view.getElementMap().get("validUid");
        String valid = (String)validElement.get("value");
        if (!valid.equalsIgnoreCase("Valid")) {
            return;
        }
        DocArchivalDataReadReq doc = new DocArchivalDataReadReq();
        doc.setIdType("uid");
        doc.setId(residentUid);
        this.docArchivalGetDocumentDetailsAPIResponse = this.ecmpApiService.makeDocArchivalApiCall(doc);
        LOGGER.info("Response from DocArchival API for POA::{}, POI::{}", (Object)this.docArchivalGetDocumentDetailsAPIResponse.getPoaMissing(), (Object)this.docArchivalGetDocumentDetailsAPIResponse.getPoiMissing());
        if (this.docArchivalGetDocumentDetailsAPIResponse.getPoiPoaMissing().booleanValue()) {
            this.showDocArchPopupMessageForBothUpdate();
        } else if (this.docArchivalGetDocumentDetailsAPIResponse.getPoaMissing().booleanValue()) {
            this.showDocArchPopupMessageForPOAUpdate();
        } else if (this.docArchivalGetDocumentDetailsAPIResponse.getPoiMissing().booleanValue()) {
            this.showDocArchPopupMessageForPoiUpdate();
        } else {
            this.showDocArchPopupMessageNotForUpdate();
        }
        this.closeWinImpl(evt);
    }

    private void closeWinImpl(ILiteEvent evt) {
        this.osd.dispose(evt.getScaffoldId());
    }

    private void displayUIdWindow() {
        String scaffoldId = this.osd.compose("residentUidPopupWin", "residentUidPreview");
        this.osd.display(scaffoldId, ScaffoldPlacement.CENTERED);
    }

    private void showDocArchPopupMessageForBothUpdate() {
        StringBuilder message = new StringBuilder("<html><font size=3>");
        message.append("This Aadhaar needs Document Update Kindly upload Proof of Identity and Proof of Address documents.");
        message.append("</font></html>").toString();
        JOptionPane.showMessageDialog(null, message, "Aadhaar Message", -1);
    }

    private void showDocArchPopupMessageForPoiUpdate() {
        StringBuilder message = new StringBuilder("<html><font size=3>");
        message.append("This Aadhaar needs Document Update Kindly upload Proof of Identity.");
        message.append("</font></html>").toString();
        JOptionPane.showMessageDialog(null, message, "Aadhaar Message", -1);
    }

    private void showDocArchPopupMessageForPOAUpdate() {
        StringBuilder message = new StringBuilder("<html><font size=3>");
        message.append("This Aadhaar needs Document Update Kindly upload Proof of Address documents.");
        message.append("</font></html>").toString();
        JOptionPane.showMessageDialog(null, message, "Aadhaar Message", -1);
    }

    private void showDocArchPopupMessageNotForUpdate() {
        StringBuilder message = new StringBuilder("<html><font size=3>");
        message.append("This Aadhaar does not need document update.");
        message.append("</font></html>").toString();
        JOptionPane.showMessageDialog(null, message, "Aadhaar Message", -1);
    }
}

