/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.findaadhaar;

import in.gov.uidai.ec.biometrics.device.DeviceType;
import in.gov.uidai.ec.ecmpapi.xml.findaadhaar.AadhaarInfo;
import in.gov.uidai.ec.ecmpapi.xml.findaadhaar.FindAadhaarRes;
import in.gov.uidai.ec.icas.text.UidLocaleUtils;
import in.gov.uidai.ec.service.biometricsauth.AuthParamType;
import in.gov.uidai.ec.service.biometricsauth.BiometricsAuthService;
import in.gov.uidai.ec.service.biometricsauth.model.RDAuthBiometrics;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.Address;
import in.gov.uidai.ec.service.enrollment.model.CaptureAttempt;
import in.gov.uidai.ec.service.enrollment.model.Demographics;
import in.gov.uidai.ec.service.enrollment.model.PersonalDetail;
import in.gov.uidai.ec.service.enrollment.model.PinCodeDetail;
import in.gov.uidai.ec.service.findaadhaar.FindAadhaarException;
import in.gov.uidai.ec.service.findaadhaar.model.AadhaarSearch;
import in.gov.uidai.ec.service.findaadhaar.model.AfterValidationCallBack;
import in.gov.uidai.ec.service.findaadhaar.model.ValidatableModel;
import in.gov.uidai.ec.service.pincode.IPinCodeService;
import in.gov.uidai.ec.service.pincode.PostOffice;
import in.gov.uidai.ec.service.pincode.PostOfficeType;
import in.gov.uidai.ec.service.pincode.PostalAddressElement;
import in.gov.uidai.ec.ui.ControllerBase;
import in.gov.uidai.ec.ui.findaadhaar.DemoBasedSearchArea;
import in.gov.uidai.ec.ui.findaadhaar.FetchAadhaarDetailsViewPeer;
import in.gov.uidai.ec.ui.shared.IFocusLostListener;
import in.gov.uidai.ec.ui.shared.IdentifierBasedSearchArea;
import in.gov.uidai.ec.ui.shared.l10n.MsgKeysPrintAadhaarTab;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.swing.bio.confirm.BiometricsRDField;
import in.gov.uidai.swing.notify.OverlayResetDocumentListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindAadhaarController
extends ControllerBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(FindAadhaarController.class);
    private static final String FIND_AADHAAR = "Find Aadhaar";
    private static final String PRINT_AADHAAR = "Print Aadhaar";
    private final FetchAadhaarDetailsViewPeer viewElements;
    private final IPinCodeService postOfficeDataService;
    private final EnrollmentService enrollmentService;
    private final BiometricsAuthService biometricsAuthService;
    private final AadhaarSearch search;
    private final ActionListener onlineEnrolListener;
    private boolean displayErrorMessages = false;

    public FindAadhaarController(FetchAadhaarDetailsViewPeer view) {
        super(view.getView());
        this.enrollmentService = view.enrollmentService;
        this.postOfficeDataService = view.postOfficeDataService;
        this.search = view.findAadhaarService.newSearch(view.rbCtxt);
        this.viewElements = view;
        this.biometricsAuthService = view.biometricsAuthService;
        this.initView();
        this.onlineEnrolListener = (ActionListener)this.viewElements.eventContext.getEventListener("eID_Online_Enrol", ActionListener.class);
    }

    private void initView() {
        this.initIdentifierSearchArea();
        this.initDemographicsSearchArea();
        this.addActionListener(this.viewElements.demoSearchSelectionRbt, this::toggleOnDemographicsSearchSelection);
        this.addActionListener(this.viewElements.identifierSearchSelectionRbt, this::toggleOnIdentifierSearchSelection);
        this.viewElements.identifierSearchSelectionRbt.doClick();
        if (this.enrollmentService.isDocumentUpdate() || this.enrollmentService.isOnlineUpdate()) {
            this.viewElements.demoSearchSelectionRbt.setEnabled(false);
        } else {
            this.viewElements.demoSearchSelectionRbt.setEnabled(true);
        }
        this.initFindAadhaarButton();
        this.initModel();
        BiometricsRDField residentRDBioField = this.viewElements.bioPanel.getRDBioField(AuthParamType.RESIDENT, DeviceType.FINGER_OR_IRIS);
        BiometricsRDField operatorRDBioField = this.viewElements.bioPanel.getRDBioField(AuthParamType.OPERATOR, DeviceType.FINGER_OR_IRIS);
        residentRDBioField.addCaptureAttemptChangeListeners(this::OnCaptureAttempt);
        operatorRDBioField.addCaptureAttemptChangeListeners(this::OnCaptureAttempt);
    }

    private void initModel() {
        DemoBasedSearchArea searchArea = this.viewElements.demoBasedSearchArea;
        IdentifierBasedSearchArea identifierBasedSearchArea = this.viewElements.identifierBasedSearchArea;
        this.addErrorValidationCallBack(this.search.getDemographicsSearch().getName(), searchArea.nameField);
        this.addErrorValidationCallBack(this.search.getDemographicsSearch().getGender(), searchArea.genderField);
        this.addErrorValidationCallBack(this.search.getDemographicsSearch().getDistrict(), searchArea.districtField);
        this.addErrorValidationCallBack(this.search.getDemographicsSearch().getPinCode(), searchArea.pincodeField);
        this.addErrorValidationCallBack(this.search.getDemographicsSearch().getState(), searchArea.stateField);
        this.addErrorValidationCallBack(this.search.getDemographicsSearch().getCareOf(), searchArea.cofField);
        this.addErrorValidationCallBack(this.search.getDemographicsSearch().getMobile(), searchArea.mobField);
        this.addErrorValidationCallBack(this.search.getDemographicsSearch().getEmail(), searchArea.emailField);
        this.addErrorValidationCallBack(this.search.getDemographicsSearch().getYob(), searchArea.yobField);
        this.addErrorValidationCallBack(this.search.getDemographicsSearch().getYobType(), searchArea.yobPanelBuilder.yobType);
        this.addErrorValidationCallBack(this.search.getIdentifierSearch().getEnrolId(), identifierBasedSearchArea.enrolId);
        this.addErrorValidationCallBack(this.search.getIdentifierSearch().getEnrolmentDate(), identifierBasedSearchArea.enrolDate);
        this.addErrorValidationCallBack(this.search.getIdentifierSearch().getUid(), identifierBasedSearchArea.uidField);
        this.search.addValidityChangeListener(this::ifValidThenEnableSearchButton);
        this.displayErrorMessages = true;
    }

    public void ifValidThenEnableSearchButton(boolean isValid) {
        if (isValid) {
            RDAuthBiometrics authBiometrics = this.biometricsAuthService.getRdAuthBiometrics();
            String residentAuthError = authBiometrics.getAuthError(AuthParamType.RESIDENT, DeviceType.FINGER_OR_IRIS);
            String operatorAuthError = authBiometrics.getAuthError(AuthParamType.OPERATOR, DeviceType.FINGER_OR_IRIS);
            if (residentAuthError != null || operatorAuthError != null) {
                isValid = false;
            }
        }
        this.viewElements.searchBtn.setEnabled(isValid);
    }

    private void initFindAadhaarButton() {
        this.viewElements.searchBtn.setText(this.enrollmentService.isSessionInitialed() && this.enrollmentService.isFindAadhaar() ? FIND_AADHAAR : PRINT_AADHAAR);
        this.viewElements.searchBtn.addActionListener(this::onFindAadhaarClick);
        JButton component = this.viewElements.searchBtn;
        ((JComponent)component).setEnabled(this.search.isValid());
    }

    private void initDemographicsSearchArea() {
        DemoBasedSearchArea demoSearchArea = this.viewElements.demoBasedSearchArea;
        demoSearchArea.nameField.getDocument().addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)demoSearchArea.nameField));
        this.updateModelOnFocusOut(demoSearchArea.genderField, this.search.getDemographicsSearch().getGender());
        this.updateModelOnFocusOut(demoSearchArea.nameField, this.search.getDemographicsSearch().getName());
        this.addItemListener(demoSearchArea.stateField, this::onStateFocusLost);
        demoSearchArea.pincodeField.getDocument().addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)demoSearchArea.pincodeField));
        this.updateModelOnPinCodeFocusOut(demoSearchArea.pincodeField, this.search.getDemographicsSearch().getPinCode());
        this.updateModelOnDistrictFocusOut(demoSearchArea.districtField, this.search.getDemographicsSearch().getDistrict());
        demoSearchArea.setPaeList(this.postOfficeDataService.findAllDistricts());
        demoSearchArea.setStateList(this.postOfficeDataService.findAllStates());
        this.updateModelOnFocusOut(demoSearchArea.cofField, this.search.getDemographicsSearch().getCareOf());
        this.updateModelOnFocusOut(demoSearchArea.emailField, this.search.getDemographicsSearch().getEmail());
        this.updateModelOnFocusOut(demoSearchArea.mobField, this.search.getDemographicsSearch().getMobile());
        this.updateModelOnFocusOut(demoSearchArea.yobField, this.search.getDemographicsSearch().getYob());
        this.updateModelOnFocusOut(demoSearchArea.yobPanelBuilder.yobType, this.search.getDemographicsSearch().getYobType());
    }

    private void initIdentifierSearchArea() {
        IdentifierBasedSearchArea identifierSearchArea = this.viewElements.identifierBasedSearchArea;
        this.updateModelOnFocusOut(identifierSearchArea.enrolId, this.search.getIdentifierSearch().getEnrolId());
        this.updateModelOnEnrolDateFocusOut(identifierSearchArea.enrolDate, this.search.getIdentifierSearch().getEnrolmentDate());
        this.updateModelOnFocusOut(identifierSearchArea.uidField, this.search.getIdentifierSearch().getUid());
        this.addActionListener(identifierSearchArea.enrolIdRbt, this::toggleOnIdentifierTypeEnrolIdSelection);
        this.addActionListener(identifierSearchArea.uidRbt, this::toggleOnIdentifierTypeUidSelection);
        identifierSearchArea.uidRbt.doClick();
    }

    public void toggleOnIdentifierSearchSelection(ActionEvent evt) {
        this.displayErrorMessages = false;
        this.viewElements.identifierBasedSearchArea.resetAllFields();
        this.clear(true, false);
        this.search.selectIdentifier();
        this.viewElements.identifierBasedSearchArea.enrolIdRbt.doClick();
        this.displayErrorMessages = true;
    }

    public void toggleOnDemographicsSearchSelection(ActionEvent evt) {
        this.displayErrorMessages = false;
        this.viewElements.demoBasedSearchArea.resetAllFields();
        this.clear(false, true);
        this.search.selectDemoGraphics();
        String yobType = (String)this.viewElements.demoBasedSearchArea.yobPanelBuilder.yobType.getSelectedItem();
        this.search.getDemographicsSearch().getYobType().setValue(yobType);
        this.displayErrorMessages = true;
    }

    private void clear(boolean isIdSearch, boolean isDemoSearch) {
        JComponent idSearch = this.viewElements.identifierBasedSearchArea.getBasePanel();
        idSearch.setEnabled(isIdSearch);
        idSearch.setVisible(isIdSearch);
        JComponent demoGraphicSearch = this.viewElements.demoBasedSearchArea.getBasePanel();
        demoGraphicSearch.setEnabled(isDemoSearch);
        demoGraphicSearch.setVisible(isDemoSearch);
        this.resetBiometrics();
    }

    private void resetBiometrics() {
        this.viewElements.bioPanel.getRDBioField(AuthParamType.RESIDENT, DeviceType.FINGER_OR_IRIS).clearCaptureAttempt();
        this.viewElements.bioPanel.getRDBioField(AuthParamType.OPERATOR, DeviceType.FINGER_OR_IRIS).clearCaptureAttempt();
    }

    public void toggleOnIdentifierTypeUidSelection(ActionEvent evt) {
        this.displayErrorMessages = false;
        IdentifierBasedSearchArea identifierBasedSearchArea = this.viewElements.identifierBasedSearchArea;
        identifierBasedSearchArea.enrolId.setEnabled(false);
        identifierBasedSearchArea.enrolDate.setEnabled(false);
        identifierBasedSearchArea.uidField.setEnabled(true);
        identifierBasedSearchArea.uidField.setEditable(true);
        identifierBasedSearchArea.getBasePanel().setEnabled(true);
        identifierBasedSearchArea.resetAllFields();
        this.search.getIdentifierSearch().selectUid();
        this.displayErrorMessages = true;
    }

    public void toggleOnIdentifierTypeEnrolIdSelection(ActionEvent evt) {
        this.displayErrorMessages = false;
        IdentifierBasedSearchArea identifierBasedSearchArea = this.viewElements.identifierBasedSearchArea;
        identifierBasedSearchArea.enrolId.setEnabled(true);
        identifierBasedSearchArea.enrolId.setEditable(true);
        identifierBasedSearchArea.enrolDate.setEnabled(true);
        identifierBasedSearchArea.enrolDate.setEditable(true);
        identifierBasedSearchArea.uidField.setEnabled(false);
        identifierBasedSearchArea.resetAllFields();
        this.search.getIdentifierSearch().selectEnrolId();
        this.search.getIdentifierSearch().getEnrolmentDate().setValue("00000000000000");
        this.displayErrorMessages = true;
    }

    public void onStateFocusLost(ItemEvent evt) {
        JComboBox<String> districtField = this.viewElements.demoBasedSearchArea.districtField;
        JComboBox<String> stateField = this.viewElements.demoBasedSearchArea.stateField;
        String stateName = (String)stateField.getSelectedItem();
        if (StringUtils.isNotBlank((String)stateName) && stateName.equalsIgnoreCase("Select")) {
            ArrayList<String> allDistrictList = new ArrayList<String>(Collections.singletonList("Select"));
            this.postOfficeDataService.findAllDistricts().stream().map(PostalAddressElement::getAddressValue).forEach(allDistrictList::add);
            this.clearComboBoxAndInsertItems(districtField, allDistrictList);
        } else {
            String stateCode = this.postOfficeDataService.findStateCode(stateName);
            ArrayList<String> filterDistrictList = new ArrayList<String>(Collections.singletonList("Select"));
            this.postOfficeDataService.findDistrictNames(stateCode).stream().map(PostalAddressElement::getAddressValue).forEach(filterDistrictList::add);
            this.clearComboBoxAndInsertItems(districtField, filterDistrictList);
        }
        if (stateName != null && stateName.equalsIgnoreCase("Select")) {
            this.search.getDemographicsSearch().getState().setValue(null);
        } else {
            this.search.getDemographicsSearch().getState().setValue(stateName);
        }
    }

    private void clearComboBoxAndInsertItems(JComboBox<String> districtField, List<String> items) {
        districtField.removeAllItems();
        items.forEach(districtField::addItem);
    }

    private void updateModelOnFocusOut(JTextField field, ValidatableModel model) {
        this.addFocusListener(field, this.setModelOnFocusLost(field, model));
    }

    private void updateModelOnFocusOut(JComboBox<String> field, ValidatableModel model) {
        this.addItemListener(field, this.setModelOnFocusLost(field, model));
    }

    private void updateModelOnFocusOut(JFormattedTextField field, ValidatableModel model) {
        this.addFocusListener(field, this.setModelOnFocusLost(field, model));
    }

    private void updateModelOnEnrolDateFocusOut(JFormattedTextField field, ValidatableModel model) {
        this.addFocusListener(field, this.setModelOnFocusLostEnrolDate(field, model));
    }

    public IFocusLostListener setModelOnFocusLost(JTextField field, ValidatableModel model) {
        return event -> {
            if (!event.isTemporary()) {
                model.setValue(field.getText());
            }
        };
    }

    public ItemListener setModelOnFocusLost(JComboBox<String> field, ValidatableModel model) {
        return event -> {
            String data = (String)field.getSelectedItem();
            if (data != null && data.equalsIgnoreCase("Select")) {
                model.setValue(null);
            } else {
                model.setValue(data);
            }
        };
    }

    public IFocusLostListener setModelOnFocusLost(JFormattedTextField field, ValidatableModel model) {
        return event -> {
            if (event.isTemporary()) {
                return;
            }
            try {
                String data = (String)field.getFormatter().stringToValue(field.getText());
                model.setValue(data);
            }
            catch (ParseException e) {
                LOGGER.debug("Data parsing error: " + e.getMessage());
            }
        };
    }

    public IFocusLostListener setModelOnFocusLostEnrolDate(JFormattedTextField field, ValidatableModel model) {
        return event -> {
            if (event.isTemporary()) {
                return;
            }
            try {
                String data = (String)field.getFormatter().stringToValue(field.getText());
                model.setValue(data);
                if (!this.search.getIdentifierSearch().getEnrolId().isValid()) {
                    this.viewElements.identifierBasedSearchArea.enrolId.requestFocus();
                }
                this.viewElements.bioPanel.getRDBioField(AuthParamType.RESIDENT, DeviceType.FINGER_OR_IRIS).requestFocus();
            }
            catch (ParseException e) {
                LOGGER.debug("Data parsing error: " + e.getMessage());
            }
        };
    }

    private void OnCaptureAttempt(CaptureAttempt captureAttempt, String captureId) {
        this.ifValidThenEnableSearchButton(this.search.isValid());
    }

    private void addErrorValidationCallBack(ValidatableModel model, JComponent field) {
        model.addValidationCallBack(this.errorMessageIfValidationFailed(field));
    }

    private void updateModelOnDistrictFocusOut(JComboBox<String> field, ValidatableModel model) {
        this.addItemListener(field, (ItemEvent event) -> {
            String data = (String)field.getSelectedItem();
            if (data != null && data.equalsIgnoreCase("Select")) {
                model.setValue(null);
            } else {
                model.setValue(data);
            }
            ValidatableModel pinCode = this.search.getDemographicsSearch().getPinCode();
            this.triggerValidation(pinCode);
        });
    }

    private void updateModelOnPinCodeFocusOut(JTextField field, ValidatableModel model) {
        this.addFocusListener(field, event -> {
            if (!event.isTemporary()) {
                model.setValue(field.getText());
                ValidatableModel district = this.search.getDemographicsSearch().getDistrict();
                this.triggerValidation(district);
            }
        });
    }

    private void triggerValidation(ValidatableModel model) {
        model.setValue(model.getValue());
    }

    public AfterValidationCallBack errorMessageIfValidationFailed(JComponent component) {
        return model -> {
            this.clearFieldError(component);
            if (this.displayErrorMessages) {
                if (!(component instanceof JFormattedTextField)) {
                    if (!model.isValid()) {
                        this.showFieldError(component, model.getErrorMessage());
                    }
                } else {
                    this.showFieldError(component, model.getErrorMessage());
                    SwingUtilities.invokeLater(() -> {
                        this.clearFieldError(component);
                        this.showFieldError(component, model.getErrorMessage());
                    });
                }
            } else if (component instanceof JFormattedTextField) {
                SwingUtilities.invokeLater(() -> this.clearFieldError(component));
            }
        };
    }

    private void onFindAadhaarClick(ActionEvent evt) {
        IVisualExecutionContext veCtxt = this.view.getVisualExecutionContext();
        JComponent viewContentPane = this.viewElements.getContentPane();
        if (veCtxt != null) {
            veCtxt.reset();
            veCtxt.setMessage(this.viewElements.rbCtxt.getMessage((Object)MsgKeysPrintAadhaarTab.FIND_AADHAAR, new Object[0]));
        }
        new Thread(() -> {
            boolean isFindAadhaar = this.enrollmentService.isSessionInitialed() && this.enrollmentService.isFindAadhaar();
            try {
                FindAadhaarRes findAadhaarResponse = this.viewElements.findAadhaarService.makeFindAadhaarRequest();
                if (isFindAadhaar) {
                    if (!this.enrollmentService.getEnrollmentLangCode().equals(findAadhaarResponse.getPrintData().getLangCode())) {
                        this.displayErrorIfLanguageMismatch(viewContentPane, findAadhaarResponse);
                    }
                    this.updateDemographicsDetailsInEnrolment(findAadhaarResponse);
                    if (veCtxt != null) {
                        veCtxt.cancel();
                    }
                    this.onlineEnrolListener.actionPerformed(evt);
                } else {
                    if (veCtxt != null) {
                        veCtxt.reset();
                        veCtxt.setMessage(this.viewElements.rbCtxt.getMessage((Object)MsgKeysPrintAadhaarTab.GENERATING_PDF, new Object[0]));
                    }
                    boolean success = this.viewElements.findAadhaarService.storePdf(findAadhaarResponse);
                    if (veCtxt != null) {
                        veCtxt.cancel();
                    }
                    if (success) {
                        try {
                            this.viewElements.findAadhaarService.storeAttemptInfo();
                            this.showInfo(viewContentPane, this.viewElements.rbCtxt.getMessage((Object)MsgKeysPrintAadhaarTab.PDF_GENERATE_SUCCESS, new Object[0]));
                            this.viewElements.identifierSearchSelectionRbt.doClick();
                        }
                        catch (Exception e) {
                            LOGGER.error("exception occurred while generating pdf", (Throwable)e);
                        }
                    } else {
                        this.showError(viewContentPane, this.viewElements.rbCtxt.getMessage((Object)MsgKeysPrintAadhaarTab.PDF_GENERATE_FAILED, new Object[0]));
                    }
                    this.viewElements.identifierSearchSelectionRbt.doClick();
                }
            }
            catch (FindAadhaarException e) {
                if (veCtxt != null) {
                    veCtxt.cancel();
                }
                String errorMsg = this.getErrorMessage(e);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("FindAadhaar request failed", (Throwable)e);
                } else {
                    LOGGER.info(errorMsg + " " + e.getMessage());
                }
                this.showError(viewContentPane, errorMsg + " Please try again.");
            }
            finally {
                this.resetBiometrics();
                if (veCtxt != null) {
                    veCtxt.cancel();
                }
            }
        }).start();
    }

    private void displayErrorIfLanguageMismatch(JComponent viewContentPane, FindAadhaarRes findAadhaarResponse) {
        int enrolLangCode = Integer.parseInt(this.enrollmentService.getEnrollmentLangCode());
        String currentEnrolLanguage = UidLocaleUtils.getLocaleFromLangCode((int)enrolLangCode).getDisplayLanguage();
        int existingEnrolLangCode = Integer.parseInt(findAadhaarResponse.getPrintData().getLangCode());
        String existingEnrolLanguage = UidLocaleUtils.getLocaleFromLangCode((int)existingEnrolLangCode).getDisplayLanguage();
        this.showInfo(viewContentPane, "Resident's enrolment language is in " + existingEnrolLanguage + " and the client language is in " + currentEnrolLanguage);
    }

    private String getErrorMessage(FindAadhaarException e) {
        String errorMsg;
        switch (e.getExceptionType()) {
            case NetworkError: {
                errorMsg = "FindAadhaar request failed due to internet connectivity.";
                break;
            }
            case ServerError: {
                errorMsg = "Failed to process Find Aadhaar Request due to Server error.";
                break;
            }
            case InternalError: {
                errorMsg = "Failed to process Find Aadhaar Request due to Internal Error.";
                break;
            }
            case InternalServerError: {
                errorMsg = "Failed to process Find Aadhaar Request due to Internal Server Error.";
                break;
            }
            case EnrolServiceClientConnectionError: {
                errorMsg = "Failed to connect to Enrol Service Client.";
                break;
            }
            case EnrolServiceClientError: {
                errorMsg = "Failed to store/retrieve information from Enrol Service Client.";
                break;
            }
            default: {
                errorMsg = e.getMessage();
            }
        }
        return errorMsg;
    }

    private void updateDemographicsDetailsInEnrolment(FindAadhaarRes findAadhaarResponse) {
        AadhaarInfo residentData = findAadhaarResponse.getPrintData();
        Demographics demoGraphics = this.enrollmentService.getDemographics();
        this.enrollmentService.setEnrollmentLocale(residentData.getLangCode());
        PersonalDetail personalDetail = demoGraphics.getPersonalDetail();
        personalDetail.setFullName(residentData.getName());
        personalDetail.setFullNameLocal(residentData.getLocalResName());
        personalDetail.getName().setMandatory(false);
        personalDetail.setAadhaarNumber(String.valueOf(residentData.getUid()));
        if (StringUtils.isNotBlank((String)residentData.getGender())) {
            personalDetail.getApplicantGender().setExistingGender(residentData.getGender());
        }
        if (StringUtils.isNotBlank((String)residentData.getDob())) {
            personalDetail.getAgeDob().setExistingDob(residentData.getDob().split("-")[2], residentData.getDob().split("-")[1], residentData.getDob().split("-")[0]);
        }
        Address address = demoGraphics.getContact().getAddress();
        if (StringUtils.isNotBlank((String)residentData.getCareof()) && residentData.getCareof().startsWith("C/O")) {
            String[] englishValue = residentData.getCareof().split(":");
            String[] translatedValue = residentData.getLocalCareof().split(":");
            if (englishValue.length > 1) {
                address.setExistingCareOfName(englishValue[1].trim());
            }
            if (translatedValue.length > 1) {
                address.setExistingCareOfNameLocal(translatedValue[1].trim());
            }
        }
        if (StringUtils.isNotBlank((String)residentData.getBuilding()) && StringUtils.isNotBlank((String)residentData.getLocalBuilding())) {
            address.setExistingBuilding(residentData.getBuilding());
            address.setExistingBuildingLocal(residentData.getLocalBuilding());
        }
        if (StringUtils.isNotBlank((String)residentData.getStreet()) && StringUtils.isNotBlank((String)residentData.getLocalStreet())) {
            address.setExistingStreet(residentData.getStreet());
            address.setExistingStreetLocal(residentData.getLocalStreet());
        }
        if (StringUtils.isNotBlank((String)residentData.getLandmark()) && StringUtils.isNotBlank((String)residentData.getLocalLandmark())) {
            address.setExistingLandmark(residentData.getLandmark());
            address.setExistingLandmarkLocal(residentData.getLocalLandmark());
        }
        if (StringUtils.isNotBlank((String)residentData.getLocality()) && StringUtils.isNotBlank((String)residentData.getLocalLocality())) {
            address.setExistingLocality(residentData.getLocality());
            address.setExistingLocalityLocal(residentData.getLocalLocality());
        }
        PinCodeDetail pinCodeDetail = address.getPinCodeDetail();
        if (StringUtils.isNotBlank((String)residentData.getState()) && StringUtils.isNotBlank((String)residentData.getStateName()) && StringUtils.isNotBlank((String)residentData.getLocalState())) {
            pinCodeDetail.getState().setExistingAddressCode(residentData.getState());
            pinCodeDetail.getState().setExistingAddressValue(residentData.getStateName());
            pinCodeDetail.getState().setExistingAddressValueLocal(residentData.getLocalState());
        }
        if (StringUtils.isNotBlank((String)residentData.getDistrict()) && StringUtils.isNotBlank((String)residentData.getDistrictName()) && StringUtils.isNotBlank((String)residentData.getLocalDistrict())) {
            pinCodeDetail.getDistrict().setExistingAddressCode(residentData.getDistrict());
            pinCodeDetail.getDistrict().setExistingAddressValue(residentData.getDistrictName());
            pinCodeDetail.getDistrict().setExistingAddressValueLocal(residentData.getLocalDistrict());
        }
        if (StringUtils.isNotBlank((String)residentData.getSubDistrict()) && StringUtils.isNotBlank((String)residentData.getSubDistrictName()) && StringUtils.isNotBlank((String)residentData.getSubDistrictLocalName())) {
            pinCodeDetail.getSubDistrict().setExistingAddressCode(residentData.getSubDistrict());
            pinCodeDetail.getSubDistrict().setExistingAddressValue(residentData.getSubDistrictName());
            pinCodeDetail.getSubDistrict().setExistingAddressValueLocal(residentData.getSubDistrictLocalName());
        }
        if (StringUtils.isNotBlank((String)residentData.getVtc()) && StringUtils.isNotBlank((String)residentData.getVtcName()) && StringUtils.isNotBlank((String)residentData.getLocalVtc())) {
            pinCodeDetail.getVtc().setExistingAddressCode(residentData.getVtc());
            pinCodeDetail.getVtc().setExistingAddressValue(residentData.getVtcName());
            pinCodeDetail.getVtc().setExistingAddressValueLocal(residentData.getLocalVtc());
        }
        if (StringUtils.isNotBlank((String)residentData.getPincode()) && StringUtils.isNotBlank((String)residentData.getPoName()) && StringUtils.isNotBlank((String)residentData.getPoNameLocal())) {
            pinCodeDetail.getPinCode().setExistingAddressCode(residentData.getPincode());
            pinCodeDetail.getPinCode().setExistingAddressValue(residentData.getPincode());
            pinCodeDetail.getPinCode().setExistingAddressValueLocal(residentData.getPincode());
            pinCodeDetail.setExistingPoName(residentData.getPoName());
            pinCodeDetail.setExistingDefaultPoName(residentData.getPoName());
            pinCodeDetail.setExistingPoNameLocal(residentData.getPoNameLocal());
            pinCodeDetail.setExistingPoPinCode(residentData.getPincode());
            PostOffice postOffice = this.postOfficeDataService.findPostOffice(residentData.getPincode(), residentData.getVtc(), residentData.getPoName());
            pinCodeDetail.setExistingPoType(postOffice != null ? postOffice.getType() : PostOfficeType.SUB_OFFICE);
        }
        if (StringUtils.isNotBlank((String)residentData.getMobile())) {
            demoGraphics.getContact().getMobile().setExistingNumber(residentData.getMobile());
        }
        if (StringUtils.isNotBlank((String)residentData.getEmail())) {
            demoGraphics.getContact().getEmail().setExistingEmail(residentData.getEmail());
        }
    }
}

