/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.findaadhaar;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.ui.findaadhaar.IGetAadhaarTabConstants;
import in.gov.uidai.ec.ui.shared.l10n.MsgKeysILV;
import in.gov.uidai.ec.ui.shared.l10n.MsgKeysPrintAadhaarTab;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import in.gov.uidai.swing.notify.OverlayResetDocumentListener;
import in.gov.uidai.swing.table.TableLayout;
import in.gov.uidai.swing.tilv.FBNumericDocument;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.GregorianCalendar;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.StringUtils;

class YOBPanelBuilder
implements IGetAadhaarTabConstants,
IViewElementComposite {
    public final JComboBox<String> yobType;
    private final JTextField yobField = new JTextField();
    private final JPanel yobBox;

    YOBPanelBuilder(IResourceBundleContext rbc) {
        this.yobType = new JComboBox();
        this.yobType.addItem("Declared");
        this.yobType.addItem("Verified");
        this.yobType.addItem("Approximate");
        FBNumericDocument dobYearDoc = new FBNumericDocument((JTextComponent)this.yobField, rbc.getMessage((Object)MsgKeysILV.NUMERIC, new Object[0]));
        dobYearDoc.setMaxLength(4);
        this.yobField.setDocument((Document)dobYearDoc);
        dobYearDoc.addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)this.yobField));
        this.yobField.putClientProperty("watermark-text", "YYYY");
        double[][] guides = new double[][]{{70.0, 5.0, -1.0}, {22.0}};
        this.yobBox = new JPanel((LayoutManager)new TableLayout((double[][])guides));
        this.yobBox.add((Component)this.yobField, "0, 0, f, f");
        this.yobBox.add(this.yobType, "2, 0, f, f");
        FocusAdapter fl = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (e.isTemporary()) {
                    return;
                }
                int age = YOBPanelBuilder.this.getYobAge();
                if (age >= 100) {
                    L10nOptionPaneBuilder.getInstance().showWarning((Object)MsgKeysPrintAadhaarTab.AGE_MAX_WARNING, (Component)YOBPanelBuilder.this.yobBox.getRootPane());
                    YOBPanelBuilder.this.yobField.setText(null);
                }
                if (age < 0) {
                    L10nOptionPaneBuilder.getInstance().showWarning((Object)MsgKeysPrintAadhaarTab.AGE_MIN_WARNING, (Component)YOBPanelBuilder.this.yobBox.getRootPane());
                    YOBPanelBuilder.this.yobField.setText(null);
                }
            }
        };
        this.yobField.addFocusListener(fl);
    }

    JComponent getOptionsPanel() {
        return this.yobBox;
    }

    JTextField getYobField() {
        return this.yobField;
    }

    private int getYobAge() {
        String yearStr = this.yobField.getText();
        if (StringUtils.isBlank((String)yearStr)) {
            return 0;
        }
        return new GregorianCalendar().get(1) - Integer.parseInt(yearStr);
    }
}

