/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.gps;

import in.gov.uidai.ec.ecmpapi.EcmpApiService;
import in.gov.uidai.ec.escapi.GpsInfo;
import in.gov.uidai.ec.escapi.StationInfoStoreException;
import in.gov.uidai.ec.icas.preference.IOucDataStore;
import in.gov.uidai.ec.service.gps.GeoData;
import in.gov.uidai.ec.service.gps.IGpsControl;
import in.gov.uidai.ec.service.gps.IGpsListener;
import in.gov.uidai.ec.service.gps.IGpsPreference;
import in.gov.uidai.ec.service.presync.IPreSyncPreference;
import in.gov.uidai.ec.ui.gps.GpsUpdateHandler;
import in.gov.uidai.ec.ui.gps.IGpsConstants;
import in.gov.uidai.ec.ui.main.UnsavedTracker;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysMainWin;
import in.gov.uidai.ec.ui.shared.l10n.MsgKeysGps;
import in.gov.uidai.litef.devapi.EventHandler;
import in.gov.uidai.litef.devapi.GenericEventHandler;
import in.gov.uidai.litef.devapi.ILiteEvent;
import in.gov.uidai.litef.devapi.ILiteScaffold;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.litef.devapi.IOnScreenDisplay;
import in.gov.uidai.litef.devapi.IOnScreenDisplayAware;
import in.gov.uidai.litef.devapi.IViewElement;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GpsDetailsControl
implements IOnScreenDisplayAware,
IGpsConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(GpsDetailsControl.class);
    private static final String LATITUDE_DEFAULTS = "0\u00b00'0.0\" N";
    private static final String LONGITUDE_DEFAULTS = "0\u00b00'0.0\" E";
    private static final String ALTITUDE_DEFAULTS = ".00m";
    private final GpsUpdateHandler gpsUpdateHandler = new GpsUpdateHandler();
    private IOnScreenDisplay osd;
    private IGpsControl gpsCtrl;
    private IGpsPreference gpsPref;
    private IOucDataStore oucDataStore;
    private UnsavedTracker tracker;
    private IPreSyncPreference preSyncPref;
    private EcmpApiService ecmpApiService;

    public void populateOnScreenDisplay(IOnScreenDisplay osd) {
        this.osd = osd;
    }

    public void setEcmpApiService(EcmpApiService ecmpApiService) {
        this.gpsUpdateHandler.setEcmpApiService(ecmpApiService);
    }

    public void setOucDataStore(IOucDataStore dataStore) {
        this.gpsUpdateHandler.setOucDataStore(dataStore);
        this.oucDataStore = dataStore;
    }

    public final void setUnsavedTracker(UnsavedTracker tracker) {
        this.tracker = tracker;
    }

    public void setPreSyncPref(IPreSyncPreference preSyncPref) {
        this.preSyncPref = preSyncPref;
    }

    public void setGpsPreference(IGpsPreference pref) {
        this.gpsPref = pref;
        this.gpsUpdateHandler.setGpsPreference(pref);
    }

    public void setGpsControl(IGpsControl ctrl) {
        this.gpsCtrl = ctrl;
        IGpsListener gpsl = new IGpsListener(){

            public void geoDataReceived(GeoData data) {
                GpsDetailsControl.this.gpsUpdateHandler.captureGPSData(data);
            }

            public void deviceRemoved() {
            }

            public void deviceConnected() {
            }
        };
        this.gpsCtrl.addGpsListener(gpsl);
    }

    @EventHandler(name="hID_Gps_Toolbut_sel", method="actionPerformed")
    public void onGpsSelect(ILiteEvent evt) {
        LOGGER.debug("gps tab selected");
        if (!this.tracker.selectOther(evt)) {
            return;
        }
        String scafId = this.osd.recompose(evt.getScaffoldId(), "gpsView");
        ILiteScaffold scaffold = this.osd.getScaffold(scafId);
        ((IViewElement)scaffold.getElementMap().get("hID_MainWin_Header")).set("text", (Object)LabelKeysMainWin.PROCESS_GPS);
        String viewId = this.osd.getScaffold(evt.getScaffoldId()).getViewId();
        ILiteView view = this.osd.getView(viewId);
        view.setEnabled(false);
        Map eMap = view.getElementMap();
        try {
            this.setBaudRateOptions(eMap);
            GpsInfo gpsInfo = this.oucDataStore.getGpsInfo();
            ((IViewElement)eMap.get("eID_Gps_Latitude")).set("text", (Object)(GeoData.convertCoords((float)gpsInfo.getLatitude().floatValue()) + " " + this.gpsPref.getLatBearing("N")));
            ((IViewElement)eMap.get("eID_Gps_Longitude")).set("text", (Object)(GeoData.convertCoords((float)gpsInfo.getLongitude().floatValue()) + " " + this.gpsPref.getLongBearing("E")));
            ((IViewElement)eMap.get("eID_Gps_Altitude")).set("text", (Object)(GeoData.COORD_FORMAT.format(gpsInfo.getAltitude().floatValue()) + "m"));
            view.setEnabled(true);
        }
        catch (IOException e) {
            LOGGER.debug("Unable to connect to ouc :", (Throwable)e);
        }
        catch (StationInfoStoreException e) {
            LOGGER.debug("Unable to fetch speed from gps.json", (Throwable)e);
        }
    }

    private void setBaudRateOptions(Map<String, IViewElement> eMap) throws IOException, StationInfoStoreException {
        String[] baudRates = this.gpsPref.getBaudrates();
        if (baudRates != null) {
            ArrayList<String> baudRateList = new ArrayList<String>(Arrays.asList(baudRates));
            eMap.get("eID_Gps_Baudrate").set("options", baudRateList);
            eMap.get("eID_Gps_Baudrate").set("selectedItem", (Object)String.valueOf(this.oucDataStore.getGpsInfo().getSpeed()));
        }
    }

    @EventHandler(name="hID_Gps_Start", method="actionPerformed")
    public void onGpsStart(ILiteEvent evt) {
        this.osd.getWindowForScaffold(evt.getScaffoldId());
        this.gpsCtrl.start();
        ILiteView view = this.osd.getView(evt.getViewId());
        Map eMap = view.getElementMap();
        ((IViewElement)eMap.get("eID_Gps_Start")).set("enable", (Object)false);
        ((IViewElement)eMap.get("eID_Gps_Stop")).set("enable", (Object)true);
        Window win = this.osd.getWindowForScaffold(evt.getScaffoldId());
        L10nOptionPaneBuilder.getInstance().showInfo((Object)MsgKeysGps.STARTED, (Component)win, new Object[0]);
    }

    @EventHandler(name="hID_Gps_Stop", method="actionPerformed")
    public void onGpsStop(ILiteEvent evt) {
        Window win = this.osd.getWindowForScaffold(evt.getScaffoldId());
        ILiteView view = this.osd.getView(evt.getViewId());
        this.gpsCtrl.stop();
        try {
            this.gpsUpdateHandler.updateGeoGPSData();
            Map eMap = view.getElementMap();
            ((IViewElement)eMap.get("eID_Gps_Stop")).set("enable", (Object)Boolean.FALSE);
            ((IViewElement)eMap.get("eID_Gps_Start")).set("enable", (Object)Boolean.TRUE);
            boolean isGPSVerify = StringUtils.equalsIgnoreCase((String)this.preSyncPref.getGPSUpdateVerifyRequired(), (String)"Y");
            boolean isGpsCaptured = false;
            MsgKeysGps msgKeysGps = MsgKeysGps.STOPPED;
            if (isGPSVerify) {
                msgKeysGps = MsgKeysGps.RESTART;
                isGpsCaptured = this.isGpsCaptured(eMap);
            }
            if (isGpsCaptured) {
                msgKeysGps = MsgKeysGps.CAPTURE_FAILED;
            }
            L10nOptionPaneBuilder.getInstance().showInfo((Object)msgKeysGps, (Component)win, new Object[0]);
        }
        catch (IOException e) {
            LOGGER.error("OUC service communication error while storing gps details", (Throwable)e);
            L10nOptionPaneBuilder.getInstance().showError((Object)MsgKeysGps.OUC_UNREACHABLE, (Component)win, new Object[0]);
        }
        catch (StationInfoStoreException e) {
            LOGGER.error("Unable to store gps info in OUC service", (Throwable)e);
            L10nOptionPaneBuilder.getInstance().showError((Object)MsgKeysGps.CAPTURE_FAILED, (Component)win, new Object[0]);
        }
    }

    private boolean isGpsCaptured(Map<String, IViewElement> eMap) {
        String lattitude = (String)eMap.get("eID_Gps_Latitude").get("text");
        String longitude = (String)eMap.get("eID_Gps_Longitude").get("text");
        String altitude = (String)eMap.get("eID_Gps_Altitude").get("text");
        return StringUtils.isBlank((String)lattitude) && StringUtils.isBlank((String)longitude) && StringUtils.isBlank((String)altitude) || lattitude.equalsIgnoreCase(LATITUDE_DEFAULTS) && longitude.equalsIgnoreCase(LONGITUDE_DEFAULTS) && altitude.equalsIgnoreCase(ALTITUDE_DEFAULTS);
    }

    @GenericEventHandler(value="hID_Goto_Gps_Page")
    public void onGpsUpdate(ILiteEvent evt) {
        this.tracker.reset();
        Map eMap = this.osd.getScaffold(evt.getScaffoldId()).getElementMap();
        ((IViewElement)eMap.get("eID_Gps_Toolbut")).call("click");
    }

    @EventHandler(name="hID_Goto_Gps_Page", method="actionPerformed")
    public void onGoToGps(ILiteEvent evt) {
        this.tracker.reset();
        Map eMap = this.osd.getScaffold(evt.getScaffoldId()).getElementMap();
        ((IViewElement)eMap.get("eID_Gps_Toolbut")).call("click");
    }

    @EventHandler(name="hID_Gps_SaveBaudRate", method="actionPerformed")
    public void saveBaudRate(ILiteEvent evt) {
        ILiteView view = this.osd.getView(evt.getViewId());
        Map eMap = view.getElementMap();
        Window win = this.osd.getWindowForScaffold(evt.getScaffoldId());
        String baudRate = (String)((IViewElement)eMap.get("eID_Gps_Baudrate")).get("selectedItem");
        try {
            GpsInfo gpsInfo = this.oucDataStore.getGpsInfo();
            gpsInfo.setSpeed(Integer.parseInt(baudRate));
            this.gpsPref.setSpeed(Integer.parseInt(baudRate));
            this.oucDataStore.setGpsInfo(gpsInfo);
            L10nOptionPaneBuilder.getInstance().showInfo((Object)MsgKeysGps.BAUD_RATE_SAVED, (Component)win, new Object[0]);
        }
        catch (IOException e) {
            LOGGER.error("OUC service communication error while storing gps details", (Throwable)e);
            L10nOptionPaneBuilder.getInstance().showError((Object)MsgKeysGps.OUC_UNREACHABLE, (Component)win, new Object[0]);
        }
        catch (StationInfoStoreException e) {
            LOGGER.error("Unable to store gps info in OUC service", (Throwable)e);
            L10nOptionPaneBuilder.getInstance().showError((Object)MsgKeysGps.BAUD_RATE_STORE_FAILED, (Component)win, new Object[0]);
        }
    }
}

