/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.gps;

import in.gov.uidai.ec.ecmpapi.EcmpApiService;
import in.gov.uidai.ec.ecmpapi.xml.Gps.GpsDataReadReq;
import in.gov.uidai.ec.ecmpapi.xml.Gps.GpsValidationResponse;
import in.gov.uidai.ec.escapi.GpsInfo;
import in.gov.uidai.ec.escapi.StationInfoStoreException;
import in.gov.uidai.ec.icas.preference.IOucDataStore;
import in.gov.uidai.ec.service.gps.GeoData;
import in.gov.uidai.ec.service.gps.IGpsPreference;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import java.io.IOException;
import java.text.DecimalFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GpsUpdateHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(GpsUpdateHandler.class);
    private final DecimalFormat df = new DecimalFormat("0000.000000");
    private IGpsPreference gpsPref;
    private IOucDataStore oucDataStore;
    private GeoData geoData;
    private EcmpApiService ecmpApiService;
    GpsValidationResponse gpsValidationResponse;

    public void setEcmpApiService(EcmpApiService ecmpApiService) {
        this.ecmpApiService = ecmpApiService;
    }

    public void setGpsPreference(IGpsPreference pref) {
        this.gpsPref = pref;
    }

    public void setOucDataStore(IOucDataStore oucDataStore) {
        this.oucDataStore = oucDataStore;
    }

    void captureGPSData(GeoData data) {
        if (data != null) {
            LOGGER.debug("received ping from GPS device :" + data.getLatitude() + "," + data.getLongitude() + "," + data.getAltitude());
        } else {
            LOGGER.debug("received ping from GPS device with no data");
        }
        this.geoData = data;
    }

    void updateGeoGPSData() throws IOException, StationInfoStoreException {
        if (this.geoData == null) {
            LOGGER.info("GPS information is not available");
            L10nOptionPaneBuilder.getInstance().showError((Object)"No GPS co-ordinates are captured. Please capture it again", null, new Object[0]);
            return;
        }
        LOGGER.info("GPS information is available");
        float latitude = Float.parseFloat(this.geoData.getLatitude());
        float longitude = Float.parseFloat(this.geoData.getLongitude());
        float altitude = Float.parseFloat(this.geoData.getAltitude());
        long captureTime = System.currentTimeMillis();
        int decimalLengthLongitude = this.df.format(longitude).length() - 1;
        int decimalLengthLatitude = this.df.format(latitude).length() - 1;
        if (decimalLengthLongitude == 10 && decimalLengthLatitude == 10) {
            GpsDataReadReq gpsDataReadReq = new GpsDataReadReq();
            gpsDataReadReq.setLatitude(latitude);
            gpsDataReadReq.setLongitude(longitude);
            try {
                this.gpsValidationResponse = this.ecmpApiService.makeGPSValidationApiCall(gpsDataReadReq);
                if (this.gpsValidationResponse.getIntValidGPS() == 0) {
                    LOGGER.info("GPS co-ordinates are not valid: " + latitude + ":" + longitude + ":" + altitude + ":" + System.currentTimeMillis());
                    L10nOptionPaneBuilder.getInstance().showError((Object)"GPS co-ordinates are not valid. Please capture it again", null, new Object[0]);
                    return;
                }
                GpsInfo gpsInfo = this.oucDataStore.getGpsInfo();
                gpsInfo.setLatitude(Float.valueOf(latitude));
                gpsInfo.setLongitude(Float.valueOf(longitude));
                gpsInfo.setAltitude(Float.valueOf(altitude));
                gpsInfo.setCaptureTime(Long.valueOf(captureTime));
                this.gpsPref.setLatitude(latitude);
                this.gpsPref.setAltitude(altitude);
                this.gpsPref.setLongitude(longitude);
                this.gpsPref.setCaptureTime(captureTime);
                LOGGER.info("saving GPS co-ordinates: " + latitude + ":" + longitude + ":" + altitude + ":" + System.currentTimeMillis());
                this.oucDataStore.setGpsInfo(gpsInfo);
                LOGGER.info("GPS co-ordinates saved successfully");
            }
            catch (Exception e) {
                LOGGER.error("GPS validation endpoint call failed", (Throwable)e);
                GpsInfo gpsInfo = this.oucDataStore.getGpsInfo();
                gpsInfo.setLatitude(Float.valueOf(latitude));
                gpsInfo.setLongitude(Float.valueOf(longitude));
                gpsInfo.setAltitude(Float.valueOf(altitude));
                gpsInfo.setCaptureTime(Long.valueOf(captureTime));
                this.gpsPref.setLatitude(latitude);
                this.gpsPref.setAltitude(altitude);
                this.gpsPref.setLongitude(longitude);
                this.gpsPref.setCaptureTime(captureTime);
                LOGGER.info("saving GPS co-ordinates: " + latitude + ":" + longitude + ":" + altitude + ":" + System.currentTimeMillis());
                this.oucDataStore.setGpsInfo(gpsInfo);
                LOGGER.info("GPS co-ordinates saved successfully");
            }
        } else {
            LOGGER.info("GPS co-ordinates are not in correct format");
            L10nOptionPaneBuilder.getInstance().showError((Object)"Captured GPS co-ordinates are not in correct format. Please capture it again", null, new Object[0]);
        }
    }
}

