/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.gps;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.gps.GeoData;
import in.gov.uidai.ec.service.gps.IGpsControl;
import in.gov.uidai.ec.service.gps.IGpsListener;
import in.gov.uidai.ec.swing.FixedWidthTopDownTile;
import in.gov.uidai.ec.ui.gps.GpsSectionHeader;
import in.gov.uidai.ec.ui.gps.IGpsConstants;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysGps;
import in.gov.uidai.ec.ui.shared.l10n.MsgKeysGps;
import in.gov.uidai.litef.beans.ModalVisualExecutionContext;
import in.gov.uidai.litef.beans.stdview.ExportViewElement;
import in.gov.uidai.litef.beans.stdview.StandardViewPeer;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.litef.widgets.StandardSwingElementFactory;
import in.gov.uidai.swing.TransparentBox;
import in.gov.uidai.swing.fontman.FontManager;
import in.gov.uidai.swing.painter.IPaintDelegate;
import in.gov.uidai.swing.painter.LinearGradientBackground;
import in.gov.uidai.swing.table.TableLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GpsViewPeer
extends StandardViewPeer
implements IGpsConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(GpsViewPeer.class);
    DecimalFormat df = new DecimalFormat("0000.000000");
    @ExportViewElement(as="eID_Gps_Latitude", using=StandardSwingElementFactory.class)
    private JLabel latitudeField;
    @ExportViewElement(as="eID_Gps_Longitude", using=StandardSwingElementFactory.class)
    private JLabel longitudeField;
    @ExportViewElement(as="eID_Gps_Altitude", using=StandardSwingElementFactory.class)
    private JLabel altitudeField;
    private IResourceBundleContext rbCtxt;
    private IGpsControl gpsCtrl;
    private static final DecimalFormat GPS_FORMAT = new DecimalFormat("00000.00");
    @ExportViewElement(as="eID_Gps_Start", using=StandardSwingElementFactory.class)
    private JButton startBut;
    @ExportViewElement(as="eID_Gps_Stop", using=StandardSwingElementFactory.class)
    private JButton saveBut;
    @ExportViewElement(as="eID_Gps_Baudrate", using=StandardSwingElementFactory.class)
    private JComboBox baudrateCombo;
    private static final String GPS_PROPS_PATH = "";

    public void setResourceBundleContext(IResourceBundleContext ctxt) {
        this.rbCtxt = ctxt;
    }

    public void setGpsControl(IGpsControl ctrl) {
        this.gpsCtrl = ctrl;
        IGpsListener gpsl = new IGpsListener(){

            public void geoDataReceived(GeoData data) {
                float dlati = Float.parseFloat(data.getLatitude());
                float dlongi = Float.parseFloat(data.getLongitude());
                float dalti = Float.parseFloat(data.getAltitude());
                double dlatitude = dlati;
                double dlongitude = dlongi;
                int decimalLengthLongitude = GpsViewPeer.this.df.format(dlongitude).length() - 1;
                int decimalLengthlatitude = GpsViewPeer.this.df.format(dlatitude).length() - 1;
                if (decimalLengthLongitude != 10 || decimalLengthlatitude != 10) {
                    return;
                }
                GpsViewPeer.this.longitudeField.setText(data.getDMSLongitude());
                GpsViewPeer.this.latitudeField.setText(data.getDMSLatitude());
                GpsViewPeer.this.altitudeField.setText(data.getFormattedAltitude() + "m");
            }

            public void deviceRemoved() {
            }

            public void deviceConnected() {
            }
        };
        this.gpsCtrl.addGpsListener(gpsl);
    }

    protected void enableImpl(boolean flag) {
        if (this.gpsCtrl.isRunning()) {
            this.startBut.setEnabled(false);
            this.saveBut.setEnabled(true);
        } else {
            this.startBut.setEnabled(true);
            this.saveBut.setEnabled(false);
        }
    }

    protected void prepareImpl() {
        FixedWidthTopDownTile mainTile = new FixedWidthTopDownTile();
        mainTile.setWidth(1000);
        mainTile.setScrollable(true);
        mainTile.setPadding(5, 0, 5, 0);
        mainTile.prepare();
        this.setContentPane(mainTile.toSwing());
        TransparentBox top1 = new TransparentBox();
        top1.setLayout((LayoutManager)new BoxLayout((Container)top1, 1));
        mainTile.addTopComponent((Component)top1);
        top1.add(Box.createVerticalStrut(20));
        top1.add((Component)new GpsSectionHeader("GPS Baud rate"));
        top1.add(Box.createVerticalStrut(10));
        top1.add((Component)this.createBaudrateArea());
        TransparentBox top = new TransparentBox();
        top.setLayout((LayoutManager)new BoxLayout((Container)top, 1));
        mainTile.addTopComponent((Component)top);
        top.add(Box.createVerticalStrut(20));
        top.add((Component)new GpsSectionHeader("GPS Information"));
        top.add(Box.createVerticalStrut(10));
        top.add((Component)this.createGpsArea());
        this.setVisualExecutionContext((IVisualExecutionContext)new ModalVisualExecutionContext(mainTile.toSwing(), false));
    }

    protected void disposeImpl() {
    }

    private JComponent createBaudrateArea() {
        JLabel baudrateInfo = new JLabel("Baud rate");
        this.baudrateCombo = new JComboBox();
        JButton saveBtn = new JButton("Save");
        saveBtn.addActionListener((ActionListener)this.getEventContext().getEventListener("hID_Gps_SaveBaudRate", ActionListener.class));
        double[][] guides = new double[][]{{-1.0, 5.0, 100.0, 15.0, 100.0, 15.0, 50.0, 5.0, 350.0, -1.0}, {5.0, 22.0, 5.0}};
        TransparentBox baudratePanel = new TransparentBox((LayoutManager)new TableLayout((double[][])guides));
        baudratePanel.add((Component)baudrateInfo, (Object)"2, 1, right, full");
        baudratePanel.add((Component)this.baudrateCombo, (Object)"4, 1, full, full");
        baudratePanel.add((Component)saveBtn, (Object)"6, 1, c, f");
        return baudratePanel;
    }

    public String[] getBaudrateOptions(String path) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        Properties props = new Properties();
        String[] baudrates = null;
        try {
            InputStream input = cl.getResourceAsStream(path);
            props.load(input);
            input.close();
            String baudRatesStr = props.getProperty("gps.baudrates");
            if (baudRatesStr != null) {
                baudrates = baudRatesStr.split(";");
            }
            if (baudrates == null) {
                baudrates = new String[]{};
            }
        }
        catch (Exception exep) {
            LOGGER.error("Error in getBaudRateOptions", (Throwable)exep);
        }
        return new String[]{"4800", "9600", "115200"};
    }

    private JComponent createGpsArea() {
        JLabel disclaimer = new JLabel(this.rbCtxt.getMessage((Object)MsgKeysGps.DISCLAIMER, new Object[0]));
        disclaimer.setBorder(new EmptyBorder(0, 100, 0, 100));
        Font font = FontManager.getInst().getScreenFont("ZURCHBC.TTF", 1, 16);
        JLabel latLab = new JLabel("Latitude:");
        latLab.setFont(font);
        JLabel longLab = new JLabel("Longitude:");
        longLab.setFont(font);
        JLabel altLab = new JLabel("Altitude:");
        altLab.setFont(font);
        this.latitudeField = new JLabel("000.00");
        this.longitudeField = new JLabel("000.00");
        this.altitudeField = new JLabel("0");
        this.startBut = new JButton(this.rbCtxt.getMessage((Object)LabelKeysGps.START, new Object[0]));
        ActionListener startAxn = (ActionListener)this.getEventContext().getEventListener("hID_Gps_Start", ActionListener.class);
        this.startBut.addActionListener(startAxn);
        this.saveBut = new JButton(this.rbCtxt.getMessage((Object)LabelKeysGps.SAVE, new Object[0]));
        ActionListener stopAxn = (ActionListener)this.getEventContext().getEventListener("hID_Gps_Stop", ActionListener.class);
        this.saveBut.addActionListener(stopAxn);
        this.saveBut.setEnabled(false);
        double[][] guides = new double[][]{{-1.0, -2.0, 5.0, 120.0, 5.0, -2.0, 5.0, 120.0, 5.0, -2.0, 5.0, 120.0, -1.0}, {10.0, 35.0, 10.0, -2.0, 10.0, 30.0}};
        TransparentBox result = new TransparentBox((LayoutManager)new TableLayout((double[][])guides));
        result.add((Component)latLab, (Object)"1, 1, right, full");
        result.add((Component)this.decorateGps(this.latitudeField), (Object)"3, 1, full, full");
        result.add((Component)longLab, (Object)"5, 1, right, full");
        result.add((Component)this.decorateGps(this.longitudeField), (Object)"7, 1, full, full");
        result.add((Component)altLab, (Object)"9, 1, right, full");
        result.add((Component)this.decorateGps(this.altitudeField), (Object)"11, 1, full, full");
        result.add((Component)disclaimer, (Object)"0, 3, 12, 3, full, full");
        TransparentBox butBox = new TransparentBox((LayoutManager)new FlowLayout(1, 0, 0));
        butBox.add((Component)this.startBut);
        butBox.add(Box.createHorizontalStrut(5));
        butBox.add((Component)this.saveBut);
        result.add((Component)butBox, (Object)"0, 5, 12, 5, center, full");
        return result;
    }

    private JComponent decorateGps(JLabel gpsField) {
        Font font = FontManager.getInst().getScreenFont("ZURCHBC.TTF", 1, 16);
        gpsField.setForeground(Color.decode("#ffffff"));
        gpsField.setFont(font);
        gpsField.setHorizontalAlignment(0);
        TransparentBox result = new TransparentBox((LayoutManager)new BorderLayout(0, 0));
        result.add((Component)gpsField, (Object)"Center");
        result.setBackground((IPaintDelegate)new LinearGradientBackground().borderSize(0.0f).direction(1).gradientColors("#999999, #999999").gradientStops("0, 1").roundingSize(5, 5));
        result.setBorder((Border)new EmptyBorder(10, 10, 10, 10));
        return result;
    }
}

