/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.login;

import in.gov.uidai.ec.ecmpapi.EcmpApiService;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.operatordisclosure.DisclosurePopupProcessor;
import in.gov.uidai.ec.service.operatordisclosure.DisclosureProcessor;
import in.gov.uidai.ec.service.opsync.OperatorSyncService;
import in.gov.uidai.ec.service.registration.IRegistrationService;
import in.gov.uidai.ec.service.session.ISessionService;
import in.gov.uidai.ec.service.session.model.LoginValidator;
import in.gov.uidai.ec.ui.login.RandomTaskExecutor;
import in.gov.uidai.ec.ui.shared.ShutdownHook;
import in.gov.uidai.ec.ui.shared.VerificationGuard;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysMainWin;
import in.gov.uidai.ec.ui.shared.l10n.MsgKeysLogin;
import in.gov.uidai.litef.devapi.EventHandler;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.devapi.IEventContextAware;
import in.gov.uidai.litef.devapi.ILiteEvent;
import in.gov.uidai.litef.devapi.ILiteScaffold;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.litef.devapi.IOnScreenDisplay;
import in.gov.uidai.litef.devapi.IOnScreenDisplayAware;
import in.gov.uidai.litef.devapi.IViewElement;
import in.gov.uidai.litef.devapi.ScaffoldPlacement;
import in.gov.uidai.swing.UidSplashScreen;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import java.awt.Component;
import java.util.Map;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class LoginControl
implements IEventContextAware,
IOnScreenDisplayAware,
ApplicationListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoginControl.class);
    private IResourceBundleContext rbCtxt;
    private IEventContext evtCtxt;
    private IOnScreenDisplay osd;
    private VerificationGuard verificationGuard;
    private ISessionService sessionService;
    private OperatorSyncService operatorSyncService;
    private boolean doOpSync;
    private DisclosureProcessor disclosureProcessor;
    private ShutdownHook shutdownHook;
    private ILiteScaffold mainWin;
    private DisclosurePopupProcessor disclosurePopupProcessor;
    private IRegistrationService registrationService;
    private EcmpApiService ecmpApiService;
    private String sid = "";

    public void setRegistrationService(IRegistrationService registrationService) {
        this.registrationService = registrationService;
    }

    public void setEcmpApiService(EcmpApiService ecmpApiService) {
        this.ecmpApiService = ecmpApiService;
    }

    public void populateEventContext(IEventContext ctxt) {
        this.evtCtxt = ctxt;
    }

    public void setShutdownHook(ShutdownHook shutdownHook) {
        this.shutdownHook = shutdownHook;
    }

    public void setDisclosurePopupProcessor(DisclosurePopupProcessor disclosurePopupProcessor) {
        this.disclosurePopupProcessor = disclosurePopupProcessor;
    }

    public void populateOnScreenDisplay(IOnScreenDisplay osd) {
        this.osd = osd;
    }

    public void setSessionService(ISessionService sessionService) {
        this.sessionService = sessionService;
    }

    public void setVerificationGuard(VerificationGuard verificationGuard) {
        this.verificationGuard = verificationGuard;
    }

    public void setResourceBundleContext(IResourceBundleContext ctxt) {
        this.rbCtxt = ctxt;
    }

    public void setOperatorSyncService(OperatorSyncService operatorSyncService) {
        this.operatorSyncService = operatorSyncService;
    }

    public void setDisclosureProcessor(DisclosureProcessor disclosureProcessor) {
        this.disclosureProcessor = disclosureProcessor;
    }

    public void onApplicationEvent(ApplicationEvent evt) {
        if (!(evt instanceof ContextRefreshedEvent)) {
            return;
        }
        LOGGER.info("IntegrityVerificationService starts");
        this.verificationGuard.verifyPropertyLoadError();
        this.verificationGuard.verifyIntegrity();
        this.verificationGuard.verifyAppRegistration();
        LOGGER.info("ApplicationIntegrityVerified successfully");
        this.verificationGuard.verifyEnrolServiceClientStatus();
        LOGGER.info("Ota update client is running in this system");
        this.disclosureProcessor.readingFromDisclosureDatFile();
        String sId = this.osd.compose("mainWin", "blankView");
        this.mainWin = this.osd.getScaffold(sId);
        this.osd.display(sId, ScaffoldPlacement.MAXIMIZED);
        this.shutdownHook.cleanupFindAadhaarOldData();
        this.showModeSelectionPage(null);
        Executors.newSingleThreadExecutor().submit(() -> this.ecmpApiService.doUpdateInfo());
        Executors.newSingleThreadExecutor().submit(() -> RandomTaskExecutor.scheduleTaskRandomly(this.ecmpApiService));
    }

    public void showModeSelectionPage(ILiteEvent evt) {
        Map elementMap = this.mainWin.getElementMap();
        ((IViewElement)elementMap.get("hID_MainWin_Header")).set("text", (Object)LabelKeysMainWin.LIFECYCLE_MODE_SELECTION);
        String scaffoldId = this.osd.compose("mainWin", "modeSelectionViewPeer");
        this.osd.display(scaffoldId, ScaffoldPlacement.CENTERED);
    }

    @EventHandler(name="mode_selection", method="actionPerformed")
    public void modeSelection(ILiteEvent evt) {
        ILiteView view = this.osd.getView(evt.getViewId());
        IViewElement mode = (IViewElement)view.getElementMap().get("mode_selected");
        String modeSelected = (String)mode.get("text");
        this.evtCtxt.fireGenericEvent("get_event", new Object[]{evt});
        Map elementMap = this.mainWin.getElementMap();
        if (modeSelected.equalsIgnoreCase("offline")) {
            if (this.osd.getScaffold(this.sid) == null) {
                this.sid = this.osd.compose("loginWin", "loginView");
                this.osd.display(this.sid, ScaffoldPlacement.CENTERED);
            }
        } else if (modeSelected.equalsIgnoreCase("online")) {
            if (!this.sessionService.isNewEnrollmentDisabled()) {
                ((IViewElement)elementMap.get("hID_OpLogin_ToolBut")).call("click");
            }
        } else {
            L10nOptionPaneBuilder.getInstance().showWarningUC((Object)"Please select one mode to continue", (Component)evt.getEvent().getSource());
        }
    }

    @EventHandler(name="relogin_selection", method="actionPerformed")
    public void reloginSelection(ILiteEvent evt) {
        this.evtCtxt.fireGenericEvent("get_event", new Object[]{evt});
        Map elementMap = this.mainWin.getElementMap();
        ((IViewElement)elementMap.get("hID_OpLogin_ToolBut")).call("click");
    }

    @EventHandler(name="opLoginWinEscHandler", method="actionPerformed")
    public void onWindowEscaped(ILiteEvent evt) {
        LOGGER.debug("escape pressed on operator login window");
        System.exit(0);
    }

    private void setDoOpSync(boolean flag) {
        this.doOpSync = flag;
    }

    @EventHandler(name="opSync", method="actionPerformed")
    public void onOperatorSync(ILiteEvent evt) {
        this.setDoOpSync(true);
        this.onOperatorLogin(evt);
        this.setDoOpSync(false);
    }

    @EventHandler(name="opLogin", method="actionPerformed")
    public void onOperatorLogin(ILiteEvent evt) {
        LoginValidator loginValidator = this.sessionService.getOperatorLoginDetails().getLoginValidator();
        loginValidator.validate(this.doOpSync);
        if (!loginValidator.isValid()) {
            String loginError = loginValidator.getLoginError();
            L10nOptionPaneBuilder.getInstance().showError((Object)loginError, (Component)this.osd.getWindowForScaffold(evt.getScaffoldId()), new Object[0]);
            if (loginError.equals(this.rbCtxt.getMessage((Object)MsgKeysLogin.MAX_INVALID_RESUME_KEY_ATTEMPTS, new Object[0]))) {
                this.doOpSync = true;
                this.onOperatorLogin(evt);
            }
            return;
        }
        if (loginValidator.isStep2LoginStarted() && !loginValidator.isStep2LoginCompleted() && !loginValidator.isOnlineLogin()) {
            this.osd.recompose(evt.getScaffoldId(), "loginView");
            return;
        }
        if (loginValidator.isOnlineLogin()) {
            this.doOpSync = true;
        }
        UidSplashScreen.getInst().setStatus("Launching Enrolment Client");
        this.osd.dispose(evt.getScaffoldId());
        if (loginValidator.isOnlineLogin()) {
            this.operatorSyncService.setAutoLaunch(true);
        }
        this.evtCtxt.fireGenericEvent(this.doOpSync ? "showOpSyncWin" : "showMainWin", new Object[0]);
    }
}

