/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.login;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.enrollment.util.EnrolHelper;
import in.gov.uidai.ec.service.onboarding.UserCredentials;
import in.gov.uidai.ec.service.session.model.OperatorDetails;
import in.gov.uidai.ec.service.session.model.OperatorLoginDetails;
import in.gov.uidai.ec.service.session.model.ResumePassword;
import in.gov.uidai.ec.ui.ControllerBase;
import in.gov.uidai.ec.ui.biometricsauth.BiometricsNonRDAuthPanel;
import in.gov.uidai.ec.ui.login.LoginViewPeer;
import in.gov.uidai.ec.ui.login.OperatorActionPanel;
import in.gov.uidai.ec.ui.login.OperatorInfoPanel;
import in.gov.uidai.ec.ui.shared.l10n.MsgKeysLogin;
import in.gov.uidai.swing.bio.confirm.BiometricsNonRDField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.JFormattedTextField;
import javax.swing.SwingUtilities;

public class LoginController
extends ControllerBase {
    private final LoginViewPeer viewElements;
    private final OperatorLoginDetails operatorLoginDetails;
    private final BiometricsNonRDAuthPanel biometricsPanel;
    private final OperatorInfoPanel infoPanel;
    private final OperatorActionPanel actionPanel;
    private final IResourceBundleContext rbCtxt;
    private final boolean isStep2Login;

    public LoginController(LoginViewPeer viewElements) {
        super(viewElements.getView());
        this.viewElements = viewElements;
        this.biometricsPanel = viewElements.bioPanel;
        this.infoPanel = viewElements.opInfoPanel;
        this.actionPanel = viewElements.opActionPanel;
        this.rbCtxt = viewElements.rbCtxt;
        this.operatorLoginDetails = viewElements.sessionService.getOperatorLoginDetails();
        this.isStep2Login = viewElements.isStep2Login;
        this.initView();
    }

    private void initView() {
        this.loadOperatorIdList();
        this.autoPopulateOperatorDetailsIfAvailable();
        this.addItemListener(this.infoPanel.opIdField, this::onOperatorIdChange);
        if (this.isStep2Login) {
            this.operatorLoginDetails.getOperatorDetails().addChangeListener(this::updateUidAndPasswordAndBioFields);
            this.addFocusListener(this.infoPanel.operatorUidField, this::operatorUidFocusLost);
            this.addFocusListener(this.infoPanel.resumePassField, this::resumePasswordFocusLost);
        }
        this.addActionListener(this.actionPanel.cancelBut, this::onCancelButtonClick);
    }

    private void loadOperatorIdList() {
        List credList = this.viewElements.userCredentialsDAO.getAllUsers();
        Iterator iterator = credList.iterator();
        if (iterator.hasNext()) {
            UserCredentials cred2 = (UserCredentials)iterator.next();
            if (cred2.getEacode() == null) {
                this.showError(this.infoPanel.opIdField, (Object)MsgKeysLogin.LATEST_FILE);
                System.exit(-1);
            }
            if (!cred2.getEacode().equalsIgnoreCase(this.viewElements.registrationService.getAgencyId())) {
                this.showError(this.infoPanel.opIdField, (Object)MsgKeysLogin.CORRECT_FILE);
                System.exit(-1);
            }
        }
        this.infoPanel.opIdField.addItem(new UserCredentials("Select"));
        credList.forEach(cred -> this.infoPanel.opIdField.addItem((UserCredentials)cred));
    }

    private void autoPopulateOperatorDetailsIfAvailable() {
        UserCredentials operatorDetails = this.operatorLoginDetails.getOperatorDetails().getOperatorDetails();
        if (operatorDetails != null && this.isStep2Login) {
            this.infoPanel.opIdField.setSelectedItem(operatorDetails);
            this.infoPanel.opIdField.setEnabled(false);
            this.infoPanel.opNameField.setText(operatorDetails.getFullName());
            this.updateUidAndPasswordAndBioFields(this.operatorLoginDetails.getOperatorDetails());
        }
    }

    private void onOperatorIdChange(ItemEvent ie) {
        if (ie.getStateChange() == 2) {
            return;
        }
        OperatorDetails credentials = this.operatorLoginDetails.getOperatorDetails();
        UserCredentials userCredentials = (UserCredentials)ie.getItem();
        credentials.setOperatorDetails(userCredentials);
        boolean valid = credentials.isValid();
        this.infoPanel.opNameField.setText(valid ? userCredentials.getFullName() : "xxx");
        this.clearFieldError(this.infoPanel.opIdField);
        if (!valid) {
            String idError = credentials.getIdError();
            if (Stream.of(MsgKeysLogin.SUSPENDED_OPERATOR, MsgKeysLogin.INACTIVE_OPERATOR).anyMatch(key -> idError.equals(this.rbCtxt.getMessage((Object)key, new Object[0])))) {
                this.showError(this.infoPanel.opIdField, idError);
            } else {
                this.showFieldError(this.infoPanel.opIdField, idError);
            }
        }
    }

    private void updateUidAndPasswordAndBioFields(OperatorDetails credentials) {
        boolean valid = credentials.isValid();
        this.infoPanel.operatorUidField.setEnabled(valid);
        this.infoPanel.operatorUidField.setText("");
        SwingUtilities.invokeLater(() -> this.clearFieldError(this.infoPanel.operatorUidField));
        this.infoPanel.resumePassField.setEnabled(valid);
        this.infoPanel.resumePassField.setText("");
        this.operatorLoginDetails.getResumePassword().setPassword("");
        this.clearFieldError(this.infoPanel.resumePassField);
        BiometricsNonRDField fingerAuthField = this.biometricsPanel.fingerAuthField;
        BiometricsNonRDField irisConfirmField = this.biometricsPanel.irisConfirmField;
        String operatorUid = credentials.getOperatorDetails().getUid();
        fingerAuthField.setConfirmUid(operatorUid);
        irisConfirmField.setConfirmUid(operatorUid);
        fingerAuthField.clearCaptureAttempt();
        irisConfirmField.clearCaptureAttempt();
        boolean userOnBoarded = this.viewElements.biometricsAuthService.isOperatorOnboarded();
        fingerAuthField.setEnabled(userOnBoarded);
        irisConfirmField.setEnabled(userOnBoarded);
    }

    private void operatorUidFocusLost(FocusEvent e) {
        if (e.isTemporary()) {
            return;
        }
        OperatorDetails operatorDetails = this.operatorLoginDetails.getOperatorDetails();
        String uid = EnrolHelper.getDeformattedFieldValue((JFormattedTextField)this.infoPanel.operatorUidField, (String)"000000000000");
        operatorDetails.validateUid(uid);
        SwingUtilities.invokeLater(() -> this.clearFieldError(this.infoPanel.operatorUidField));
        if (!operatorDetails.isValid()) {
            SwingUtilities.invokeLater(() -> this.showFieldError(this.infoPanel.operatorUidField, operatorDetails.getUidError()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumePasswordFocusLost(FocusEvent e) {
        String pd;
        ResumePassword resumePd;
        if (e.isTemporary()) {
            return;
        }
        try {
            resumePd = this.operatorLoginDetails.getResumePassword();
            pd = String.valueOf(this.infoPanel.resumePassField.getPassword());
            resumePd.setPassword(pd);
            this.clearFieldError(this.infoPanel.resumePassField);
            if (!resumePd.isValid()) {
                this.showFieldError(this.infoPanel.resumePassField, resumePd.getError());
            }
        }
        finally {
            pd = null;
            resumePd = null;
        }
    }

    private void onCancelButtonClick(ActionEvent event) {
        ((ActionListener)this.viewElements.evtCtxt.getEventListener("closeWin", ActionListener.class)).actionPerformed(event);
    }
}

