/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.login;

import in.gov.uidai.ec.biometrics.device.IClientDeviceManager;
import in.gov.uidai.ec.biometrics.device.impl.DeviceLifeCycleListener;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.icas.util.ApplicationVersion;
import in.gov.uidai.ec.service.biometricsauth.BiometricsAuthService;
import in.gov.uidai.ec.service.onboarding.IUserCredentialsDAO;
import in.gov.uidai.ec.service.presync.IPreSyncPreference;
import in.gov.uidai.ec.service.registration.IRegistrationService;
import in.gov.uidai.ec.service.session.ISessionService;
import in.gov.uidai.ec.ui.biometricsauth.BiometricsNonRDAuthController;
import in.gov.uidai.ec.ui.biometricsauth.BiometricsNonRDAuthPanel;
import in.gov.uidai.ec.ui.login.LoginController;
import in.gov.uidai.ec.ui.login.OperatorActionPanel;
import in.gov.uidai.ec.ui.login.OperatorInfoPanel;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysLogin;
import in.gov.uidai.litef.beans.ModalVisualExecutionContext;
import in.gov.uidai.litef.beans.stdview.StandardViewPeer;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.swing.ImageArea;
import in.gov.uidai.swing.TransparentBox;
import in.gov.uidai.swing.l10n.L10nDecorator;
import in.gov.uidai.swing.table.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import org.springframework.beans.factory.InitializingBean;

public class LoginViewPeer
extends StandardViewPeer
implements InitializingBean {
    protected IResourceBundleContext rbCtxt;
    protected IEventContext evtCtxt;
    protected OperatorInfoPanel opInfoPanel;
    protected BiometricsNonRDAuthPanel bioPanel;
    protected OperatorActionPanel opActionPanel;
    protected IUserCredentialsDAO userCredentialsDAO;
    protected IRegistrationService registrationService;
    protected ISessionService sessionService;
    protected boolean isStep2Login;
    protected BiometricsAuthService biometricsAuthService;
    private IClientDeviceManager devMgr;
    private IUIPreference uiPref;
    private IPreSyncPreference preSyncPref;
    private DeviceLifeCycleListener deviceLifeCycleListener;

    public void setBiometricsAuthService(BiometricsAuthService biometricsAuthService) {
        this.biometricsAuthService = biometricsAuthService;
    }

    public void setPreSyncPreference(IPreSyncPreference pref) {
        this.preSyncPref = pref;
    }

    public void setClientDeviceManager(IClientDeviceManager cdm) {
        this.devMgr = cdm;
    }

    public void setResourceBundleContext(IResourceBundleContext ctxt) {
        this.rbCtxt = ctxt;
    }

    public void setUIPreference(IUIPreference pref) {
        this.uiPref = pref;
    }

    public void setUserCredentialsDAO(IUserCredentialsDAO userCredentialsDAO) {
        this.userCredentialsDAO = userCredentialsDAO;
    }

    public void setRegistrationService(IRegistrationService registrationService) {
        this.registrationService = registrationService;
    }

    public void setSessionService(ISessionService sessionService) {
        this.sessionService = sessionService;
    }

    public void setDeviceLifeCycleListener(DeviceLifeCycleListener deviceLifeCycleListener) {
        this.deviceLifeCycleListener = deviceLifeCycleListener;
    }

    public void afterPropertiesSet() throws Exception {
        this.isStep2Login = this.sessionService.getOperatorLoginDetails().getLoginValidator().isStep2LoginStarted();
    }

    protected void enableImpl(boolean flag) {
        this.opInfoPanel.opIdField.setEnabled(flag);
        this.opActionPanel.loginBut.setEnabled(flag);
        super.getContentPane().setCursor(flag ? Cursor.getDefaultCursor() : Cursor.getPredefinedCursor(3));
        this.opActionPanel.cancelBut.setCursor(Cursor.getDefaultCursor());
        if (this.isStep2Login) {
            this.opInfoPanel.operatorUidField.setEnabled(flag);
            this.opInfoPanel.resumePassField.setEnabled(flag);
            this.opActionPanel.opSyncBut.setCursor(Cursor.getDefaultCursor());
        }
    }

    protected void prepareImpl() {
        this.evtCtxt = super.getEventContext();
        this.setMenuBar(null);
        this.opInfoPanel = new OperatorInfoPanel(this.rbCtxt, this.uiPref);
        this.bioPanel = new BiometricsNonRDAuthPanel(this.rbCtxt, this.uiPref, this.deviceLifeCycleListener, this.devMgr, this.preSyncPref, this.evtCtxt);
        this.opActionPanel = new OperatorActionPanel(this.rbCtxt, this.evtCtxt, this.isStep2Login);
        this.opInfoPanel.createOperatorIdPanel();
        this.opInfoPanel.createOperatorNamePanel();
        this.opActionPanel.createLoginButton();
        this.opActionPanel.createCancelButton();
        if (this.isStep2Login) {
            this.opInfoPanel.createOperatorUIDPanel();
            this.opInfoPanel.createResumePasswordPanel();
            this.opActionPanel.createOpSyncButton();
        }
        double[][] guides = new double[][]{{250.0, 5.0, 180.0, 5.0, 60.0, 5.0, 0.0, 2.0, 2.0, 40.0}, {50.0, 25.0, 25.0, 25.0, 25.0, 0.0, 0.0, 25.0, 25.0, 5.0, 25.0, 5.0, 25.0}};
        if (this.isStep2Login) {
            guides[0][2] = 120.0;
            guides[0][6] = 100.0;
            guides[0][9] = 0.0;
            guides[1][0] = 0.0;
            guides[1][5] = 25.0;
            guides[1][6] = 25.0;
            if (this.bioPanel.authTypeIsBoth()) {
                guides[0][0] = 150.0;
                guides[0][9] = 100.0;
            }
        }
        TransparentBox cntPane = new TransparentBox((LayoutManager)new TableLayout((double[][])guides));
        cntPane.add((Component)this.getAadhaarLogoImage(), (Object)"0, 0, 0, 7, f, b");
        cntPane.add((Component)this.getLogoText(), (Object)"0, 8, 0, 9, c, t");
        cntPane.add((Component)this.opInfoPanel.opIdLabel, (Object)"2, 1, 4, 1, l, c");
        cntPane.add(this.opInfoPanel.opIdField, (Object)"2, 2, 4, 2, f, f");
        cntPane.add((Component)this.opInfoPanel.opNameLabel, (Object)"2, 3, 4, 3, l, c");
        cntPane.add((Component)this.opInfoPanel.opNameField, (Object)"2, 4, 4, 4, f, f");
        if (this.isStep2Login) {
            cntPane.add((Component)this.opInfoPanel.operatorUidLab, (Object)"2, 5, 4, 5, l, c");
        }
        if (this.isStep2Login) {
            cntPane.add((Component)this.opInfoPanel.operatorUidField, (Object)"2, 6, 4, 6, f, f");
        }
        if (this.isStep2Login) {
            cntPane.add((Component)this.opInfoPanel.resumePassLabel, (Object)"2, 7, 4, 7, l, c");
        }
        if (this.isStep2Login) {
            cntPane.add((Component)this.opInfoPanel.resumePassField, (Object)"2, 8, 4, 8, f, f");
        }
        cntPane.add((Component)this.opActionPanel.loginBut, (Object)"2, 10, r, c");
        cntPane.add((Component)this.opActionPanel.cancelBut, (Object)"4, 10, l, c");
        if (this.isStep2Login) {
            cntPane.add((Component)this.opActionPanel.opSyncBut, (Object)"6, 10, l, c");
        }
        if (this.isStep2Login) {
            cntPane.add((Component)(this.bioPanel.authTypeIsIris() ? this.bioPanel.createNonRDIrisArea() : this.bioPanel.createNonRDFingerArea()), (Object)"6, 2, 6, 6, f, f");
        }
        cntPane.add((Component)this.createCopyRightView(), (Object)"0, 12, 9, 12, f, f");
        if (this.isStep2Login && this.bioPanel.authTypeIsBoth()) {
            cntPane.add((Component)this.bioPanel.createNonRDIrisArea(), (Object)"9, 2, 9, 6, f, f");
        }
        super.setContentPane((JComponent)cntPane);
        super.setVisualExecutionContext((IVisualExecutionContext)new ModalVisualExecutionContext((JComponent)cntPane, false, new L10nDecorator(this.rbCtxt, this.uiPref.getApplicationLocalize(false))));
        this.devMgr.refreshDeviceStates();
        new LoginController(this);
        if (this.isStep2Login) {
            new BiometricsNonRDAuthController(this.getView(), this.bioPanel, this.biometricsAuthService);
        }
    }

    private ImageArea getAadhaarLogoImage() {
        if (this.isStep2Login && this.bioPanel.authTypeIsBoth()) {
            return new ImageArea("res/images/aadhar_logo.png", 150, 100);
        }
        return new ImageArea("res/images/aadhar_logo.png");
    }

    private JLabel getLogoText() {
        L10nDecorator ldeco = new L10nDecorator(this.rbCtxt, this.uiPref.getApplicationLocalize(false));
        JLabel logoText = new JLabel((Object)((Object)LabelKeysLogin.LOGO) + " " + ApplicationVersion.FULLDISPLAYVERSION);
        ldeco.localize(logoText, (Object)LabelKeysLogin.LOGO, new Object[]{ApplicationVersion.FULLDISPLAYVERSION});
        return logoText;
    }

    private JLabel createCopyRightView() {
        L10nDecorator ldeco = new L10nDecorator(this.rbCtxt, this.uiPref.getApplicationLocalize(false));
        JLabel copyright = new JLabel(this.rbCtxt.getMessage((Object)LabelKeysLogin.COPYRIGHT, new Object[0]));
        copyright.setHorizontalAlignment(0);
        copyright.setBackground(Color.decode("#84a9d8"));
        copyright.setOpaque(true);
        copyright.setBorder(new EmptyBorder(0, 0, 0, 0));
        ldeco.localize(copyright, (Object)LabelKeysLogin.COPYRIGHT, new Object[0]);
        return copyright;
    }

    protected void disposeImpl() {
    }
}

