/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.login;

import in.gov.uidai.ec.biometrics.lvs.LVSLocator;
import in.gov.uidai.ec.service.onboarding.IOnboardingAdminService;
import in.gov.uidai.ec.ui.shared.l10n.MsgKeysLogin;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

public class UserCredentialsLoader
implements InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserCredentialsLoader.class);
    private IOnboardingAdminService onboardingAdminService;
    private Resource credDataLoc;

    public void setOnboardingAdminService(IOnboardingAdminService onboardingAdminService) {
        this.onboardingAdminService = onboardingAdminService;
    }

    public void setUserCredentialsData(Resource dataLoc) {
        this.credDataLoc = dataLoc;
    }

    public void afterPropertiesSet() {
        LVSLocator lvsLocator = null;
        try {
            lvsLocator = new LVSLocator();
        }
        catch (Exception e) {
            System.exit(-1);
        }
        if (lvsLocator.get() == null) {
            L10nOptionPaneBuilder.getInstance().showError((Object)MsgKeysLogin.STARTUP_NOLVS, null, new Object[0]);
            System.exit(1);
        }
        try {
            this.onboardingAdminService.load(this.credDataLoc.getURL(), true);
        }
        catch (Exception e) {
            LOGGER.warn("", (Throwable)e);
            L10nOptionPaneBuilder.getInstance().showError((Object)MsgKeysLogin.STARTUP_BADCRED, null, new Object[0]);
            System.exit(1);
        }
    }
}

