/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.main;

import in.gov.uidai.ec.security.sapi.SecurityProvider;
import in.gov.uidai.ec.service.operatordisclosure.DisclosurePopupProcessor;
import in.gov.uidai.ec.service.presync.IPreSyncPreference;
import in.gov.uidai.ec.service.report.IEodReportSearch;
import in.gov.uidai.ec.service.session.ISessionService;
import in.gov.uidai.ec.ui.main.IMainWinProvider;
import in.gov.uidai.ec.ui.main.MainWinDecorator;
import in.gov.uidai.ec.ui.main.UnsavedTracker;
import in.gov.uidai.ec.ui.shared.ShutdownHook;
import in.gov.uidai.litef.devapi.EventHandler;
import in.gov.uidai.litef.devapi.GenericEventHandler;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.devapi.IEventContextAware;
import in.gov.uidai.litef.devapi.ILiteEvent;
import in.gov.uidai.litef.devapi.ILiteScaffold;
import in.gov.uidai.litef.devapi.IOnScreenDisplay;
import in.gov.uidai.litef.devapi.IOnScreenDisplayAware;
import in.gov.uidai.litef.devapi.IViewElement;
import in.gov.uidai.litef.devapi.ScaffoldPlacement;
import in.gov.uidai.litef.widgets.ToolBarElement;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import in.gov.uidai.swing.l10n.MsgKeysCommon;
import java.awt.Component;
import java.util.Map;

public class MainWinControl
implements IOnScreenDisplayAware,
IMainWinProvider,
IEventContextAware {
    private IOnScreenDisplay osd;
    private ILiteScaffold mainWin;
    private UnsavedTracker tracker;
    private ShutdownHook shutdownHook;
    private IMainWinProvider mainWinProv;
    private IEodReportSearch eodReportSearch;
    private ISessionService sessionService;
    private DisclosurePopupProcessor disclosurePopupProcessor;
    private IEventContext evtCtxt;

    public void setEodReportSearch(IEodReportSearch eodReportSearch) {
        this.eodReportSearch = eodReportSearch;
    }

    public final void setPreSyncPreference(IPreSyncPreference preSyncPref) {
        SecurityProvider.getInst().setKeySize(preSyncPref.getKeySize());
    }

    public void setDisclosurePopupProcessor(DisclosurePopupProcessor disclosurePopupProcessor) {
        this.disclosurePopupProcessor = disclosurePopupProcessor;
    }

    public final void setMainWinProvider(IMainWinProvider mwp) {
        this.mainWinProv = mwp;
    }

    public void setSessionService(ISessionService sessionService) {
        this.sessionService = sessionService;
    }

    public void populateOnScreenDisplay(IOnScreenDisplay osd) {
        this.osd = osd;
    }

    @Override
    public String getMainWinId() {
        return this.mainWin == null ? null : this.mainWin.getId();
    }

    public void setUnsavedTracker(UnsavedTracker tracker) {
        this.tracker = tracker;
    }

    public void setShutdownHook(ShutdownHook shutdownHook) {
        this.shutdownHook = shutdownHook;
    }

    @GenericEventHandler(value="showMainWin")
    public void showMainWin() {
        this.osd.dispose("mainWin");
        String sId = this.osd.compose("mainWin", "blankView");
        this.setMainwin(sId);
        this.osd.display(sId, ScaffoldPlacement.MAXIMIZED);
        this.shutdownHook.cleanupFindAadhaarOldData();
        this.showModeSelectionPage(null);
    }

    public void showModeSelectionPage(ILiteEvent evt) {
        this.evtCtxt.fireGenericEvent("get_event", new Object[]{evt});
        Map elementMap = this.mainWin.getElementMap();
        ((IViewElement)elementMap.get("eID_OpStat_Toolbut")).call("click");
        if (!this.showOpDisclosurePopup()) {
            if (!this.sessionService.isNewEnrollmentDisabled()) {
                this.enableMenuButtonsEcmp(elementMap);
                ((IViewElement)elementMap.get("hID_Enrol_ToolBut")).call("click");
            } else if (!this.sessionService.isBiometricUpdateDisabledForStation()) {
                ((IViewElement)elementMap.get("hID_Uenrol_ToolBut")).call("click");
            } else {
                ((IViewElement)elementMap.get("hID_OUenrol_ToolBut")).call("click");
            }
        }
    }

    @GenericEventHandler(value="showOpSyncWin")
    public void showOpSyncWin() {
        String sId = this.osd.compose("mainWin", "blankView");
        this.setMainwin(sId);
        this.osd.display(sId, ScaffoldPlacement.MAXIMIZED);
        this.enableOnlyOpSync();
    }

    @GenericEventHandler(value="showAfterDisclosureSuccess")
    public void showAfterDisclosureSuccess() {
        this.osd.dispose("mainWin");
        String sId = this.osd.compose("mainWin", "blankView");
        this.setMainwin(sId);
        this.osd.display(sId, ScaffoldPlacement.MAXIMIZED);
        this.enableAfterDisclosureSuccess();
    }

    @GenericEventHandler(value="showOpDisclosureWin")
    public void showOpDisclosureWin() {
        String sId = this.osd.compose("mainWin", "blankView");
        this.setMainwin(sId);
        this.osd.display(sId, ScaffoldPlacement.MAXIMIZED);
        Map eMap = this.mainWin.getElementMap();
        ((IViewElement)eMap.get("eID_OpDisclosure_Toolbut")).call("click");
    }

    @GenericEventHandler(value="hID_MainWin_Enrol")
    public void clickNewEnrol() {
        Map eMap = this.mainWin.getElementMap();
        ((IViewElement)eMap.get("hID_Enrol_ToolBut")).call("click");
    }

    @GenericEventHandler(value="hID_MainWin_Appointment_Enrol")
    public void clickNewAppointment() {
        Map eMap = this.mainWin.getElementMap();
        ((IViewElement)eMap.get("hID_Appointment_ScanBut")).call("click");
    }

    @GenericEventHandler(value="hID_MainWin_Uenrol")
    public void clickUenrol() {
        Map eMap = this.mainWin.getElementMap();
        ((IViewElement)eMap.get("hID_Uenrol_ToolBut")).call("click");
    }

    @GenericEventHandler(value="hID_MainWin_Online_Uenrol")
    public void clickOUenrol() {
        Map eMap = this.mainWin.getElementMap();
        ((IViewElement)eMap.get("hID_OUenrol_ToolBut")).call("click");
    }

    @GenericEventHandler(value="hID_MainWin_Operator_Uenrol")
    public void clickOpLogin() {
        Map eMap = this.mainWin.getElementMap();
        ((IViewElement)eMap.get("hID_OpLogin_ToolBut")).call("click");
    }

    @GenericEventHandler(value="timeChangeClosing")
    public void ChangingTime() {
        String sId = this.osd.compose("mainWin", "blankView");
        this.setMainwin(sId);
        L10nOptionPaneBuilder.getInstance().showError((Object)"System time has been changed, application will be closed!", (Component)this.osd.getWindowForScaffold(sId), new Object[0]);
        this.exitApplication(sId);
    }

    @GenericEventHandler(value="timeZoneChangeClosing")
    public void ChangingTimeZone() {
        String sId = this.osd.compose("mainWin", "blankView");
        this.setMainwin(sId);
        L10nOptionPaneBuilder.getInstance().showError((Object)"System timezone does not match with (UTC+05:30)Chennai,Kolkata,Mumbai,New Delhi, Application will be closed !", (Component)this.osd.getWindowForScaffold(sId), new Object[0]);
        this.exitApplication(sId);
    }

    @EventHandler(name="mainWinHandler", method="windowClosing")
    public void onWindowClosing(ILiteEvent evt) {
        String message;
        Component parent = (Component)evt.getEvent().getSource();
        if (this.tracker.isUnsaved()) {
            message = "This will close your Aadhaar enrolment client. Any unsaved data will be lost. Do you wish to continue?";
            MsgKeysCommon confirmation = L10nOptionPaneBuilder.getInstance().showYesNoUC(message, parent);
            if (confirmation.equals((Object)MsgKeysCommon.NO)) {
                return;
            }
        } else {
            message = "This will close your Aadhaar enrolment client. Do you wish to continue?";
            MsgKeysCommon confirmation = L10nOptionPaneBuilder.getInstance().showYesNoUC(message, parent);
            if (confirmation.equals((Object)MsgKeysCommon.NO)) {
                return;
            }
            String sId = this.osd.compose("mainWin", "blankView");
            this.setMainwin(sId);
            Map eMap = this.mainWin.getElementMap();
            ((IViewElement)eMap.get("eID_Logout_Toolbut_UC")).call("click");
        }
        if (this.eodReportSearch.getUnUploadedPacketsCount() > 0) {
            message = String.format("<html><p align=\"center\"><font size=\\\"5px\\\"><b>You have %d packets pending for upload<br/>Please leave your machine connected to the Internet and ensure packets are uploaded on the same day to avoid client freeze.</b></p></html>", this.eodReportSearch.getUnUploadedPacketsCount());
            L10nOptionPaneBuilder.getInstance().showWarning((Object)message, parent);
        }
        this.shutdownHook.cleanupFindAadhaarGeneratedFile();
        this.exitApplication(evt.getScaffoldId());
    }

    private void exitApplication(String sId) {
        this.osd.dispose(sId);
        System.exit(0);
    }

    @GenericEventHandler(value="hID_MainWin_Online_Doc_Uenrol")
    public void clickODUenrol() {
        Map eMap = this.mainWin.getElementMap();
        ((IViewElement)eMap.get("hID_OUDocument_ToolBut")).call("click");
    }

    @GenericEventHandler(value="hID_MainWin_Offline_Doc_Uenrol")
    public void clickODUOFFenrol() {
        Map eMap = this.mainWin.getElementMap();
        ((IViewElement)eMap.get("hID_OFFUDocument_ToolBut")).call("click");
    }

    public void enableOnlyOpSync() {
        Map eMap = this.osd.getScaffold(this.mainWinProv.getMainWinId()).getElementMap();
        ((IViewElement)eMap.get("eID_Enrol_BtnGrp")).set("enable", (Object)false);
        ((IViewElement)eMap.get("eID_Lc_BtnGrp")).set("enable", (Object)false);
        ((IViewElement)eMap.get("eID_Appointment_BtnGrp")).set("enable", (Object)false);
        ((IViewElement)eMap.get("eID_Logout_Toolbut")).set("enable", (Object)false);
        ((IViewElement)eMap.get("eID_Report_ToolBut")).set("enable", (Object)this.sessionService.isOperatorOnboarded());
        ((IViewElement)eMap.get("eID_Vrol_ToolBut")).set("enable", (Object)this.sessionService.isOperatorOnboarded());
        ((IViewElement)eMap.get("eID_OpDisclosure_Toolbut")).set("enable", (Object)false);
        ((IViewElement)eMap.get("hID_OpSync_ToolBut")).call("click");
        this.removeKeyBindings(eMap);
    }

    @EventHandler(name="disableMenuButton", method="actionPerformed")
    public void disableMenuButtons(ILiteEvent evt) {
        Map eMap = this.osd.getScaffold(evt.getScaffoldId()).getElementMap();
        ((IViewElement)eMap.get("eID_Lc_BtnGrp")).set("enable", (Object)true);
        ((IViewElement)eMap.get("hID_OpLogin_ToolBut")).set("visible", (Object)false);
        ((IViewElement)eMap.get("hID_UC_OUenrol_ToolBut")).set("enable", (Object)false);
        ((IViewElement)eMap.get("hID_Mode_ToolBut")).set("enable", (Object)true);
        ((IViewElement)eMap.get("hID_Uenrol_ToolBut")).set("enable", (Object)false);
        ((IViewElement)eMap.get("hID_OUenrol_ToolBut")).set("enable", (Object)false);
        ((IViewElement)eMap.get("eID_Paadhaar_Toolbut")).set("enable", (Object)false);
        ((IViewElement)eMap.get("eID_Enrol_BtnGrp")).set("enable", (Object)false);
        ((IViewElement)eMap.get("eID_Appointment_BtnGrp")).set("enable", (Object)false);
        ((IViewElement)eMap.get("hID_OUDocument_ToolBut")).set("enable", (Object)false);
        ((IViewElement)eMap.get("hID_OFFUDocument_ToolBut")).set("enable", (Object)false);
        ((IViewElement)eMap.get("hID_OpLogin_ToolBut")).set("enable", (Object)true);
        ((IViewElement)eMap.get("hID_Scanner_ToolBut")).set("enable", (Object)true);
        ((IViewElement)eMap.get("eID_Logout_Toolbut_UC")).set("enable", (Object)false);
        ((IViewElement)eMap.get("eID_Logout_Toolbut_UC")).set("visible", (Object)false);
        ((IViewElement)eMap.get("eID_Report_ToolBut_for_UC")).set("visible", (Object)false);
        ((IViewElement)eMap.get("eID_Report_ToolBut_for_UC")).set("enable", (Object)false);
    }

    @EventHandler(name="enableMenuButtonUC", method="actionPerformed")
    public void enableMenuButtonsUC(ILiteEvent evt) {
        Map eMap = this.osd.getScaffold(evt.getScaffoldId()).getElementMap();
        ((IViewElement)eMap.get("eID_Lc_BtnGrp")).set("enable", (Object)true);
        ((IViewElement)eMap.get("hID_OpLogin_ToolBut")).set("visible", (Object)true);
        ((IViewElement)eMap.get("hID_OpLogin_ToolBut")).set("enable", (Object)true);
        ((IViewElement)eMap.get("hID_Scanner_ToolBut")).set("visible", (Object)true);
        ((IViewElement)eMap.get("hID_Scanner_ToolBut")).set("enable", (Object)true);
        ((IViewElement)eMap.get("hID_UC_OUenrol_ToolBut")).set("enable", (Object)true);
        ((IViewElement)eMap.get("hID_Mode_ToolBut")).set("enable", (Object)true);
        ((IViewElement)eMap.get("eID_Appointment_BtnGrp")).set("enable", (Object)true);
        ((IViewElement)eMap.get("eID_Logout_Toolbut_UC")).set("enable", (Object)true);
        ((IViewElement)eMap.get("eID_Logout_Toolbut_UC")).set("visible", (Object)true);
        ((IViewElement)eMap.get("hID_Appointment_ScanBut_UC")).set("visible", (Object)true);
        ((IViewElement)eMap.get("eID_Report_ToolBut_for_UC")).set("visible", (Object)true);
        ((IViewElement)eMap.get("eID_Report_ToolBut_for_UC")).set("enable", (Object)true);
        ((IViewElement)eMap.get("eID_Enrol_BtnGrp")).set("enable", (Object)false);
        ((IViewElement)eMap.get("hID_Appointment_ScanBut")).set("visible", (Object)false);
        ((IViewElement)eMap.get("hID_Uenrol_ToolBut")).set("enable", (Object)false);
        ((IViewElement)eMap.get("hID_OUenrol_ToolBut")).set("enable", (Object)false);
        ((IViewElement)eMap.get("hID_OUDocument_ToolBut")).set("enable", (Object)false);
        ((IViewElement)eMap.get("eID_Paadhaar_Toolbut")).set("enable", (Object)false);
        ((IViewElement)eMap.get("eID_Logout_Toolbut")).set("enable", (Object)false);
        ((IViewElement)eMap.get("eID_Logout_Toolbut")).set("visible", (Object)false);
    }

    public void enableMenuButtonsEcmp(Map<String, IViewElement> eMap) {
        eMap.get("eID_Lc_BtnGrp").set("enable", (Object)true);
        eMap.get("eID_Enrol_BtnGrp").set("enable", (Object)true);
        eMap.get("eID_Appointment_BtnGrp").set("enable", (Object)true);
        eMap.get("hID_Uenrol_ToolBut").set("enable", (Object)true);
        eMap.get("hID_OUenrol_ToolBut").set("enable", (Object)true);
        eMap.get("eID_Paadhaar_Toolbut").set("enable", (Object)true);
        eMap.get("hID_Mode_ToolBut").set("enable", (Object)true);
        eMap.get("hID_OUDocument_ToolBut").set("enable", (Object)true);
        eMap.get("hID_OFFUDocument_ToolBut").set("enable", (Object)true);
        eMap.get("eID_Logout_Toolbut").set("enable", (Object)true);
        eMap.get("eID_Logout_Toolbut").set("visible", (Object)true);
        eMap.get("hID_Appointment_ScanBut").set("visible", (Object)true);
        eMap.get("hID_Appointment_ScanBut_UC").set("visible", (Object)false);
        eMap.get("hID_OpLogin_ToolBut").set("enable", (Object)false);
        eMap.get("hID_Scanner_ToolBut").set("enable", (Object)false);
        eMap.get("hID_UC_OUenrol_ToolBut").set("enable", (Object)false);
        eMap.get("eID_Logout_Toolbut_UC").set("enable", (Object)false);
        eMap.get("eID_Logout_Toolbut_UC").set("visible", (Object)false);
    }

    public void disableButtonsAfterClientTypeError() {
        Map eMap = this.mainWin.getElementMap();
        ((IViewElement)eMap.get("eID_Lc_BtnGrp")).set("enable", (Object)true);
        ((IViewElement)eMap.get("hID_OpLogin_ToolBut")).set("visible", (Object)false);
        ((IViewElement)eMap.get("hID_UC_OUenrol_ToolBut")).set("enable", (Object)false);
        ((IViewElement)eMap.get("hID_Mode_ToolBut")).set("enable", (Object)true);
        ((IViewElement)eMap.get("hID_Uenrol_ToolBut")).set("enable", (Object)false);
        ((IViewElement)eMap.get("hID_OUenrol_ToolBut")).set("enable", (Object)false);
        ((IViewElement)eMap.get("eID_Paadhaar_Toolbut")).set("enable", (Object)false);
        ((IViewElement)eMap.get("eID_Enrol_BtnGrp")).set("enable", (Object)false);
        ((IViewElement)eMap.get("eID_Appointment_BtnGrp")).set("enable", (Object)false);
        ((IViewElement)eMap.get("hID_OUDocument_ToolBut")).set("enable", (Object)false);
        ((IViewElement)eMap.get("hID_OFFUDocument_ToolBut")).set("enable", (Object)false);
        ((IViewElement)eMap.get("hID_OpLogin_ToolBut")).set("enable", (Object)true);
    }

    private void removeKeyBindings(Map<String, IViewElement> elementMap) {
        ToolBarElement toolbarEl = (ToolBarElement)elementMap.get("hID_MainWin_ToolBar");
        MainWinDecorator.getEnrolKeys().forEach(key -> toolbarEl.set("removeKeyBinding", key));
    }

    public boolean showOpDisclosurePopup() {
        if (this.sessionService.isOperatorOnboarded()) {
            String operatorId = this.sessionService.getOperatorLoginDetails().getCredentials().getOperatorId();
            this.disclosurePopupProcessor.setOperatorId(operatorId);
            Map eMap = this.osd.getScaffold(this.mainWinProv.getMainWinId()).getElementMap();
            if (!this.disclosurePopupProcessor.isDisclosureDone()) {
                ((IViewElement)eMap.get("eID_Enrol_BtnGrp")).set("enable", (Object)false);
                ((IViewElement)eMap.get("eID_Lc_BtnGrp")).set("enable", (Object)false);
                ((IViewElement)eMap.get("eID_Appointment_BtnGrp")).set("enable", (Object)false);
                ((IViewElement)eMap.get("eID_OpDisclosure_Toolbut")).set("enable", (Object)true);
                String scafId = this.osd.compose("opDisclosurePopupWin", "opDisclosurePopupView");
                this.osd.display(scafId, ScaffoldPlacement.CENTERED);
                return true;
            }
            ((IViewElement)eMap.get("eID_OpDisclosure_Toolbut")).set("enable", (Object)false);
        }
        return false;
    }

    public void enableAfterDisclosureSuccess() {
        Map eMap = this.osd.getScaffold(this.mainWinProv.getMainWinId()).getElementMap();
        ((IViewElement)eMap.get("eID_Enrol_BtnGrp")).set("enable", (Object)true);
        ((IViewElement)eMap.get("eID_Lc_BtnGrp")).set("enable", (Object)true);
        ((IViewElement)eMap.get("eID_Appointment_BtnGrp")).set("enable", (Object)true);
        ((IViewElement)eMap.get("hID_OpSync_ToolBut")).set("enable", (Object)true);
        ((IViewElement)eMap.get("eID_OpDisclosure_Toolbut")).set("enable", (Object)false);
        ((IViewElement)eMap.get("hID_Uenrol_ToolBut")).set("enable", (Object)true);
        ((IViewElement)eMap.get("hID_OUenrol_ToolBut")).set("enable", (Object)true);
        ((IViewElement)eMap.get("eID_Paadhaar_Toolbut")).set("enable", (Object)true);
        ((IViewElement)eMap.get("hID_Mode_ToolBut")).set("enable", (Object)true);
        ((IViewElement)eMap.get("hID_OUDocument_ToolBut")).set("enable", (Object)true);
        ((IViewElement)eMap.get("hID_OFFUDocument_ToolBut")).set("enable", (Object)true);
    }

    public void populateEventContext(IEventContext ctxt) {
        this.evtCtxt = ctxt;
    }

    @GenericEventHandler(value="postDiscloserEvent")
    public void postDiscloserEvent() {
        String sId = this.osd.compose("mainWin", "blankView");
        this.setMainwin(sId);
        this.osd.display(sId, ScaffoldPlacement.MAXIMIZED);
        this.shutdownHook.cleanupFindAadhaarOldData();
        Map elementMap = this.mainWin.getElementMap();
        ((IViewElement)elementMap.get("eID_OpStat_Toolbut")).call("click");
        if (this.sessionService.isNewEnrollmentDisabled() && this.sessionService.isBiometricUpdateDisabledForStation()) {
            ((IViewElement)elementMap.get("eID_Enrol_BtnGrp")).set("enable", (Object)false);
            ((IViewElement)elementMap.get("eID_Appointment_BtnGrp")).set("enable", (Object)false);
            ((IViewElement)elementMap.get("hID_Uenrol_ToolBut")).set("enable", (Object)false);
            ((IViewElement)elementMap.get("hID_OUenrol_ToolBut")).call("click");
        } else if (!this.sessionService.isNewEnrollmentDisabled() && !this.sessionService.isBiometricUpdateDisabledForStation()) {
            String mainwinEnrolEvent = "hID_MainWin_Enrol";
            this.evtCtxt.fireGenericEvent(mainwinEnrolEvent, new Object[0]);
        }
    }

    private void setMainwin(String sId) {
        if (this.mainWin == null) {
            this.mainWin = this.osd.getScaffold(sId);
        }
    }
}

