/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.main;

import in.gov.uidai.ec.biometrics.device.DeviceInfo;
import in.gov.uidai.ec.biometrics.device.DeviceType;
import in.gov.uidai.ec.biometrics.device.IClientDeviceManager;
import in.gov.uidai.ec.biometrics.device.IDeviceContext;
import in.gov.uidai.ec.biometrics.device.impl.DeviceLifeCycleListener;
import in.gov.uidai.ec.biometrics.registereddevice.RegisteredDeviceContext;
import in.gov.uidai.ec.escapi.EnrolServiceClientApiService;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.icas.util.ApplicationVersion;
import in.gov.uidai.ec.oauthapi.token.TokenManager;
import in.gov.uidai.ec.rd.device.xml.DeviceRdInfo;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.gps.GeoData;
import in.gov.uidai.ec.service.gps.IGpsControl;
import in.gov.uidai.ec.service.gps.IGpsListener;
import in.gov.uidai.ec.service.gps.IGpsPreference;
import in.gov.uidai.ec.service.machineidentity.MachineInfo;
import in.gov.uidai.ec.service.registration.IRegistrationService;
import in.gov.uidai.ec.service.session.OperatorDetails;
import in.gov.uidai.ec.service.session.SessionService;
import in.gov.uidai.ec.ui.appointment.IAppointmentConstants;
import in.gov.uidai.ec.ui.gps.GpsUpdateHandler;
import in.gov.uidai.ec.ui.main.IMainWinConstants;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysMainWin;
import in.gov.uidai.litef.beans.tsb.ITsbDecorator;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.devapi.IViewElement;
import in.gov.uidai.litef.widgets.StandardSwingElementFactory;
import in.gov.uidai.swing.DropDownToggleButton;
import in.gov.uidai.swing.ImageArea;
import in.gov.uidai.swing.ImageIconCache;
import in.gov.uidai.swing.StatusBarClock;
import in.gov.uidai.swing.StatusBarGPS;
import in.gov.uidai.swing.TransparentBox;
import in.gov.uidai.swing.border.RoundedBorder;
import in.gov.uidai.swing.border.SingleLineBorder;
import in.gov.uidai.swing.l10n.L10nDecorator;
import in.gov.uidai.swing.l10n.L10nLabel;
import in.gov.uidai.swing.notify.NotificationLocation;
import in.gov.uidai.swing.notify.NotificationPopup;
import in.gov.uidai.swing.painter.IPaintDelegate;
import in.gov.uidai.swing.painter.LinearGradientBackground;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.standard.PrinterMakeAndModel;
import javax.print.attribute.standard.PrinterName;
import javax.print.attribute.standard.PrinterState;
import javax.print.attribute.standard.QueuedJobCount;
import javax.print.event.PrintServiceAttributeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class MainWinDecorator
implements ITsbDecorator,
IMainWinConstants,
IAppointmentConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(MainWinDecorator.class);
    public static final String KS_ENROL = "alt control Nn";
    public static final String KS_UENROL = "alt control U";
    public static final String KS_OUENROL = "alt control F";
    public static final String KS_SCAN = "alt control Y";
    public static final String KS_ONLINE = "alt control E";
    public static final String KS_PENROL = "alt control P";
    public static final String KS_OP_SYNC = "alt control O";
    public static final String KS_REPORT = "alt control R";
    public static final String KS_VERIFY = "alt control V";
    public static final String KS_GPS = "alt control G";
    public static final String KS_OPSTAT = "alt control S";
    public static final String KS_OPDISCLOSURE = "alt control H";
    public static final String KS_APPOINTMENT_SCAN = "alt control A";
    public static final String KS_APPOINTMENTID_FEILD = "alt control B";
    public static final String KS_LOGOUT = "alt control L";
    public static final String KS_MONITOR_SYSTEM_INFO = "alt control I";
    public static final String ENROL_AXN = "enrolAxn";
    public static final String U_ENROL_AXN = "uEnrolAxn";
    public static final String OU_ENROL_AXN = "ouEnrolAxn";
    public static final String P_ENROL_AXN = "pEnrolAxn";
    public static final String APPOINTMENT_SCAN_AXN = "appointmentScanAxn";
    private static final String APPOINTMENT_ICON = "res/ecmp/images/tbar/tb-prenrol.png";
    private static final String SCAN_APPOINTMENT_ICON = "res/ecmp/images/but-scan-32.png";
    private static final String RESIDENT_ICON = "res/ecmp/images/tbar/tb-enrol.png";
    private static final String NEW_ENROL_ICON = "res/ecmp/images/tbar/tb-enrol-new.png";
    private static final String LIFECYCLE_ICON = "res/ecmp/images/tbar/tb-lifecycle.png";
    private static final String UPDATE_ENROL_ICON = "res/ecmp/images/tbar/tb-lifecycle-update.png";
    private static final String PRINT_AADHAAR_ICON = "res/ecmp/images/tbar/tb-print-aadhaar.png";
    private static final String EOD_VERIFY_ICON = "res/ecmp/images/tbar/tb-eod-verify.png";
    private static final String SYNC_ICON = "res/ecmp/images/tbar/sync.png";
    private static final String EOD_REPORT_ICON = "res/ecmp/images/tbar/tb-eod-report.png";
    private static final String GPS_ICON = "res/ecmp/images/tbar/tb-eod-gps.png";
    private static final String OP_STAT = "res/ecmp/images/tbar/tb-op-stat.png";
    private static final String OP_DISCLOSURE = "res/ecmp/images/tbar/tb-op-stat.png";
    private static final String LOGOUT_ICON = "res/ecmp/images/tbar/tb-logout.png";
    private static final String EOD_ICON = "res/ecmp/images/tbar/tb-eod.png";
    private static final String DEVICE_POPUP_NAME = "device-status";
    private static final String AADHAAR_LOGO = "AADHAAR_LOGO";
    private static final String SB_PHOTO_ON = "SB_PHOTO_ON";
    private static final String SB_PHOTO_OFF = "SB_PHOTO_OFF";
    private static final String SB_SLAP_ON = "SB_SLAP_ON";
    private static final String SB_SLAP_OFF = "SB_SLAP_OFF";
    private static final String SB_IRIS_ON = "SB_IRIS_ON";
    private static final String SB_IRIS_OFF = "SB_IRIS_OFF";
    private static final String SB_RD_IRIS_ON = "SB_RD_IRIS_ON";
    private static final String SB_RD_IRIS_OFF = "SB_RD_IRIS_OFF";
    private static final String SB_PRINTER_ON = "SB_PRINTER_ON";
    private static final String SB_PRINTER_OFF = "SB_PRINTER_OFF";
    private static final String SB_GPS_ON = "SB_GPS_ON";
    private static final String SB_GPS_OFF = "SB_GPS_OFF";
    private static final String SB_REG_ON = "SB_REG_ON";
    private static final String SB_REG_OFF = "SB_REG_OFF";
    private static final String SB_RD_FINGER_ON = "SB_RD_FINGER_ON";
    private static final String SB_RD_FINGER_OFF = "SB_RD_FINGER_OFF";
    private static final String SB_OP_LOGGED_IN_ONLINE_TRUE = "SB_OP_LOGGED_IN_ONLINE_TRUE ";
    private static final String SB_OP_LOGGED_IN_ONLINE_FALSE = "SB_OP_LOGGED_IN_ONLINE_FALSE ";
    private final Map<String, IViewElement> eMap;
    private final Timer chkPrnTimer;
    private final PrintServiceAttributeListener psal;
    private final GpsUpdateHandler gpsHandler;
    protected SessionService sessionService;
    private IResourceBundleContext rbCtxt;
    private IEventContext evtCtxt;
    private JToolBar toolBar;
    private TransparentBox statusBar;
    private ImageArea photoStatus;
    private ImageArea slapStatus;
    private ImageArea irisStatus;
    private ImageArea rdFingerStatus;
    private ImageArea rdIrisStatus;
    private ImageArea printerStatus;
    private ImageArea gpsStatus;
    private ImageArea regStatus;
    private IClientDeviceManager clientDevMgr;
    private IRegistrationService registrationService;
    private IUIPreference uiPref;
    private PrintService defPrnSvc;
    private StatusBarGPS statusBarGPS;
    private DeviceLifeCycleListener deviceLifeCycleListener;
    private L10nDecorator ldeco;
    private ImageArea opOnlineStatus;
    private EnrollmentService enrollmentService;
    private TokenManager operatorTokenManager;
    private IGpsPreference gpsPref;
    private JLabel sidLabel = new JLabel("");
    private JLabel opDetails = new JLabel("");
    @Autowired
    private EnrolServiceClientApiService enrolServiceClientApiService;

    public MainWinDecorator() {
        this.eMap = new HashMap<String, IViewElement>();
        this.chkPrnTimer = new Timer(true);
        this.psal = evt -> this.updatePrinterStatus();
        this.gpsHandler = new GpsUpdateHandler();
    }

    public static List<String> getEnrolKeys() {
        ArrayList<String> enrolKeys = new ArrayList<String>();
        enrolKeys.add(KS_ENROL);
        enrolKeys.add(KS_UENROL);
        enrolKeys.add(KS_OUENROL);
        enrolKeys.add(KS_PENROL);
        enrolKeys.add(KS_APPOINTMENT_SCAN);
        return enrolKeys;
    }

    public void setResourceBundleContext(IResourceBundleContext ctxt) {
        this.rbCtxt = ctxt;
    }

    public void setEnrollmentService(EnrollmentService enrollmentService) {
        this.enrollmentService = enrollmentService;
    }

    public void setOperatorTokenManager(TokenManager tokenManager) {
        this.operatorTokenManager = tokenManager;
    }

    public void setClientDeviceManager(IClientDeviceManager cdm) {
        this.clientDevMgr = cdm;
    }

    public void setSessionService(SessionService sessionService) {
        this.sessionService = sessionService;
    }

    public void setDeviceLifeCycleListener(DeviceLifeCycleListener deviceLifeCycleListener) {
        this.deviceLifeCycleListener = deviceLifeCycleListener;
    }

    public void setGpsControl(IGpsControl ctrl) {
        IGpsListener gpsHandler = new IGpsListener(){

            public void geoDataReceived(GeoData data) {
                MainWinDecorator.this.doGpsReceived(data);
            }

            public void deviceRemoved() {
                MainWinDecorator.this.doGpsStopped();
            }

            public void deviceConnected() {
                MainWinDecorator.this.doGpsStarted();
            }
        };
        ctrl.addGpsListener(gpsHandler);
    }

    public void setStatusBarGPS(StatusBarGPS gps) {
        this.statusBarGPS = gps;
    }

    public void setRegistrationService(IRegistrationService registrationService) {
        this.registrationService = registrationService;
    }

    public void setUIPreference(IUIPreference pref) {
        this.uiPref = pref;
    }

    public void setGpsPreference(IGpsPreference pref) {
        this.gpsPref = pref;
        this.gpsHandler.setGpsPreference(pref);
    }

    public void setEventContext(IEventContext ctxt) {
        this.evtCtxt = ctxt;
    }

    public void prepare() {
        this.toolBar = new JToolBar(0);
        this.toolBar.setLayout(new BorderLayout());
        this.toolBar.setFloatable(false);
        ImageArea logo = new ImageArea();
        logo.setIcon((Icon)ImageIconCache.getInst().getIcon(AADHAAR_LOGO));
        this.toolBar.add((Component)logo, "West");
        this.addShortCutToMonitorCPUAndMemoryUsage();
        this.toolBar.add((Component)this.createToolBarButtonArea(), "East");
        this.statusBar = new TransparentBox((LayoutManager)new BorderLayout(0, 0));
        LinearGradientBackground statusBg = new LinearGradientBackground().direction(1).borderSize(0.0f).roundingSize(2, 2).gradientColors("#6a6a6a, #404040").gradientStops("0, 1");
        this.statusBar.setBackground((IPaintDelegate)statusBg);
        this.statusBar.setPreferredSize(new Dimension(32, 32));
        TransparentBox devStatusArea = new TransparentBox((LayoutManager)new GridLayout(1, 4, 4, 4));
        devStatusArea.setBorder((Border)new EmptyBorder(4, 4, 4, 4));
        this.statusBar.add((Component)devStatusArea, (Object)"West");
        this.photoStatus = this.createDeviceStatusArea(SB_PHOTO_OFF);
        devStatusArea.add((Component)this.photoStatus);
        this.slapStatus = this.createDeviceStatusArea(SB_SLAP_OFF);
        devStatusArea.add((Component)this.slapStatus);
        this.irisStatus = this.createDeviceStatusArea(SB_IRIS_OFF);
        devStatusArea.add((Component)this.irisStatus);
        this.rdFingerStatus = this.createDeviceStatusArea(SB_RD_FINGER_OFF);
        devStatusArea.add((Component)this.rdFingerStatus);
        this.rdIrisStatus = this.createDeviceStatusArea(SB_RD_IRIS_OFF);
        devStatusArea.add((Component)this.rdIrisStatus);
        this.printerStatus = this.createDeviceStatusArea(SB_PRINTER_OFF);
        devStatusArea.add((Component)this.printerStatus);
        this.gpsStatus = this.createDeviceStatusArea(SB_GPS_OFF);
        devStatusArea.add((Component)this.gpsStatus);
        this.opOnlineStatus = this.createDeviceStatusArea(SB_OP_LOGGED_IN_ONLINE_FALSE);
        devStatusArea.add((Component)this.opOnlineStatus);
        this.enrollmentService.newSidListener(newSid -> SwingUtilities.invokeLater(() -> this.updateSid((String)newSid)));
        this.enrollmentService.displayOperatorDetails(op -> SwingUtilities.invokeLater(() -> this.updateOperatorDetails((OperatorDetails)op)));
        this.operatorTokenManager.addValidityListener(onlineStatus -> SwingUtilities.invokeLater(() -> this.updateOperatorOnlineStatus((boolean)onlineStatus)));
        this.deviceLifeCycleListener.addDeviceStartedListener(this::doDeviceStarted);
        this.deviceLifeCycleListener.addDeviceStoppedListener(this::doDeviceStopped);
        this.clientDevMgr.refreshDeviceStates();
        this.chkPrnTimer.scheduleAtFixedRate((TimerTask)new CheckPrinterTask(), 5000L, 5000L);
        this.statusBar.add((Component)this.createApplicationStatus(), (Object)"East");
    }

    private ImageArea createDeviceStatusArea(String icon) {
        ImageArea imageArea = new ImageArea();
        imageArea.setPreferredSize(new Dimension(28, 28));
        imageArea.setBorder((Border)new RoundedBorder().lineColor("#ffffff").lineThickness(1.0f).rounding(3, 3));
        NotificationPopup.getToolTip((JComponent)imageArea, (String)DEVICE_POPUP_NAME).setLocation(NotificationLocation.TOP);
        imageArea.setIcon((Icon)ImageIconCache.getInst().getIcon(icon));
        return imageArea;
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public JComponent getStatusBar() {
        return this.statusBar;
    }

    public Map<String, IViewElement> getElementMap() {
        return this.eMap;
    }

    private JComponent createToolBarButtonArea() {
        this.ldeco = new L10nDecorator(this.rbCtxt, this.uiPref.getApplicationLocalize(false));
        TransparentBox buttonArea = new TransparentBox();
        buttonArea.setLayout((LayoutManager)new BoxLayout((Container)buttonArea, 0));
        buttonArea.add((Component)this.createMainWinHeader());
        JSeparator separator = new JSeparator(1);
        EmptyBorder border1 = new EmptyBorder(5, 5, 5, 5);
        SingleLineBorder border2 = new SingleLineBorder().drawEdges(false, true, false, false).lineColor("#999999").lineThickness(1.0f);
        separator.setBorder(new CompoundBorder(border1, (Border)border2));
        buttonArea.add((Component)separator);
        ButtonGroup tbButGrp = new ButtonGroup();
        DropDownToggleButton appointmentBut = this.createDropDownButton(buttonArea, tbButGrp, LabelKeysMainWin.APPOINTMENT, APPOINTMENT_ICON, "eID_Appointment_BtnGrp");
        this.createMenuButton(appointmentBut, LabelKeysMainWin.APPOINTMENT_SCAN, SCAN_APPOINTMENT_ICON, "hID_Appointment_ScanButSel", "hID_Appointment_ScanBut", KS_APPOINTMENT_SCAN, APPOINTMENT_SCAN_AXN);
        this.createMenuButton(appointmentBut, LabelKeysMainWin.APPOINTMENT_FETCH, SCAN_APPOINTMENT_ICON, "hID_Appointment_FeildButSel", "hID_Appointment_ScanBut_UC", KS_APPOINTMENTID_FEILD, APPOINTMENT_SCAN_AXN);
        DropDownToggleButton enrolBut = this.createDropDownButton(buttonArea, tbButGrp, LabelKeysMainWin.ENROL, RESIDENT_ICON, "eID_Enrol_BtnGrp");
        this.createMenuButton(enrolBut, LabelKeysMainWin.ENROL_NEW, NEW_ENROL_ICON, "hID_New_Enrol", "hID_Enrol_ToolBut", KS_ENROL, ENROL_AXN);
        DropDownToggleButton lcBut = this.createDropDownButton(buttonArea, tbButGrp, LabelKeysMainWin.LIFECYCLE, LIFECYCLE_ICON, "eID_Lc_BtnGrp");
        this.createMenuButton(lcBut, LabelKeysMainWin.LIFECYCLE_UPDATE_OFFLINE, UPDATE_ENROL_ICON, "hID_Update_Enrol", "hID_Uenrol_ToolBut", KS_UENROL, U_ENROL_AXN);
        this.createMenuButton(lcBut, LabelKeysMainWin.LIFECYCLE_UPDATE_DOCUMENT_OFFLINE, UPDATE_ENROL_ICON, "hID_ODUpdate_Enrol", "hID_OFFUDocument_ToolBut", KS_UENROL, U_ENROL_AXN);
        this.createMenuButton(lcBut, LabelKeysMainWin.LIFECYCLE_UPDATE_ONLINE, UPDATE_ENROL_ICON, "eID_duAADHAR", "hID_OUenrol_ToolBut", KS_OUENROL, OU_ENROL_AXN);
        this.createMenuButton(lcBut, LabelKeysMainWin.LIFECYCLE_UPDATE_DOCUMENT_ONLINE, UPDATE_ENROL_ICON, "eID_docUpdate", "hID_OUDocument_ToolBut", KS_OUENROL, OU_ENROL_AXN);
        this.createMenuButton(lcBut, LabelKeysMainWin.LIFECYCLE_PRINTAADHAAR, PRINT_AADHAAR_ICON, "eID_eAADHAR", "eID_Paadhaar_Toolbut", KS_PENROL, P_ENROL_AXN);
        this.createMenuButton(lcBut, LabelKeysMainWin.OPERATOR_LOGIN, UPDATE_ENROL_ICON, "login", "hID_OpLogin_ToolBut", KS_OUENROL, OU_ENROL_AXN);
        this.createMenuButton(lcBut, LabelKeysMainWin.LIFECYCLE_SCANNER_SELECT, UPDATE_ENROL_ICON, "scanner_select", "hID_Scanner_ToolBut", KS_SCAN, OU_ENROL_AXN);
        this.createMenuButton(lcBut, LabelKeysMainWin.LIFECYCLE_CANCEL_TRANSACTION, UPDATE_ENROL_ICON, "cancelDemo", "hID_UC_OUenrol_ToolBut", KS_ONLINE, OU_ENROL_AXN);
        this.createMenuButton(lcBut, LabelKeysMainWin.LIFECYCLE_MODE_SELECTION, UPDATE_ENROL_ICON, "mode_select", "hID_Mode_ToolBut", KS_ONLINE, OU_ENROL_AXN);
        DropDownToggleButton eodBut = this.createDropDownButton(buttonArea, tbButGrp, LabelKeysMainWin.PROCESS, EOD_ICON, null);
        this.createMenuButton(eodBut, LabelKeysMainWin.VIEW_ENROLLMENT_DETAILS, EOD_VERIFY_ICON, "hID_Vrol_ToolBut_Sel", "eID_Vrol_ToolBut", KS_VERIFY, "viewEnrolDetailsAxn");
        this.createMenuButton(eodBut, LabelKeysMainWin.PROCESS_OPERATOR_SYNC, SYNC_ICON, "hID_OpSync", "hID_OpSync_ToolBut", KS_OP_SYNC, "opSyncAxn");
        this.createMenuButton(eodBut, LabelKeysMainWin.PROCESS_REPORT, EOD_REPORT_ICON, "hID_Report_ToolBut_Sel", "eID_Report_ToolBut", KS_REPORT, "reportAxn");
        this.createMenuButton(eodBut, LabelKeysMainWin.PROCESS_REPORT_FOR_UC, EOD_REPORT_ICON, "hID_Report_ToolBut_Sel_for_UC", "eID_Report_ToolBut_for_UC", KS_REPORT, "reportAxn");
        this.createMenuButton(eodBut, LabelKeysMainWin.PROCESS_GPS, GPS_ICON, "hID_Gps_Toolbut_sel", "eID_Gps_Toolbut", KS_GPS, "gpsAxn");
        this.createMenuButton(eodBut, LabelKeysMainWin.PROCESS_OPSTATS, "res/ecmp/images/tbar/tb-op-stat.png", "hID_OpStat_Toolbut_sel", "eID_OpStat_Toolbut", KS_OPSTAT, "opStatAxn");
        this.createMenuButton(eodBut, LabelKeysMainWin.PROCESS_OPDISCLOSURE, "res/ecmp/images/tbar/tb-op-stat.png", "hID_OpDisclosure_Toolbut_sel", "eID_OpDisclosure_Toolbut", KS_OPDISCLOSURE, "opDiscloseAxn");
        this.createMenuButton(eodBut, LabelKeysMainWin.PROCESS_LOGOUT, LOGOUT_ICON, "hID_Session_Logout", "eID_Logout_Toolbut", KS_LOGOUT, "logoutAxn");
        this.createMenuButton(eodBut, LabelKeysMainWin.PROCESS_LOGOUT, LOGOUT_ICON, "operator_logout", "eID_Logout_Toolbut_UC", KS_LOGOUT, "logoutAxn");
        this.eMap.put("hID_MainWin_ToolBar", new StandardSwingElementFactory().get((Object)this.toolBar, "hID_MainWin_ToolBar"));
        if (this.sessionService.isSessionValid()) {
            this.setMenuItemState();
        }
        this.sessionService.addSessionDataChangeListener(e -> this.setMenuItemState());
        return buttonArea;
    }

    private void addShortCutToMonitorCPUAndMemoryUsage() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MachineInfo.monitorCPUAndMemoryUsage();
            }
        };
        String keyAction = "MonitorCPUAndMemoryUsage";
        InputMap inMap = this.toolBar.getInputMap(2);
        inMap.put(KeyStroke.getKeyStroke(KS_MONITOR_SYSTEM_INFO), keyAction);
        ActionMap axnMap = this.toolBar.getActionMap();
        axnMap.put(keyAction, action);
    }

    private void setMenuItemState() {
        InputMap inMap = this.toolBar.getInputMap(2);
        boolean operatorOnboarded = this.sessionService.isOperatorOnboarded();
        if (this.sessionService.isSessionValid()) {
            boolean enableNewEnrollment = operatorOnboarded && !this.sessionService.isNewEnrollmentDisabled();
            boolean enableOfflineUpdate = operatorOnboarded && !this.sessionService.isBiometricUpdateDisabledForStation();
            boolean enableOfflineDocUpdate = operatorOnboarded && !this.sessionService.isBiometricUpdateDisabledForStation();
            boolean enableAppointment = enableNewEnrollment && enableOfflineUpdate;
            boolean enableFindAadhaar = this.sessionService.isFindAadhaarEnabled();
            this.eMap.get("eID_Enrol_BtnGrp").set("enable", (Object)enableNewEnrollment);
            this.eMap.get("hID_Uenrol_ToolBut").set("enable", (Object)enableOfflineUpdate);
            this.eMap.get("hID_OFFUDocument_ToolBut").set("enable", (Object)enableOfflineDocUpdate);
            this.eMap.get("eID_Appointment_BtnGrp").set("enable", (Object)enableAppointment);
            this.eMap.get("eID_Paadhaar_Toolbut").set("enable", (Object)enableFindAadhaar);
            this.eMap.get("eID_Lc_BtnGrp").set("enable", (Object)true);
            this.eMap.get("eID_Logout_Toolbut").set("enable", (Object)true);
            this.eMap.get("eID_Report_ToolBut").set("enable", (Object)true);
            this.eMap.get("eID_Vrol_ToolBut").set("enable", (Object)true);
            this.eMap.get("hID_OpLogin_ToolBut").set("enable", (Object)false);
            this.eMap.get("hID_UC_OUenrol_ToolBut").set("enable", (Object)false);
            this.eMap.get("hID_OUenrol_ToolBut").set("enable", (Object)true);
            this.eMap.get("hID_Mode_ToolBut").set("enable", (Object)true);
            this.eMap.get("hID_OUDocument_ToolBut").set("enable", (Object)true);
            this.eMap.get("hID_Scanner_ToolBut").set("enable", (Object)false);
            if (enableNewEnrollment) {
                inMap.put(KeyStroke.getKeyStroke(KS_ENROL), ENROL_AXN);
            }
            if (enableOfflineUpdate) {
                inMap.put(KeyStroke.getKeyStroke(KS_UENROL), U_ENROL_AXN);
            }
            if (enableOfflineDocUpdate) {
                inMap.put(KeyStroke.getKeyStroke(KS_UENROL), U_ENROL_AXN);
            }
            inMap.put(KeyStroke.getKeyStroke(KS_OUENROL), OU_ENROL_AXN);
            if (enableFindAadhaar) {
                inMap.put(KeyStroke.getKeyStroke(KS_PENROL), P_ENROL_AXN);
            }
            if (enableAppointment) {
                inMap.put(KeyStroke.getKeyStroke(KS_APPOINTMENT_SCAN), APPOINTMENT_SCAN_AXN);
            }
        } else {
            this.eMap.get("eID_Enrol_BtnGrp").set("enable", (Object)false);
            this.eMap.get("eID_Lc_BtnGrp").set("enable", (Object)false);
            this.eMap.get("eID_Appointment_BtnGrp").set("enable", (Object)false);
            this.eMap.get("eID_Logout_Toolbut").set("enable", (Object)false);
            if (!operatorOnboarded) {
                this.eMap.get("eID_Report_ToolBut").set("enable", (Object)false);
                this.eMap.get("eID_Vrol_ToolBut").set("enable", (Object)false);
            }
            inMap.remove(KeyStroke.getKeyStroke(KS_ENROL));
            inMap.remove(KeyStroke.getKeyStroke(KS_UENROL));
            inMap.remove(KeyStroke.getKeyStroke(KS_OUENROL));
            inMap.remove(KeyStroke.getKeyStroke(KS_PENROL));
            inMap.remove(KeyStroke.getKeyStroke(KS_APPOINTMENT_SCAN));
        }
    }

    private DropDownToggleButton createDropDownButton(TransparentBox buttonArea, ButtonGroup tbButGrp, LabelKeysMainWin label, String iconPath, String buttonGroup) {
        DropDownToggleButton toggleButton = new DropDownToggleButton(this.rbCtxt.getMessage((Object)label, new Object[0]), iconPath);
        buttonArea.add((Component)toggleButton);
        tbButGrp.add((AbstractButton)toggleButton);
        this.ldeco.localize((AbstractButton)toggleButton, (Object)label, new Object[0]);
        if (buttonGroup != null) {
            this.eMap.put(buttonGroup, new StandardSwingElementFactory().get((Object)toggleButton, buttonGroup));
        }
        return toggleButton;
    }

    private L10nLabel createMainWinHeader() {
        L10nDecorator hdeco = new L10nDecorator(this.rbCtxt, this.uiPref.getApplicationLocalize(false));
        Font headerFont = new Font("URW Gothic L Demi", 1, 24);
        hdeco.setDefaultFont(headerFont);
        hdeco.followDefaultFontParameters(true);
        L10nLabel header = new L10nLabel();
        header.setL10nDecorator(hdeco);
        header.setFont(headerFont);
        this.eMap.put("hID_MainWin_Header", new StandardSwingElementFactory().get((Object)header, "hID_MainWin_Header"));
        return header;
    }

    private void createMenuButton(DropDownToggleButton button, LabelKeysMainWin label, String iconPath, String event, String buttonKey, String keyStroke, String keyAction) {
        final JMenuItem menuItem = button.addMenuItem(this.rbCtxt.getMessage((Object)label, new Object[0]), iconPath);
        this.ldeco.localize((AbstractButton)menuItem, (Object)label, new Object[0]);
        menuItem.addActionListener((ActionListener)this.evtCtxt.getEventListener(event, ActionListener.class));
        this.eMap.put(buttonKey, new StandardSwingElementFactory().get((Object)menuItem, buttonKey));
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                menuItem.doClick();
            }
        };
        if (keyStroke != null) {
            InputMap inMap = this.toolBar.getInputMap(2);
            inMap.put(KeyStroke.getKeyStroke(keyStroke), keyAction);
            ActionMap axnMap = this.toolBar.getActionMap();
            axnMap.put(keyAction, action);
            menuItem.setToolTipText("Press " + keyStroke + " to activate");
        }
    }

    private void doDeviceStarted(DeviceType type) {
        if (type == null) {
            return;
        }
        IDeviceContext devCtxt = this.clientDevMgr.getDeviceContext(type);
        StringBuilder tipText = new StringBuilder("<html>");
        if (devCtxt != null) {
            DeviceInfo devInfo = devCtxt.getDeviceInformation();
            Map attribMap = devInfo.getDeviceAttributes();
            attribMap.keySet().forEach(key -> {
                String value = (String)attribMap.get(key);
                tipText.append("<b>").append((String)key).append(":</b> ").append(value).append("<br>");
            });
            tipText.append("<b>Video Formats:</b> ");
            List vfiList = devInfo.getVideoFormats();
            if (vfiList.isEmpty()) {
                tipText.append("information not available");
            } else {
                vfiList.forEach(vfi -> tipText.append("modality=").append(vfi.getModality()).append(" ").append(vfi.getWidth() + "x" + vfi.getHeight()).append(" ").append(vfi.getPixelFormat()).append(" "));
            }
            List sfiList = devInfo.getSampleFormats();
            tipText.append("<br><b>Sample Formats:</b> ");
            if (sfiList.isEmpty()) {
                tipText.append("information not available");
            } else {
                sfiList.forEach(sfi -> tipText.append(sfi.getWidth() + "x" + sfi.getHeight()).append(" ").append(sfi.getResolution()).append(" "));
            }
        } else {
            RegisteredDeviceContext devCtxtRd = this.clientDevMgr.getRegisteredDeviceManager().getDeviceContext(type);
            if (devCtxtRd == null) {
                return;
            }
            DeviceRdInfo devInfo = devCtxtRd.getDeviceInformation();
            HashMap<String, String> attribMap = this.getDeviceAttributes(devInfo);
            attribMap.keySet().forEach(key -> {
                String value = (String)attribMap.get(key);
                tipText.append("<b>").append((String)key).append(":</b> ").append(value).append("<br>");
            });
            if (devCtxtRd.getDeviceUri() != null) {
                tipText.append("<b>").append("Rd-Uri").append(":</b> ").append(devCtxtRd.getDeviceUri()).append("<br>");
            }
        }
        switch (type) {
            case PHOTO: {
                this.setDeviceState(this.photoStatus, SB_PHOTO_ON, tipText.toString(), "Camera is now available");
                break;
            }
            case FINGERPRINT: {
                this.setDeviceState(this.slapStatus, SB_SLAP_ON, tipText.toString(), "Fingerprint capture device is now available");
                break;
            }
            case FINGERPRINT_AUTH: {
                this.setDeviceState(this.rdFingerStatus, SB_RD_FINGER_ON, tipText.toString(), "Fingerprint capture registered device is now available");
                break;
            }
            case IRIS: {
                this.setDeviceState(this.irisStatus, SB_IRIS_ON, tipText.toString(), "Iris capture device is now available");
                break;
            }
            case IRIS_AUTH: {
                this.setDeviceState(this.rdIrisStatus, SB_RD_IRIS_ON, tipText.toString(), "Iris capture registered device is now available");
            }
        }
    }

    private void doDeviceStopped(DeviceType type) {
        if (type == null) {
            return;
        }
        switch (type) {
            case PHOTO: {
                this.setDeviceState(this.photoStatus, SB_PHOTO_OFF, "Camera unplugged/not available", null);
                break;
            }
            case FINGERPRINT: {
                this.setDeviceState(this.slapStatus, SB_SLAP_OFF, "Fingerprint scanner unplugged/not available", null);
                break;
            }
            case FINGERPRINT_AUTH: {
                this.setDeviceState(this.rdFingerStatus, SB_RD_FINGER_OFF, "Fingerprint scanner unplugged/not available", null);
                break;
            }
            case IRIS: {
                this.setDeviceState(this.irisStatus, SB_IRIS_OFF, "Iris scanner unplugged/not available", null);
                break;
            }
            case IRIS_AUTH: {
                this.setDeviceState(this.rdIrisStatus, SB_RD_IRIS_OFF, "Iris scanner unplugged/not available", null);
            }
        }
    }

    private void doGpsStarted() {
        this.setDeviceState(this.gpsStatus, SB_GPS_ON, "GPS device active", "GPS device active");
    }

    private void doGpsStopped() {
        this.setDeviceState(this.gpsStatus, SB_GPS_OFF, "GPS device inactive", "GPS device inactive");
    }

    private void doGpsReceived(GeoData data) {
        String ttip = "GPS Data Updates: " + data;
        NotificationPopup.getToolTip((JComponent)this.gpsStatus, (String)DEVICE_POPUP_NAME).showToolTip(ttip, true);
    }

    private void updatePrinterStatus() {
        if (this.defPrnSvc == null) {
            this.printerStatus.setIcon((Icon)ImageIconCache.getInst().getIcon(SB_PRINTER_OFF));
            this.printerStatus.setToolTipText(null);
            return;
        }
        PrinterName prnName = this.defPrnSvc.getAttribute(PrinterName.class);
        PrinterMakeAndModel prnMod = this.defPrnSvc.getAttribute(PrinterMakeAndModel.class);
        PrinterState prnState = this.defPrnSvc.getAttribute(PrinterState.class);
        QueuedJobCount jobCount = this.defPrnSvc.getAttribute(QueuedJobCount.class);
        StringBuilder tipText = new StringBuilder("<html>");
        if (prnName != null) {
            tipText.append("<b>").append(prnName.getValue()).append("</b><br>");
        }
        if (prnMod != null) {
            tipText.append("<b>Model:</b> ").append(prnMod.getValue()).append("<br>");
        }
        if (jobCount != null) {
            tipText.append("<b>Pending Jobs:</b> ").append(jobCount.getValue()).append("<br>");
        }
        String printerStatusIcon = SB_PRINTER_ON;
        if (prnState != null) {
            if (prnState.equals(PrinterState.STOPPED)) {
                printerStatusIcon = SB_PRINTER_OFF;
            } else if (prnState.equals(PrinterState.IDLE) || prnState.equals(PrinterState.PROCESSING)) {
                printerStatusIcon = SB_PRINTER_ON;
            }
        }
        this.setDeviceState(this.printerStatus, printerStatusIcon, tipText.toString(), null);
    }

    private void updateOperatorOnlineStatus(boolean active) {
        LOGGER.info("Operator online status is " + active);
        if (active) {
            this.setDeviceState(this.opOnlineStatus, SB_OP_LOGGED_IN_ONLINE_TRUE, "Operator online", null);
        } else {
            this.setDeviceState(this.opOnlineStatus, SB_OP_LOGGED_IN_ONLINE_FALSE, "Operator offline", null);
        }
    }

    private void updateSid(String incomingSid) {
        this.sidLabel.setText(incomingSid);
    }

    private void updateOperatorDetails(OperatorDetails operatorDetailsUC) {
        String opName;
        String opId;
        if (operatorDetailsUC != null) {
            opId = operatorDetailsUC.getOperatorId();
            opName = operatorDetailsUC.getOpName();
            this.statusBarGPS.setText(operatorDetailsUC.getLatitude(), this.gpsPref.getLatBearing("N"), operatorDetailsUC.getLongitude(), this.gpsPref.getLatBearing("E"), operatorDetailsUC.getAltitude());
        } else {
            opId = this.sessionService.getOperatorCredentials().getOperatorId();
            opName = this.sessionService.getOperatorCredentials().getFullName();
        }
        this.opDetails.setText("(" + opId + ") " + opName);
    }

    private void setDeviceState(ImageArea imageArea, String iconPath, String toolTip, String status) {
        imageArea.setIcon((Icon)ImageIconCache.getInst().getIcon(iconPath));
        imageArea.setToolTipText(toolTip);
        NotificationPopup.getToolTip((JComponent)imageArea, (String)DEVICE_POPUP_NAME).showToolTip(status == null ? toolTip : status, true);
    }

    private JComponent createApplicationStatus() {
        TransparentBox appStatusArea = new TransparentBox((LayoutManager)new FlowLayout(2, 0, 0));
        appStatusArea.setBorder((Border)new EmptyBorder(8, 4, 0, 0));
        SingleLineBorder slb = new SingleLineBorder().lineThickness(1.0f).lineColor("#ffffff").drawEdges(false, false, false, true);
        CompoundBorder cb = new CompoundBorder((Border)slb, new EmptyBorder(0, 4, 0, 4));
        this.sidLabel.setForeground(Color.WHITE);
        this.sidLabel.setBorder(cb);
        this.opDetails.setForeground(Color.WHITE);
        this.opDetails.setBorder(cb);
        String regId = "0000";
        String eacId = "0";
        String stationId = "0";
        String location = "000000";
        if (this.registrationService.isRegistered()) {
            regId = this.registrationService.getRegistrarId();
            eacId = this.registrationService.getAgencyId();
            stationId = this.registrationService.getStationId();
            location = this.registrationService.getClientLocation();
        }
        String registrationDetails = StringUtils.isNotBlank((String)location) ? regId + "-" + eacId + "-" + stationId + "-" + location : regId + "-" + eacId + "-" + stationId;
        JLabel regDetails = new JLabel(registrationDetails);
        regDetails.setForeground(Color.WHITE);
        regDetails.setBorder(cb);
        JLabel verDetails = new JLabel("version " + ApplicationVersion.FULLDISPLAYVERSION);
        verDetails.setForeground(Color.WHITE);
        verDetails.setBorder(cb);
        StatusBarClock clock = new StatusBarClock("dd-MMM-yyyy hh:mm:ss a", 500, this.evtCtxt);
        clock.setForeground(Color.WHITE);
        clock.setBorder((Border)cb);
        this.statusBarGPS.init();
        this.statusBarGPS.setForeground(Color.WHITE);
        this.statusBarGPS.setBorder((Border)new EmptyBorder(0, 5, 0, 4));
        this.regStatus = new ImageArea();
        this.regStatus.setPreferredSize(new Dimension(18, 18));
        NotificationPopup.getToolTip((JComponent)this.regStatus, (String)DEVICE_POPUP_NAME).setLocation(NotificationLocation.TOP);
        this.regStatus.setIcon((Icon)ImageIconCache.getInst().getIcon(SB_REG_OFF));
        ScheduledExecutorService tracker = Executors.newSingleThreadScheduledExecutor();
        tracker.scheduleAtFixedRate(() -> {
            this.regStatus.setIcon((Icon)ImageIconCache.getInst().getIcon(SB_REG_OFF));
            this.regStatus.setToolTipText("<html><b>Registrar packet will not be available.");
        }, 0L, 15L, TimeUnit.SECONDS);
        appStatusArea.add((Component)this.sidLabel);
        appStatusArea.add((Component)this.regStatus);
        appStatusArea.add((Component)this.opDetails);
        appStatusArea.add((Component)regDetails);
        appStatusArea.add((Component)verDetails);
        appStatusArea.add((Component)clock);
        appStatusArea.add((Component)this.statusBarGPS);
        return appStatusArea;
    }

    private HashMap<String, String> getDeviceAttributes(DeviceRdInfo conformerBioDeviceInfo) {
        HashMap<String, String> attribs = new HashMap<String, String>();
        if (conformerBioDeviceInfo != null) {
            attribs.put("Rd-Provider-Id ", conformerBioDeviceInfo.getDpId());
            attribs.put("Rd-Certified-Service-Id.", conformerBioDeviceInfo.getRdsId());
            attribs.put("Rd-Service-Version", conformerBioDeviceInfo.getRdsVer());
            attribs.put("Rd-Code", conformerBioDeviceInfo.getDc());
            attribs.put("Rd-Model-Id", conformerBioDeviceInfo.getMi());
        }
        return attribs;
    }

    static {
        ImageIconCache.getInst().addIcon(AADHAAR_LOGO, "res/images/aadhar_logo_tb.png");
        ImageIconCache.getInst().addIcon(SB_PHOTO_ON, "res/images/sb-photo.png");
        ImageIconCache.getInst().addIcon(SB_PHOTO_OFF, "res/images/sb-photo-off.png");
        ImageIconCache.getInst().addIcon(SB_SLAP_ON, "res/images/sb-slap.png");
        ImageIconCache.getInst().addIcon(SB_SLAP_OFF, "res/images/sb-slap-off.png");
        ImageIconCache.getInst().addIcon(SB_IRIS_ON, "res/images/sb-iris.png");
        ImageIconCache.getInst().addIcon(SB_IRIS_OFF, "res/images/sb-iris-off.png");
        ImageIconCache.getInst().addIcon(SB_RD_IRIS_ON, "res/images/sb-iris-tick.png");
        ImageIconCache.getInst().addIcon(SB_RD_IRIS_OFF, "res/images/sb-iris-off-tick.png");
        ImageIconCache.getInst().addIcon(SB_PRINTER_ON, "res/images/sb-printer.png");
        ImageIconCache.getInst().addIcon(SB_PRINTER_OFF, "res/images/sb-printer-off.png");
        ImageIconCache.getInst().addIcon(SB_GPS_ON, "res/images/sb-gps.png");
        ImageIconCache.getInst().addIcon(SB_GPS_OFF, "res/images/sb-gps-off.png");
        ImageIconCache.getInst().addIcon(SB_REG_ON, "res/images/sb-reg-on.png");
        ImageIconCache.getInst().addIcon(SB_REG_OFF, "res/images/sb-reg-off.png");
        ImageIconCache.getInst().addIcon(SB_RD_FINGER_ON, "res/images/sb-rd-finger-on-tick.png");
        ImageIconCache.getInst().addIcon(SB_RD_FINGER_OFF, "res/images/sb-rd-finger-off-tick.png");
        ImageIconCache.getInst().addIcon(SB_OP_LOGGED_IN_ONLINE_TRUE, "res/images/op-online.png");
        ImageIconCache.getInst().addIcon(SB_OP_LOGGED_IN_ONLINE_FALSE, "res/images/op-offline.png");
    }

    private class CheckPrinterTask
    extends TimerTask {
        private CheckPrinterTask() {
        }

        @Override
        public void run() {
            PrintService prnSvc = PrintServiceLookup.lookupDefaultPrintService();
            if (prnSvc == null) {
                return;
            }
            if (!ObjectUtils.equals((Object)prnSvc, (Object)MainWinDecorator.this.defPrnSvc)) {
                if (MainWinDecorator.this.defPrnSvc != null) {
                    MainWinDecorator.this.defPrnSvc.removePrintServiceAttributeListener(MainWinDecorator.this.psal);
                }
                MainWinDecorator.this.defPrnSvc = prnSvc;
                MainWinDecorator.this.defPrnSvc.addPrintServiceAttributeListener(MainWinDecorator.this.psal);
                MainWinDecorator.this.updatePrinterStatus();
            }
        }
    }
}

