/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.main;

import in.gov.uidai.ec.ui.shared.l10n.MsgKeysLifeCycle;
import in.gov.uidai.litef.devapi.ILiteEvent;
import in.gov.uidai.litef.devapi.IOnScreenDisplay;
import in.gov.uidai.litef.devapi.IOnScreenDisplayAware;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import in.gov.uidai.swing.l10n.MsgKeysCommon;
import java.awt.Component;
import java.awt.Window;
import java.util.stream.IntStream;

public class UnsavedTracker
implements IOnScreenDisplayAware {
    private static final int STATUS_OTHER = 0;
    private static final int STATUS_ENROL = 1;
    private static final int STATUS_PRINT_AADHAAR = 3;
    private static final int STATUS_APPOINTMENT = 4;
    private static final int STATUS_LOGOUT = 5;
    private IOnScreenDisplay osd;
    private int currentStatus;
    private int previousStatus;

    public void populateOnScreenDisplay(IOnScreenDisplay osd) {
        this.osd = osd;
    }

    public void reset() {
        this.currentStatus = 0;
    }

    public boolean isUnsaved() {
        return IntStream.of(1, 4, 3).anyMatch(i -> this.currentStatus == i);
    }

    public boolean selectPrintAadhaar(ILiteEvent evt) {
        if (!this.checkStatus(evt)) {
            return false;
        }
        this.currentStatus = 3;
        return true;
    }

    public boolean selectEnrol(ILiteEvent evt) {
        if (!this.checkStatus(evt)) {
            return false;
        }
        this.currentStatus = 1;
        return true;
    }

    public boolean selectAppointment(ILiteEvent evt) {
        if (!this.checkStatus(evt)) {
            return false;
        }
        this.currentStatus = 4;
        return true;
    }

    public boolean selectOther(ILiteEvent evt) {
        if (!this.checkStatus(evt)) {
            return false;
        }
        this.currentStatus = 0;
        return true;
    }

    private boolean checkStatus(ILiteEvent evt) {
        Window mainWin = this.osd.getWindowForScaffold(evt.getScaffoldId());
        MsgKeysLifeCycle mode = null;
        block0 : switch (this.currentStatus) {
            case 1: 
            case 4: {
                mode = MsgKeysLifeCycle.MODE_ENROL;
                break;
            }
            case 3: {
                mode = MsgKeysLifeCycle.MODE_PRINTAADHAAR;
                break;
            }
            case 5: {
                switch (this.previousStatus) {
                    case 1: 
                    case 4: {
                        mode = MsgKeysLifeCycle.MODE_ENROL_LOGOUT;
                        break block0;
                    }
                    case 3: {
                        mode = MsgKeysLifeCycle.MODE_PRINTAADHAAR_LOGOUT;
                        break block0;
                    }
                }
                mode = MsgKeysLifeCycle.MODE_LOGOUT;
            }
        }
        return mode == null || !L10nOptionPaneBuilder.getInstance().showYesNoConfirmation((Object)mode, (Component)mainWin).equals((Object)MsgKeysCommon.NO);
    }

    public boolean selectLogout(ILiteEvent evt) {
        this.previousStatus = this.currentStatus;
        this.currentStatus = 5;
        if (!this.checkStatus(evt)) {
            this.currentStatus = this.previousStatus;
            return false;
        }
        this.currentStatus = this.previousStatus;
        return true;
    }

    public void setCurrentStatusToOther() {
        this.currentStatus = 0;
        this.previousStatus = 0;
    }

    public boolean selectEnrolUC(ILiteEvent evt) {
        return this.checkStatusUC(evt);
    }

    private boolean checkStatusUC(ILiteEvent evt) {
        Window mainWin = this.osd.getWindowForScaffold(evt.getScaffoldId());
        String msg = "This will cancel the current enrolment. Data for the current process, collected so far, will be lost. Do you wish to continue?";
        return !L10nOptionPaneBuilder.getInstance().showYesNoUC(msg, (Component)mainWin).equals((Object)MsgKeysCommon.NO);
    }
}

