/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.modeselectionpage;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.net.URL;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ModeSelectionView {
    private JLabel Welcome;
    private JLabel aadhaarGif;
    protected JButton btnOffline;
    protected JButton btnOnline;
    protected JPanel mainPanel;
    private JLabel select;
    private final Color customBlue = new Color(19, 126, 178);
    private static final String AADHAAR_GIF = "res/ecmp/images/aadhargif.gif";
    private static final String NO_INTERNET_ICON = "res/ecmp/images/no_wifi.png";
    private static final String INTERNET_ICON = "res/ecmp/images/wifi_icon.png";

    public ModeSelectionView() {
        this.initComponents();
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.Welcome = new JLabel();
        this.select = new JLabel();
        this.aadhaarGif = new JLabel();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        this.btnOffline = this.createScalableButton(cl.getResource(NO_INTERNET_ICON));
        this.btnOnline = this.createScalableButton(cl.getResource(INTERNET_ICON));
        String font = "Segoe UI";
        this.mainPanel.setBackground(Color.white);
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.mainPanel.setFont(new Font(font, 1, 14));
        this.mainPanel.setLayout(new GridBagLayout());
        this.Welcome.setBackground(this.customBlue);
        this.Welcome.setFont(new Font(font, 1, 50));
        this.Welcome.setHorizontalAlignment(0);
        this.Welcome.setText("WELCOME !!!");
        this.select.setBackground(this.customBlue);
        this.select.setFont(new Font(font, 0, 24));
        this.select.setHorizontalAlignment(0);
        this.select.setText("Please Select the Operation Mode to Continue.");
        this.aadhaarGif.setHorizontalAlignment(0);
        this.aadhaarGif.setIcon(new ImageIcon(Objects.requireNonNull(cl.getResource(AADHAAR_GIF))));
        this.aadhaarGif.setHorizontalTextPosition(0);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridBagLayout());
        this.btnOffline.setFont(new Font(font, 1, 24));
        this.btnOffline.setText("ECMP");
        this.btnOffline.setBorder(BorderFactory.createEmptyBorder(1, 1, 35, 1));
        this.btnOffline.setBorderPainted(false);
        this.btnOffline.setCursor(new Cursor(12));
        this.btnOffline.setIcon(new ImageIcon(Objects.requireNonNull(cl.getResource(NO_INTERNET_ICON))));
        this.btnOffline.setLayout(new BoxLayout(this.btnOffline, 1));
        this.btnOffline.setVerticalTextPosition(3);
        this.btnOffline.setHorizontalTextPosition(0);
        this.btnOffline.setPreferredSize(new Dimension(300, 300));
        this.btnOffline.setMinimumSize(new Dimension(200, 200));
        this.btnOnline.setFont(new Font(font, 1, 24));
        this.btnOnline.setText("Universal Client");
        this.btnOnline.setName("Universal Client");
        this.btnOnline.setBorder(BorderFactory.createEmptyBorder(1, 1, 35, 1));
        this.btnOnline.setBorderPainted(false);
        this.btnOnline.setCursor(new Cursor(12));
        this.btnOnline.setIcon(new ImageIcon(Objects.requireNonNull(cl.getResource(INTERNET_ICON))));
        this.btnOnline.setLayout(new BoxLayout(this.btnOnline, 1));
        this.btnOnline.setVerticalTextPosition(3);
        this.btnOnline.setHorizontalTextPosition(0);
        this.btnOnline.setPreferredSize(new Dimension(300, 300));
        this.btnOnline.setMinimumSize(new Dimension(200, 200));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(5, 10, 5, 10);
        gbc.fill = 2;
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.insets = new Insets(50, 50, 20, 50);
        gbc1.fill = 2;
        buttonPanel.add((Component)this.btnOnline, gbc1);
        ++gbc1.gridx;
        buttonPanel.add((Component)this.btnOffline, gbc1);
        this.mainPanel.add((Component)this.aadhaarGif, gbc);
        ++gbc.gridy;
        this.mainPanel.add((Component)this.Welcome, gbc);
        ++gbc.gridy;
        this.mainPanel.add((Component)this.select, gbc);
        ++gbc.gridy;
        this.mainPanel.add((Component)buttonPanel, gbc);
    }

    private JButton createScalableButton(final URL path) {
        final JButton button = new JButton(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (this.getIcon() != null) {
                    ImageIcon imageIcon = new ImageIcon(Objects.requireNonNull(path));
                    Image image = imageIcon.getImage();
                    int width = (int)(0.5 * (double)this.getWidth());
                    int height = (int)(0.5 * (double)this.getHeight());
                    Image scaledImage = image.getScaledInstance(width, height, 4);
                    this.setIcon(new ImageIcon(scaledImage));
                    int newFontSize = Math.max(8, Math.min(24, this.getHeight() / 10));
                    this.setFont(this.getFont().deriveFont((float)newFontSize));
                }
            }
        };
        button.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                button.repaint();
            }
        });
        return button;
    }
}

