/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.onlineupdate.close;

import in.gov.uidai.ec.ui.onlineupdate.close.PacViewPeer;
import in.gov.uidai.ec.ui.onlineupdate.close.StepPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class OnlineSplipUI {
    protected JPanel mainPanel;
    protected JButton previewButton;
    protected JButton printButton;
    protected JButton submitButton;
    protected StepPanel signedPanel;
    protected StepPanel enrolPanel;
    protected PacViewPeer pacViewPeer;
    private boolean isPacRequire;
    private static final String AADHAAR_GREY_ICON = "uidlaf/images/aadhaar_grey.png";
    private static final String EYE_ICON = "uidlaf/images/eye.png";
    private static final String PRINTER_ICON = "uidlaf/images/printer.png";
    static final Color CUSTOM_BLUE = new Color(19, 126, 178);
    private final int width = 40;

    public OnlineSplipUI(boolean isPacRequire) {
        this.isPacRequire = isPacRequire;
        this.initComponents();
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.previewButton = this.createButton("Preview", EYE_ICON);
        this.printButton = this.createButton("Print", PRINTER_ICON);
        this.printButton.setName("Print");
        this.submitButton = this.createSubmitButton();
        this.pacViewPeer = new PacViewPeer();
        this.signedPanel = this.createStepPanel("Attach the signed acknowledgement slip", "Here you can attach the signed slip directly from your computer or by scanning.", "Step 1");
        this.signedPanel.setName("AckSlip");
        this.enrolPanel = this.createStepPanel("Attach the enrolment form", "Here you can attach the enrolment form directly from your computer or by scanning.", "Step 2");
        this.enrolPanel.setName("EnrolSlip");
        this.mainPanel.setBackground(Color.WHITE);
        this.mainPanel.setLayout((LayoutManager)new AbsoluteLayout());
        JLabel aadhaarLogo = this.createLogoLabel();
        JPanel contentPanel = this.createContentPanel();
        this.mainPanel.add((Component)contentPanel, new AbsoluteConstraints(0, 0, 720, 420));
        this.mainPanel.add((Component)aadhaarLogo, new AbsoluteConstraints(0, 0, 720, 420));
    }

    private JButton createButton(String text, String iconPath) {
        JButton button = new JButton();
        button.setPreferredSize(new Dimension(104, 30));
        button.setForeground(CUSTOM_BLUE);
        button.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getClassLoader().getResource(iconPath))));
        button.setText(text);
        button.setIconTextGap(6);
        return button;
    }

    private JButton createSubmitButton() {
        JButton button = new JButton("SUBMIT");
        button.setPreferredSize(new Dimension(150, 30));
        button.setFont(new Font("Segoe UI", 1, 14));
        button.setForeground(CUSTOM_BLUE);
        button.setEnabled(false);
        return button;
    }

    private StepPanel createStepPanel(String title1, String title2, String step) {
        return new StepPanel(title1, title2, step);
    }

    private JLabel createLogoLabel() {
        JLabel logoLabel = new JLabel();
        logoLabel.setHorizontalAlignment(0);
        logoLabel.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getClassLoader().getResource(AADHAAR_GREY_ICON))));
        logoLabel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        return logoLabel;
    }

    private JPanel createContentPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setOpaque(false);
        panel.add(this.createFirstPanel());
        if (this.isPacRequire) {
            panel.add(this.createSecondPanel());
        }
        panel.add(this.createThirdPanel());
        panel.add(this.createFourthPanel());
        panel.add(this.createFifthPanel());
        return panel;
    }

    private JPanel createFirstPanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.setOpaque(false);
        panel.add(Box.createHorizontalStrut(40));
        panel.add(new JLabel("Here is your Acknowledgement Slip. Now you can"));
        panel.add(Box.createHorizontalStrut(50));
        panel.add(this.previewButton);
        panel.add(Box.createHorizontalStrut(15));
        panel.add(this.printButton);
        panel.add(Box.createHorizontalStrut(40));
        return panel;
    }

    private JPanel createSecondPanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.setOpaque(false);
        panel.add(Box.createHorizontalStrut(40));
        panel.add(this.pacViewPeer.getMainPanel());
        panel.add(Box.createHorizontalStrut(40));
        return panel;
    }

    private JPanel createThirdPanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.setOpaque(false);
        panel.add(Box.createHorizontalStrut(40));
        panel.add(this.signedPanel.getPanel());
        panel.add(Box.createHorizontalStrut(40));
        return panel;
    }

    private JPanel createFourthPanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.setOpaque(false);
        panel.add(Box.createHorizontalStrut(40));
        panel.add(this.enrolPanel.getPanel());
        panel.add(Box.createHorizontalStrut(40));
        return panel;
    }

    private JPanel createFifthPanel() {
        JPanel panel = new JPanel(new FlowLayout(1));
        panel.setOpaque(false);
        panel.add(this.submitButton);
        return panel;
    }
}

