/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.onlineupdate.close;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.oauthapi.exception.ErrorCodes;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.UpdateType;
import in.gov.uidai.ec.service.pac.PaymentAuthException;
import in.gov.uidai.ec.service.pac.PaymentAuthService;
import in.gov.uidai.ec.swing.imgvu.DisplayMode;
import in.gov.uidai.ec.telemetry.TelemetryService;
import in.gov.uidai.ec.ui.main.UnsavedTracker;
import in.gov.uidai.ec.ui.onlineupdate.close.PacViewPeer;
import in.gov.uidai.ec.ui.utils.Utils;
import in.gov.uidai.litef.beans.ModalVisualExecutionContext;
import in.gov.uidai.litef.devapi.EventHandler;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.devapi.ILiteEvent;
import in.gov.uidai.litef.devapi.IOnScreenDisplay;
import in.gov.uidai.litef.devapi.IViewElement;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.litef.devapi.ScaffoldPlacement;
import in.gov.uidai.swing.l10n.L10nDecorator;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineUpdateCloseControl {
    private static final Logger LOGGER = LoggerFactory.getLogger(OnlineUpdateCloseControl.class);
    private final EnrollmentService enrollmentService;
    private final UnsavedTracker tracker;
    private final IEventContext eventContext;
    private final IOnScreenDisplay osd;
    private final IResourceBundleContext ctxt;
    private final PaymentAuthService paymentAuthService;

    public OnlineUpdateCloseControl(EnrollmentService enrollmentService, UnsavedTracker tracker, IEventContext eventContext, IOnScreenDisplay osd, IResourceBundleContext ctxt, PaymentAuthService paymentAuthService) {
        this.enrollmentService = enrollmentService;
        this.tracker = tracker;
        this.eventContext = eventContext;
        this.osd = osd;
        this.ctxt = ctxt;
        this.paymentAuthService = paymentAuthService;
    }

    @EventHandler(name="HID_COMPLETE_ENROLMENT", method="actionPerformed")
    public void onCompleteEnrolment(ILiteEvent event) {
        LOGGER.debug("Completing online update enrolment");
        this.enrollmentService.fireDisableAllTabs();
        this.tracker.reset();
        this.closeWin(event.getScaffoldId(), event.getViewId());
        Utils.openEnrolEvent(this.eventContext, UpdateType.NEW_ENROLLMENT);
    }

    @EventHandler(name="HID_ACK_SLIP_PREVIEW", method="actionPerformed")
    public void onShowAckSlip(ILiteEvent event) {
        if (!this.enrollmentService.getAckSlip().isEmpty()) {
            ModalVisualExecutionContext veCtxt = new ModalVisualExecutionContext(null, false, new L10nDecorator(this.ctxt, false));
            try {
                Utils.showProgressBar((IVisualExecutionContext)veCtxt, "Acknowledgement Slip will be rendered, Please wait...");
                byte[] ackSlipImg = this.pdfToImageAckSlip(this.enrollmentService.getAckSlip());
                Utils.cancelProgressBar((IVisualExecutionContext)veCtxt);
                String scaffoldId = this.osd.compose(event.getScaffoldId(), "displayImageWin", "displayImageView");
                ((IViewElement)this.osd.getView(this.osd.getScaffold(scaffoldId).getViewId()).getElementMap().get("eID_display_image_preview")).set("image", (Object)ackSlipImg).set("displayMode", (Object)DisplayMode.AUTO_FIT);
                this.osd.display(scaffoldId, ScaffoldPlacement.CENTERED);
            }
            catch (IOException e) {
                Utils.cancelProgressBar((IVisualExecutionContext)veCtxt);
                String msg = "Error occurred while parsing ack slip";
                LOGGER.error(msg, (Throwable)e);
                TelemetryService.getTelemetryServiceInstance().postLogData((Exception)e, ErrorCodes.UC_GEN_143.getErrorCode(), new String[0]);
                L10nOptionPaneBuilder.getInstance().showError((Object)msg, (Component)this.osd.getWindowForScaffold(event.getScaffoldId()), new Object[0]);
            }
        }
    }

    @EventHandler(name="HID_ACK_SLIP_PANEL_DISPLAY", method="actionPerformed")
    public void showAckSlipPanel(ILiteEvent evt) {
        this.osd.display(this.osd.compose("ouCloseViewWin", "ouCloseViewPeer"), ScaffoldPlacement.CENTERED);
    }

    private void closeWin(String scaffoldId, String viewId) {
        this.osd.dispose(scaffoldId);
        this.osd.disposeView(viewId);
    }

    private byte[] pdfToImageAckSlip(String pdf) throws IOException {
        byte[] pdfBytes = this.enrollmentService.getAckSlipBytes();
        PDDocument document = PDDocument.load((byte[])pdfBytes);
        PDFRenderer pdfRenderer = new PDFRenderer(document);
        BufferedImage bufferedImage = pdfRenderer.renderImageWithDPI(0, 300.0f, ImageType.RGB);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "png", baos);
        byte[] image = baos.toByteArray();
        document.close();
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(name="validate_pac_uc", method="actionPerformed")
    public void validatePac(ILiteEvent event) {
        IVisualExecutionContext veCtxt = this.osd.getView(event.getViewId()).getVisualExecutionContext();
        if (veCtxt != null) {
            veCtxt.reset();
            veCtxt.setMessage("Validating Pac code.Please wait.");
        }
        try {
            if (this.paymentAuthService.makePacValidateUC()) {
                LOGGER.info("Pac code validate successfully");
                PacViewPeer.verify.setEnabled(false);
                PacViewPeer.textField.setEnabled(false);
                L10nOptionPaneBuilder.getInstance().showInfoUC((Object)"Pac code validate successfully");
            } else {
                LOGGER.error(ErrorCodes.UC_PAC_002.getReason());
                TelemetryService.getTelemetryServiceInstance().postLogData(new Exception(ErrorCodes.UC_PAC_002.getReason()), ErrorCodes.UC_PAC_002.name(), new String[0]);
                L10nOptionPaneBuilder.getInstance().showErrorUC(ErrorCodes.UC_PAC_002.getReason(), (Component)this.osd.getWindowForScaffold(event.getScaffoldId()), ErrorCodes.UC_PAC_002.name(), this.enrollmentService.getTransactionId(), new Object[0]);
            }
        }
        catch (PaymentAuthException e) {
            if (veCtxt != null) {
                veCtxt.cancel();
            }
            LOGGER.error(e.getExceptionType().toString() + " : " + e.getMessage());
            TelemetryService.getTelemetryServiceInstance().postLogData((Exception)((Object)e), ErrorCodes.UC_PAC_002.name(), new String[0]);
            L10nOptionPaneBuilder.getInstance().showErrorUC(ErrorCodes.UC_PAC_002.getReason() + " : " + e.getExceptionType().toString(), (Component)this.osd.getWindowForScaffold(event.getScaffoldId()), ErrorCodes.UC_PAC_002.name(), this.enrollmentService.getTransactionId(), new Object[0]);
        }
        finally {
            if (veCtxt != null) {
                veCtxt.cancel();
            }
        }
    }
}

