/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.onlineupdate.close;

import com.google.protobuf.ByteString;
import in.gov.uidai.ec.escapi.ScannerInfo;
import in.gov.uidai.ec.escapi.StationInfoStoreException;
import in.gov.uidai.ec.grpc.GrpcService;
import in.gov.uidai.ec.icas.preference.IOucDataStore;
import in.gov.uidai.ec.icas.scan.ScanMode;
import in.gov.uidai.ec.oauthapi.OnlineGatewayException;
import in.gov.uidai.ec.oauthapi.exception.ErrorCodes;
import in.gov.uidai.ec.oauthapi.json.UosResponse;
import in.gov.uidai.ec.print.impl.SimplePrint;
import in.gov.uidai.ec.protobuf.UcDemographicServiceProto;
import in.gov.uidai.ec.protobuf.UcDocumentServiceProto;
import in.gov.uidai.ec.service.document.DocumentType;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.document.DocumentsManager;
import in.gov.uidai.ec.telemetry.TelemetryMetrics;
import in.gov.uidai.ec.telemetry.TelemetryService;
import in.gov.uidai.ec.ui.ControllerBase;
import in.gov.uidai.ec.ui.enrol.document.DocumentUtils;
import in.gov.uidai.ec.ui.enrol.universalClient.common.CommonUtilsUC;
import in.gov.uidai.ec.ui.onlineupdate.close.OnlineUpdateCloseViewPeer;
import in.gov.uidai.ec.ui.onlineupdate.close.PacViewPeer;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysAction;
import in.gov.uidai.ec.ui.utils.ThreadPool;
import in.gov.uidai.swing.ImageIconCache;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineUpdateCloseController
extends ControllerBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(OnlineUpdateCloseController.class);
    private static final String OK_ICON_PATH = "res/ecmp/images/compliance-ok.png";
    private static final String ERROR_ICON_PATH = "res/ecmp/images/compliance-error.png";
    private static final String DOC_ATTACH_TIP = "Document attached";
    private static final String DOC_NOT_ATTACH_TIP = "Document not attached";
    private final EnrollmentService enrollmentService;
    private final OnlineUpdateCloseViewPeer view;
    private final SimplePrint simplePrint;
    private final IOucDataStore oucDataStore;
    private final ActionListener complete;
    private JButton done;
    GrpcService grpcService = GrpcService.getInst();

    public OnlineUpdateCloseController(OnlineUpdateCloseViewPeer view, EnrollmentService enrollmentService, SimplePrint simplePrint, IOucDataStore oucDataStore) {
        super(view.getView());
        this.enrollmentService = enrollmentService;
        this.view = view;
        this.simplePrint = simplePrint;
        this.oucDataStore = oucDataStore;
        this.addHandlers();
        enrollmentService.getDocManager().setCurrentOperatingDocType(DocumentType.SIGNED_ACK_SLIP);
        ThreadPool.commonPool().submit(this::fetchAckSlip);
        view.onlineSplip.previewButton.addActionListener(e -> this.fetchAckSlip());
        this.complete = (ActionListener)view.evtCtxt.getEventListener("test_trnx2", ActionListener.class);
        this.done = new JButton();
        this.done.addActionListener(this.complete);
    }

    private void addHandlers() {
        this.addActionListener(this.view.onlineSplip.printButton, (ActionEvent e) -> this.printAckSlip());
        this.addActionListener(this.view.onlineSplip.signedPanel.uploadButton, (ActionEvent e) -> this.attachAckSlip(e, true));
        this.addActionListener(this.view.onlineSplip.signedPanel.scanButton, (ActionEvent e) -> this.showAckSlipPanel());
        this.addActionListener(this.view.onlineSplip.enrolPanel.uploadButton, (ActionEvent e) -> this.attachAckSlip(e, false));
        this.addActionListener(this.view.onlineSplip.enrolPanel.scanButton, (ActionEvent e) -> this.showAckSlipPanel());
        this.addActionListener(this.view.onlineSplip.submitButton, (ActionEvent e) -> ThreadPool.commonPool().submit(this::uploadSignedDocuments));
        this.addActionListener(this.view.onlineSplip.signedPanel.scanButton, (ActionEvent e) -> this.scanDocument(e, DocumentType.SIGNED_ACK_SLIP));
        this.addActionListener(this.view.onlineSplip.enrolPanel.scanButton, (ActionEvent e) -> this.scanDocument(e, DocumentType.ENROL_FORM));
        this.addActionListener(this.view.scanAckSlipPanel.backButton, (ActionEvent e) -> this.showMainPanel());
        PacViewPeer cfr_ignored_0 = this.view.onlineSplip.pacViewPeer;
        this.addActionListener(PacViewPeer.verify, this::verifyPac);
        this.enrollmentService.getDocManager().addChangeListener(this::docObtained);
        this.enrollmentService.addOnDocSuccessListener(this::scanSuccess);
    }

    private void verifyPac(ActionEvent event) {
        if (this.enrollmentService.isPACValidationRequired() && this.enrollmentService.isUpdateUC() && !this.view.onlineSplip.pacViewPeer.getPacTextField().getText().isEmpty()) {
            this.enrollmentService.getPacDetail().setPacCode(this.view.onlineSplip.pacViewPeer.getPacTextField().getText());
            ((ActionListener)this.view.evtCtxt.getEventListener("validate_pac_uc", ActionListener.class)).actionPerformed(event);
        } else {
            TelemetryService.getTelemetryServiceInstance().postLogData(new Exception(), ErrorCodes.UC_PAC_001.name(), new String[0]);
            this.showErrorUC(this.view.getContentPane(), ErrorCodes.UC_PAC_001.getReason(), ErrorCodes.UC_PAC_001.name(), this.enrollmentService.getOauthGwApiService().getTransactionId(), new Object[0]);
        }
    }

    private void showAckSlipPanel() {
        CardLayout layout = (CardLayout)this.view.rootPanel.getLayout();
        layout.show(this.view.rootPanel, "SCAN_PANEL");
    }

    private void showMainPanel() {
        CardLayout layout = (CardLayout)this.view.rootPanel.getLayout();
        layout.show(this.view.rootPanel, "MAIN_PANEL");
    }

    private void printAckSlip() {
        LOGGER.info("Printing acknowledgement slip");
        try {
            byte[] pdfBytes = this.enrollmentService.getAckSlipBytes();
            if (this.simplePrint.print(pdfBytes)) {
                this.view.scanAckSlipButton.setEnabled(true);
                this.view.attachAckSlipButton.setEnabled(true);
                this.view.onlineSplip.signedPanel.statusLabel.setVisible(true);
                this.view.onlineSplip.signedPanel.statusLabel.setIcon(ImageIconCache.getInst().getIcon(ERROR_ICON_PATH));
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("Exception occurred while printing ack slip", (Throwable)e);
            this.showError(this.view.getContentPane(), "Couldn't print acknowledgment slip");
        }
    }

    private void attachAckSlip(ActionEvent evt, boolean isSlipUpload) {
        String msg;
        DocumentsManager docMan = this.enrollmentService.getDocManager();
        this.enrollmentService.getDocManager().setPreviewType(LabelKeysAction.UPLOAD.toString());
        if (isSlipUpload) {
            docMan.setCurrentOperatingDocType(DocumentType.SIGNED_ACK_SLIP);
        } else {
            docMan.setCurrentOperatingDocType(DocumentType.ENROL_FORM);
        }
        this.enrollmentService.getDocManager().setPreviewSaveButtonListener(this::onDocScanSaveForAckSlipAndEnrolForm);
        try {
            File file = DocumentUtils.getInstance().selectPdfFileFromBrowser(this.view.getContentPane());
            if (file != null) {
                docMan.setDocumentBytes(file);
                String error = docMan.getAttachedDoc().getError();
                if (StringUtils.isNotBlank((String)error)) {
                    throw new IllegalStateException(error);
                }
                this.setStatusIcon(docMan.getCurrentDocumentTypeForUploadOrVerify());
                if (isSlipUpload) {
                    this.view.onlineSplip.enrolPanel.setEnable(true);
                    this.view.onlineSplip.enrolPanel.statusLabel.setVisible(true);
                    this.view.onlineSplip.enrolPanel.statusLabel.setIcon(ImageIconCache.getInst().getIcon(ERROR_ICON_PATH));
                } else {
                    this.view.onlineSplip.submitButton.setEnabled(true);
                }
            }
        }
        catch (IOException e) {
            docMan.resetDocument();
            msg = "Error occurred while reading attached document";
            LOGGER.error(msg, (Throwable)e);
            this.showSimpleError(this.view.getContentPane(), msg, new Object[0]);
        }
        catch (IllegalStateException e) {
            docMan.resetDocument();
            msg = "Failed to attach document: " + e.getMessage();
            LOGGER.error(msg, (Throwable)e);
            this.showSimpleError(this.view.getContentPane(), msg, new Object[0]);
        }
        catch (Exception e) {
            docMan.resetDocument();
            msg = "Failed to attach document";
            LOGGER.error(msg, (Throwable)e);
            this.showSimpleError(this.view.getContentPane(), msg, new Object[0]);
        }
        try {
            BufferedImage bufferedImage = this.enrollmentService.getDocManager().getAttachedDoc().getBufferedImage();
            this.enrollmentService.getDocManager().addNextDocument(bufferedImage, "BLACK");
        }
        catch (OutOfMemoryError e) {
            this.clearDocument(isSlipUpload ? DocumentType.SIGNED_ACK_SLIP : DocumentType.ENROL_FORM);
            LOGGER.error("System error - out of memory", (Throwable)e);
            L10nOptionPaneBuilder.getInstance().showSimpleErrorUC((Object)"Unable to display the document (System error - out of memory)", (Component)evt.getSource(), new Object[0]);
            return;
        }
        catch (Throwable e) {
            this.clearDocument(isSlipUpload ? DocumentType.SIGNED_ACK_SLIP : DocumentType.ENROL_FORM);
            throw new RuntimeException("Failed to capture image");
        }
        this.view.showPreviewListener.actionPerformed(evt);
        this.showMainPanel();
    }

    private void scanDocument(ActionEvent evt, DocumentType docType) {
        this.enrollmentService.getDocManager().setPreviewType(LabelKeysAction.UPLOAD.toString());
        this.enrollmentService.getDocManager().setcurrentOperatingDocTypeForVerification(docType);
        this.enrollmentService.getDocManager().setPreviewSaveButtonListener(this::onDocScanSaveForAckSlipAndEnrolForm);
        this.view.showProgressBar("Scanning in progress, Please wait");
        ThreadPool.commonPool().submit(() -> {
            try {
                this.handleDocumentScanning(evt, docType);
            }
            catch (OnlineGatewayException e) {
                this.handleScanningException((Exception)((Object)e), evt, docType);
            }
            catch (OutOfMemoryError e) {
                this.handleOutOfMemoryError(e, evt, docType);
            }
            catch (StationInfoStoreException | IOException e) {
                this.handleScannerInfoError((Exception)e, evt, docType);
            }
            finally {
                this.view.cancelProgressBar();
            }
            this.showMainPanel();
        });
    }

    private boolean isScannerAndDocumentValid() throws StationInfoStoreException, IOException {
        ScannerInfo scannerInfo = this.oucDataStore.getScannerInfo();
        if (StringUtils.isBlank((String)scannerInfo.getLastScanner()) || "select".equalsIgnoreCase(scannerInfo.getLastScanner())) {
            this.showSimpleError(this.view.getContentPane(), "Scanner name selection is mandatory", new Object[0]);
            this.view.cancelProgressBar();
            return false;
        }
        return true;
    }

    private void handleScanningException(Exception e, ActionEvent evt, DocumentType docType) {
        this.clearDocument(docType);
        this.enrollmentService.getDocManager().resetDocument();
        this.showErrorUC((JButton)evt.getSource(), ErrorCodes.UC_GEN_008.getReason(), ErrorCodes.UC_GEN_008.getErrorCode(), this.enrollmentService.getTransactionId(), new Object[0]);
        TelemetryService.getTelemetryServiceInstance().postLogData(e, ErrorCodes.UC_GEN_008.getErrorCode(), new String[0]);
        LOGGER.error("Error while Scanning document.", (Throwable)e);
    }

    private void handleOutOfMemoryError(OutOfMemoryError e, ActionEvent evt, DocumentType docType) {
        this.clearDocument(docType);
        LOGGER.error("*********************Out of memory*************************");
        this.showErrorUC((JButton)evt.getSource(), ErrorCodes.UC_GEN_006.getReason(), ErrorCodes.UC_GEN_006.getErrorCode(), this.enrollmentService.getTransactionId(), new Object[0]);
        TelemetryService.getTelemetryServiceInstance().postLogData(new Exception(ErrorCodes.UC_GEN_006.getReason()), ErrorCodes.UC_GEN_006.getErrorCode(), new String[0]);
    }

    private void handleScannerInfoError(Exception e, ActionEvent evt, DocumentType docType) {
        this.clearDocument(docType);
        LOGGER.error("Scanner is not found");
        this.showErrorUC((JButton)evt.getSource(), ErrorCodes.UC_GEN_009.getReason(), ErrorCodes.UC_GEN_009.getErrorCode(), this.enrollmentService.getTransactionId(), new Object[0]);
        TelemetryService.getTelemetryServiceInstance().postLogData(new Exception(ErrorCodes.UC_GEN_009.getReason()), ErrorCodes.UC_GEN_009.getErrorCode(), new String[0]);
    }

    private void handleDocumentScanning(ActionEvent evt, DocumentType docType) throws OnlineGatewayException, StationInfoStoreException, IOException {
        this.setStatusIcon(docType);
        if (!this.isScannerAndDocumentValid()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.enrollmentService.getDocManager().setCurrentOperatingDocType(docType);
        BufferedImage bufferedImage = DocumentUtils.getInstance().acquireImage(ScanMode.COLOR, null, this.enrollmentService);
        if (bufferedImage == null) {
            LOGGER.error(ErrorCodes.UC_GEN_008.getReason());
            throw OnlineGatewayException.getClientExceptionFromEnum((ErrorCodes)ErrorCodes.UC_GEN_008, (String)this.enrollmentService.getTransactionId(), (Exception)new Exception(ErrorCodes.UC_GEN_008.getReason()));
        }
        this.enrollmentService.getDocManager().addNextDocument(bufferedImage, this.oucDataStore.getScannerInfo().getLastMode());
        long responseTime = System.currentTimeMillis() - startTime;
        LOGGER.info("Time taken to scan in UC Reference Screen: " + responseTime);
        TelemetryService.getTelemetryServiceInstance().postMetricsData("UC-ScanTime", TelemetryMetrics.SCAN_TIME, responseTime, new String[0]);
        this.view.showPreviewListener.actionPerformed(evt);
        this.view.cancelProgressBar();
    }

    private void fetchAckSlip() {
        if (this.enrollmentService.getAckSlipBytes() == null || this.enrollmentService.getAckSlipBytes().length == 0) {
            this.view.showProgressBar("Obtaining Acknowledgement slip");
            GrpcService grpcService = GrpcService.getInst();
            UcDemographicServiceProto.AcknowledgementSlipRequest ackSlipRequest = UcDemographicServiceProto.AcknowledgementSlipRequest.newBuilder().setSid(this.enrollmentService.getSid()).build();
            CountDownLatch ackSlipFetchCompleted = new CountDownLatch(1);
            grpcService.getAckSlip(ackSlipRequest, ackSlipResponse -> {
                LOGGER.info("Get Acknowledgement Slip Call Successful !");
                String ackSlip = ackSlipResponse.getAckSlip().toStringUtf8();
                this.enrollmentService.setAckSlip(ackSlip);
                this.enrollmentService.setAckSlipBytes(ackSlipResponse.getAckSlip().toByteArray());
                ackSlipFetchCompleted.countDown();
                this.view.cancelProgressBar();
            }, errorResponse -> {
                LOGGER.info(CommonUtilsUC.getErrorMessage(errorResponse), errorResponse);
                this.view.cancelProgressBar();
                ackSlipFetchCompleted.countDown();
                this.view.cancelProgressBar();
                this.showErrorUC(this.view.getContentPane(), CommonUtilsUC.getErrorMessage(errorResponse), errorResponse.getErrorCode(), this.enrollmentService.getOauthGwApiService().getTransactionId(), new Object[0]);
            });
            try {
                ackSlipFetchCompleted.await(25L, TimeUnit.SECONDS);
                this.view.cancelProgressBar();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (!this.enrollmentService.getAckSlip().isEmpty()) {
            SwingUtilities.invokeLater(() -> this.view.onlineSplip.signedPanel.setEnable(true));
        }
    }

    private void docObtained(DocumentsManager docMan) {
        byte[] slipDocumentBytes = docMan.getDocumentBytes(DocumentType.SIGNED_ACK_SLIP);
        byte[] enrolFormDocumentBytes = docMan.getDocumentBytes(DocumentType.ENROL_FORM);
        if (slipDocumentBytes != null && enrolFormDocumentBytes != null) {
            this.setStatusIcon(this.enrollmentService.getDocManager().getCurrentDocumentTypeForUploadOrVerify());
            this.view.onlineSplip.submitButton.setEnabled(true);
        } else if (slipDocumentBytes != null) {
            this.setStatusIcon(this.enrollmentService.getDocManager().getCurrentDocumentTypeForUploadOrVerify());
            this.view.onlineSplip.enrolPanel.setEnable(true);
            this.view.onlineSplip.enrolPanel.statusLabel.setVisible(true);
            this.view.onlineSplip.enrolPanel.statusLabel.setIcon(ImageIconCache.getInst().getIcon(ERROR_ICON_PATH));
        } else {
            this.view.onlineSplip.submitButton.setEnabled(false);
        }
    }

    private void uploadSignedDocuments() {
        this.view.showProgressBar("Uploading Documents");
        ThreadPool.commonPool().submit(() -> {
            try {
                if (this.enrollmentService.isPACValidationRequired() && this.enrollmentService.isUpdateUC() && !this.enrollmentService.getPacDetail().isPacSuccess()) {
                    this.view.cancelProgressBar();
                    TelemetryService.getTelemetryServiceInstance().postLogData(new Exception(), ErrorCodes.UC_PAC_001.name(), new String[0]);
                    this.showErrorUC(this.view.getContentPane(), ErrorCodes.UC_PAC_001.getReason(), ErrorCodes.UC_PAC_001.name(), this.enrollmentService.getOauthGwApiService().getTransactionId(), new Object[0]);
                    return;
                }
                this.grpcService.genericDocSave(this.createSaveGenericDocumentRequest(), successResponse -> this.handleGenericSuccessResponse(), this::handleException);
            }
            catch (OnlineGatewayException e) {
                String msg = " signed ack slip | Enrolment Form";
                LOGGER.error(msg, (Throwable)e);
                this.view.cancelProgressBar();
                this.showErrorUC(this.view.getContentPane(), e.getDisplayMessage(), e.getErrorCode(), this.enrollmentService.getOauthGwApiService().getTransactionId(), new Object[0]);
            }
        });
    }

    private void handleGenericSuccessResponse() {
        SwingUtilities.invokeLater(() -> {
            this.view.cancelProgressBar();
            if (this.enrollmentService.isNewEnrollmentUC()) {
                LOGGER.info("Enrolment request accepted for sid :: " + this.enrollmentService.getSid());
                L10nOptionPaneBuilder.getInstance().showInfoUC((Object)("Enrolment request accepted for sid :: " + this.enrollmentService.getSid()));
            } else {
                LOGGER.info("Online update request accepted for sid :: " + this.enrollmentService.getSid());
                L10nOptionPaneBuilder.getInstance().showInfoUC((Object)("Online update request accepted for sid :: " + this.enrollmentService.getSid()));
            }
            this.enrollmentService.setSid("");
            ActionEvent jButtonEvent = new ActionEvent(this.view.dummyCompleteEnrolButton, 1001, "Anything", System.currentTimeMillis(), 0);
            for (ActionListener actionListener : this.view.dummyCompleteEnrolButton.getActionListeners()) {
                actionListener.actionPerformed(jButtonEvent);
            }
            this.enrollmentService.getOauthGwApiService().clearTransactionId();
            this.view.consentTokenManager.invalidate();
            this.view.supervisorTokenManager.invalidate();
            this.grpcService.removeConsentToken();
            this.enrollmentService.clearMemory();
            this.enrollmentService.setGrievanceId(null);
            this.enrollmentService.setLinkedEid(null);
            this.enrollmentService.getBiometricsException().getExceptionDetail().reset();
            this.done.doClick();
        });
    }

    private void handleException(UosResponse errorResponse) {
        this.view.cancelProgressBar();
        LOGGER.error(CommonUtilsUC.getErrorMessage(errorResponse));
        String msg = " signed ack slip | Enrolment Form";
        TelemetryService.getTelemetryServiceInstance().postLogData(new Exception(CommonUtilsUC.getErrorMessage(errorResponse)), errorResponse.getErrorCode(), new String[0]);
        this.showErrorUC(this.view.getContentPane(), CommonUtilsUC.getErrorMessage(errorResponse), errorResponse.getErrorCode(), this.enrollmentService.getOauthGwApiService().getTransactionId(), new Object[0]);
    }

    private UcDocumentServiceProto.DocumentGenericRequest createSaveGenericDocumentRequest() {
        int i;
        ArrayList<UcDocumentServiceProto.GenericDocument> genericDocuments = new ArrayList<UcDocumentServiceProto.GenericDocument>();
        ArrayList<byte[]> pagesList = new ArrayList<byte[]>();
        for (i = 0; i < this.enrollmentService.getDocManager().getScannedDoc(DocumentType.SIGNED_ACK_SLIP).getTotalScannedPages(); ++i) {
            pagesList.add(this.enrollmentService.getDocManager().getScannedDoc(DocumentType.SIGNED_ACK_SLIP).getConvertedBytes(i));
        }
        genericDocuments.add(this.buildGenericDocument(pagesList, "AckSlip"));
        pagesList.clear();
        for (i = 0; i < this.enrollmentService.getDocManager().getScannedDoc(DocumentType.ENROL_FORM).getTotalScannedPages(); ++i) {
            pagesList.add(this.enrollmentService.getDocManager().getScannedDoc(DocumentType.ENROL_FORM).getConvertedBytes(i));
        }
        genericDocuments.add(this.buildGenericDocument(pagesList, "EnrolForm"));
        pagesList.clear();
        return UcDocumentServiceProto.DocumentGenericRequest.newBuilder().setRequestId(this.enrollmentService.getTransactionId()).setDocumentGenericHeader(this.buildDocumentGenericHeader()).addAllGenericDocuments(genericDocuments).build();
    }

    private UcDocumentServiceProto.GenericDocument buildGenericDocument(List<byte[]> pages, String documentName) {
        List<UcDocumentServiceProto.Page> pageList = this.convertPages(pages);
        return UcDocumentServiceProto.GenericDocument.newBuilder().addAllDocumentPages(pageList).setDocumentName(documentName).setMimeType("application/jp2000").build();
    }

    private UcDocumentServiceProto.DocumentGenericHeader buildDocumentGenericHeader() {
        return UcDocumentServiceProto.DocumentGenericHeader.newBuilder().setSid(this.enrollmentService.getSid()).setRefId(this.enrollmentService.getRefId()).build();
    }

    private void setStatusIcon(DocumentType docType) {
        String iconPath = this.enrollmentService.getDocManager().getDocumentBytes(docType) != null ? OK_ICON_PATH : ERROR_ICON_PATH;
        String tooltip = this.enrollmentService.getDocManager().getDocumentBytes(docType) != null ? DOC_ATTACH_TIP : DOC_NOT_ATTACH_TIP;
        this.setStatusIcon(docType, iconPath, tooltip);
    }

    private void scanSuccess() {
        this.setStatusIcon(this.enrollmentService.getDocManager().getCurrentDocumentTypeForUploadOrVerify());
        if (this.enrollmentService.getDocManager().getCurrentDocumentTypeForUploadOrVerify() == DocumentType.SIGNED_ACK_SLIP) {
            this.view.onlineSplip.enrolPanel.setEnable(true);
            this.view.onlineSplip.enrolPanel.statusLabel.setVisible(true);
            this.view.onlineSplip.enrolPanel.statusLabel.setIcon(ImageIconCache.getInst().getIcon(ERROR_ICON_PATH));
        } else {
            this.view.onlineSplip.submitButton.setEnabled(true);
        }
    }

    private void setStatusIcon(DocumentType docType, String iconPath, String tooltip) {
        JLabel docFieldLbl = null;
        switch (docType) {
            case SIGNED_ACK_SLIP: {
                docFieldLbl = this.view.onlineSplip.signedPanel.statusLabel;
                break;
            }
            case ENROL_FORM: {
                docFieldLbl = this.view.onlineSplip.enrolPanel.statusLabel;
            }
        }
        if (docFieldLbl != null) {
            docFieldLbl.setIcon(ImageIconCache.getInst().getIcon(iconPath));
            docFieldLbl.setToolTipText(tooltip);
        }
    }

    private void clearDocument(DocumentType docType) {
        if (this.enrollmentService.getDocManager().getDocumentBytes(docType) != null) {
            this.enrollmentService.getDocManager().resetDocument(docType);
        }
    }

    private List<UcDocumentServiceProto.Page> convertPages(List<byte[]> pageBytes) {
        ArrayList<UcDocumentServiceProto.Page> pages = new ArrayList<UcDocumentServiceProto.Page>();
        for (int i = 0; i < pageBytes.size(); ++i) {
            pages.add(UcDocumentServiceProto.Page.newBuilder().setData(ByteString.copyFrom((byte[])pageBytes.get(i))).setIndex(i + 1).build());
        }
        return pages;
    }

    public void onDocScanSaveForAckSlipAndEnrolForm(ActionEvent actionEvent) {
        this.view.showProgressBar("Saving the document. Please wait.");
        DocumentType docType = this.enrollmentService.getDocManager().getCurrentDocumentTypeForUploadOrVerify();
        SwingUtilities.getWindowAncestor((JButton)actionEvent.getSource()).setVisible(false);
        ThreadPool.commonPool().submit(() -> {
            this.enrollmentService.getDocManager().getScannedDoc().getLastScannedPage().finalizeDocument();
            try {
                this.enrollmentService.getDocManager().saveToJp2000();
                this.enrollmentService.getDocManager().setDocumentCompressAndSaved(docType);
                this.enrollmentService.fireDocUploadSuccess();
                this.view.cancelProgressBar();
                this.enrollmentService.getDocManager().validateDocs(docType);
            }
            catch (Exception e) {
                this.view.cancelProgressBar();
                LOGGER.error("Error while converting image to jp2000 format ", (Throwable)e);
                this.showSimpleError((JButton)actionEvent.getSource(), "Error while saving the document. " + e.getMessage(), new Object[0]);
            }
            finally {
                this.view.cancelProgressBar();
                SwingUtilities.getWindowAncestor((JButton)actionEvent.getSource()).dispose();
            }
        });
    }
}

