/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.onlineupdate.start;

import com.google.common.base.Strings;
import in.gov.uidai.ec.biometrics.device.IClientDeviceManager;
import in.gov.uidai.ec.ecmpapi.xml.genericotp.GenerateOtpResponse;
import in.gov.uidai.ec.escapi.StationInfoStoreException;
import in.gov.uidai.ec.grpc.GrpcService;
import in.gov.uidai.ec.icas.preference.IOucDataStore;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.icas.util.ApplicationVersion;
import in.gov.uidai.ec.oauthapi.OnlineGatewayException;
import in.gov.uidai.ec.oauthapi.exception.ErrorCodes;
import in.gov.uidai.ec.oauthapi.json.UosResponse;
import in.gov.uidai.ec.oauthapi.json.countapi.CountLimitData;
import in.gov.uidai.ec.oauthapi.json.countapi.UpdateCountResponse;
import in.gov.uidai.ec.oauthapi.json.srnapi.AgeGroup;
import in.gov.uidai.ec.oauthapi.json.srnapi.RequestSubType;
import in.gov.uidai.ec.oauthapi.json.srnapi.RequestType;
import in.gov.uidai.ec.oauthapi.json.srnapi.ResidentType;
import in.gov.uidai.ec.oauthapi.token.TokenManager;
import in.gov.uidai.ec.protobuf.UcDemographicServiceProto;
import in.gov.uidai.ec.protobuf.UosProto;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.BiometricsExceptionDetail;
import in.gov.uidai.ec.service.enrollment.model.Email;
import in.gov.uidai.ec.service.enrollment.model.FieldsUpdateCount;
import in.gov.uidai.ec.service.enrollment.model.Mobile;
import in.gov.uidai.ec.service.enrollment.model.ResidentInfo;
import in.gov.uidai.ec.service.gps.GeoData;
import in.gov.uidai.ec.service.isd.ISD;
import in.gov.uidai.ec.service.pincode.IPinCodeService;
import in.gov.uidai.ec.service.registration.IRegistrationService;
import in.gov.uidai.ec.service.universalClient.uiHandler.FieldInfoUtils;
import in.gov.uidai.ec.telemetry.TelemetryService;
import in.gov.uidai.ec.ui.biologin.LogoutResponse;
import in.gov.uidai.ec.ui.enrol.operator.TransactionType;
import in.gov.uidai.ec.ui.enrol.resident.IResidentLoginConstants;
import in.gov.uidai.ec.ui.enrol.universalClient.common.CommonUtilsUC;
import in.gov.uidai.ec.ui.main.UnsavedTracker;
import in.gov.uidai.ec.ui.oponlinelogin.IOperatorOnlineLoginConstants;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysMainWin;
import in.gov.uidai.ec.ui.utils.ThreadPool;
import in.gov.uidai.ec.ui.utils.Utils;
import in.gov.uidai.litef.beans.ModalVisualExecutionContext;
import in.gov.uidai.litef.devapi.EventHandler;
import in.gov.uidai.litef.devapi.GenericEventHandler;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.devapi.IEventContextAware;
import in.gov.uidai.litef.devapi.ILiteEvent;
import in.gov.uidai.litef.devapi.ILiteScaffold;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.litef.devapi.IOnScreenDisplay;
import in.gov.uidai.litef.devapi.IOnScreenDisplayAware;
import in.gov.uidai.litef.devapi.IViewElement;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.litef.devapi.ScaffoldPlacement;
import in.gov.uidai.swing.l10n.L10nDecorator;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineUpdateStartControl
implements IOnScreenDisplayAware,
IEventContextAware,
IOperatorOnlineLoginConstants,
IResidentLoginConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(OnlineUpdateStartControl.class);
    private EnrollmentService enrollmentService;
    private IClientDeviceManager cdm;
    private IResourceBundleContext enrolRbCtxt;
    private UnsavedTracker tracker;
    private IOnScreenDisplay osd;
    private IEventContext evtCtxt;
    private ILiteEvent mainEvent;
    private IPinCodeService pinCodeService;
    private IOucDataStore oucDataStore;
    private TransactionType transactionType;
    private TokenManager opTokenManager;
    private TokenManager consentTokenManager;
    private TokenManager hofConsentTokenManager;
    private TokenManager supTokenManager;
    private IRegistrationService registrationService;
    private boolean firstLogin;
    private boolean showTransactionPage;
    private boolean operatorLogout;
    private ActionEvent dummyActionEvent;
    GrpcService grpcService = GrpcService.getInst();
    ResidentInfo residentInfo;

    public void setClientDeviceManager(IClientDeviceManager cdm) {
        this.cdm = cdm;
    }

    @EventHandler(name="operatorTransactionType", method="actionPerformed")
    public void displayTransactionWin(ILiteEvent evt) {
        this.mainEvent = evt;
        this.showTransactionPage = true;
        this.dummyActionEvent = new ActionEvent(evt.getEvent().getSource(), 1, "actionPerformed");
        if (!this.opTokenManager.isValid()) {
            LOGGER.info("Operator not logged in");
            L10nOptionPaneBuilder.getInstance().showWarningUC((Object)"Operator needs to be logged in for online update", (Component)evt.getEvent().getSource());
            return;
        }
        if (this.enrollmentService.getSid() != null && !this.enrollmentService.getSid().isEmpty()) {
            this.cancelDemo(evt);
        }
        this.enrollmentService.initiateUcEnrollment(this.enrollmentService.isPACValidationRequired());
        if (this.enrollmentService.getSid() != null) {
            this.enrollmentService.setSid("");
        }
        String sId = this.osd.compose("mainWin", "blankView");
        ILiteScaffold scaffold = this.osd.getScaffold(sId);
        ((IViewElement)scaffold.getElementMap().get("hID_MainWin_Header")).set("text", (Object)LabelKeysMainWin.TRNX_TYPE);
        this.osd.recompose(sId, "transactionTypeView");
    }

    @GenericEventHandler(value="get_event")
    public void getMainEvent(ILiteEvent evt) {
        this.mainEvent = evt;
    }

    @EventHandler(name="transaction_selected", method="actionPerformed")
    public void transactionSelected(ILiteEvent evt) {
        this.mainEvent = evt;
        this.residentInfo = (ResidentInfo)evt.getExtraParameters().get("residentInfo");
        this.transactionType = (TransactionType)((Object)evt.getExtraParameters().get("transactionType"));
        this.enrollmentService.getOauthGwApiService().clearTransactionId();
        if (this.consentTokenManager.getBioAuthToken() != null && !this.consentTokenManager.getBioAuthToken().isEmpty() && !this.consentTokenManager.isValid()) {
            this.consentTokenManager.invalidate();
        }
        if (Strings.isNullOrEmpty((String)this.enrollmentService.getSid())) {
            this.onSelectOnlineNewEnrolment(null);
        } else if (this.residentInfo.isHofBased() && !this.consentTokenManager.isValid()) {
            this.consentInitialise(null);
            this.displayConsent(null);
        } else if (this.residentInfo.isHofBased() && this.consentTokenManager.isValid()) {
            this.afterConsent(null);
        } else {
            this.obtainSid(null);
        }
    }

    @GenericEventHandler(value="hID_Online_Enrol")
    public void initAppointmentEnrol(ILiteEvent evt) {
        this.enrollmentService.getDemoContactDetails().getMobile().setIsdCode(this.enrollmentService.getIsdService().getDefaultSelect().getISDCode());
        this.onSelectOnlineNewEnrolment(evt);
    }

    @EventHandler(name="hID_Online_Enrol", method="actionPerformed")
    public void onSelectOnlineNewEnrolment(ILiteEvent evt) {
        this.enrollmentService.clearMemory();
        boolean isProd = this.cdm.getRegisteredDeviceManager().getRdManagerPreference().getRegisteredDeviceEnvironment().equalsIgnoreCase("P");
        if (isProd && !CommonUtilsUC.isGpsValid(this.oucDataStore)) {
            TelemetryService.getTelemetryServiceInstance().postLogData(new Exception(ErrorCodes.UC_GEN_011.getReason()), ErrorCodes.UC_GEN_011.getErrorCode(), new String[0]);
            LOGGER.error(ErrorCodes.UC_GEN_011.getReason());
            L10nOptionPaneBuilder.getInstance().showErrorUC(ErrorCodes.UC_GEN_011.getReason(), null, ErrorCodes.UC_GEN_011.getErrorCode(), this.enrollmentService.getTransactionId(), new Object[0]);
            return;
        }
        this.grpcService.setGrpcConfigUOS(this.enrollmentService.getOauthGwApiService().getGatewayPreference().getGrpcServicesUrl());
        this.grpcService.setTokenManager(this.opTokenManager);
        this.enrollmentService.setForeignResident(this.residentInfo.isForeignResident());
        boolean isLinkedEidPresent = !Strings.isNullOrEmpty((String)this.enrollmentService.getLinkedEid());
        String grievanceId = isLinkedEidPresent ? this.enrollmentService.getGrievanceId() : null;
        BiometricsExceptionDetail bioxDetail = this.enrollmentService.getBiometricsException().getExceptionDetail();
        if (Strings.isNullOrEmpty((String)this.enrollmentService.getSid()) && this.enrollmentService.getAppointmentId() == null) {
            this.enrollmentService.initiateUcEnrollment(this.enrollmentService.isPACValidationRequired());
        }
        if (!Strings.isNullOrEmpty((String)this.residentInfo.getHofUid()) && this.residentInfo.isHofBased()) {
            this.enrollmentService.setHofUid(this.residentInfo.getHofUid());
            this.enrollmentService.setHofEnrollment(true);
            FieldInfoUtils.setIsHofEnrollment((boolean)true);
        } else {
            FieldInfoUtils.setIsHofEnrollment((boolean)false);
        }
        this.enrollmentService.setGrievanceId(grievanceId);
        this.enrollmentService.getBiometricsException().setExceptionDetail(bioxDetail);
        this.enrollmentService.setDocumentBasedEnrollment(this.residentInfo.isDocumentBased());
        this.enrollmentService.setChildEnrollment(this.transactionType.equals((Object)TransactionType.CHILD_ENROL_BELOW_5));
        this.enrollmentService.setMinorEnrollment(this.transactionType.equals((Object)TransactionType.CHILD_ENROL_ABOVE_5));
        this.enrollmentService.setBiometricUpdate(!this.transactionType.equals((Object)TransactionType.CHILD_ENROL_BELOW_5));
        this.enrollmentService.setForeignResident(this.residentInfo.isForeignResident());
        this.enrollmentService.setIsNRIEnrolment(this.residentInfo.isNriResident());
        if (!Strings.isNullOrEmpty((String)this.residentInfo.getMobile()) && this.enrollmentService.getSid().isEmpty()) {
            this.enrollmentService.getDemographics().getContact().getMobile().setNumber(this.residentInfo.getMobile());
            this.enrollmentService.getDemoContactDetails().getMobile().setIsdCode(this.residentInfo.getIsd());
        }
        if (!Strings.isNullOrEmpty((String)this.residentInfo.getEmail()) && this.enrollmentService.getSid().isEmpty()) {
            this.enrollmentService.getDemographics().getContact().getEmail().setEmail(this.residentInfo.getEmail());
        }
        if (this.residentInfo.isForeignResident()) {
            if (!this.verifyLocalLanguage()) {
                return;
            }
            this.enrollmentService.setEnrollmentLocale("06");
        }
        this.enrollmentService.setNriHaveForeignAddress(this.residentInfo.isForeignAddress());
        this.enrollmentService.setPobRequired(this.residentInfo.isPobPresent());
        this.enrollmentService.getDemoPersonalDetails().getAgeDob().setDobSelected(this.residentInfo.isPobPresent());
        this.enrollmentService.getDemoPersonalDetails().getConfirmDob().setDobSelected(this.residentInfo.isPobPresent());
        this.enrollmentService.getDemographics().getOtherDetail().setRelationType(this.residentInfo.getResidentType());
        if (this.enrollmentService.isHofEnrollment() && !this.consentTokenManager.isValid()) {
            this.consentInitialise(evt);
        }
        this.obtainSid(evt);
        this.opTokenManager.setUniversalClientTransaction(this.enrollmentService.isUniversalClientTrnx());
    }

    @EventHandler(name="test_trnx", method="actionPerformed")
    public void testTranx(ILiteEvent evt) {
        if (this.firstLogin) {
            return;
        }
        this.firstLogin = true;
        this.showTransactionPage = true;
        this.operatorLogout = false;
        this.enrollmentService.initiateUcEnrollment(this.enrollmentService.isPACValidationRequired());
        String sId = this.osd.compose("mainWin", "blankView");
        ILiteScaffold scaffold = this.osd.getScaffold(sId);
        ((IViewElement)scaffold.getElementMap().get("hID_MainWin_Header")).set("text", (Object)LabelKeysMainWin.TRNX_TYPE);
        this.osd.recompose(sId, "transactionTypeView");
    }

    @EventHandler(name="test_trnx2", method="actionPerformed")
    public void testTranx2(ILiteEvent evt) {
        this.closeWinImpl(evt);
        this.firstLogin = false;
        this.testTranx(evt);
    }

    @EventHandler(name="mode_select", method="actionPerformed")
    public void showModeSelectionPage(ILiteEvent evt) {
        this.firstLogin = false;
        this.showTransactionPage = false;
        this.operatorLogout = false;
        if (!this.enrollmentService.isEnrolmentStateNull() && this.enrollmentService.getSid() != null && !this.enrollmentService.getSid().isEmpty()) {
            this.cancelDemo(evt);
        }
        String scaffoldId = this.osd.compose("mainWin", "modeSelectionViewPeer");
        ILiteScaffold scaffold = this.osd.getScaffold(scaffoldId);
        ((IViewElement)scaffold.getElementMap().get("hID_MainWin_Header")).set("text", (Object)LabelKeysMainWin.LIFECYCLE_MODE_SELECTION);
        this.osd.display(scaffoldId, ScaffoldPlacement.CENTERED);
    }

    @EventHandler(name="scanner_select", method="actionPerformed")
    public void scannerConfig(ILiteEvent evt) {
        String sid = this.osd.compose("scannerPopupWin", "scannerConfigViewPeer");
        ILiteScaffold scaffold = this.osd.getScaffold(sid);
        this.osd.display(sid, ScaffoldPlacement.CENTERED);
    }

    @EventHandler(name="operator_logout", method="actionPerformed")
    public void operatorLogout(ILiteEvent evt) {
        this.showTransactionPage = false;
        this.operatorLogout = true;
        if (!Strings.isNullOrEmpty((String)this.enrollmentService.getSid())) {
            this.cancelDemo(evt);
        } else if (!this.tracker.selectEnrolUC(evt)) {
            return;
        }
        if (this.opTokenManager.getAccessToken() != null && !this.opTokenManager.getAccessToken().isEmpty()) {
            Window parent = this.osd.getWindowForScaffold(evt.getScaffoldId());
            try {
                LogoutResponse response = this.enrollmentService.operatorLogout();
                if (!response.getStatus().equalsIgnoreCase("Success")) {
                    LOGGER.error("Operator logout failed");
                    L10nOptionPaneBuilder.getInstance().showErrorUC(response.getMessage(), (Component)parent, ErrorCodes.UC_NET_002.getErrorCode(), this.enrollmentService.getOauthGwApiService().getTransactionId(), new Object[0]);
                } else {
                    this.enrollmentService.getOauthGwApiService().clearTransactionId();
                    this.grpcService.removeConsentToken();
                    this.enrollmentService.clearOperatorDetails();
                    this.opTokenManager.invalidate();
                    this.enrollmentService.setPACValidationRequired(false);
                    this.enrollmentService.clearMemory();
                    this.enrollmentService.clearEnrollmentState();
                    String msg = "Operator logged out successfully";
                    LOGGER.info(msg);
                    L10nOptionPaneBuilder.getInstance().showInfoUC((Object)msg);
                    this.showModeSelectionPage(evt);
                }
            }
            catch (OnlineGatewayException e) {
                LOGGER.error("Error While Operator logout", (Throwable)e);
                L10nOptionPaneBuilder.getInstance().showErrorUC(e.getMessage(), (Component)parent, e.getErrorCode(), this.enrollmentService.getOauthGwApiService().getTransactionId(), new Object[0]);
                TelemetryService.getTelemetryServiceInstance().postLogData((Exception)((Object)e), e.getErrorCode(), new String[0]);
            }
        }
    }

    @EventHandler(name="residentMobileVerifyButton", method="actionPerformed")
    public void residentMobileVerifyButton(ILiteEvent evt) {
        ILiteView view = this.osd.getView(evt.getViewId());
        Window parent = this.osd.getWindowForScaffold(evt.getScaffoldId());
        IVisualExecutionContext veCtxt = view.getVisualExecutionContext();
        boolean isEnrolment = this.enrollmentService.isNewEnrollmentUC();
        IViewElement isdEntered = (IViewElement)view.getElementMap().get("check_sid");
        String isdEntered1 = ((ISD)isdEntered.get("selectedItem")).getISDCode();
        IViewElement mobileEntered = (IViewElement)view.getElementMap().get(isEnrolment ? "enrolResMobile" : "resMobile");
        String mobile = (String)mobileEntered.get("text");
        if (mobile.length() == 0) {
            LOGGER.info("Mobile number is not entered");
            L10nOptionPaneBuilder.getInstance().showWarningUC((Object)"Mobile number is not entered. Please enter the mobile number. ", (Component)this.mainEvent.getEvent().getSource());
            return;
        }
        if (mobile.length() < 10) {
            LOGGER.info("Mobile length is less than 10 digit");
            L10nOptionPaneBuilder.getInstance().showWarningUC((Object)"Mobile length is less than 10 digit. Please enter correctly.", (Component)this.mainEvent.getEvent().getSource());
            return;
        }
        if (mobile.equals(this.enrollmentService.getDemoContactDetails().getMobile().getExistingNumber())) {
            LOGGER.info("Entered Same Mobile Number");
            L10nOptionPaneBuilder.getInstance().showWarningUC((Object)"Entered same mobile number. Please enter different mobile number.", (Component)this.mainEvent.getEvent().getSource());
            return;
        }
        if (!this.enrollmentService.getIsdService().getDefaultSelect().getISDCode().equalsIgnoreCase(isdEntered1)) {
            this.onSelectOnlineNewEnrolment(evt);
            return;
        }
        Utils.showProgressBar(veCtxt, "Generating OTP ... ");
        LOGGER.info("Making Generic OTP Request");
        try {
            GenerateOtpResponse otpResponse = this.enrollmentService.getOauthGwApiService().otpRequestSubmit(true, mobile);
            Utils.cancelProgressBar(veCtxt);
            LOGGER.info("Otp Request successfully completed");
            if (otpResponse.getResult().equalsIgnoreCase("Y")) {
                if (!isEnrolment) {
                    this.displayOtpWindow();
                } else {
                    this.onSelectOnlineNewEnrolment(evt);
                }
            } else {
                LOGGER.error(otpResponse.getMessage());
                L10nOptionPaneBuilder.getInstance().showErrorUC(otpResponse.getMessage(), (Component)parent, otpResponse.getErrorCode(), this.enrollmentService.getOauthGwApiService().getTransactionId(), new Object[0]);
            }
        }
        catch (OnlineGatewayException e) {
            Utils.cancelProgressBar(veCtxt);
            LOGGER.error("Error While Generating Otp", (Throwable)e);
            L10nOptionPaneBuilder.getInstance().showErrorUC(e.getMessage(), (Component)parent, e.getErrorCode(), this.enrollmentService.getOauthGwApiService().getTransactionId(), new Object[0]);
            TelemetryService.getTelemetryServiceInstance().postLogData((Exception)((Object)e), e.getErrorCode(), new String[0]);
        }
    }

    @EventHandler(name="displayConsent", method="actionPerformed")
    public void displayConsent(ILiteEvent evt) {
        String scaffoldId = this.osd.compose("operatorLoginWin", "consentLoginPreview");
        if (this.enrollmentService.isHofEnrollment() || !this.enrollmentService.isNewEnrollmentUC()) {
            this.osd.display(scaffoldId, ScaffoldPlacement.CENTERED);
        }
    }

    @EventHandler(name="showDvsQcResult", method="actionPerformed")
    public void showDvsQcResult(ILiteEvent evt) {
        String scaffoldId = this.osd.compose("showQCResultPopupWin", "qcViewPeer");
        this.osd.display(scaffoldId, ScaffoldPlacement.CENTERED);
    }

    @EventHandler(name="reasonCode", method="actionPerformed")
    public void displayReasonCodePopup(ILiteEvent evt) {
        String scaffoldId = this.osd.compose("reasonCodePopupWin", "reasonCodeViewPeer");
        this.osd.display(scaffoldId, ScaffoldPlacement.CENTERED);
    }

    @EventHandler(name="closeWin", method="actionPerformed")
    public void closeWinImpl(ILiteEvent evt) {
        try {
            if (this.osd != null) {
                this.osd.dispose(evt.getScaffoldId());
                this.osd.disposeView(evt.getViewId());
            } else {
                LOGGER.info("OSD is not initialized.");
            }
        }
        catch (Exception e) {
            LOGGER.error("Error closing window: " + e.getMessage());
        }
    }

    @EventHandler(name="cancelDemo", method="actionPerformed")
    public void cancelDemo(ILiteEvent event) {
        if (!this.operatorLogout && !this.tracker.selectEnrolUC(event)) {
            return;
        }
        LOGGER.info("Cancelling the transaction...");
        this.enrollmentService.setGrievanceId(null);
        this.enrollmentService.setLinkedEid(null);
        this.enrollmentService.getBiometricsException().getExceptionDetail().reset();
        UcDemographicServiceProto.CancelDemoRequest.Builder requestBuilder = UcDemographicServiceProto.CancelDemoRequest.newBuilder();
        requestBuilder.setSid(this.enrollmentService.getSid());
        UcDemographicServiceProto.CancelDemoRequest request = requestBuilder.build();
        String sid = this.enrollmentService.getSid();
        if (!Strings.isNullOrEmpty((String)sid)) {
            IVisualExecutionContext veCtxt = this.createVisualExecutionContext();
            Utils.showProgressBar(veCtxt, "Cancelling the transaction, please wait..");
            this.grpcService.cancelDemo(request, cancelDemoResponse -> {
                LOGGER.info("Transaction Canceled : " + sid);
                this.enrollmentService.setSid("");
                Utils.cancelProgressBar(veCtxt);
                L10nOptionPaneBuilder.getInstance().showInfoUC((Object)("The transaction is cancelled for the SID: " + sid));
                this.enrollmentService.getOauthGwApiService().clearTransactionId();
                this.consentTokenManager.invalidate();
                this.hofConsentTokenManager.invalidate();
                this.supTokenManager.invalidate();
                this.grpcService.removeConsentToken();
                this.enrollmentService.clearMemory();
                if (this.showTransactionPage) {
                    this.displayTransactionWin(event);
                }
            }, errorResponse -> {
                Utils.cancelProgressBar(veCtxt);
                LOGGER.info(CommonUtilsUC.getErrorMessage(errorResponse), errorResponse);
                L10nOptionPaneBuilder.getInstance().showErrorUC(CommonUtilsUC.getErrorMessage(errorResponse), (Component)((JComponent)event.getEvent().getSource()), errorResponse.getErrorCode(), this.enrollmentService.getOauthGwApiService().getTransactionId(), new Object[0]);
            });
        } else {
            this.displayTransactionWin(event);
        }
    }

    @EventHandler(name="showBioLoginPopup", method="ActionPerformed")
    public void showBioLoginPopup(ILiteEvent evt) {
        String scaffoldId = this.osd.compose("opBioLoginViewWin", "opBioLoginView");
        this.osd.display(scaffoldId, ScaffoldPlacement.CENTERED);
    }

    @EventHandler(name="showResBioLoginPopup", method="ActionPerformed")
    public void showResBioLoginPopup(ILiteEvent evt) {
        String scaffoldId = this.osd.compose("opBioLoginViewWin", "resBioLoginView");
        this.osd.display(scaffoldId, ScaffoldPlacement.CENTERED);
    }

    private void displayUIdWindow() {
        String scaffoldId = this.osd.compose("residentUidPopupWin", "residentUidPreview");
        this.osd.display(scaffoldId, ScaffoldPlacement.CENTERED);
    }

    private void displayOtpWindow() {
        String scaffoldId = this.osd.compose("verifyResidentMobilePopupWin", "otpViewPeer");
        this.osd.display(scaffoldId, ScaffoldPlacement.CENTERED);
    }

    private void countCall(ILiteEvent evt) throws OnlineGatewayException {
        Window parent = this.osd.getWindowForScaffold(evt.getScaffoldId());
        LOGGER.info("Making Update Count Request");
        UpdateCountResponse updateCountResponse = this.enrollmentService.getOauthGwApiService().getUpdateCountData(this.enrollmentService.getResidentUid());
        if (updateCountResponse.getStatus().equalsIgnoreCase("Success")) {
            LOGGER.info("Count Request successfully completed");
            this.updateCountDetailsInUpdateFlow(updateCountResponse);
        } else {
            LOGGER.error("Error : {}", (Object)CommonUtilsUC.getErrorMessage((UosResponse)updateCountResponse));
            L10nOptionPaneBuilder.getInstance().showErrorUC(CommonUtilsUC.getErrorMessage((UosResponse)updateCountResponse), (Component)parent, updateCountResponse.getErrorCode(), this.enrollmentService.getOauthGwApiService().getTransactionId(), new Object[0]);
        }
    }

    private void grpcCountCall(IVisualExecutionContext veCtxt) {
        LOGGER.info("Update Call Request Started");
        UcDemographicServiceProto.DemographicCountRequest countRequest = UcDemographicServiceProto.DemographicCountRequest.newBuilder().setUid(this.enrollmentService.getResidentUid()).build();
        this.grpcService.getUpdateCount(countRequest, response -> this.handleCountResponse((UcDemographicServiceProto.DemographicCountResponse)response, veCtxt), error -> this.handleErrorResponse((UosResponse)error, veCtxt));
    }

    private void updateCountDetailsInUpdateFlow(UpdateCountResponse updateCountResponse) {
        FieldsUpdateCount fieldsUpdateCount = this.enrollmentService.getFieldsUpdateCount();
        CountLimitData countLimitData = updateCountResponse.getCountLimitData();
        fieldsUpdateCount.setLanguage(countLimitData.getLanguage());
        fieldsUpdateCount.setName(countLimitData.getName());
        fieldsUpdateCount.setAddress(countLimitData.getAddress());
        fieldsUpdateCount.setDob(countLimitData.getDob());
        fieldsUpdateCount.setGender(countLimitData.getGender());
        fieldsUpdateCount.setMobile(countLimitData.getMobile());
        fieldsUpdateCount.setEmail(countLimitData.getEmail());
    }

    @EventHandler(name="sid_gen", method="ActionPerformed")
    public void obtainSid(ILiteEvent evt) {
        Mobile mobile = this.enrollmentService.getDemoContactDetails().getMobile();
        Email email = this.enrollmentService.getDemoContactDetails().getEmail();
        if (!(Strings.isNullOrEmpty((String)this.enrollmentService.getSid()) || email.isUpdated() || mobile.isUpdated())) {
            if (!this.enrollmentService.isNewEnrollmentUC() && !this.consentTokenManager.isValid()) {
                this.displayConsent(null);
            } else if (this.enrollmentService.isNewEnrollmentUC()) {
                this.evtCtxt.fireGenericEvent("hID_Enrol", new Object[]{this.mainEvent, false, this.enrollmentService.isUpdateUC(), true, false});
            }
        } else {
            this.obtainSId(evt);
        }
    }

    private void obtainSId(ILiteEvent evt) throws RuntimeException {
        IVisualExecutionContext veCtxt = this.createVisualExecutionContext();
        RequestType requestType = this.getRequestType();
        RequestSubType requestSubType = this.getRequestSubType();
        AgeGroup ageGroup = this.getAgeGroup();
        ResidentType residentType = this.getResidentType();
        Utils.showProgressBar(veCtxt, "Generating Sid");
        this.enrollmentService.getOauthGwApiService().clearTransactionId();
        this.grpcService.setTransactionId(this.enrollmentService.getOauthGwApiService().getTransactionId());
        this.handleNewEnrollment(evt, veCtxt, requestType, requestSubType, residentType, ageGroup);
    }

    private IVisualExecutionContext createVisualExecutionContext() {
        return new ModalVisualExecutionContext(null, false, new L10nDecorator(this.enrolRbCtxt, false));
    }

    private RequestType getRequestType() {
        return this.transactionType.getRequestType();
    }

    private RequestSubType getRequestSubType() {
        if (this.enrollmentService.isNewEnrollmentUC()) {
            return RequestSubType.DEMO_BIO;
        }
        if (!this.enrollmentService.isBiometricUpdate()) {
            return RequestSubType.DEMO;
        }
        if (!this.enrollmentService.isDemoUpdate()) {
            return RequestSubType.BIO;
        }
        return RequestSubType.DEMO_BIO;
    }

    private AgeGroup getAgeGroup() {
        return this.transactionType.getAgeGroup();
    }

    private ResidentType getResidentType() {
        if (this.enrollmentService.isForeignResident()) {
            return ResidentType.FOREIGN;
        }
        if (this.enrollmentService.isNRIEnrolment()) {
            return ResidentType.NRI;
        }
        return ResidentType.CITIZEN;
    }

    private void handleNewEnrollment(ILiteEvent evt, IVisualExecutionContext veCtxt, RequestType requestType, RequestSubType requestSubType, ResidentType residentType, AgeGroup ageGroup) {
        UcDemographicServiceProto.UpdateIndicator updateIndicatorGrpc = this.createUpdateIndicatorGrpc();
        UcDemographicServiceProto.EnrolMetadataAudit srnAudit = this.createAuditGrpc();
        UosProto.SrnRequest srnRequest = this.prepareSrnRequest(requestType, requestSubType, srnAudit, this.enrollmentService.getResidentUid(), updateIndicatorGrpc, residentType, ageGroup);
        AtomicBoolean srnCallSuccess = new AtomicBoolean(false);
        CountDownLatch srnCompleted = new CountDownLatch(1);
        this.grpcService.generateSrn(srnRequest, srnResponse -> this.handleSrnResponse((UcDemographicServiceProto.EnrolMetadataResponse)srnResponse, veCtxt, srnCompleted, evt), errorResponse -> {
            srnCompleted.countDown();
            this.handleErrorResponse((UosResponse)errorResponse, veCtxt);
        });
        this.waitForSrnCompletion(srnCompleted, srnCallSuccess, veCtxt);
    }

    private void handleCountResponse(UcDemographicServiceProto.DemographicCountResponse countResponse, IVisualExecutionContext veCtxt) {
        FieldsUpdateCount fieldsUpdateCount = this.enrollmentService.getFieldsUpdateCount();
        fieldsUpdateCount.setName(countResponse.getName());
        fieldsUpdateCount.setDob(countResponse.getDob());
        fieldsUpdateCount.setAddress(countResponse.getAddress());
        fieldsUpdateCount.setGender(countResponse.getGender());
        fieldsUpdateCount.setEmail(countResponse.getEmail());
        fieldsUpdateCount.setMobile(countResponse.getMobile());
        Utils.cancelProgressBar(veCtxt);
        this.enrollmentService.countScreenSuccess();
    }

    private void handleSrnResponse(UcDemographicServiceProto.EnrolMetadataResponse srnResponse, IVisualExecutionContext veCtxt, CountDownLatch srnCompleted, ILiteEvent evt) {
        this.enrollmentService.setSid(srnResponse.getSid());
        this.enrollmentService.setRefId(srnResponse.getRefId());
        LOGGER.info("Sid: " + srnResponse.getSid());
        TelemetryService.getTelemetryServiceInstance().setSid(this.enrollmentService.getSid());
        if (!this.residentInfo.getEmail().isEmpty()) {
            ThreadPool.commonPool().submit(() -> ((ActionListener)this.evtCtxt.getEventListener("email_resend_otp", ActionListener.class)).actionPerformed(this.dummyActionEvent));
        }
        if (!this.residentInfo.getMobile().isEmpty() && this.residentInfo.getIsd().contains("+91")) {
            ThreadPool.commonPool().submit(() -> ((ActionListener)this.evtCtxt.getEventListener("mobile_resend_otp", ActionListener.class)).actionPerformed(this.dummyActionEvent));
        }
        if (this.enrollmentService.isHofEnrollment() || this.enrollmentService.isUpdateUC()) {
            this.displayConsent(null);
        } else if (!this.enrollmentService.isHofEnrollment() && this.enrollmentService.isNewEnrollmentUC()) {
            this.evtCtxt.fireGenericEvent("hID_Enrol", new Object[]{this.mainEvent, false, this.enrollmentService.isUpdateUC(), true, false});
        }
        Utils.cancelProgressBar(veCtxt);
        srnCompleted.countDown();
    }

    private void handleErrorResponse(UosResponse errorResponse, IVisualExecutionContext veCtxt) {
        Utils.cancelProgressBar(veCtxt);
        LOGGER.error(CommonUtilsUC.getErrorMessage(errorResponse), (Object)errorResponse);
        L10nOptionPaneBuilder.getInstance().showErrorUC(CommonUtilsUC.getErrorMessage(errorResponse), null, errorResponse.getErrorCode(), this.enrollmentService.getOauthGwApiService().getTransactionId(), new Object[0]);
    }

    private void waitForSrnCompletion(CountDownLatch srnCompleted, AtomicBoolean srnCallSuccess, IVisualExecutionContext veCtxt) {
        try {
            boolean success = srnCompleted.await(25L, TimeUnit.SECONDS);
            Utils.cancelProgressBar(veCtxt);
            srnCallSuccess.set(success);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private UcDemographicServiceProto.UpdateIndicator createUpdateIndicatorGrpc() {
        UcDemographicServiceProto.UpdateIndicator.Builder updateIndicatorBuilder = UcDemographicServiceProto.UpdateIndicator.newBuilder();
        if (this.enrollmentService.isNewEnrollmentUC()) {
            updateIndicatorBuilder.setName(true).setAddress(this.enrollmentService.isDocumentBasedEnrollment()).setGender(true).setDob(this.enrollmentService.getIsPobRequired()).setLanguage(true).setMobile(!Strings.isNullOrEmpty((String)this.enrollmentService.getDemographics().getContact().getMobile().number())).setEmail(!Strings.isNullOrEmpty((String)this.enrollmentService.getDemoContactDetails().getEmail().email()));
        } else if (this.enrollmentService.isDemoUpdate()) {
            FieldsUpdateCount fieldsUpdateCount = this.enrollmentService.getFieldsUpdateCount();
            updateIndicatorBuilder.setName(fieldsUpdateCount.getName().hasToBeUpdated()).setAddress(fieldsUpdateCount.getAddress().hasToBeUpdated()).setGender(fieldsUpdateCount.getGender().hasToBeUpdated()).setDob(fieldsUpdateCount.getDob().hasToBeUpdated()).setLanguage(false).setMobile(fieldsUpdateCount.getMobile().hasToBeUpdated()).setEmail(fieldsUpdateCount.getEmail().hasToBeUpdated());
        }
        updateIndicatorBuilder.setBio(this.enrollmentService.isBiometricUpdate());
        updateIndicatorBuilder.setBioException(this.enrollmentService.getBiometricsException().getExceptionDetail().isBiometricExceptionApplied());
        updateIndicatorBuilder.setHof(this.enrollmentService.isHofEnrollment());
        updateIndicatorBuilder.setResidentForeigner(this.enrollmentService.isForeignResident());
        updateIndicatorBuilder.setNri(this.enrollmentService.isNRIEnrolment());
        return updateIndicatorBuilder.build();
    }

    private UosProto.SrnRequest prepareSrnRequest(RequestType requestType, RequestSubType requestSubType, UcDemographicServiceProto.EnrolMetadataAudit audit, String uid, UcDemographicServiceProto.UpdateIndicator updateIndicator, ResidentType residentType, AgeGroup ageGroup) {
        UosProto.SrnRequest.Builder builder = UosProto.SrnRequest.newBuilder().setAgeGroup(ageGroup.name()).setEnrolmentType(requestType.name()).setEnrolmentSubType(requestSubType.name()).setAudit(audit).setUpdateIndicator(updateIndicator).setResidentType(residentType.name());
        if (!Strings.isNullOrEmpty((String)this.enrollmentService.getGrievanceId())) {
            builder.setGrievanceId(this.enrollmentService.getGrievanceId());
        }
        if (!Strings.isNullOrEmpty((String)uid)) {
            builder.setUid(uid);
        }
        return builder.build();
    }

    private UcDemographicServiceProto.EnrolMetadataAudit createAuditGrpc() {
        UcDemographicServiceProto.EnrolMetadataAudit.Builder auditBuilder;
        try {
            auditBuilder = UcDemographicServiceProto.EnrolMetadataAudit.newBuilder().setOperatorId(this.enrollmentService.getOAuthSessionService().getOperatorDetails().getOperatorId()).setEnrolmentCentre(this.registrationService.getClientLocation()).setLongitude(GeoData.convertToDecimalDegrees((float)this.oucDataStore.getGpsInfo().getLongitude().floatValue())).setLatitude(GeoData.convertToDecimalDegrees((float)this.oucDataStore.getGpsInfo().getLatitude().floatValue())).setClientVersion(ApplicationVersion.FULLDISPLAYVERSION).setMachineCode(this.registrationService.getRegisteredMachineCode()).setAgencyCode(this.registrationService.getAgencyId()).setRegistrarId(this.registrationService.getRegistrarId()).setStationId(this.registrationService.getStationId());
        }
        catch (StationInfoStoreException | IOException e) {
            throw new RuntimeException(e);
        }
        if (this.enrollmentService.getHofUid() != null && this.enrollmentService.getHofUid().length() == 12) {
            auditBuilder.setHofUid(this.enrollmentService.getHofUid());
        }
        return auditBuilder.build();
    }

    @EventHandler(name="consent_init", method="ActionPerformed")
    public void consentInitialise(ILiteEvent evt) {
        this.enrollmentService.setConsentCountDownLatch(new CountDownLatch(1));
        ThreadPool.commonPool().submit(() -> {
            boolean isSuccess;
            try {
                isSuccess = this.enrollmentService.getConsentCountDownLatch().await(2L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                return;
            }
            if (isSuccess) {
                this.afterConsent(evt);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(name="consent_after", method="ActionPerformed")
    public void afterConsent(ILiteEvent evt) {
        this.grpcService.setConsentTokenManager(this.consentTokenManager);
        this.consentTokenManager.setUniversalClientTransaction(true);
        LOGGER.info("Consent Taken Successfully. Preparing other tabs");
        IVisualExecutionContext veCtxt = this.createVisualExecutionContext();
        try {
            if (!this.enrollmentService.isNewEnrollmentUC() || this.enrollmentService.isHofEnrollment()) {
                Utils.showProgressBar(veCtxt, "Making Profile Request");
                this.makeProfileFetch();
                Utils.cancelProgressBar(veCtxt);
            } else {
                this.evtCtxt.fireGenericEvent("hID_Enrol", new Object[]{this.mainEvent, false, this.enrollmentService.isUpdateUC(), true, false});
            }
        }
        catch (OnlineGatewayException e) {
            LOGGER.error("Error calling profile service", (Throwable)e);
            L10nOptionPaneBuilder.getInstance().showErrorUC("Error occurred while fetching profile data", null, ErrorCodes.UC_GEN_001.getErrorCode(), this.enrollmentService.getOauthGwApiService().getTransactionId(), new Object[0]);
        }
        catch (Exception e) {
            L10nOptionPaneBuilder.getInstance().showErrorUC("Error occurred while fetching profile data : " + e.getMessage(), null, ErrorCodes.UC_GEN_001.getErrorCode(), this.enrollmentService.getOauthGwApiService().getTransactionId(), new Object[0]);
        }
        finally {
            Utils.cancelProgressBar(veCtxt);
        }
    }

    private void makeProfileFetch() {
        LOGGER.info("Making Profile Request");
        String uid = Strings.isNullOrEmpty((String)this.enrollmentService.getResidentUid()) ? this.enrollmentService.getHofUid() : this.enrollmentService.getResidentUid();
        UcDemographicServiceProto.ProfileDataRequest profileDataRequest = UcDemographicServiceProto.ProfileDataRequest.newBuilder().setUid(uid).build();
        this.grpcService.getProfileData(profileDataRequest, this::handleProfileResponse, errorResponse -> this.handleErrorResponse((UosResponse)errorResponse, this.createVisualExecutionContext()));
    }

    private void handleProfileResponse(UcDemographicServiceProto.ProfileDataResponse profileDataResponse) {
        if (CommonUtilsUC.isAgeFiveOrLess(profileDataResponse.getDob())) {
            L10nOptionPaneBuilder.getInstance().showErrorUC(ErrorCodes.UC_GEN_012.getReason(), (Component)((JComponent)this.mainEvent.getEvent().getSource()), ErrorCodes.UC_GEN_012.getErrorCode(), this.enrollmentService.getOauthGwApiService().getTransactionId(), new Object[0]);
            OnlineGatewayException exception = new OnlineGatewayException(ErrorCodes.UC_GEN_012.getReason(), ErrorCodes.UC_GEN_012.getReason(), ErrorCodes.UC_GEN_012.getErrorCode());
            TelemetryService.getTelemetryServiceInstance().postLogData((Exception)((Object)exception), exception.getErrorCode(), new String[0]);
            return;
        }
        try {
            this.enrollmentService.updateDemographicsDataInEnrolment(profileDataResponse, this.pinCodeService);
            this.evtCtxt.fireGenericEvent("hID_Enrol", new Object[]{this.mainEvent, false, this.enrollmentService.isUpdateUC(), true, false});
        }
        catch (OnlineGatewayException e) {
            L10nOptionPaneBuilder.getInstance().showErrorUC(e.getDisplayMessage(), (Component)((JComponent)this.mainEvent.getEvent().getSource()), e.getErrorCode(), this.enrollmentService.getTransactionId(), new Object[0]);
            TelemetryService.getTelemetryServiceInstance().postLogData((Exception)((Object)e), e.getErrorCode(), new String[0]);
        }
    }

    public void setPinCodeService(IPinCodeService pinCodeService) {
        this.pinCodeService = pinCodeService;
    }

    public void setResourceBundleContext(IResourceBundleContext ctxt) {
        this.enrolRbCtxt = ctxt;
    }

    public void setOucDataStore(IOucDataStore oucDataStore) {
        this.oucDataStore = oucDataStore;
    }

    public void setConsentTokenManager(TokenManager consentTokenManager) {
        this.consentTokenManager = consentTokenManager;
    }

    public void setHofConsentTokenManager(TokenManager hofConsentTokenManager) {
        this.hofConsentTokenManager = hofConsentTokenManager;
    }

    public void setEnrollmentService(EnrollmentService enrollmentService) {
        this.enrollmentService = enrollmentService;
    }

    public void setTracker(UnsavedTracker tracker) {
        this.tracker = tracker;
    }

    public void setOpTokenManager(TokenManager opTokenManager) {
        this.opTokenManager = opTokenManager;
    }

    public void populateEventContext(IEventContext ctxt) {
        this.evtCtxt = ctxt;
    }

    public void populateOnScreenDisplay(IOnScreenDisplay osd) {
        this.osd = osd;
    }

    public void setRegistrationService(IRegistrationService registrationService) {
        this.registrationService = registrationService;
    }

    private boolean verifyLocalLanguage() {
        try {
            if (this.oucDataStore.getLocalisationInfo().getLocale().equalsIgnoreCase("en_in")) {
                L10nOptionPaneBuilder.getInstance().showWarningUC((Object)"Please select other than english as local language for Foreign Enrollment", null);
                return false;
            }
        }
        catch (StationInfoStoreException | IOException e) {
            TelemetryService.getTelemetryServiceInstance().postLogData((Exception)e, ErrorCodes.UC_GEN_001.getErrorCode(), new String[0]);
            return false;
        }
        return true;
    }

    public void setSupTokenManager(TokenManager supTokenManager) {
        this.supTokenManager = supTokenManager;
    }
}

