/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.operatordisclosure;

import in.gov.uidai.ec.ecmpapi.EcmpApiService;
import in.gov.uidai.ec.ecmpapi.xml.bioverify.xml.BioVerifyResponse;
import in.gov.uidai.ec.ecmpapi.xml.bioverify.xml.Result;
import in.gov.uidai.ec.ecmpapi.xml.disclosure.DisclosedPackets;
import in.gov.uidai.ec.ecmpapi.xml.disclosure.DisclosureResponse;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.operatordisclosure.DisclosedData;
import in.gov.uidai.ec.service.operatordisclosure.DisclosureInfoData;
import in.gov.uidai.ec.service.operatordisclosure.MissingEIDFile;
import in.gov.uidai.ec.service.operatordisclosure.OperatorDiscService;
import in.gov.uidai.ec.service.packet.IPacketService;
import in.gov.uidai.ec.service.packet.IPacketSummaryDAO;
import in.gov.uidai.ec.service.registration.IRegistrationService;
import in.gov.uidai.ec.service.session.ISessionService;
import in.gov.uidai.ec.ui.operatordisclosure.IDiscloseConstants;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysMainWin;
import in.gov.uidai.ec.ui.shared.l10n.MsgKeysOperatorDis;
import in.gov.uidai.ec.ui.shared.l10n.MsgKeysOperatorSync;
import in.gov.uidai.ec.ui.utils.StationRegistrationHelper;
import in.gov.uidai.litef.devapi.EventHandler;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.devapi.IEventContextAware;
import in.gov.uidai.litef.devapi.ILiteEvent;
import in.gov.uidai.litef.devapi.ILiteScaffold;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.litef.devapi.IOnScreenDisplay;
import in.gov.uidai.litef.devapi.IOnScreenDisplayAware;
import in.gov.uidai.litef.devapi.IViewElement;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.litef.devapi.ScaffoldPlacement;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import java.awt.Component;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.jutils.jprocesses.JProcesses;
import org.jutils.jprocesses.model.ProcessInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisclosureControl
implements IDiscloseConstants,
IOnScreenDisplayAware,
IEventContextAware {
    private IOnScreenDisplay osd;
    OperatorDiscService operatorDiscService;
    private ILiteScaffold mainWin;
    private static String detailsWinScaffoldId;
    private IResourceBundleContext rbCtxt;
    private IPacketService packetService;
    private IPacketSummaryDAO packetSummaryDAO;
    private ISessionService sessionService;
    private DisclosureInfoData disclosureInfoData;
    private IEventContext evtCtxt;
    private List<DisclosedPackets> disclosedPackets = new ArrayList<DisclosedPackets>();
    private IRegistrationService registrationService;
    private EcmpApiService ecmpApiService;
    public MissingEIDFile missingEIDFile;
    private static final Logger LOGGER;

    public void setRegistrationService(IRegistrationService registrationService) {
        this.registrationService = registrationService;
    }

    public void setEcmpApiService(EcmpApiService ecmpApiService) {
        this.ecmpApiService = ecmpApiService;
    }

    public void setPacketService(IPacketService packetService) {
        this.packetService = packetService;
    }

    public final void setPacketSummaryDAO(IPacketSummaryDAO packetSummaryDAO) {
        this.packetSummaryDAO = packetSummaryDAO;
    }

    public void setDisclosureInfoData(DisclosureInfoData disclosureInfoData) {
        this.disclosureInfoData = disclosureInfoData;
    }

    public void populateOnScreenDisplay(IOnScreenDisplay osd) {
        this.osd = osd;
    }

    @EventHandler(name="hID_OpDisclosure_Toolbut_sel", method="actionPerformed")
    public void onOpDiscloseSelect(ILiteEvent evt) {
        String scafId = this.osd.recompose(evt.getScaffoldId(), "opDisclosureView");
        ILiteScaffold scaffold = this.osd.getScaffold(scafId);
        ((IViewElement)scaffold.getElementMap().get("hID_MainWin_Header")).set("text", (Object)LabelKeysMainWin.PROCESS_OPDISCLOSURE);
        this.osd.display(scafId, ScaffoldPlacement.CENTERED);
        this.showPacketData(this.osd.getView(this.osd.getScaffold(evt.getScaffoldId()).getViewId()));
    }

    @EventHandler(name="hID_Op_BioCapture", method="actionPerformed")
    public void onDiscloseSelect(ILiteEvent evt) {
        ILiteView view = this.osd.getView(evt.getViewId());
        IVisualExecutionContext veCtxt = view.getVisualExecutionContext();
        try {
            String connectType = new String(Files.readAllBytes(Paths.get("./conf/connect.type", new String[0])));
            if (!connectType.equalsIgnoreCase(this.sessionService.getConnectTypeKey())) {
                throw new UnsupportedOperationException();
            }
            LOGGER.info("Connect type from DB ::: " + this.sessionService.getConnectTypeKey());
            LOGGER.info("Connect type from Local ::: " + connectType);
            String scafId = this.osd.compose(evt.getScaffoldId(), "operatorBioWin", "operatorBioView");
            this.osd.display(scafId, ScaffoldPlacement.CENTERED);
            LOGGER.info("About to start StationRegistrationHelper-DisclosureControl");
            StationRegistrationHelper.getInstance().updateStationRegistrationHelperInfo(this.ecmpApiService);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (UnsupportedOperationException e) {
            this.showErrorPopup(evt, veCtxt, this.rbCtxt.getMessage((Object)MsgKeysOperatorSync.CLIENT_VERIFICATION_ERROR, new Object[0]), "Client Type Mismatch Error");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(name="hID_Op_BioSubmit", method="actionPerformed")
    public void onBiometricsSubmit(ILiteEvent evt) {
        ILiteView view = this.osd.getView(evt.getViewId());
        IVisualExecutionContext veCtxt = view.getVisualExecutionContext();
        this.showProgressBar(veCtxt, "Verifying operator biometrics. Please wait.");
        try {
            BioVerifyResponse opAuthResponse = this.operatorDiscService.makeBioSubmitCall();
            if (opAuthResponse.getResult().equals((Object)Result.FAILURE)) {
                this.onBiometricsSubmit(evt, veCtxt, opAuthResponse);
            } else {
                DisclosureResponse disclosureResponse = this.operatorDiscService.makeDisclosureRequest(this.disclosedPackets);
                if (!"OK".equals(disclosureResponse.getMessage())) {
                    this.onDisclosureSubmit(evt, veCtxt, disclosureResponse);
                } else {
                    this.cancelProgressBar(veCtxt);
                    MsgKeysOperatorDis successMsgKey = MsgKeysOperatorDis.OPERATOR_DISCLOSURE_SUCCESSFUL;
                    L10nOptionPaneBuilder.getInstance().createInfoPane().message((Object)this.rbCtxt.getMessage((Object)successMsgKey, new Object[0]), new Object[0]).title("Operator Disclosure Successful").show((Component)this.osd.getWindowForScaffold(evt.getScaffoldId()));
                    this.osd.dispose(detailsWinScaffoldId);
                    this.operatorDiscService.saveDisclosureDataToLocal();
                    this.deleteExistingMissingEidsFile();
                    if (this.sessionService.isSessionValid()) {
                        this.evtCtxt.fireGenericEvent("showAfterDisclosureSuccess", new Object[0]);
                        this.evtCtxt.fireGenericEvent("postDiscloserEvent", new Object[0]);
                    } else {
                        this.evtCtxt.fireGenericEvent("showOpSyncWin", new Object[0]);
                    }
                    this.stopNonThirdPartyApp();
                }
            }
        }
        catch (IOException e) {
            this.showErrorPopup(evt, veCtxt, "Operator authentication failed due to network error. Please try again. " + e.getMessage(), "Network Error");
        }
        catch (Exception e) {
            this.showErrorPopup(evt, veCtxt, "Operator authentication failed due to server error. Please try again." + e.getMessage(), "Authentication Error");
        }
        finally {
            this.osd.dispose(evt.getScaffoldId());
        }
    }

    private void deleteExistingMissingEidsFile() throws IOException {
        this.missingEIDFile = new MissingEIDFile("./data/stationData.txt");
        if (this.missingEIDFile.exists()) {
            Files.delete(Paths.get("./data/stationData.txt", new String[0]));
            LOGGER.info("File deleted successfully");
        }
    }

    private void stopNonThirdPartyApp() {
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
        Runnable task = () -> {
            List processesList = JProcesses.getProcessList();
            Runtime runTime = Runtime.getRuntime();
            String str = "mstsc.exe,AnyDesk.exe,TeamViewer.exe";
            LOGGER.info("Process PID,Process Name,Process Used Time");
            try {
                for (ProcessInfo processInfo : processesList) {
                    if (processInfo.getName() == null || !str.contains(processInfo.getName())) continue;
                    LOGGER.info("System is running with non Recommended services. Stopped the process :: " + processInfo.getName());
                    runTime.exec("taskkill  /F /IM " + processInfo.getName());
                }
            }
            catch (Exception e) {
                LOGGER.info("Error while stopping the process : " + e);
            }
        };
        scheduledExecutorService.scheduleAtFixedRate(task, 2L, 2L, TimeUnit.MINUTES);
    }

    @EventHandler(name="hID_OpDisclosure_Popupbut_sel", method="actionPerformed")
    public void onOpDisclosurePopupSelect(ILiteEvent evt) {
        String scafId = this.osd.compose(evt.getScaffoldId(), "opDisclosurePopupWin", "opDisclosurePopupView");
        this.osd.display(scafId, ScaffoldPlacement.CENTERED);
    }

    @EventHandler(name="opDisclosurePopupOKButton", method="actionPerformed")
    public void opDisclosurePopupOKButton(ILiteEvent evt) {
        String sId = this.osd.compose("mainWin", "opDisclosureView");
        this.mainWin = this.osd.getScaffold(sId);
        this.osd.display(sId, ScaffoldPlacement.MAXIMIZED);
        Map elementMap = this.mainWin.getElementMap();
        ((IViewElement)elementMap.get("eID_OpDisclosure_Toolbut")).call("click");
    }

    private void onBiometricsSubmit(ILiteEvent evt, IVisualExecutionContext veCtxt, BioVerifyResponse opAuthResponse) {
        this.cancelProgressBar(veCtxt);
        String errorCode = StringUtils.isNotBlank((String)opAuthResponse.getErrorCode()) ? " due to " + opAuthResponse.getErrorCode() : "";
        String message = "Operator Auth failed" + errorCode + ". Please try again";
        String resultErrorMessage = opAuthResponse.getErrorMessage();
        String opAuthResponseErrorMessage = opAuthResponse.getErrorMessage();
        if (StringUtils.isNotBlank((String)resultErrorMessage)) {
            message = resultErrorMessage;
        }
        if (StringUtils.isNotBlank((String)opAuthResponseErrorMessage) && !opAuthResponseErrorMessage.equals(resultErrorMessage)) {
            message = opAuthResponseErrorMessage + " \n" + message;
        }
        LOGGER.error("Operator Auth Failed, " + message + ", " + opAuthResponse.getErrorCode() + ", ErrorCodeType: " + opAuthResponse.getErrorCodeType());
        L10nOptionPaneBuilder.getInstance().createErrorPane().message((Object)message, new Object[0]).title("Authentication Error").show((Component)this.osd.getWindowForScaffold(evt.getScaffoldId()));
    }

    private void onDisclosureSubmit(ILiteEvent evt, IVisualExecutionContext veCtxt, DisclosureResponse disclosureResponse) {
        this.cancelProgressBar(veCtxt);
        String errorMessage = " due to " + disclosureResponse.getMessage();
        String message = "Operator Disclosure failed" + errorMessage;
        LOGGER.error("Operator Disclosure Failed, " + message + ", " + disclosureResponse.getStatusCode());
        L10nOptionPaneBuilder.getInstance().createErrorPane().message((Object)message, new Object[0]).title("Disclosure Error").show((Component)this.osd.getWindowForScaffold(evt.getScaffoldId()));
    }

    private void showPacketData(ILiteView view) {
        try {
            List query_result = this.packetService.getUploadedPacketsCountByDate();
            ArrayList<DisclosedData> disclosedDataList = new ArrayList<DisclosedData>();
            if (query_result.size() == 0) {
                String operator_id = this.sessionService.getOperatorCredentials().getOperatorId();
                String startDateOfDisclosure = (String)this.disclosureInfoData.getDisclosedData().get(operator_id);
                DisclosedPackets disclosedPacket = new DisclosedPackets(startDateOfDisclosure, 0);
                this.disclosedPackets.add(disclosedPacket);
            } else {
                for (int i = 0; i < query_result.size(); ++i) {
                    Map data = (Map)query_result.get(i);
                    int totalNumberOfUploadedPackets = Integer.parseInt(String.valueOf(data.get("2")));
                    String startDateOfDisclosure = ((String)data.get("1")).substring(0, 4) + "-" + ((String)((Map)query_result.get(0)).get("1")).substring(4, 6) + "-" + ((String)((Map)query_result.get(0)).get("1")).substring(6, 8);
                    DisclosedPackets disclosedPacket = new DisclosedPackets(startDateOfDisclosure, totalNumberOfUploadedPackets);
                    this.disclosedPackets.add(disclosedPacket);
                    String date_format = ((String)data.get("1")).substring(0, 4) + "-" + ((String)data.get("1")).substring(4, 6) + "-" + ((String)data.get("1")).substring(6, 8);
                    disclosedDataList.add(new DisclosedData(i + 1, date_format, String.valueOf(data.get("2"))));
                }
            }
            Map eMap = view.getElementMap();
            ((IViewElement)eMap.get("eID_Disclosure_PktList")).set("value", disclosedDataList);
        }
        catch (Exception e) {
            LOGGER.error("error in show packet data ", (Throwable)e);
        }
    }

    private void showErrorPopup(ILiteEvent evt, IVisualExecutionContext veCtxt, String message, String title) {
        this.cancelProgressBar(veCtxt);
        L10nOptionPaneBuilder.getInstance().createErrorPane().message((Object)message, new Object[0]).title(title).show((Component)this.osd.getWindowForScaffold(evt.getScaffoldId()));
    }

    private void cancelProgressBar(IVisualExecutionContext veCtxt) {
        if (veCtxt != null) {
            veCtxt.cancel();
        }
    }

    private void showProgressBar(IVisualExecutionContext veCtxt, String s) {
        if (veCtxt != null) {
            veCtxt.reset();
            veCtxt.setMessage(s);
        }
    }

    public void setOperatorDiscService(OperatorDiscService operatorDiscService) {
        this.operatorDiscService = operatorDiscService;
    }

    public final void setResourceBundleContext(IResourceBundleContext rbCtxt) {
        this.rbCtxt = rbCtxt;
    }

    public void setSessionService(ISessionService sessionService) {
        this.sessionService = sessionService;
    }

    public void populateEventContext(IEventContext ctxt) {
        this.evtCtxt = ctxt;
    }

    static {
        LOGGER = LoggerFactory.getLogger(DisclosureControl.class);
    }
}

