/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.operatordisclosure;

import in.gov.uidai.ec.biometrics.device.DeviceType;
import in.gov.uidai.ec.biometrics.device.IClientDeviceManager;
import in.gov.uidai.ec.biometrics.device.impl.DeviceLifeCycleListener;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.biometricsauth.AuthParamType;
import in.gov.uidai.ec.service.biometricsauth.BiometricsAuthService;
import in.gov.uidai.ec.service.operatordisclosure.OperatorDiscService;
import in.gov.uidai.ec.service.opsync.OperatorSyncService;
import in.gov.uidai.ec.service.presync.IPreSyncPreference;
import in.gov.uidai.ec.service.session.ISessionService;
import in.gov.uidai.ec.ui.biometricsauth.BiometricsNonRDAuthController;
import in.gov.uidai.ec.ui.biometricsauth.BiometricsNonRDAuthPanel;
import in.gov.uidai.ec.ui.biometricsauth.BiometricsRDAuthController;
import in.gov.uidai.ec.ui.biometricsauth.BiometricsRDAuthPanel;
import in.gov.uidai.ec.ui.operatordisclosure.OperatorDisclosureController;
import in.gov.uidai.ec.ui.opsync.IOpSyncFormConstants;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysAction;
import in.gov.uidai.litef.beans.ModalVisualExecutionContext;
import in.gov.uidai.litef.beans.stdview.StandardViewPeer;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.swing.TransparentBox;
import in.gov.uidai.swing.l10n.L10nDecorator;
import in.gov.uidai.swing.table.TableLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JRadioButton;

public class OperatorDisclosureBioCaptureViewPeer
extends StandardViewPeer
implements IOpSyncFormConstants {
    protected JFormattedTextField otpField;
    protected JButton okBtn;
    protected JButton cancelBtn;
    protected JRadioButton fingerOption;
    protected JRadioButton irisOption;
    protected ButtonGroup btnGrp;
    protected IResourceBundleContext rbCtxt;
    protected ISessionService sessionService;
    protected BiometricsAuthService biometricsAuthService;
    private IUIPreference uiPref;
    private IPreSyncPreference preSyncPref;
    private IClientDeviceManager devMgr;
    private DeviceLifeCycleListener deviceLifeCycleListener;
    private OperatorSyncService operatorSyncService;
    private OperatorDiscService operatorDiscService;

    public void setBiometricsAuthService(BiometricsAuthService biometricsAuthService) {
        this.biometricsAuthService = biometricsAuthService;
    }

    public void setOperatorDiscService(OperatorDiscService operatorDiscService) {
        this.operatorDiscService = operatorDiscService;
    }

    public void setUIPreference(IUIPreference pref) {
        this.uiPref = pref;
    }

    public void setResourceBundleContext(IResourceBundleContext ctxt) {
        this.rbCtxt = ctxt;
    }

    public void setSessionService(ISessionService sessionService) {
        this.sessionService = sessionService;
    }

    public void setPreSyncPreference(IPreSyncPreference pref) {
        this.preSyncPref = pref;
    }

    public void setClientDeviceManager(IClientDeviceManager cdm) {
        this.devMgr = cdm;
    }

    public void setDeviceLifeCycleListener(DeviceLifeCycleListener deviceLifeCycleListener) {
        this.deviceLifeCycleListener = deviceLifeCycleListener;
    }

    public void setOperatorSyncService(OperatorSyncService operatorSyncService) {
        this.operatorSyncService = operatorSyncService;
    }

    protected void prepareImpl() {
        L10nDecorator ldeco = new L10nDecorator(this.rbCtxt, this.uiPref.getApplicationLocalize(false));
        this.fingerOption = new JRadioButton();
        this.fingerOption.setSelected(this.authTypeIsFinger() || this.authTypeIsBoth());
        this.fingerOption.setActionCommand(AuthParamType.FINGER.toString());
        this.fingerOption.setEnabled(this.authTypeIsFinger() || this.authTypeIsBoth());
        this.irisOption = new JRadioButton();
        this.irisOption.setSelected(this.authTypeIsIris());
        this.irisOption.setActionCommand(AuthParamType.IRIS.toString());
        this.irisOption.setEnabled(this.authTypeIsIris() || this.authTypeIsBoth());
        if (this.authTypeIsBoth()) {
            this.btnGrp = new ButtonGroup();
            this.btnGrp.add(this.fingerOption);
            this.btnGrp.add(this.irisOption);
        }
        this.okBtn = new JButton(this.rbCtxt.getMessage((Object)LabelKeysAction.OK, new Object[0]));
        ldeco.localize((AbstractButton)this.okBtn, (Object)"OK", new Object[0]);
        this.cancelBtn = new JButton(this.rbCtxt.getMessage((Object)LabelKeysAction.CANCEL, new Object[0]));
        ldeco.localize((AbstractButton)this.cancelBtn, (Object)"CANCEL", new Object[0]);
        AuthParamType authParamType = this.operatorDiscService.getAuthParamType();
        if (this.operatorDiscService.isrdDeviceSelected()) {
            this.createRdPane(ldeco, authParamType);
        } else {
            this.createNonRdPane(ldeco);
        }
        this.devMgr.refreshDeviceStates();
    }

    private void createNonRdPane(L10nDecorator ldeco) {
        BiometricsNonRDAuthPanel biometricsNonRDAuthPanel = new BiometricsNonRDAuthPanel(this.rbCtxt, this.uiPref, this.deviceLifeCycleListener, this.devMgr, this.preSyncPref, this.getEventContext());
        TransparentBox cntPane = this.getBiometricCapturePane(ldeco, biometricsNonRDAuthPanel, null, null);
        super.setContentPane((JComponent)cntPane);
        super.setVisualExecutionContext((IVisualExecutionContext)new ModalVisualExecutionContext((JComponent)cntPane, false, ldeco));
        biometricsNonRDAuthPanel.fingerAuthField.setEnabled(this.fingerOption.isSelected());
        biometricsNonRDAuthPanel.irisConfirmField.setEnabled(this.irisOption.isSelected());
        BiometricsNonRDAuthController biometricsNonRDAuthController = new BiometricsNonRDAuthController(this.getView(), biometricsNonRDAuthPanel, this.biometricsAuthService);
        biometricsNonRDAuthController.setEnableAuthentication(false);
        new OperatorDisclosureController(this, this.operatorDiscService, this.biometricsAuthService, biometricsNonRDAuthPanel, null, this.getEventContext());
    }

    private void createRdPane(L10nDecorator ldeco, AuthParamType authParamType) {
        BiometricsRDAuthPanel biometricsRDAuthPanel = new BiometricsRDAuthPanel(this.rbCtxt, this.uiPref, this.deviceLifeCycleListener, this.devMgr);
        TransparentBox cntPane = this.getBiometricCapturePane(ldeco, null, biometricsRDAuthPanel, authParamType);
        super.setContentPane((JComponent)cntPane);
        super.setVisualExecutionContext((IVisualExecutionContext)new ModalVisualExecutionContext((JComponent)cntPane, false, ldeco));
        biometricsRDAuthPanel.getRDBioField(authParamType, DeviceType.FINGERPRINT_AUTH).setEnabled(this.fingerOption.isSelected());
        biometricsRDAuthPanel.getRDBioField(authParamType, DeviceType.IRIS_AUTH).setEnabled(this.irisOption.isSelected());
        new BiometricsRDAuthController(this.getView(), biometricsRDAuthPanel, this.biometricsAuthService);
        new OperatorDisclosureController(this, this.operatorDiscService, this.biometricsAuthService, null, biometricsRDAuthPanel, this.getEventContext());
    }

    private TransparentBox getBiometricCapturePane(L10nDecorator ldeco, BiometricsNonRDAuthPanel biometricsNonRDAuthPanel, BiometricsRDAuthPanel biometricsRDAuthPanel, AuthParamType authParamType) {
        boolean rdPane = biometricsRDAuthPanel != null && authParamType != null && biometricsNonRDAuthPanel == null;
        double[] columns = new double[]{5.0, 5.0, 15.0, 10.0, 75.0, 30.0, 5.0, 5.0, 20.0, 75.0, 30.0, 20.0, 5.0};
        double[][] guides = new double[][]{columns, {5.0, 25.0, 5.0, 5.0, 25.0, 120.0, 10.0, 10.0, 15.0, 10.0, 5.0}};
        boolean isOnboarded = this.sessionService.getOperatorCredentials().isOnboard();
        if (isOnboarded) {
            guides = new double[][]{columns, {5.0, 25.0, 5.0, 5.0, 25.0, 120.0, 10.0, 30.0, 25.0, 15.0, 10.0, 5.0}};
        }
        TransparentBox cntPane = new TransparentBox((LayoutManager)new TableLayout((double[][])guides));
        JLabel biometricsReqLabel = rdPane ? new JLabel("Please provide your biometrics with RD devices") : new JLabel("Please provide your biometrics");
        biometricsReqLabel.setFont(new Font(biometricsReqLabel.getFont().getName(), 1, 12));
        cntPane.add((Component)biometricsReqLabel, (Object)"0,3,11,4,c,c");
        cntPane.add((Component)this.fingerOption, (Object)"1,5,2,6,f,f");
        cntPane.add((Component)(rdPane ? biometricsRDAuthPanel.createOpSyncFingerArea(authParamType) : biometricsNonRDAuthPanel.createNonRDFingerArea()), (Object)"4, 5, 5, 6, f, f");
        cntPane.add((Component)this.irisOption, (Object)"7,5,8,6,f,f");
        cntPane.add((Component)(rdPane ? biometricsRDAuthPanel.createOpSyncIrisArea(authParamType) : biometricsNonRDAuthPanel.createNonRDIrisArea()), (Object)"9, 5, 10, 6, f, f");
        if (isOnboarded) {
            JLabel declarationMsg = new JLabel("<html>After clicking on OK, you will be able to authenticate.</html>");
            cntPane.add((Component)declarationMsg, (Object)"1, 7, 11, 8, c, c");
        }
        cntPane.add((Component)this.okBtn, (Object)(isOnboarded ? "2, 9, 5, 10, f, f" : "3, 8, 5, 9, f, f"));
        cntPane.add((Component)this.cancelBtn, (Object)(isOnboarded ? "8, 9, 10, 10, f, f" : "9, 8, 11, 9, f, f"));
        return cntPane;
    }

    protected void enableImpl(boolean flag) {
    }

    protected void disposeImpl() {
    }

    protected boolean authTypeIsFinger() {
        String authType = this.preSyncPref.getFingerIrisAuthType("finger");
        return authType != null && authType.equalsIgnoreCase(AuthParamType.FINGER.toString());
    }

    protected boolean authTypeIsIris() {
        String authType = this.preSyncPref.getFingerIrisAuthType("finger");
        return authType != null && authType.equalsIgnoreCase(AuthParamType.IRIS.toString());
    }

    protected boolean authTypeIsBoth() {
        String authType = this.preSyncPref.getFingerIrisAuthType("finger");
        return authType != null && authType.equalsIgnoreCase(AuthParamType.BOTH.toString());
    }
}

