/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.operatordisclosure;

import in.gov.uidai.ec.biometrics.device.DeviceType;
import in.gov.uidai.ec.service.biometricsauth.AuthParamType;
import in.gov.uidai.ec.service.biometricsauth.BiometricsAuthService;
import in.gov.uidai.ec.service.operatordisclosure.OperatorDiscService;
import in.gov.uidai.ec.ui.ControllerBase;
import in.gov.uidai.ec.ui.biometricsauth.BiometricsNonRDAuthPanel;
import in.gov.uidai.ec.ui.biometricsauth.BiometricsRDAuthPanel;
import in.gov.uidai.ec.ui.operatordisclosure.OperatorDisclosureBioCaptureViewPeer;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.swing.bio.confirm.BiometricsNonRDField;
import in.gov.uidai.swing.bio.confirm.BiometricsRDField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatorDisclosureController
extends ControllerBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperatorDisclosureController.class);
    private OperatorDisclosureBioCaptureViewPeer viewPeer;
    private BiometricsRDAuthPanel biometricsRDAuthPanel;
    private BiometricsNonRDAuthPanel biometricsNonRDAuthPanel;
    private BiometricsAuthService biometricsAuthService;
    private OperatorDiscService operatorDiscService;
    private IVisualExecutionContext veCtxt;
    private boolean useRDDevices;
    private AuthParamType authParamType;
    private boolean isBioCaptureValid;

    public OperatorDisclosureController(OperatorDisclosureBioCaptureViewPeer viewPeer, OperatorDiscService operatorDiscService, BiometricsAuthService biometricsAuthService, BiometricsNonRDAuthPanel biometricsNonRDAuthPanel, BiometricsRDAuthPanel biometricsRDAuthPanel, IEventContext eventContext) {
        super(viewPeer.getView());
        this.viewPeer = viewPeer;
        this.biometricsRDAuthPanel = biometricsRDAuthPanel;
        this.biometricsAuthService = biometricsAuthService;
        this.biometricsNonRDAuthPanel = biometricsNonRDAuthPanel;
        this.operatorDiscService = operatorDiscService;
        this.viewPeer.fingerOption.addItemListener(this::bioTypeOptionSelected);
        this.viewPeer.irisOption.addItemListener(this::bioTypeOptionSelected);
        this.viewPeer.okBtn.addActionListener((ActionListener)eventContext.getEventListener("hID_Op_BioSubmit", ActionListener.class));
        this.viewPeer.cancelBtn.addActionListener(this::onCancel);
        this.viewPeer.okBtn.setEnabled(false);
        this.authParamType = this.operatorDiscService.getAuthParamType();
        boolean bl = this.useRDDevices = biometricsRDAuthPanel != null && biometricsNonRDAuthPanel == null;
        if (this.useRDDevices) {
            this.initViewForRD();
        } else {
            this.initViewForNonRD();
        }
        this.toggleBioCaptureState();
        this.validate();
    }

    private void onCancel(ActionEvent evt) {
        if (this.biometricsAuthService.getSingleFingerAuth().getCaptureAttempt() != null) {
            this.biometricsAuthService.getSingleFingerAuth().getCaptureAttempt().delete();
        }
        if (this.biometricsAuthService.getLeftIrisAuth().getCaptureAttempt() != null) {
            this.biometricsAuthService.getLeftIrisAuth().getCaptureAttempt().delete();
        }
        if (this.biometricsAuthService.getRdAuthBiometrics() != null) {
            this.biometricsAuthService.getRdAuthBiometrics().clearAll();
        }
        SwingUtilities.getWindowAncestor((JButton)evt.getSource()).setVisible(false);
    }

    private void initViewForRD() {
        BiometricsRDField rdFingerAuthField = this.biometricsRDAuthPanel.getRDBioField(this.authParamType, DeviceType.FINGERPRINT_AUTH);
        BiometricsRDField rdIrisAuthField = this.biometricsRDAuthPanel.getRDBioField(this.authParamType, DeviceType.IRIS_AUTH);
        this.biometricsAuthService.getRdAuthBiometrics().addValidityChangeListener(this::onRDBioAuthValidityChange);
        this.operatorDiscService.setFingerAndIrisStatus(rdFingerAuthField.isEnabled(), rdIrisAuthField.isEnabled());
    }

    private void initViewForNonRD() {
        BiometricsNonRDField fingerAuthField = this.biometricsNonRDAuthPanel.fingerAuthField;
        BiometricsNonRDField irisConfirmField = this.biometricsNonRDAuthPanel.irisConfirmField;
        this.biometricsAuthService.getSingleFingerAuth().addValidityChangeListener(this::onNonRDFingerAuthValidityChange);
        this.biometricsAuthService.getLeftIrisAuth().addValidityChangeListener(this::onNonRDIrisAuthValidityChange);
        this.operatorDiscService.setFingerAndIrisStatus(fingerAuthField.isEnabled(), irisConfirmField.isEnabled());
    }

    private void onRDBioAuthValidityChange(boolean valid) {
        boolean fingerEnabled = this.operatorDiscService.isFingerEnabled();
        boolean irisEnabled = this.operatorDiscService.isIrisEnabled();
        if (this.useRDDevices && fingerEnabled) {
            this.isBioCaptureValid = this.biometricsAuthService.getRdAuthBiometrics().isCaptureValid(this.authParamType, DeviceType.FINGERPRINT_AUTH);
        }
        if (this.useRDDevices && irisEnabled) {
            this.isBioCaptureValid = this.biometricsAuthService.getRdAuthBiometrics().isCaptureValid(this.authParamType, DeviceType.IRIS_AUTH);
        }
        this.validate();
    }

    private void onNonRDFingerAuthValidityChange(boolean valid) {
        if (!this.useRDDevices && this.operatorDiscService.isFingerEnabled()) {
            this.isBioCaptureValid = valid;
        }
        this.validate();
    }

    private void onNonRDIrisAuthValidityChange(boolean valid) {
        if (!this.useRDDevices && this.operatorDiscService.isIrisEnabled()) {
            this.isBioCaptureValid = valid;
        }
        this.validate();
    }

    private void validate() {
        this.viewPeer.okBtn.setEnabled(this.isBioCaptureValid);
    }

    private void bioTypeOptionSelected(ItemEvent ie) {
        if (ie.getStateChange() != 1) {
            return;
        }
        if (this.useRDDevices) {
            this.onBioOptionSelectedForRD();
        } else {
            this.onBioOptionSelectedForNonRD();
        }
    }

    private void toggleBioCaptureState() {
        this.isBioCaptureValid = true;
        if (this.operatorDiscService.isFingerEnabled()) {
            BiometricsNonRDField fingerField;
            if (this.useRDDevices) {
                fingerField = this.biometricsRDAuthPanel.getRDBioField(this.authParamType, DeviceType.FINGERPRINT_AUTH);
                fingerField.setEnabled(true);
                fingerField.clearCaptureAttempt();
            } else {
                fingerField = this.biometricsNonRDAuthPanel.fingerAuthField;
                fingerField.setEnabled(true);
                fingerField.clearCaptureAttempt();
            }
        }
        if (this.operatorDiscService.isIrisEnabled()) {
            BiometricsNonRDField irisField;
            if (this.useRDDevices) {
                irisField = this.biometricsRDAuthPanel.getRDBioField(this.authParamType, DeviceType.IRIS_AUTH);
                irisField.setEnabled(true);
                irisField.clearCaptureAttempt();
            } else {
                irisField = this.biometricsNonRDAuthPanel.irisConfirmField;
                irisField.setEnabled(true);
                irisField.clearCaptureAttempt();
            }
        }
    }

    private void onBioOptionSelectedForRD() {
        BiometricsRDField rdFingerAuthField = this.biometricsRDAuthPanel.getRDBioField(this.authParamType, DeviceType.FINGERPRINT_AUTH);
        BiometricsRDField rdIrisAuthField = this.biometricsRDAuthPanel.getRDBioField(this.authParamType, DeviceType.IRIS_AUTH);
        rdFingerAuthField.clearCaptureAttempt();
        rdIrisAuthField.clearCaptureAttempt();
        this.biometricsAuthService.getRdAuthBiometrics().clearAll();
        if (this.viewPeer.btnGrp == null) {
            return;
        }
        String actionCommand = this.viewPeer.btnGrp.getSelection().getActionCommand();
        boolean isFingerEnabled = actionCommand.equals(AuthParamType.FINGER.toString());
        rdFingerAuthField.setEnabled(isFingerEnabled);
        boolean isIrisEnabled = actionCommand.equals(AuthParamType.IRIS.toString());
        rdIrisAuthField.setEnabled(isIrisEnabled);
        this.operatorDiscService.setFingerAndIrisStatus(isFingerEnabled, isIrisEnabled);
    }

    private void onBioOptionSelectedForNonRD() {
        BiometricsNonRDField fingerAuthField = this.biometricsNonRDAuthPanel.fingerAuthField;
        BiometricsNonRDField irisConfirmField = this.biometricsNonRDAuthPanel.irisConfirmField;
        fingerAuthField.clearCaptureAttempt();
        irisConfirmField.clearCaptureAttempt();
        this.biometricsAuthService.getSingleFingerAuth().clear();
        this.biometricsAuthService.getLeftIrisAuth().clear();
        if (this.viewPeer.btnGrp == null) {
            return;
        }
        String actionCommand = this.viewPeer.btnGrp.getSelection().getActionCommand();
        boolean isFingerEnabled = actionCommand.equals(AuthParamType.FINGER.toString());
        fingerAuthField.setEnabled(isFingerEnabled);
        boolean isIrisEnabled = actionCommand.equals(AuthParamType.IRIS.toString());
        irisConfirmField.setEnabled(isIrisEnabled);
        this.operatorDiscService.setFingerAndIrisStatus(isFingerEnabled, isIrisEnabled);
    }
}

