/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.operatorstat;

import in.gov.uidai.ec.service.packet.IPacketService;
import in.gov.uidai.ec.service.presync.IPreSyncPreference;
import in.gov.uidai.ec.service.report.IEodReportSearch;
import in.gov.uidai.ec.service.session.ISessionService;
import in.gov.uidai.ec.ui.ControllerBase;
import in.gov.uidai.ec.ui.operatorstat.OperatorStatsViewPeer;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OperatorStatsController
extends ControllerBase {
    private final ISessionService sessionService;
    private final IPacketService packetService;
    private final IEodReportSearch eodReportSearch;
    private final IPreSyncPreference preSyncPref;
    private final OperatorStatsViewPeer viewPeer;

    public OperatorStatsController(OperatorStatsViewPeer viewPeer) {
        super(viewPeer.getView());
        this.sessionService = viewPeer.sessionService;
        this.packetService = viewPeer.packetService;
        this.eodReportSearch = viewPeer.eodReportSearch;
        this.preSyncPref = viewPeer.preSyncPref;
        this.viewPeer = viewPeer;
        this.initView();
    }

    private void initView() {
        this.viewPeer.stationInfo.setText(this.showStationInfo());
        this.viewPeer.packetRejectionSummary.setText(this.showPacketStatsForOperator());
    }

    private String showStationInfo() {
        StringBuilder message = new StringBuilder("<html><font size=4><ol>");
        int packetsAsOfToday = this.eodReportSearch.getCountOfEnrolmentsAsOn(new SimpleDateFormat("yyyyMMdd").format(new Date()));
        int maxPacketsPerDay = this.preSyncPref.getMaxPacketsPerDay();
        if (packetsAsOfToday > 0 && maxPacketsPerDay > 0) {
            message.append("<li>Total enrolments done today is ").append(packetsAsOfToday).append(" and max allowed is ").append(maxPacketsPerDay);
        } else if (maxPacketsPerDay > 0) {
            message.append("<li>This client's daily packet limit is ").append(maxPacketsPerDay).append(".");
        }
        if (this.sessionService.getSessionRemainingValidityInDays() == 0) {
            message.append("<li>Operator have to sync today. Your last sync was done on ").append(this.sessionService.getStartTime());
        } else {
            message.append("<li>Operator have " + Math.abs(this.sessionService.getSessionRemainingValidityInDays()) + " day(s) left to sync. Operator last sync was done on " + this.sessionService.getStartTime());
        }
        message.append("<li>Total number of un-uploaded packets in station is ").append(this.eodReportSearch.getUnUploadedPacketsCount());
        message.append("</ol></font></html>");
        return message.toString();
    }

    private String showPacketStatsForOperator() {
        String operatorId = this.sessionService.getOperatorCredentials().getOperatorId();
        StringBuilder message = new StringBuilder("<html><font size=4>");
        int rejectedPacketSize = this.packetService.findRejectedPackets(operatorId).size();
        List qcRejectedPackets = this.packetService.getQcRejectedPackets(operatorId);
        List<String> packetSummaryDetails = this.getPacketSummaryDetails(qcRejectedPackets);
        message.append("&nbsp &nbsp Total number of packets rejected in past 30 days: ").append(rejectedPacketSize).append("<br><br>");
        message.append("&nbsp &nbsp Number of document based rejections: ").append(qcRejectedPackets.size()).append("<br><br>");
        if (!packetSummaryDetails.isEmpty()) {
            message.append("<b>&nbsp &nbsp &nbsp &nbsp Common document based rejection reasons:</b><br><ol>");
            packetSummaryDetails.forEach(detail -> message.append("<li>").append((String)detail).append("</li>"));
            message.append("</ol>");
        }
        return message.append("</font></html>").toString();
    }

    private List<String> getPacketSummaryDetails(List<Map<String, String>> packetStatusList) {
        HashMap descMap = new HashMap();
        for (Map<String, String> packetStatus : packetStatusList) {
            if (packetStatus == null) continue;
            String[] descriptions = packetStatus.get("SUB_REJECT_REASON_DESC").split(",");
            Arrays.stream(descriptions).map(String::trim).forEach(desc -> descMap.put(desc, descMap.getOrDefault(desc, 0) + 1));
        }
        return descMap.entrySet().stream().sorted(Collections.reverseOrder(Map.Entry.comparingByValue())).limit(3L).map(Map.Entry::getKey).collect(Collectors.toList());
    }
}

