/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.oponlinelogin;

import com.google.common.base.Strings;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.oauthapi.OnlineGatewayException;
import in.gov.uidai.ec.oauthapi.exception.ErrorCodes;
import in.gov.uidai.ec.oauthapi.json.UosResponse;
import in.gov.uidai.ec.oauthapi.token.TokenManager;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.pac.PacDetail;
import in.gov.uidai.ec.service.registration.IRegistrationService;
import in.gov.uidai.ec.telemetry.TelemetryService;
import in.gov.uidai.ec.ui.biologin.CheckTokenResponse;
import in.gov.uidai.ec.ui.enrol.universalClient.common.CommonUtilsUC;
import in.gov.uidai.ec.ui.oponlinelogin.IOperatorOnlineLoginConstants;
import in.gov.uidai.ec.ui.pac.PacResponse;
import in.gov.uidai.ec.ui.utils.Utils;
import in.gov.uidai.litef.beans.ModalVisualExecutionContext;
import in.gov.uidai.litef.devapi.EventHandler;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.devapi.IEventContextAware;
import in.gov.uidai.litef.devapi.ILiteEvent;
import in.gov.uidai.litef.devapi.IOnScreenDisplay;
import in.gov.uidai.litef.devapi.IOnScreenDisplayAware;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.litef.devapi.ScaffoldPlacement;
import in.gov.uidai.swing.l10n.L10nDecorator;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatorLoginControl
implements IOnScreenDisplayAware,
IEventContextAware,
IOperatorOnlineLoginConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperatorLoginControl.class);
    private EnrollmentService enrollmentService;
    private IOnScreenDisplay osd;
    private IEventContext evtCtxt;
    protected IResourceBundleContext enrolRbCtxt;
    private IVisualExecutionContext veCtxt;
    private TokenManager opTokenManager;
    protected IRegistrationService registrationService;
    private String sid = "";

    public void setResourceBundleContext(IResourceBundleContext rbCtxt) {
        this.enrolRbCtxt = rbCtxt;
    }

    public OperatorLoginControl() {
        LOGGER.trace("Inside OperatorLoginControl constructor");
    }

    public void setEnrollmentService(EnrollmentService enrollmentService) {
        this.enrollmentService = enrollmentService;
    }

    public TokenManager getOpTokenManager() {
        return this.opTokenManager;
    }

    public void populateOnScreenDisplay(IOnScreenDisplay osd) {
        this.osd = osd;
    }

    @EventHandler(name="login", method="actionPerformed")
    public void operatorLogin(ILiteEvent evt) {
        this.veCtxt = new ModalVisualExecutionContext(null, false, new L10nDecorator(this.enrolRbCtxt, false));
        Utils.showProgressBar(this.veCtxt, "Loading Operator Login Page, Please wait");
        if (!this.enrollmentService.isOnlineUpdate()) {
            this.enrollmentService.initiateUCOnline();
        }
        if (!this.checkOperatorToken()) {
            this.initiateOperatorLogin();
        } else {
            Utils.cancelProgressBar(this.veCtxt);
            this.opTokenManager.setUniversalClientTransaction(true);
            ((ActionListener)this.evtCtxt.getEventListener("test_trnx", ActionListener.class)).actionPerformed(new ActionEvent(evt.getEvent().getSource(), 1, "actionPerformed"));
        }
    }

    private boolean checkOperatorToken() {
        if (Strings.isNullOrEmpty((String)this.opTokenManager.getRefreshToken())) {
            return false;
        }
        try {
            CheckTokenResponse response = this.enrollmentService.getOauthGwApiService().checkOperatorToken();
            return response.getStatus().equalsIgnoreCase("SUCCESS");
        }
        catch (OnlineGatewayException e) {
            LOGGER.info("Checking token call failed");
            return false;
        }
    }

    private void initiateOperatorLogin() {
        if (this.osd.getScaffold(this.sid) == null) {
            this.sid = this.osd.compose("operatorLoginWin", "operatorLoginPreview");
            this.osd.display(this.sid, ScaffoldPlacement.CENTERED);
        }
        Utils.cancelProgressBar(this.veCtxt);
    }

    @EventHandler(name="pacInitiate", method="actionPerformed")
    public void initiatePacCall(ILiteEvent evt) {
        if (!this.enrollmentService.isPACValidationRequired()) {
            this.getPacInfo(evt);
            if (!this.enrollmentService.isPACValidationRequired()) {
                LOGGER.info("PAC not permitted to the operator.");
                L10nOptionPaneBuilder.getInstance().showInfoUC((Object)"PAC not permitted for the operator");
                return;
            }
        }
        LOGGER.info("PAC permitted to the operator.");
        L10nOptionPaneBuilder.getInstance().showInfoUC((Object)"PAC permitted for the operator");
    }

    @EventHandler(name="pacCall", method="actionPerformed")
    public void getPacInfo(ILiteEvent evt) {
        Utils.showProgressBar(this.veCtxt, "Verifying PAC, Please wait.");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("registrarId", this.registrationService.getRegistrarId());
        queryParams.put("agencyId", this.registrationService.getAgencyId());
        queryParams.put("stationId", this.registrationService.getStationId());
        PacResponse pacResponse = this.enrollmentService.getOauthGwApiService().checkPacRequired(queryParams);
        this.enrollmentService.setPACValidationRequired(pacResponse.isValidatePac());
        if (pacResponse.isValidatePac()) {
            LOGGER.info("PAC permitted to the operator.");
            this.enrollmentService.setPacDetail(new PacDetail(pacResponse.getPacUrl(), pacResponse.getPacKey(), pacResponse.getPacVersion()));
        } else {
            LOGGER.info("PAC not permitted to the operator.");
            LOGGER.error(pacResponse.getErrorCode() + ":" + CommonUtilsUC.getErrorMessage((UosResponse)pacResponse));
            if (!Strings.isNullOrEmpty((String)pacResponse.getErrorCode())) {
                TelemetryService.getTelemetryServiceInstance().postLogData((Exception)((Object)OnlineGatewayException.getClientException((String)pacResponse.getErrorCode(), (String)("PAC failure: " + CommonUtilsUC.getErrorMessage((UosResponse)pacResponse)), (String)this.enrollmentService.getTransactionId(), (Exception)new Exception())), pacResponse.getErrorCode(), new String[0]);
            }
            if (!Strings.isNullOrEmpty((String)pacResponse.getErrDescription())) {
                String code = !Strings.isNullOrEmpty((String)pacResponse.getErrShortName()) ? pacResponse.getErrShortName() : ErrorCodes.UC_PAC_003.getErrorCode();
                TelemetryService.getTelemetryServiceInstance().postLogData((Exception)((Object)OnlineGatewayException.getClientException((String)code, (String)("PAC failure: " + pacResponse.getErrDescription()), (String)this.enrollmentService.getTransactionId(), (Exception)new Exception())), code, new String[0]);
                L10nOptionPaneBuilder.getInstance().showErrorUC(pacResponse.getErrDescription(), null, code, this.enrollmentService.getTransactionId(), new Object[0]);
            }
        }
        Utils.cancelProgressBar(this.veCtxt);
    }

    @EventHandler(name="hID_OpLoginCloseWin", method="actionPerformed")
    public void onCloseWin(ILiteEvent evt) {
        this.closeWinImpl(evt);
    }

    private void closeWinImpl(ILiteEvent evt) {
        this.osd.dispose(evt.getScaffoldId());
    }

    public void setOpTokenManager(TokenManager opTokenManager) {
        this.opTokenManager = opTokenManager;
    }

    public void populateEventContext(IEventContext ctxt) {
        this.evtCtxt = ctxt;
    }

    public void setRegistrationService(IRegistrationService registrationService) {
        this.registrationService = registrationService;
    }
}

