/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.oponlinelogin;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.sun.javafx.webkit.WebConsoleListener;
import in.gov.uidai.ec.escapi.StationInfoStoreException;
import in.gov.uidai.ec.oauthapi.OnlineGatewayException;
import in.gov.uidai.ec.oauthapi.json.UosResponse;
import in.gov.uidai.ec.oauthapi.token.AuthCodeListener;
import in.gov.uidai.ec.oauthapi.token.TokenUtils;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.gps.GeoData;
import in.gov.uidai.ec.service.pac.PacDetail;
import in.gov.uidai.ec.service.session.OperatorDetails;
import in.gov.uidai.ec.telemetry.TelemetryService;
import in.gov.uidai.ec.ui.ControllerBase;
import in.gov.uidai.ec.ui.biologin.BioAuthType;
import in.gov.uidai.ec.ui.biologin.UserType;
import in.gov.uidai.ec.ui.enrol.universalClient.common.CommonUtilsUC;
import in.gov.uidai.ec.ui.oponlinelogin.IOperatorOnlineLoginConstants;
import in.gov.uidai.ec.ui.oponlinelogin.OAuthAlert;
import in.gov.uidai.ec.ui.oponlinelogin.OperatorLoginViewPeer;
import in.gov.uidai.ec.ui.oponlinelogin.gps.GpsControl;
import in.gov.uidai.ec.ui.oponlinelogin.gps.WebViewWrapper;
import in.gov.uidai.ec.ui.pac.PacResponse;
import in.gov.uidai.ec.ui.utils.ThreadPool;
import in.gov.uidai.ec.ui.utils.Utils;
import in.gov.uidai.ec.util.WebviewLocalProxy;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import javafx.application.Platform;
import javafx.scene.input.KeyCode;
import javafx.scene.web.WebView;
import javax.swing.JButton;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatorLoginController
extends ControllerBase
implements IOperatorOnlineLoginConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperatorLoginController.class);
    private final OperatorLoginViewPeer viewElements;
    private final EnrollmentService enrollmentService;
    private final AuthCodeListener authCodeListener;
    private final ActionListener operatorBioListener;
    private final ActionListener transactionPageListner;
    private JButton initBioCaptureButton;
    private JButton transactionPageButton;
    private GpsControl gpsControl;
    private String codeVerifier;
    private boolean isLoadSuccess;
    private boolean isClosePopup;
    IVisualExecutionContext veCtxt;

    public OperatorLoginController(OperatorLoginViewPeer view, AuthCodeListener authCodeListener) {
        super(view.getView());
        this.viewElements = view;
        this.enrollmentService = view.enrollmentService;
        this.authCodeListener = authCodeListener;
        this.operatorBioListener = (ActionListener)view.evtCtxt.getEventListener("showBioLoginPopup", ActionListener.class);
        this.transactionPageListner = (ActionListener)view.evtCtxt.getEventListener("test_trnx", ActionListener.class);
        this.initBioCaptureButton = new JButton("test");
        this.initBioCaptureButton.addActionListener(this.operatorBioListener);
        this.enrollmentService.addOnBioLoginFailureListener(this::closePopup);
        this.transactionPageButton = new JButton();
        this.transactionPageButton.addActionListener(this.transactionPageListner);
        this.veCtxt = view.getView().getVisualExecutionContext();
        this.gpsControl = new GpsControl();
        this.gpsControl.start();
        Platform.setImplicitExit((boolean)false);
        Platform.runLater(() -> {
            LOGGER.trace("Inside platform run later call");
            WebviewLocalProxy.startLocalProxyServer();
            this.renderOperatorLoginPage();
        });
    }

    public void renderOperatorLoginPage() {
        String uri;
        LOGGER.info("Initiating Operator Login screen");
        WebView webView = WebViewWrapper.getWebViewWrapper().getWebView();
        WebConsoleListener wc = (webView1, message, lineNumber, sourceId) -> LOGGER.debug("Console: [" + message + ":" + lineNumber + "] " + sourceId);
        WebConsoleListener.setDefaultListener((WebConsoleListener)wc);
        String codeVerifier = TokenUtils.randomString();
        this.setCodeVerifier(codeVerifier);
        try {
            uri = this.createUri(codeVerifier);
        }
        catch (URISyntaxException | NoSuchAlgorithmException e) {
            LOGGER.error("Error creating URI", (Throwable)e);
            this.showSimpleError(this.viewElements.getContentPane(), "Error occurred while trying to log in: Please contact support team", new Object[0]);
            return;
        }
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (!OperatorLoginController.this.isLoadSuccess) {
                    LOGGER.info("Closing Operator Screen Now after waiting for 1 minute");
                    try {
                        OperatorLoginController.this.closePopup("Page Load Failure");
                    }
                    catch (Exception exception) {
                        LOGGER.info("Exception while calling closing popup");
                    }
                }
            }
        }, 60000L);
        Utils.showProgressBar(this.veCtxt, "Loading Operator Login Page");
        LOGGER.debug("Webview Location : {}", (Object)webView.getEngine().getLocation());
        CookieManager manager = new CookieManager();
        CookieHandler.setDefault(manager);
        manager.getCookieStore().removeAll();
        webView.getEngine().setOnAlert(stringWebEvent -> this.parseAlertAndCall((String)stringWebEvent.getData()));
        webView.getEngine().load(uri);
        this.viewElements.getJfxPanel().setScene(WebViewWrapper.getWebViewWrapper().getScene());
        this.viewElements.getJfxPanel().getScene().setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode() == KeyCode.ESCAPE || keyEvent.getCode() == KeyCode.F4 && keyEvent.isAltDown()) {
                LOGGER.debug("Closing Operator Login Javafx Engine through ESC press");
                if (WebViewWrapper.getWebViewWrapper().getWebView() != null) {
                    String path = this.getClass().getResource("/res/ecmp/html/blank.html").toExternalForm();
                    LOGGER.debug("Loaded blank page");
                    WebViewWrapper.getWebViewWrapper().getWebView().getEngine().load(path);
                }
            }
        });
    }

    private void closeJavaFxEngine() {
        WebviewLocalProxy.stopLocalProxyServer();
        LOGGER.debug("Closing Operator Login Javafx Engine through Close popup");
        Platform.runLater(() -> {
            if (WebViewWrapper.getWebViewWrapper().getWebView() != null) {
                String path = this.getClass().getResource("/res/ecmp/html/blank.html").toExternalForm();
                LOGGER.debug("Loaded blank page");
                WebViewWrapper.getWebViewWrapper().getWebView().getEngine().load(path);
            }
        });
    }

    private String createUri(String codeVerifier) throws URISyntaxException, NoSuchAlgorithmException {
        String telemetrySessionId = UUID.randomUUID().toString();
        LOGGER.info("Telemetry Session ID for Operator Login page: {}", (Object)telemetrySessionId);
        URIBuilder uriBuilder = new URIBuilder(this.enrollmentService.getOauthGwApiService().getGatewayPreference().getOAuthGWServicesUrl());
        uriBuilder.setPath("/access/oauth/authorize");
        uriBuilder.setParameter("client_id", this.enrollmentService.getOauthGwApiService().getGatewayPreference().getOAuthClientId());
        uriBuilder.setParameter("grant_type", this.enrollmentService.getOauthGwApiService().getGatewayPreference().getOAuthGrantType());
        uriBuilder.setParameter("response_type", "code");
        uriBuilder.setParameter("scope", "READ");
        uriBuilder.setParameter("code_challenge", TokenUtils.getCodeChallenge((String)codeVerifier));
        uriBuilder.setParameter("telemetry_session_id", telemetrySessionId);
        uriBuilder.setParameter("code_challenge_method", "S256");
        uriBuilder.setParameter("role", "operator");
        LOGGER.info(uriBuilder.toString());
        return uriBuilder.toString();
    }

    private void parseAlertAndCall(String jsonString) {
        OAuthAlert oAuthAlert;
        try {
            oAuthAlert = (OAuthAlert)new ObjectMapper().readValue(jsonString, OAuthAlert.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String funcName = oAuthAlert.getEvent();
        HashMap<String, String> params = oAuthAlert.getParams();
        this.callFrontendUtil(funcName, params);
    }

    private void callFrontendUtil(String funcName, HashMap<String, String> params) {
        switch (funcName) {
            case "setCodeVerifier": {
                this.setCodeVerifier(params.get("codeVerifier"));
                break;
            }
            case "startBioAuth": {
                this.startBioAuth(params.get("token"), params.get("bioAuthType"));
                break;
            }
            case "closePopup": {
                this.closePopup(params.get("errorMessage"));
                break;
            }
            case "reLoginClosePopup": {
                this.reLoginClosePopup();
                break;
            }
            case "onSuccess": {
                this.onSuccess(params.get("authCode"));
                break;
            }
            case "pageLoaded": {
                this.pageLoaded(params.get("isLoadSuccess"));
                break;
            }
            default: {
                LOGGER.info("Failed to call FE function");
            }
        }
    }

    public void setCodeVerifier(String codeVerifier) {
        this.codeVerifier = codeVerifier;
    }

    public void startBioAuth(String token, String bioAuthType) {
        LOGGER.debug("Calling Bio Auth through javafx for operator login " + token + " " + bioAuthType);
        this.authCodeListener.acceptBioAuth(token, bioAuthType, UserType.OPERATOR, null);
        if (!bioAuthType.equalsIgnoreCase(BioAuthType.face.name())) {
            this.initBioCaptureButton.doClick();
        }
    }

    public void closePopup(String errorMessage) {
        if (this.isClosePopup) {
            return;
        }
        ActionEvent jButtonEvent = new ActionEvent(this.viewElements.dummyActionListenerComp, 1001, "Anything", System.currentTimeMillis(), 0);
        this.closeJavaFxEngine();
        for (ActionListener listener : this.viewElements.dummyActionListenerComp.getActionListeners()) {
            listener.actionPerformed(jButtonEvent);
        }
        this.isClosePopup = true;
    }

    public void reLoginClosePopup() {
        LOGGER.info("Operator re-login initiated");
        WebViewWrapper.getWebViewWrapper().getWebView().getEngine().reload();
    }

    public void onSuccess(String authCode) {
        LOGGER.info("Operator login otp matched");
        Utils.showProgressBar(this.veCtxt, "Logging in");
        ThreadPool.commonPool().submit(() -> {
            try {
                this.authCodeListener.acceptOp(authCode, this.codeVerifier, this::operatorLogoutReminder);
                OperatorDetails operatorDetails = new OperatorDetails();
                operatorDetails.setOpUid(this.authCodeListener.getOperatorUid());
                operatorDetails.setOperatorId(this.authCodeListener.getOperatorId());
                operatorDetails.setOpName(this.authCodeListener.getOperatorName());
                LOGGER.info("Operator login successful");
                this.getPacInfo();
                this.transactionPageButton.doClick();
                operatorDetails.setLatitude(GeoData.convertCoords((float)this.viewElements.oucDataStore.getGpsInfo().getLatitude().floatValue()));
                operatorDetails.setLongitude(GeoData.convertCoords((float)this.viewElements.oucDataStore.getGpsInfo().getLongitude().floatValue()));
                operatorDetails.setAltitude(GeoData.COORD_FORMAT.format(this.viewElements.oucDataStore.getGpsInfo().getAltitude()));
                this.enrollmentService.initiateNewSession(operatorDetails);
            }
            catch (OnlineGatewayException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                Utils.cancelProgressBar(this.veCtxt);
                this.showError(this.viewElements.getContentPane(), "Error occurred while trying to log in");
            }
            catch (StationInfoStoreException | IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                Utils.cancelProgressBar(this.veCtxt);
                this.closePopup("Successfully logged in");
            }
        });
    }

    public void pageLoaded(String isLoadSuccess) {
        if (isLoadSuccess.equalsIgnoreCase("true")) {
            Utils.cancelProgressBar(this.veCtxt);
            LOGGER.info("Operator Page Loaded Successfully");
        }
        this.isLoadSuccess = isLoadSuccess.equalsIgnoreCase("true");
    }

    private void operatorLogoutReminder() {
        LOGGER.info("Universal Client : Operator is logged out");
        this.showWarningUC("Universal Client : Operator is logged out, Please login again to continue Universal Client transaction.", this.viewElements.getContentPane());
    }

    private void getPacInfo() {
        ThreadPool.commonPool().submit(() -> {
            HashMap<String, String> queryParams = new HashMap<String, String>();
            queryParams.put("registrarId", this.viewElements.registrationService.getRegistrarId());
            queryParams.put("agencyId", this.viewElements.registrationService.getAgencyId());
            queryParams.put("stationId", this.viewElements.registrationService.getStationId());
            PacResponse pacResponse = this.enrollmentService.getOauthGwApiService().checkPacRequired(queryParams);
            this.enrollmentService.setPACValidationRequired(pacResponse.isValidatePac());
            if (pacResponse.isValidatePac()) {
                LOGGER.info("PAC permitted to the operator.");
                this.enrollmentService.setPacDetail(new PacDetail(pacResponse.getPacUrl(), pacResponse.getPacKey(), pacResponse.getPacVersion()));
            } else {
                LOGGER.info("PAC not permitted to the operator.");
                LOGGER.error(pacResponse.getErrorCode() + ":" + CommonUtilsUC.getErrorMessage((UosResponse)pacResponse));
                if (!Strings.isNullOrEmpty((String)pacResponse.getErrorCode())) {
                    TelemetryService.getTelemetryServiceInstance().postLogData((Exception)((Object)OnlineGatewayException.getClientException((String)pacResponse.getErrorCode(), (String)CommonUtilsUC.getErrorMessage((UosResponse)pacResponse), (String)this.enrollmentService.getTransactionId(), (Exception)new Exception())), pacResponse.getErrorCode(), new String[0]);
                }
                if (!Strings.isNullOrEmpty((String)pacResponse.getErrDescription())) {
                    TelemetryService.getTelemetryServiceInstance().postLogData((Exception)((Object)OnlineGatewayException.getClientException((String)pacResponse.getErrShortName(), (String)pacResponse.getErrDescription(), (String)this.enrollmentService.getTransactionId(), (Exception)new Exception())), pacResponse.getErrShortName(), new String[0]);
                }
            }
        });
    }
}

