/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.oponlinelogin;

import com.google.common.base.Strings;
import com.sun.net.httpserver.HttpServer;
import in.gov.uidai.ec.grpc.GrpcService;
import in.gov.uidai.ec.oauthapi.exception.ErrorCodes;
import in.gov.uidai.ec.oauthapi.token.AuthCodeListener;
import in.gov.uidai.ec.oauthapi.token.TokenManager;
import in.gov.uidai.ec.oauthapi.token.TokenUtils;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.telemetry.TelemetryService;
import in.gov.uidai.ec.ui.utils.ThreadPool;
import in.gov.uidai.litef.devapi.EventHandler;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.devapi.IEventContextAware;
import in.gov.uidai.litef.devapi.ILiteEvent;
import in.gov.uidai.litef.devapi.IOnScreenDisplay;
import in.gov.uidai.litef.devapi.IOnScreenDisplayAware;
import in.gov.uidai.litef.devapi.ScaffoldPlacement;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import javax.swing.JComponent;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupervisorAuthControl
implements IEventContextAware,
IOnScreenDisplayAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(SupervisorAuthControl.class);
    private final TokenManager supervisorToken;
    private final EnrollmentService enrollmentService;
    private String codeVerifier;
    private HttpServer server;
    private final AuthCodeListener authCodeListener;
    private IOnScreenDisplay osd;
    private IEventContext evtCtx;
    private String scaffoldId;

    public SupervisorAuthControl(TokenManager supervisorToken, EnrollmentService enrollmentService, AuthCodeListener authCodeListener) {
        this.supervisorToken = supervisorToken;
        this.enrollmentService = enrollmentService;
        this.authCodeListener = authCodeListener;
    }

    @EventHandler(name="supervisorAuth", method="actionPerformed")
    public void startSupervisorAuth(ILiteEvent event) {
        String codeVerifier;
        this.codeVerifier = codeVerifier = TokenUtils.randomString();
        try {
            String uri = this.createUri(codeVerifier);
            this.enrollmentService.setSupervisorAuthUrl(uri);
            this.scaffoldId = this.osd.compose("supervisorAuthPopupWin", "supervisorAuthPopup");
            this.osd.display(this.scaffoldId, ScaffoldPlacement.CENTERED);
            Desktop.getDesktop().browse(new URI(uri));
        }
        catch (URISyntaxException | NoSuchAlgorithmException e) {
            LOGGER.error("Error creating URI", (Throwable)e);
            L10nOptionPaneBuilder.getInstance().showSimpleErrorUC((Object)"Error occurred while trying to do supervisor auth. Please contact support team", (Component)((JComponent)event.getEvent().getSource()), new Object[0]);
            return;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            this.initialiseServer();
            this.simpleServer();
        }
        catch (IOException e) {
            TelemetryService.getTelemetryServiceInstance().postLogData((Exception)e, ErrorCodes.UC_GEN_119.getErrorCode(), new String[0]);
            throw new RuntimeException(e);
        }
    }

    public void closePopup() {
        try {
            if (this.osd != null) {
                this.osd.dispose(this.scaffoldId);
            } else {
                LOGGER.info("OSD is not initialized.");
            }
        }
        catch (Exception e) {
            LOGGER.error("Error closing window: " + e.getMessage());
        }
    }

    private String createUri(String codeVerifier) throws URISyntaxException, NoSuchAlgorithmException {
        String telemetrySessionId = UUID.randomUUID().toString();
        LOGGER.info("Telemetry Session ID for Operator Login page: {}", (Object)telemetrySessionId);
        URIBuilder uriBuilder = new URIBuilder(this.enrollmentService.getOauthGwApiService().getGatewayPreference().getOAuthGWServicesUrl());
        uriBuilder.setPath("/uc-access/oauth/authorize");
        uriBuilder.setParameter("client_id", this.enrollmentService.getOauthGwApiService().getGatewayPreference().getOAuthClientId());
        uriBuilder.setParameter("grant_type", this.enrollmentService.getOauthGwApiService().getGatewayPreference().getOAuthGrantType());
        uriBuilder.setParameter("response_type", "code");
        uriBuilder.setParameter("scope", "READ");
        uriBuilder.setParameter("code_challenge", TokenUtils.getCodeChallenge((String)codeVerifier));
        uriBuilder.setParameter("telemetry_session_id", telemetrySessionId);
        uriBuilder.setParameter("code_challenge_method", "S256");
        uriBuilder.setParameter("role", this.getRole());
        LOGGER.info(uriBuilder.toString());
        return uriBuilder.toString();
    }

    private void initialiseServer() {
        try {
            if (this.server != null) {
                this.server.stop(0);
            }
            this.server = HttpServer.create(new InetSocketAddress(9009), 0);
        }
        catch (IOException e) {
            LOGGER.error(ErrorCodes.UC_GEN_119.getReason(), (Throwable)e);
            TelemetryService.getTelemetryServiceInstance().postLogData((Exception)e, ErrorCodes.UC_GEN_119.getErrorCode(), new String[0]);
        }
    }

    public void simpleServer() throws IOException {
        this.server.createContext("/", httpExchange -> {
            String code = httpExchange.getRequestURI().getQuery().replace("code=", "");
            this.onSuccess(code);
            String response = "Successful login";
            httpExchange.sendResponseHeaders(200, response.length());
            OutputStream os = httpExchange.getResponseBody();
            os.write(response.getBytes());
            LOGGER.info("Client stops listening");
            os.close();
            httpExchange.close();
            this.server.stop(0);
        });
        this.server.setExecutor(null);
        this.server.start();
    }

    private void onSuccess(String authCode) {
        ThreadPool.commonPool().submit(() -> {
            this.authCodeListener.acceptOp(authCode, this.codeVerifier, null);
            GrpcService.getInst().setTokenManager(this.supervisorToken);
            this.closePopup();
            ((ActionListener)this.evtCtx.getEventListener("HID_ACK_SLIP_PANEL_DISPLAY", ActionListener.class)).actionPerformed(null);
        });
    }

    private String getRole() {
        if (!Strings.isNullOrEmpty((String)this.enrollmentService.getGrievanceId())) {
            return "supervisor";
        }
        if (this.enrollmentService.getBiometricsException().getExceptionDetail().isBiometricExceptionApplied()) {
            return "supervisor-biox";
        }
        return "operator";
    }

    public void populateOnScreenDisplay(IOnScreenDisplay osd) {
        this.osd = osd;
    }

    public void populateEventContext(IEventContext ctx) {
        this.evtCtx = ctx;
    }
}

