/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.oponlinelogin.gps;

import java.text.DecimalFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoData {
    private String latitude;
    private String longitude;
    private String altitude;
    private String latBearing;
    private String longBearing;
    public static final DecimalFormat COORD_FORMAT = new DecimalFormat("#.00");
    private static final String DEGREE_SYMBOL = "\u00b0";
    private static final Logger LOGGER = LoggerFactory.getLogger(GeoData.class);

    public String getLatitude() {
        return this.latitude;
    }

    public String getDMSLatitude() {
        return GeoData.convertCoords(this.latitude);
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public String getLongitude() {
        return this.longitude;
    }

    public String getDMSLongitude() {
        return GeoData.convertCoords(this.longitude);
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public String getAltitude() {
        return this.altitude;
    }

    public String getFormattedAltitude() {
        return COORD_FORMAT.format(Double.parseDouble(this.altitude));
    }

    public void setAltitude(String altitude) {
        this.altitude = altitude;
    }

    public String getLatBearing() {
        return this.latBearing;
    }

    public void setLatBearing(String latBearing) {
        this.latBearing = latBearing;
    }

    public String getLongBearing() {
        return this.longBearing;
    }

    public void setLongBearing(String longBearing) {
        this.longBearing = longBearing;
    }

    public String toString() {
        float lati = 0.0f;
        float longi = 0.0f;
        float alti = 0.0f;
        try {
            lati = Float.parseFloat(this.latitude);
            longi = Float.parseFloat(this.longitude);
            alti = Float.parseFloat(this.altitude);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "latitude:" + GeoData.convertCoords(lati) + " " + this.latBearing + ", longitude:" + GeoData.convertCoords(longi) + " " + this.longBearing + ", altitude:" + COORD_FORMAT.format(alti);
    }

    private static String convertCoords(String coords) {
        return GeoData.convertCoords(Float.parseFloat(coords));
    }

    public static String convertCoords(float coords) {
        try {
            String minutesWithDegrees = String.valueOf(coords % 100.0f);
            int decimalLocation = minutesWithDegrees.indexOf(46);
            String minutes = minutesWithDegrees.substring(0, decimalLocation);
            String secondsInDecimals = minutesWithDegrees.substring(decimalLocation);
            double seconds = Double.valueOf(secondsInDecimals) * 60.0;
            String geoData = Math.round(coords) / 100 + DEGREE_SYMBOL + minutes + "'" + seconds + "\"";
            String minDegSec = geoData.split("\\.")[0];
            String decimalValue = geoData.split("\\.")[1];
            if (decimalValue.length() > 6) {
                return minDegSec + "." + decimalValue.substring(0, 6);
            }
            return geoData;
        }
        catch (Exception e) {
            LOGGER.info("not able to covert the coords", (Throwable)e);
            return "0.0";
        }
    }
}

