/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.oponlinelogin.gps;

import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import in.gov.uidai.ec.ui.oponlinelogin.gps.GeoData;
import in.gov.uidai.ec.ui.oponlinelogin.gps.IGpsListener;
import in.gov.uidai.ec.ui.oponlinelogin.gps._GeoMessageParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.TooManyListenersException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class _GpsMessageListener
implements SerialPortEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(_GpsMessageListener.class);
    private static final String GEO_PREFIX = "$GPGGA";
    private static final String GEO_NAV_PREFIX = "$GNGGA";
    private static final String NEW_LINE = "\n";
    private SerialPort serialPort;
    private _GeoMessageParser msgParser = new _GeoMessageParser();
    private List<IGpsListener> listeners = new ArrayList<IGpsListener>();

    _GpsMessageListener() {
    }

    void addGpsListener(IGpsListener gpsl) {
        if (!this.listeners.contains(gpsl)) {
            this.listeners.add(gpsl);
        }
    }

    void removeGpsListener(IGpsListener gpsl) {
        this.listeners.remove(gpsl);
    }

    public void connect(SerialPort port) throws IOException, TooManyListenersException {
        this.serialPort = port;
        port.addEventListener((SerialPortEventListener)this);
        this.notifyConnect();
    }

    void disconnect() {
        this.serialPort = null;
        this.notifyRemove();
    }

    public void serialEvent(SerialPortEvent event) {
        LOGGER.debug("Event Type : " + event.getEventType());
        String gpsMessage = this.getGPSMessage();
        String geoSentence = this.getGeoSentence(gpsMessage);
        if (geoSentence == null) {
            return;
        }
        try {
            GeoData geoData = this.msgParser.parse(geoSentence);
            if (geoData != null) {
                this.notifyData(geoData);
            }
        }
        catch (Exception exep) {
            LOGGER.warn(exep.getMessage(), (Throwable)exep);
        }
    }

    private String getGPSMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int data;
            InputStream portin = this.serialPort.getInputStream();
            while ((data = portin.read()) > -1) {
                stringBuilder.append((char)data);
                if (!stringBuilder.toString().contains(GEO_PREFIX) && !stringBuilder.toString().contains(GEO_NAV_PREFIX) || !stringBuilder.toString().endsWith(NEW_LINE)) continue;
                break;
            }
        }
        catch (IOException ioException) {
            LOGGER.warn("IOException while reading from port", (Throwable)ioException);
        }
        return stringBuilder.toString();
    }

    private String getGeoSentence(String gpsMessage) {
        if (!gpsMessage.contains(GEO_PREFIX) && !gpsMessage.contains(GEO_NAV_PREFIX)) {
            return null;
        }
        int beginIndex = 0;
        beginIndex = gpsMessage.contains(GEO_PREFIX) ? gpsMessage.indexOf(GEO_PREFIX) : gpsMessage.indexOf(GEO_NAV_PREFIX);
        int endIndex = gpsMessage.indexOf(NEW_LINE, beginIndex);
        return gpsMessage.substring(beginIndex, endIndex);
    }

    private void notifyConnect() {
        for (IGpsListener gpsDataChangedListener : this.listeners) {
            gpsDataChangedListener.deviceConnected();
        }
    }

    private void notifyRemove() {
        for (IGpsListener gpsDataChangedListener : this.listeners) {
            gpsDataChangedListener.deviceRemoved();
        }
    }

    private void notifyData(GeoData data) {
        for (IGpsListener gpsDataChangedListener : this.listeners) {
            gpsDataChangedListener.geoDataReceived(data);
        }
    }
}

