/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.opsync;

import in.gov.uidai.ec.service.opsync.OperatorSyncService;
import in.gov.uidai.ec.ui.main.UnsavedTracker;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysMainWin;
import in.gov.uidai.litef.devapi.EventHandler;
import in.gov.uidai.litef.devapi.ILiteEvent;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.litef.devapi.IOnScreenDisplay;
import in.gov.uidai.litef.devapi.IOnScreenDisplayAware;
import in.gov.uidai.litef.devapi.IViewElement;
import in.gov.uidai.litef.devapi.ScaffoldPlacement;
import java.util.Map;

public class OpSyncControl
implements IOnScreenDisplayAware {
    private IOnScreenDisplay osd;
    private UnsavedTracker tracker;
    private OperatorSyncService operatorSyncService;

    public void populateOnScreenDisplay(IOnScreenDisplay osd) {
        this.osd = osd;
    }

    public final void setUnsavedTracker(UnsavedTracker tracker) {
        this.tracker = tracker;
    }

    @EventHandler(name="hID_OpSync", method="actionPerformed")
    public void onOperatorSyncSelect(ILiteEvent evt) {
        if (!this.tracker.selectOther(evt)) {
            return;
        }
        Map eMap = this.osd.getScaffold(this.osd.recompose(evt.getScaffoldId(), "processOpSyncView")).getElementMap();
        ((IViewElement)eMap.get("hID_MainWin_Header")).set("text", (Object)LabelKeysMainWin.PROCESS_OPERATOR_SYNC);
        ILiteView view = this.osd.getView(this.osd.getScaffold(evt.getScaffoldId()).getViewId());
        view.setEnabled(true);
        if (this.operatorSyncService.isAutoLaunchEnabled()) {
            ((IViewElement)view.getElementMap().get("eID_OpSync_WinBut")).set("visible", (Object)false);
            ((IViewElement)view.getElementMap().get("eID_OpSync_WinBut")).call("click");
            ((IViewElement)view.getElementMap().get("eID_OpSync_WinBut")).set("visible", (Object)true);
        }
    }

    @EventHandler(name="hID_goToSyncPage", method="actionPerformed")
    public void onGoToSync(ILiteEvent evt) {
        this.tracker.reset();
        Map eMap = this.osd.getScaffold(evt.getScaffoldId()).getElementMap();
        ((IViewElement)eMap.get("hID_OpSync_ToolBut")).call("click");
    }

    @EventHandler(name="hID_deregChecklist", method="actionPerformed")
    public void onShowDeregChecklistWin(ILiteEvent evt) {
        String scafId = this.osd.compose(evt.getScaffoldId(), "deregChecklistWin", "deregChecklistView");
        this.osd.display(scafId, ScaffoldPlacement.CENTERED);
    }

    public void setOperatorSyncService(OperatorSyncService operatorSyncService) {
        this.operatorSyncService = operatorSyncService;
    }
}

