/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.opsync;

import in.gov.uidai.ec.service.opsync.OperatorSyncService;
import in.gov.uidai.ec.service.pincode.PostOffice;
import in.gov.uidai.ec.service.pincode.PostalAddress;
import in.gov.uidai.ec.service.session.OperatorDetails;
import in.gov.uidai.ec.ui.ControllerBase;
import in.gov.uidai.ec.ui.opsync.IOpSyncFormConstants;
import in.gov.uidai.ec.ui.opsync.OperatorSyncDetailsSubmitViewPeer;
import in.gov.uidai.litef.devapi.IEventContext;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.commons.lang.StringUtils;

public class OperatorSyncDetailsSubmitController
extends ControllerBase
implements IOpSyncFormConstants {
    private final OperatorSyncDetailsSubmitViewPeer viewPeer;
    private final IEventContext eventContext;
    private final OperatorSyncService operatorSyncService;

    public OperatorSyncDetailsSubmitController(OperatorSyncDetailsSubmitViewPeer viewPeer, IEventContext eventContext) {
        super(viewPeer.getView());
        this.viewPeer = viewPeer;
        this.eventContext = eventContext;
        this.operatorSyncService = viewPeer.operatorSyncService;
        this.initView();
    }

    private void initView() {
        this.addDialogBoxSwitchListeners();
        this.addEditableFieldListeners();
        this.viewPeer.okBtn.setEnabled(this.operatorSyncService.getOperatorSyncState().isValid());
        this.operatorSyncService.getOperatorSyncState().addValidityChangeListener(this::onValidityChange);
        this.populateView();
        this.initViewErrors();
    }

    private void onValidityChange(boolean valid) {
        this.viewPeer.okBtn.setEnabled(valid);
    }

    private void addEditableFieldListeners() {
        this.viewPeer.centerTypeField.addItemListener(this::onCenterTypeFieldItemSelected);
        this.addFocusListener(this.viewPeer.centerNameField, this::onCenterNameFieldFocusLost);
        this.addFocusListener(this.viewPeer.centerAddrsField, this::onCenterAddressFieldFocusLost);
        this.addFocusListener(this.viewPeer.postOffField, this::onPostOffFieldFocusLost);
        this.addFocusListener(this.viewPeer.pinCodeField, this::onPinCodeFieldFocusLost);
        this.viewPeer.postOffField.addValueChangeListener(this::onPostOfficeValueChanged);
        this.viewPeer.pinCodeField.addValueChangeListener(this::onPinCodeValueChanged);
        this.viewPeer.isWhiteListed.addItemListener(this::onWhiteListedBEFieldItemSelected);
    }

    private void onPinCodeValueChanged(DocumentEvent documentEvent) {
        String pinCode = this.viewPeer.pinCodeField.getText();
        Object poSelectedOption = this.viewPeer.postOffField.getSelectedOption();
        if (poSelectedOption instanceof PostOffice && (pinCode == null || !pinCode.equalsIgnoreCase(((PostOffice)poSelectedOption).getPincode()))) {
            this.operatorSyncService.setPostOffice(null);
            this.showFieldErrorIfAny(this.operatorSyncService.getPostOfficeError(), this.viewPeer.postOffField);
        }
    }

    private void onPostOfficeValueChanged(DocumentEvent documentEvent) {
        this.updatePoDetails();
    }

    private void onWhiteListedBEFieldItemSelected(ItemEvent itemEvent) {
        if (this.areOpDetailsNull()) {
            return;
        }
        this.clearFieldError(this.viewPeer.isWhiteListed);
        if (itemEvent.getStateChange() == 1) {
            this.operatorSyncService.setWhiteListedForBE(itemEvent.getItem().toString());
            this.showFieldErrorIfAny(this.operatorSyncService.getWhiteListedBEError(), this.viewPeer.isWhiteListed);
        }
    }

    private void onCenterTypeFieldItemSelected(ItemEvent itemEvent) {
        if (this.areOpDetailsNull()) {
            return;
        }
        this.clearFieldError(this.viewPeer.centerTypeField);
        if (itemEvent.getStateChange() == 1) {
            this.operatorSyncService.setCenterType(itemEvent.getItem().toString());
            this.showFieldErrorIfAny(this.operatorSyncService.getCenterTypeError(), this.viewPeer.centerTypeField);
        }
    }

    private void onCenterNameFieldFocusLost(FocusEvent focusEvent) {
        if (this.areOpDetailsNull() || focusEvent.isTemporary()) {
            return;
        }
        this.clearFieldError(this.viewPeer.centerNameField);
        this.operatorSyncService.setCenterName(this.viewPeer.centerNameField.getText());
        this.showFieldErrorIfAny(this.operatorSyncService.getCenterNameError(), this.viewPeer.centerNameField);
    }

    private void onCenterAddressFieldFocusLost(FocusEvent focusEvent) {
        if (this.areOpDetailsNull() || focusEvent.isTemporary()) {
            return;
        }
        this.clearFieldError(this.viewPeer.centerAddrsField);
        this.operatorSyncService.setCenterAddress(this.viewPeer.centerAddrsField.getText());
        this.showFieldErrorIfAny(this.operatorSyncService.getCenterAddressError(), this.viewPeer.centerAddrsField);
    }

    private void onPostOffFieldFocusLost(FocusEvent focusEvent) {
        if (this.areOpDetailsNull() || focusEvent.isTemporary()) {
            return;
        }
        this.updatePoDetails();
    }

    private void updatePoDetails() {
        PostOffice selectedOption;
        String po = null;
        this.clearFieldError(this.viewPeer.postOffField);
        if (StringUtils.isNotBlank((String)this.viewPeer.postOffField.getText())) {
            po = this.viewPeer.postOffField.getText();
        } else if (this.viewPeer.postOffField.getSelectedOption() instanceof PostOffice && (selectedOption = (PostOffice)this.viewPeer.postOffField.getSelectedOption()) != null) {
            po = selectedOption.getName();
        }
        this.operatorSyncService.setPostOffice(po);
        this.showFieldErrorIfAny(this.operatorSyncService.getPostOfficeError(), this.viewPeer.postOffField);
    }

    private void onPinCodeFieldFocusLost(FocusEvent focusEvent) {
        if (this.areOpDetailsNull() || focusEvent.isTemporary() || this.viewPeer.pinCodeField.getSelectedOption() != null && !(this.viewPeer.pinCodeField.getSelectedOption() instanceof PostalAddress)) {
            return;
        }
        PostalAddress selectedOption = (PostalAddress)this.viewPeer.pinCodeField.getSelectedOption();
        this.clearFieldError(this.viewPeer.pinCodeField);
        this.clearFieldError(this.viewPeer.vtcField);
        this.operatorSyncService.setPincode(selectedOption != null ? selectedOption.getPinCode().getAddressValue() : null);
        this.operatorSyncService.setVtcDetails(selectedOption != null ? selectedOption.getVtc().getAddressValue() : null);
        this.operatorSyncService.setSubDistrict(selectedOption != null ? selectedOption.getSubDistrict().getAddressValue() : null);
        this.operatorSyncService.setDistrict(selectedOption != null ? selectedOption.getDistrict().getAddressValue() : null);
        this.operatorSyncService.setState(selectedOption != null ? selectedOption.getState().getAddressValue() : null);
        this.showFieldErrorIfAny(this.operatorSyncService.getPinCodeError(), this.viewPeer.pinCodeField);
        this.showFieldErrorIfAny(this.operatorSyncService.getVTCError(), this.viewPeer.vtcField);
    }

    private void showFieldErrorIfAny(String errorMessage, JComponent field) {
        if (this.operatorSyncService.operatorDetailsValid()) {
            return;
        }
        if (StringUtils.isNotEmpty((String)errorMessage)) {
            SwingUtilities.invokeLater(() -> this.showFieldError(field, errorMessage));
        }
    }

    private boolean areOpDetailsNull() {
        return this.operatorSyncService.getOperatorDetails() == null;
    }

    private void addDialogBoxSwitchListeners() {
        this.viewPeer.pinCodeField.addPopupMenuListener((PopupMenuListener)this.eventContext.getEventListener("hID_DemoTab_SPinCodePopup", PopupMenuListener.class));
        this.viewPeer.pinCodeField.addFocusListener((FocusListener)this.eventContext.getEventListener("hID_DemoTab_SPinCodePropagate_Operator", FocusListener.class));
        this.viewPeer.okBtn.addActionListener((ActionListener)this.eventContext.getEventListener("hId_On_Operator_Sync_Otp_Details_Submit", ActionListener.class));
        this.viewPeer.cancelBtn.addActionListener((ActionListener)this.eventContext.getEventListener("hID_On_Operator_Sync_Escape", ActionListener.class));
    }

    private void populateView() {
        OperatorDetails opDetails = this.viewPeer.operatorSyncService.getOperatorDetails();
        if (this.areOpDetailsNull()) {
            return;
        }
        this.viewPeer.registrarField.setText(opDetails.getRegistrarName());
        this.viewPeer.eaField.setText(opDetails.getEnrolmentAgencyName());
        this.viewPeer.stationIdField.setText(opDetails.getStationId());
        this.viewPeer.centerIdField.setText(opDetails.getCenterId());
        this.viewPeer.centerNameField.setText(opDetails.getCenterName());
        int centerIdx = Arrays.asList(this.viewPeer.centerOptions).indexOf(opDetails.getCenterType());
        this.viewPeer.centerTypeField.setSelectedIndex(centerIdx == -1 ? 0 : centerIdx);
        this.viewPeer.centerAddrsField.setText(opDetails.getCenterAddress());
        this.viewPeer.vtcField.setText(opDetails.getVtcDetails());
        this.viewPeer.subDistField.setText(opDetails.getSubDistrict());
        this.viewPeer.districtField.setText(opDetails.getDistrict());
        this.viewPeer.stateField.setText(opDetails.getState());
        this.viewPeer.postOffField.setText(opDetails.getPostOffice());
        this.viewPeer.pinCodeField.setText(opDetails.getPincode());
        this.viewPeer.opIdField.setText(this.viewPeer.operatorSyncService.getOpId());
        this.viewPeer.opNameField.setText(opDetails.getOpName());
        this.viewPeer.opUIDField.setText(opDetails.getOpUid());
        this.viewPeer.opMobileField.setText(opDetails.getOpMobile());
        int whiteListedIdx = Arrays.asList(this.viewPeer.whiteListedOptions).indexOf(opDetails.getWhiteListedForBE());
        this.viewPeer.isWhiteListed.setSelectedIndex(whiteListedIdx == -1 ? 0 : whiteListedIdx);
        this.viewPeer.latitudeField.setText(opDetails.getLatitude());
        this.viewPeer.longitudeField.setText(opDetails.getLongitude());
        this.viewPeer.altitudeField.setText(opDetails.getAltitude());
    }

    private void initViewErrors() {
        this.operatorSyncService.validateView();
        this.showFieldErrorIfAny(this.operatorSyncService.getWhiteListedBEError(), this.viewPeer.isWhiteListed);
        this.showFieldErrorIfAny(this.operatorSyncService.getCenterTypeError(), this.viewPeer.centerTypeField);
        this.showFieldErrorIfAny(this.operatorSyncService.getCenterNameError(), this.viewPeer.centerNameField);
        this.showFieldErrorIfAny(this.operatorSyncService.getCenterAddressError(), this.viewPeer.centerAddrsField);
        this.showFieldErrorIfAny(this.operatorSyncService.getPostOfficeError(), this.viewPeer.postOffField);
        this.showFieldErrorIfAny(this.operatorSyncService.getPinCodeError(), this.viewPeer.pinCodeField);
        this.showFieldErrorIfAny(this.operatorSyncService.getVTCError(), this.viewPeer.vtcField);
    }
}

