/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.opsync;

import in.gov.uidai.ec.biometrics.device.DeviceType;
import in.gov.uidai.ec.service.biometricsauth.AuthParamType;
import in.gov.uidai.ec.service.biometricsauth.BiometricsAuthService;
import in.gov.uidai.ec.service.opsync.OperatorSyncService;
import in.gov.uidai.ec.service.session.model.ResumePassword;
import in.gov.uidai.ec.ui.ControllerBase;
import in.gov.uidai.ec.ui.biometricsauth.BiometricsNonRDAuthPanel;
import in.gov.uidai.ec.ui.biometricsauth.BiometricsRDAuthPanel;
import in.gov.uidai.ec.ui.opsync.IOpSyncFormConstants;
import in.gov.uidai.ec.ui.opsync.OperatorSyncOtpAndBioCaptureViewPeer;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.swing.bio.confirm.BiometricsNonRDField;
import in.gov.uidai.swing.bio.confirm.BiometricsRDField;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Objects;
import javax.swing.JFormattedTextField;

public class OperatorSyncOtpAndBioCaptureController
extends ControllerBase
implements IOpSyncFormConstants {
    private final OperatorSyncOtpAndBioCaptureViewPeer viewPeer;
    private final BiometricsNonRDAuthPanel biometricsNonRDAuthPanel;
    private final BiometricsRDAuthPanel biometricsRDAuthPanel;
    private final BiometricsAuthService biometricsAuthService;
    private final OperatorSyncService operatorSyncService;
    private final boolean useRDDevices;
    private final AuthParamType authParamType;
    private boolean isBioCaptureValid;
    private boolean isOtpValid;

    public OperatorSyncOtpAndBioCaptureController(OperatorSyncOtpAndBioCaptureViewPeer viewPeer, OperatorSyncService operatorSyncService, BiometricsAuthService biometricsAuthService, BiometricsNonRDAuthPanel biometricsNonRDAuthPanel, BiometricsRDAuthPanel biometricsRDAuthPanel, IEventContext eventContext) {
        super(viewPeer.getView());
        this.viewPeer = viewPeer;
        this.biometricsNonRDAuthPanel = biometricsNonRDAuthPanel;
        this.biometricsRDAuthPanel = biometricsRDAuthPanel;
        this.useRDDevices = biometricsRDAuthPanel != null && biometricsNonRDAuthPanel == null;
        this.operatorSyncService = operatorSyncService;
        this.biometricsAuthService = biometricsAuthService;
        this.viewPeer.fingerOption.addItemListener(this::bioTypeOptionSelected);
        this.viewPeer.irisOption.addItemListener(this::bioTypeOptionSelected);
        this.viewPeer.okBtn.addActionListener((ActionListener)eventContext.getEventListener("hID_On_OpSync_Otp_Submit", ActionListener.class));
        this.viewPeer.cancelBtn.addActionListener((ActionListener)eventContext.getEventListener("hID_On_OpSync_Otp_Submit_Escape", ActionListener.class));
        this.viewPeer.okBtn.setEnabled(false);
        this.authParamType = this.operatorSyncService.getAuthParamType();
        String opUid = this.viewPeer.sessionService.getOperatorCredentials().getUid();
        if (this.useRDDevices) {
            this.initViewForRD();
        } else {
            this.initViewForNonRD();
        }
        this.addKeyReleasedListener(this.viewPeer.otpField, this::onOtpFieldChanged);
    }

    private void initViewForRD() {
        BiometricsRDField rdFingerAuthField = this.biometricsRDAuthPanel.getRDBioField(this.authParamType, DeviceType.FINGERPRINT_AUTH);
        BiometricsRDField rdIrisAuthField = this.biometricsRDAuthPanel.getRDBioField(this.authParamType, DeviceType.IRIS_AUTH);
        this.biometricsAuthService.getRdAuthBiometrics().addValidityChangeListener(this::onRDBioAuthValidityChange);
        this.operatorSyncService.setFingerAndIrisStatus(rdFingerAuthField.isEnabled(), rdIrisAuthField.isEnabled());
        rdFingerAuthField.setEnabled(false);
        rdIrisAuthField.setEnabled(false);
    }

    private void initViewForNonRD() {
        BiometricsNonRDField fingerAuthField = this.biometricsNonRDAuthPanel.fingerAuthField;
        BiometricsNonRDField irisConfirmField = this.biometricsNonRDAuthPanel.irisConfirmField;
        this.biometricsAuthService.getSingleFingerAuth().addValidityChangeListener(this::onNonRDFingerAuthValidityChange);
        this.biometricsAuthService.getLeftIrisAuth().addValidityChangeListener(this::onNonRDIrisAuthValidityChange);
        this.operatorSyncService.setFingerAndIrisStatus(fingerAuthField.isEnabled(), irisConfirmField.isEnabled());
        fingerAuthField.setEnabled(false);
        irisConfirmField.setEnabled(false);
    }

    private void addKeyReleasedListener(JFormattedTextField field, final IKeyReleasedListener l) {
        field.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                l.keyReleased(e);
            }
        });
    }

    private void onOtpFieldChanged(KeyEvent keyEvent) {
        ResumePassword opSyncOtp = this.viewPeer.sessionService.getOperatorLoginDetails().getResumePassword();
        String otp = String.valueOf(this.viewPeer.otpField.getText());
        if (!Objects.equals(opSyncOtp.getOpSyncOtp(), otp)) {
            this.biometricsAuthService.clear();
            this.isBioCaptureValid = false;
            opSyncOtp.setOpSyncOtp(otp);
            this.setOtpForRdDeviceCapture(otp);
        }
        this.clearFieldError(this.viewPeer.otpField);
        if (!opSyncOtp.isValid()) {
            this.showFieldError(this.viewPeer.otpField, opSyncOtp.getError());
            this.isOtpValid = false;
        } else {
            this.isOtpValid = true;
        }
        this.toggleBioCaptureState(this.isOtpValid);
        this.validate();
    }

    private void toggleBioCaptureState(boolean isOtpValid) {
        if (this.operatorSyncService.isFingerEnabled()) {
            BiometricsNonRDField fingerField;
            if (this.useRDDevices) {
                fingerField = this.biometricsRDAuthPanel.getRDBioField(this.authParamType, DeviceType.FINGERPRINT_AUTH);
                fingerField.setEnabled(isOtpValid);
                fingerField.clearCaptureAttempt();
            } else {
                fingerField = this.biometricsNonRDAuthPanel.fingerAuthField;
                fingerField.setEnabled(isOtpValid);
                fingerField.clearCaptureAttempt();
            }
        }
        if (this.operatorSyncService.isIrisEnabled()) {
            BiometricsNonRDField irisField;
            if (this.useRDDevices) {
                irisField = this.biometricsRDAuthPanel.getRDBioField(this.authParamType, DeviceType.IRIS_AUTH);
                irisField.setEnabled(isOtpValid);
                irisField.clearCaptureAttempt();
            } else {
                irisField = this.biometricsNonRDAuthPanel.irisConfirmField;
                irisField.setEnabled(isOtpValid);
                irisField.clearCaptureAttempt();
            }
        }
    }

    private void setOtpForRdDeviceCapture(String otp) {
        if (!this.useRDDevices || this.biometricsRDAuthPanel == null) {
            return;
        }
        BiometricsRDField fingerRdBioField = this.biometricsRDAuthPanel.getRDBioField(this.authParamType, DeviceType.FINGERPRINT_AUTH);
        fingerRdBioField.setOtpForPidOptions(otp);
        BiometricsRDField irisRdBioField = this.biometricsRDAuthPanel.getRDBioField(this.authParamType, DeviceType.IRIS_AUTH);
        irisRdBioField.setOtpForPidOptions(otp);
    }

    private void bioTypeOptionSelected(ItemEvent ie) {
        if (ie.getStateChange() != 1) {
            return;
        }
        if (this.useRDDevices) {
            this.onBioOptionSelectedForRD();
        } else {
            this.onBioOptionSelectedForNonRD();
        }
    }

    private void onBioOptionSelectedForRD() {
        BiometricsRDField rdFingerAuthField = this.biometricsRDAuthPanel.getRDBioField(this.authParamType, DeviceType.FINGERPRINT_AUTH);
        BiometricsRDField rdIrisAuthField = this.biometricsRDAuthPanel.getRDBioField(this.authParamType, DeviceType.IRIS_AUTH);
        rdFingerAuthField.clearCaptureAttempt();
        rdIrisAuthField.clearCaptureAttempt();
        this.biometricsAuthService.getRdAuthBiometrics().clearAll();
        if (this.viewPeer.btnGrp == null) {
            return;
        }
        String actionCommand = this.viewPeer.btnGrp.getSelection().getActionCommand();
        boolean isFingerEnabled = actionCommand.equals(AuthParamType.FINGER.toString());
        rdFingerAuthField.setEnabled(isFingerEnabled);
        boolean isIrisEnabled = actionCommand.equals(AuthParamType.IRIS.toString());
        rdIrisAuthField.setEnabled(isIrisEnabled);
        this.operatorSyncService.setFingerAndIrisStatus(isFingerEnabled, isIrisEnabled);
    }

    private void onBioOptionSelectedForNonRD() {
        BiometricsNonRDField fingerAuthField = this.biometricsNonRDAuthPanel.fingerAuthField;
        BiometricsNonRDField irisConfirmField = this.biometricsNonRDAuthPanel.irisConfirmField;
        fingerAuthField.clearCaptureAttempt();
        irisConfirmField.clearCaptureAttempt();
        this.biometricsAuthService.getSingleFingerAuth().clear();
        this.biometricsAuthService.getLeftIrisAuth().clear();
        if (this.viewPeer.btnGrp == null) {
            return;
        }
        String actionCommand = this.viewPeer.btnGrp.getSelection().getActionCommand();
        boolean isFingerEnabled = actionCommand.equals(AuthParamType.FINGER.toString());
        fingerAuthField.setEnabled(isFingerEnabled);
        boolean isIrisEnabled = actionCommand.equals(AuthParamType.IRIS.toString());
        irisConfirmField.setEnabled(isIrisEnabled);
        this.operatorSyncService.setFingerAndIrisStatus(isFingerEnabled, isIrisEnabled);
    }

    private void onRDBioAuthValidityChange(boolean valid) {
        boolean fingerEnabled = this.operatorSyncService.isFingerEnabled();
        boolean irisEnabled = this.operatorSyncService.isIrisEnabled();
        if (this.useRDDevices && fingerEnabled) {
            this.isBioCaptureValid = this.biometricsAuthService.getRdAuthBiometrics().isCaptureValid(this.authParamType, DeviceType.FINGERPRINT_AUTH);
        }
        if (this.useRDDevices && irisEnabled) {
            this.isBioCaptureValid = this.biometricsAuthService.getRdAuthBiometrics().isCaptureValid(this.authParamType, DeviceType.IRIS_AUTH);
        }
        this.validate();
    }

    private void onNonRDFingerAuthValidityChange(boolean valid) {
        if (!this.useRDDevices && this.operatorSyncService.isFingerEnabled()) {
            this.isBioCaptureValid = valid;
        }
        this.validate();
    }

    private void onNonRDIrisAuthValidityChange(boolean valid) {
        if (!this.useRDDevices && this.operatorSyncService.isIrisEnabled()) {
            this.isBioCaptureValid = valid;
        }
        this.validate();
    }

    private void validate() {
        this.viewPeer.okBtn.setEnabled(this.isOtpValid && this.isBioCaptureValid);
    }

    private static interface IKeyReleasedListener {
        public void keyReleased(KeyEvent var1);
    }
}

