/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.opsync;

import in.gov.uidai.ec.ecmpapi.CIDRStatus;
import in.gov.uidai.ec.ecmpapi.EcmpApiBusinessException;
import in.gov.uidai.ec.ecmpapi.EcmpApiService;
import in.gov.uidai.ec.ecmpapi.xml.Gps.GpsDataReadReq;
import in.gov.uidai.ec.ecmpapi.xml.Gps.GpsValidationResponse;
import in.gov.uidai.ec.ecmpapi.xml.operatorsync.OperatorCenterSyncErrorCode;
import in.gov.uidai.ec.ecmpapi.xml.operatorsync.OperatorCenterSyncResponse;
import in.gov.uidai.ec.ecmpapi.xml.operatorsync.OperatorCenterSyncResult;
import in.gov.uidai.ec.ecmpapi.xml.operatorsync.Result;
import in.gov.uidai.ec.escapi.GpsInfo;
import in.gov.uidai.ec.escapi.StationInfoStoreException;
import in.gov.uidai.ec.icas.preference.IOucDataStore;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.biometricsauth.BiometricsAuthService;
import in.gov.uidai.ec.service.opsync.OperatorSyncService;
import in.gov.uidai.ec.service.packetgenerator.xml.GpsDataType;
import in.gov.uidai.ec.service.session.ISessionService;
import in.gov.uidai.ec.service.session.model.ResumePassword;
import in.gov.uidai.ec.service.verification.VerificationService;
import in.gov.uidai.ec.ui.main.MainWinControl;
import in.gov.uidai.ec.ui.opsync.IOpSyncFormConstants;
import in.gov.uidai.ec.ui.shared.VerificationGuard;
import in.gov.uidai.ec.ui.shared.l10n.MsgKeysOperatorSync;
import in.gov.uidai.litef.devapi.EventHandler;
import in.gov.uidai.litef.devapi.ILiteEvent;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.litef.devapi.IOnScreenDisplay;
import in.gov.uidai.litef.devapi.IOnScreenDisplayAware;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.litef.devapi.ScaffoldPlacement;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatorSyncWidgetController
implements IOnScreenDisplayAware,
IOpSyncFormConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperatorSyncWidgetController.class);
    private static String detailsWinScaffoldId;
    private IResourceBundleContext rbCtxt;
    private ISessionService sessionService;
    private OperatorSyncService operatorSyncService;
    private IOnScreenDisplay osd;
    private BiometricsAuthService biometricsAuthService;
    private VerificationGuard verificationGuard;
    private MainWinControl mainWinCtrl;
    private IOucDataStore oucDataStore;
    private EcmpApiService ecmpApiService;
    private static final DecimalFormat GPS_FORMAT;

    public void setOucDataStore(IOucDataStore oucDataStore) {
        this.oucDataStore = oucDataStore;
    }

    public void setEcmpApiService(EcmpApiService ecmpApiService) {
        this.ecmpApiService = ecmpApiService;
    }

    public void setSessionService(ISessionService sessionService) {
        this.sessionService = sessionService;
    }

    public void setBiometricsAuthService(BiometricsAuthService biometricsAuthService) {
        this.biometricsAuthService = biometricsAuthService;
    }

    public void setOperatorSyncService(OperatorSyncService operatorSyncService) {
        this.operatorSyncService = operatorSyncService;
    }

    public void setVerificationGuard(VerificationGuard verificationGuard) {
        this.verificationGuard = verificationGuard;
    }

    public void setMainWinCtrl(MainWinControl mainWinCtrl) {
        this.mainWinCtrl = mainWinCtrl;
    }

    public void populateOnScreenDisplay(IOnScreenDisplay osd) {
        this.osd = osd;
    }

    public final void setResourceBundleContext(IResourceBundleContext ctxt) {
        this.rbCtxt = ctxt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(name="hID_On_Operator_Sync", method="actionPerformed")
    public void onOperatorSync(ILiteEvent evt) {
        IVisualExecutionContext veCtxt = this.osd.getView(evt.getViewId()).getVisualExecutionContext();
        this.showProgressBar(veCtxt, "Loading details for operator..");
        try {
            this.operatorSyncService.init();
        }
        catch (Exception e) {
            LOGGER.error("Fetching operator details failed", (Throwable)e);
            this.showErrorPopup(evt, veCtxt, "Failed to read operator details from Aadhaar Enrol Service Client");
            return;
        }
        finally {
            this.cancelProgressBar(veCtxt);
        }
        try {
            this.showProgressBar(veCtxt, "Syncing operator details with server. Please wait.");
            CIDRStatus status = this.operatorSyncService.makePreSyncRequest();
            if (status != null && status.equals((Object)CIDRStatus.SUCCESS)) {
                this.cancelProgressBar(veCtxt);
                if (!this.verificationGuard.verifyOnStartUp(VerificationService.Type.OperatorSync, evt)) {
                    return;
                }
                try {
                    detailsWinScaffoldId = this.osd.compose(evt.getScaffoldId(), "operatorDetailsSyncWin", "operatorDetailsSyncView");
                    this.osd.display(detailsWinScaffoldId, ScaffoldPlacement.CENTERED);
                }
                catch (Exception e) {
                    this.cancelProgressBar(veCtxt);
                    LOGGER.warn("Operator Sync issue. ", (Throwable)e);
                }
            } else {
                if (status != null) {
                    LOGGER.error("PreSync with Server failed with status " + status.getDescription());
                } else {
                    LOGGER.error("PreSync with Server failed with unknown status");
                }
                this.showErrorPopup(evt, veCtxt, "Failed to sync operator details with Server. Please try again.");
            }
        }
        catch (IOException e) {
            LOGGER.error("PreSync with Server failed with network exception", (Throwable)e);
            if (this.operatorSyncService.isAutoLaunchEnabled()) {
                this.showErrorPopup(evt, veCtxt, "Failed to perform online login due to network issue. Please check your internet connection and try again.");
            } else {
                this.showErrorPopup(evt, veCtxt, "Failed to sync operator details due to network issue. Please check your internet connection and try again.");
            }
        }
        catch (Exception e) {
            LOGGER.error("PreSync with Server failed", (Throwable)e);
            this.showErrorPopup(evt, veCtxt, "Failed to sync operator details with Server. Please try again.");
        }
        finally {
            this.operatorSyncService.setAutoLaunch(false);
            this.cancelProgressBar(veCtxt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(name="hId_On_Operator_Sync_Otp_Details_Submit", method="actionPerformed")
    public void opDetailsSubmit(ILiteEvent evt) {
        ILiteView view = this.osd.getView(evt.getViewId());
        IVisualExecutionContext veCtxt = view.getVisualExecutionContext();
        this.showProgressBar(veCtxt, "Processing operator details. Please wait.");
        try {
            OperatorCenterSyncResponse opSyncResponse = this.operatorSyncService.makeDetailsSubmitCall();
            if (opSyncResponse.getResult().equals((Object)Result.FAILURE)) {
                this.operatorSyncFailureHandler(evt, veCtxt, opSyncResponse);
                return;
            }
            LOGGER.debug("opSyncResponse" + opSyncResponse);
        }
        catch (IOException e) {
            LOGGER.error("Operator Sync failed due to network error.", (Throwable)e);
            this.showErrorPopup(evt, veCtxt, "Operator Sync failed due to network error. Please try again.");
            return;
        }
        catch (EcmpApiBusinessException e) {
            LOGGER.error(e.getMessage());
            this.showErrorPopup(evt, veCtxt, e.getMessage());
            return;
        }
        catch (Exception e) {
            LOGGER.error("Error during Operator Sync", (Throwable)e);
            this.showErrorPopup(evt, veCtxt, "Operator Sync Failed. Please try again. " + e.getMessage());
            return;
        }
        finally {
            this.cancelProgressBar(veCtxt);
        }
        String otpWinScaffoldId = this.osd.compose("operatorOTPWin", "operatorOTPView");
        this.osd.display(otpWinScaffoldId, ScaffoldPlacement.CENTERED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(name="hID_On_OpSync_Otp_Submit", method="actionPerformed")
    public void otpSubmit(ILiteEvent evt) {
        block22: {
            LOGGER.info("OperatorSyncFormControl : otpSubmit : Start");
            ResumePassword opSyncOtp = this.sessionService.getOperatorLoginDetails().getResumePassword();
            Window windowForScaffold = this.osd.getWindowForScaffold(evt.getScaffoldId());
            if (!opSyncOtp.isValid()) {
                L10nOptionPaneBuilder.getInstance().showError((Object)opSyncOtp.getError(), (Component)windowForScaffold, new Object[0]);
                return;
            }
            this.sessionService.clearCurrentSession();
            ILiteView view = this.osd.getView(evt.getViewId());
            IVisualExecutionContext veCtxt = view.getVisualExecutionContext();
            this.showProgressBar(veCtxt, "Verifying operator biometrics and OTP. Please wait.");
            try {
                OperatorCenterSyncResponse opSyncResponse = this.operatorSyncService.makeOTPSubmitCall();
                if (opSyncResponse.getResult().equals((Object)Result.FAILURE)) {
                    this.operatorSyncFailureHandler(evt, veCtxt, opSyncResponse);
                    if (((OperatorCenterSyncResult)opSyncResponse.getOperatorCenterSyncResults().get(0)).getErrorCode() != OperatorCenterSyncErrorCode.AUTH_FAILED) {
                        this.osd.dispose(evt.getScaffoldId());
                    }
                    break block22;
                }
                try {
                    this.operatorSyncService.saveOnOTPSubmit();
                }
                catch (Exception e) {
                    this.cancelProgressBar(veCtxt);
                    LOGGER.warn("Error: ", (Throwable)e);
                }
                try {
                    this.operatorSyncService.saveSessionData(opSyncResponse.getSessionData());
                }
                catch (Exception e) {
                    LOGGER.error("Unable to create session. ", (Throwable)e);
                    this.cancelProgressBar(veCtxt);
                    L10nOptionPaneBuilder.getInstance().createErrorPane().message((Object)("Unable to create session." + e.getMessage()), new Object[0]).title("Internal Error").show((Component)this.osd.getWindowForScaffold(evt.getScaffoldId()));
                    this.osd.dispose(evt.getScaffoldId());
                    return;
                }
                this.cancelProgressBar(veCtxt);
                MsgKeysOperatorSync successMsgKey = this.sessionService.getOperatorCredentials().isOnboard() ? MsgKeysOperatorSync.OPERATOR_SYNC_SUCCESSFUL : MsgKeysOperatorSync.ONLINE_LOGIN_SUCCESSFUL;
                L10nOptionPaneBuilder.getInstance().createInfoPane().message((Object)this.rbCtxt.getMessage((Object)successMsgKey, new Object[0]), new Object[0]).title("Operator Sync Successful").show((Component)this.osd.getWindowForScaffold(evt.getScaffoldId()));
                this.osd.dispose(detailsWinScaffoldId);
                try {
                    String connectType = new String(Files.readAllBytes(Paths.get("./conf/connect.type", new String[0])));
                    if (connectType.equalsIgnoreCase(this.sessionService.getConnectTypeKey())) {
                        LOGGER.info("Connect type from DB ::: " + this.sessionService.getConnectTypeKey());
                        LOGGER.info("Connect type from Local ::: " + connectType);
                        try {
                            GpsDataType gpsDataType = this.getGpsData();
                            GpsDataReadReq gpsDataReadReq = new GpsDataReadReq();
                            gpsDataReadReq.setLatitude(Float.parseFloat(gpsDataType.getLatitude()));
                            gpsDataReadReq.setLongitude(Float.parseFloat(gpsDataType.getLongitude()));
                            GpsValidationResponse gpsValidationResponse = this.ecmpApiService.makeGPSValidationApiCall(gpsDataReadReq);
                            if (gpsValidationResponse.getIntValidGPS() == 0) {
                                LOGGER.info("GPS co-ordinates are not valid: " + gpsDataType.getLatitude() + ":" + gpsDataType.getLongitude() + ":" + gpsDataType.getAltitude() + ":" + System.currentTimeMillis());
                                L10nOptionPaneBuilder.getInstance().showError((Object)"GPS co-ordinates are not valid. Please capture it again", null, new Object[0]);
                                this.mainWinCtrl.disableButtonsAfterClientTypeError();
                            } else {
                                LOGGER.info("Valid GPS co-ordinates : " + gpsDataType.getLatitude() + ":" + gpsDataType.getLongitude() + ":" + gpsDataType.getAltitude() + ":" + System.currentTimeMillis());
                                this.mainWinCtrl.showOpDisclosurePopup();
                            }
                        }
                        catch (Exception e) {
                            LOGGER.info("GPS call failed");
                        }
                        this.mainWinCtrl.showOpDisclosurePopup();
                        break block22;
                    }
                    this.mainWinCtrl.disableButtonsAfterClientTypeError();
                    throw new UnsupportedOperationException();
                }
                catch (UnsupportedOperationException e) {
                    this.showErrorPopup(evt, veCtxt, this.rbCtxt.getMessage((Object)MsgKeysOperatorSync.CLIENT_VERIFICATION_ERROR, new Object[0]), "Client Type Mismatch Error");
                }
            }
            catch (IOException e) {
                this.showErrorPopup(evt, veCtxt, "Operator Sync failed due to network error. Please try again. " + e.getMessage(), "Network Error");
            }
            catch (Exception e) {
                this.showErrorPopup(evt, veCtxt, this.rbCtxt.getMessage((Object)MsgKeysOperatorSync.OTP_VERIFICATION_ERROR, new Object[0]), "Authentication Error");
            }
            finally {
                this.osd.dispose(evt.getScaffoldId());
            }
        }
    }

    private GpsDataType getGpsData() throws IOException, StationInfoStoreException {
        GpsDataType gpsDataType = new GpsDataType();
        GpsInfo gpsInfo = this.oucDataStore.getGpsInfo();
        float latitude = gpsInfo.getLatitude().floatValue();
        float longitude = gpsInfo.getLongitude().floatValue();
        float altitude = gpsInfo.getAltitude().floatValue();
        if (latitude == -1.0f && longitude == -1.0f && altitude == -1.0f) {
            return null;
        }
        if (latitude >= 0.0f) {
            gpsDataType.setLatitude(GPS_FORMAT.format(latitude));
        }
        if (longitude >= 0.0f) {
            gpsDataType.setLongitude(GPS_FORMAT.format(longitude));
        }
        if (altitude >= 0.0f) {
            gpsDataType.setAltitude(GPS_FORMAT.format(altitude));
        }
        return gpsDataType;
    }

    private void operatorSyncFailureHandler(ILiteEvent evt, IVisualExecutionContext veCtxt, OperatorCenterSyncResponse opSyncResponse) {
        this.cancelProgressBar(veCtxt);
        List list = opSyncResponse.getOperatorCenterSyncResults();
        LOGGER.info("list::" + list);
        OperatorCenterSyncResult result = (OperatorCenterSyncResult)list.get(0);
        LOGGER.info("list result::" + result);
        String errorCode = StringUtils.isNotBlank((String)result.getErrorCode().value()) ? " due to " + result.getErrorCode() : "";
        String message = "Operator Sync failed" + errorCode + ". Please try again";
        String resultErrorMessage = result.getErrorMessage();
        String opSyncResponseErrorMessage = opSyncResponse.getErrorMessage();
        if (StringUtils.isNotBlank((String)resultErrorMessage)) {
            message = resultErrorMessage;
        }
        if (StringUtils.isNotBlank((String)opSyncResponseErrorMessage) && !opSyncResponseErrorMessage.equals(resultErrorMessage)) {
            message = opSyncResponseErrorMessage + " \n" + message;
        }
        LOGGER.error("Operator Sync Failed, " + message + ", " + result.getErrorCode() + ", ErrorCodeType: " + opSyncResponse.getErrorCodeType());
        L10nOptionPaneBuilder.getInstance().createErrorPane().message((Object)message, new Object[0]).title("Authentication Error").show((Component)this.osd.getWindowForScaffold(evt.getScaffoldId()));
    }

    private void cancelProgressBar(IVisualExecutionContext veCtxt) {
        if (veCtxt != null) {
            veCtxt.cancel();
        }
    }

    private void showProgressBar(IVisualExecutionContext veCtxt, String s) {
        if (veCtxt != null) {
            veCtxt.reset();
            veCtxt.setMessage(s);
        }
    }

    private void showErrorPopup(ILiteEvent evt, IVisualExecutionContext veCtxt, String message, String title) {
        this.cancelProgressBar(veCtxt);
        L10nOptionPaneBuilder.getInstance().createErrorPane().message((Object)message, new Object[0]).title(title).show((Component)this.osd.getWindowForScaffold(evt.getScaffoldId()));
    }

    private void showErrorPopup(ILiteEvent evt, IVisualExecutionContext veCtxt, String message) {
        this.cancelProgressBar(veCtxt);
        L10nOptionPaneBuilder.getInstance().showError((Object)message, (Component)this.osd.getWindowForScaffold(evt.getScaffoldId()), new Object[0]);
    }

    @EventHandler(name="hID_On_OpSync_Otp_Submit_Escape", method="actionPerformed")
    public void onOtpSubmitEscCloseWin(ILiteEvent evt) {
        this.disposeView(evt);
        this.biometricsAuthService.clear();
    }

    @EventHandler(name="hID_On_Operator_Sync_Escape", method="actionPerformed")
    public void onEscCloseWin(ILiteEvent evt) {
        this.disposeView(evt);
        this.operatorSyncService.clear();
        this.biometricsAuthService.clear();
    }

    private void disposeView(ILiteEvent evt) {
        String scaffoldId = evt.getScaffoldId();
        this.osd.dispose(scaffoldId);
    }

    static {
        GPS_FORMAT = new DecimalFormat("00000.00");
    }
}

