/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.report;

import in.gov.uidai.ec.swing.shared.ViewUtils;
import in.gov.uidai.ec.ui.report.IBioxField;
import in.gov.uidai.swing.fontman.FontManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public abstract class BioxOverlayField
extends JComponent
implements IBioxField {
    private final Map<String, Rectangle> hotSpotMap = new HashMap<String, Rectangle>();
    private final Map<String, Boolean> toggleMap = new HashMap<String, Boolean>();
    private final ImageIcon ovlIcon = ViewUtils.getImageIcon(this.getClass(), "res/images/missing-bio.png");
    private ImageIcon bioPic;
    private String title;

    protected BioxOverlayField() {
        this.setFont(FontManager.getInst().getScreenFont("broadside.ttf", 1, 14));
    }

    protected final void setBioPic(String path) {
        this.bioPic = ViewUtils.getImageIcon(this.getClass(), path);
    }

    protected final void addHotSpot(String name, int x, int y, int width, int height) {
        Rectangle hotSpot = new Rectangle(x, y, width, height);
        this.hotSpotMap.put(name, hotSpot);
        this.toggleMap.put(name, true);
    }

    protected final void toggleBioPresent(String name) {
        if (this.toggleMap.containsKey(name)) {
            this.toggleMap.put(name, this.toggleMap.get(name) == false);
        }
        this.repaint();
    }

    protected final boolean isBioPresent(String name) {
        if (this.toggleMap.containsKey(name)) {
            return this.toggleMap.get(name);
        }
        return false;
    }

    protected final void setBioPresent(String name, boolean flag) {
        this.toggleMap.put(name, flag);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public final void reset() {
        for (String s : this.toggleMap.keySet()) {
            this.toggleMap.put(s, true);
        }
        this.repaint();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.bioPic == null) {
            return new Dimension(1, 1);
        }
        int titleHeight = 0;
        if (this.title != null && this.getFont() != null) {
            Font compFont = this.getFont();
            FontMetrics fm = this.getFontMetrics(compFont);
            titleHeight = fm.getHeight() + 5;
        }
        return new Dimension(this.bioPic.getIconWidth(), this.bioPic.getIconHeight() + titleHeight);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Font compFont;
        FontMetrics fm;
        int textWidth;
        if (this.bioPic == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        Dimension dim = this.getSize();
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 0, dim.width, dim.height);
        if (dim.height < this.bioPic.getIconHeight()) {
            return;
        }
        if (dim.width < this.bioPic.getIconWidth()) {
            return;
        }
        if (this.bioPic != null) {
            g.drawImage(this.bioPic.getImage(), 0, 0, this);
        }
        for (String key : this.hotSpotMap.keySet()) {
            boolean flag;
            Rectangle hotSpot = this.hotSpotMap.get(key);
            if (hotSpot == null || (flag = this.toggleMap.get(key).booleanValue())) continue;
            this.ovlIcon.paintIcon(this, g2, hotSpot.x, hotSpot.y);
        }
        if (this.title != null && this.getFont() != null && (textWidth = (fm = this.getFontMetrics(compFont = this.getFont())).stringWidth(this.title)) < this.getWidth()) {
            int posx = this.getWidth() / 2 - textWidth / 2;
            int posy = this.getHeight() - 5;
            g.setColor(Color.BLACK);
            g.setFont(compFont);
            g.drawString(this.title, posx, posy);
        }
    }
}

