/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.report;

import in.gov.uidai.ec.ui.report.BioxToggleField;
import in.gov.uidai.qssitv.model.BiometricPosition;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class LeftEyeField
extends BioxToggleField {
    public LeftEyeField() {
        this.setTitle("Left Eye");
        this.setBioPic("res/images/eye-left.png");
        this.setMissingBioPic("res/images/eye-left-miss.png");
        this.addHierarchyListener(evt -> this.createKeyboardBinding());
    }

    @Override
    public List<BiometricPosition> available(List<BiometricPosition> posList) {
        List<BiometricPosition> result = posList;
        if (result == null) {
            result = new ArrayList<BiometricPosition>();
        }
        if (this.isBioPresent()) {
            result.add(BiometricPosition.LEFT_IRIS);
        }
        return result;
    }

    @Override
    public List<BiometricPosition> missing(List<BiometricPosition> posList) {
        List<BiometricPosition> result = posList;
        if (result == null) {
            result = new ArrayList<BiometricPosition>();
        }
        if (!this.isBioPresent()) {
            result.add(BiometricPosition.LEFT_IRIS);
        }
        return result;
    }

    @Override
    public void setMissing(List<BiometricPosition> posList) {
        this.setBioPresent(!posList.contains(BiometricPosition.LEFT_IRIS));
    }

    private void createKeyboardBinding() {
        JRootPane root = SwingUtilities.getRootPane(this);
        if (root == null) {
            return;
        }
        root.getInputMap().put(KeyStroke.getKeyStroke("control F12"), "left-eye");
        AbstractAction axn = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LeftEyeField.this.toggleBioPresent();
            }
        };
        root.getActionMap().put("left-eye", axn);
    }
}

