/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.report;

import in.gov.uidai.ec.ui.report.BioxOverlayField;
import in.gov.uidai.qssitv.model.BiometricPosition;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class LeftHandField
extends BioxOverlayField {
    private static final String FINGER_1 = "finger1";
    private static final String FINGER_2 = "finger2";
    private static final String FINGER_3 = "finger3";
    private static final String FINGER_4 = "finger4";
    private static final String THUMB = "thumb";

    public LeftHandField() {
        this.setTitle("Left Hand");
        this.setBioPic("res/images/hand-left.png");
        this.addHotSpot(THUMB, 6, 110, 40, 40);
        this.addHotSpot(FINGER_1, 51, 22, 40, 40);
        this.addHotSpot(FINGER_2, 100, 5, 40, 40);
        this.addHotSpot(FINGER_3, 137, 15, 40, 40);
        this.addHotSpot(FINGER_4, 170, 49, 40, 40);
        this.enableEvents(8L);
        HierarchyListener hl = evt -> {
            this.createKeyboardBinding(FINGER_1, "control F6");
            this.createKeyboardBinding(FINGER_2, "control F7");
            this.createKeyboardBinding(FINGER_3, "control F8");
            this.createKeyboardBinding(FINGER_4, "control F9");
            this.createKeyboardBinding(THUMB, "control F10");
        };
        this.addHierarchyListener(hl);
    }

    @Override
    public List<BiometricPosition> available(List<BiometricPosition> posList) {
        List<BiometricPosition> result = posList;
        if (result == null) {
            result = new ArrayList<BiometricPosition>();
        }
        if (this.isBioPresent(FINGER_1)) {
            result.add(BiometricPosition.LEFT_INDEX);
        }
        if (this.isBioPresent(FINGER_2)) {
            result.add(BiometricPosition.LEFT_MIDDLE);
        }
        if (this.isBioPresent(FINGER_3)) {
            result.add(BiometricPosition.LEFT_RING);
        }
        if (this.isBioPresent(FINGER_4)) {
            result.add(BiometricPosition.LEFT_LITTLE);
        }
        if (this.isBioPresent(THUMB)) {
            result.add(BiometricPosition.LEFT_THUMB);
        }
        return result;
    }

    @Override
    public List<BiometricPosition> missing(List<BiometricPosition> posList) {
        List<BiometricPosition> result = posList;
        if (result == null) {
            result = new ArrayList<BiometricPosition>();
        }
        if (!this.isBioPresent(FINGER_1)) {
            result.add(BiometricPosition.LEFT_INDEX);
        }
        if (!this.isBioPresent(FINGER_2)) {
            result.add(BiometricPosition.LEFT_MIDDLE);
        }
        if (!this.isBioPresent(FINGER_3)) {
            result.add(BiometricPosition.LEFT_RING);
        }
        if (!this.isBioPresent(FINGER_4)) {
            result.add(BiometricPosition.LEFT_LITTLE);
        }
        if (!this.isBioPresent(THUMB)) {
            result.add(BiometricPosition.LEFT_THUMB);
        }
        return result;
    }

    @Override
    public void setMissing(List<BiometricPosition> posList) {
        this.reset();
        if (posList.contains(BiometricPosition.LEFT_INDEX)) {
            this.setBioPresent(FINGER_1, false);
        }
        if (posList.contains(BiometricPosition.LEFT_MIDDLE)) {
            this.setBioPresent(FINGER_2, false);
        }
        if (posList.contains(BiometricPosition.LEFT_RING)) {
            this.setBioPresent(FINGER_3, false);
        }
        if (posList.contains(BiometricPosition.LEFT_LITTLE)) {
            this.setBioPresent(FINGER_4, false);
        }
        if (posList.contains(BiometricPosition.LEFT_THUMB)) {
            this.setBioPresent(THUMB, false);
        }
    }

    private void createKeyboardBinding(final String name, String shortcut) {
        JRootPane root = SwingUtilities.getRootPane(this);
        if (root == null) {
            return;
        }
        root.getInputMap().put(KeyStroke.getKeyStroke(shortcut), "left-" + name);
        AbstractAction axn = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LeftHandField.this.toggleBioPresent(name);
            }
        };
        root.getActionMap().put("left-" + name, axn);
    }
}

