/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.report;

import in.gov.uidai.ec.grpc.GrpcService;
import in.gov.uidai.ec.icas.preference.TimeInterval;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.icas.util.ApplicationVersion;
import in.gov.uidai.ec.protobuf.UcDemographicServiceProto;
import in.gov.uidai.ec.service.enrol.ECMPDateFormatHelper;
import in.gov.uidai.ec.service.enrol.ECMPDateFormats;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.onboarding.IOnboardingService;
import in.gov.uidai.ec.service.onboarding.UserCredentials;
import in.gov.uidai.ec.service.packet.EnrolSummary;
import in.gov.uidai.ec.service.packet.PacketStatusType;
import in.gov.uidai.ec.service.packet.UenrolSummary;
import in.gov.uidai.ec.service.presync.IServerSyncDAO;
import in.gov.uidai.ec.service.registration.IRegistrationService;
import in.gov.uidai.ec.service.report.CsvReportWriter;
import in.gov.uidai.ec.service.report.EODDetailsSummary;
import in.gov.uidai.ec.service.report.EODReportData;
import in.gov.uidai.ec.service.report.HoldRejectDetailsSummary;
import in.gov.uidai.ec.service.report.HoldRejectReportData;
import in.gov.uidai.ec.service.report.IReportDAO;
import in.gov.uidai.ec.service.report.SupervisorBeSummaryReport;
import in.gov.uidai.ec.service.report.VelocityHelper;
import in.gov.uidai.ec.service.session.ISessionService;
import in.gov.uidai.ec.telemetry.TelemetryService;
import in.gov.uidai.ec.ui.enrol.universalClient.common.CommonUtilsUC;
import in.gov.uidai.ec.ui.main.UnsavedTracker;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysMainWin;
import in.gov.uidai.ec.ui.shared.l10n.MsgKeysReport;
import in.gov.uidai.ec.util.ProtectedZipUtil;
import in.gov.uidai.litef.devapi.EventHandler;
import in.gov.uidai.litef.devapi.ILiteEvent;
import in.gov.uidai.litef.devapi.ILiteScaffold;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.litef.devapi.IOnScreenDisplay;
import in.gov.uidai.litef.devapi.IOnScreenDisplayAware;
import in.gov.uidai.litef.devapi.IViewElement;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.litef.widgets.TabbedPaneElement;
import in.gov.uidai.qssitv.model.BiometricPosition;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportControl
implements IOnScreenDisplayAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportControl.class);
    private static final String KEY_EOD_REPORT_DATA = "report-data";
    private static final String KEY_INT_FAILED_REPORT_DATA = "int-failed-report-data";
    private static final String KEY_EOD_BE_REPORT_DATA = "be-report-data";
    private static final String KEY_EOD_BE_SUMMARY_REPORT_DATA = "be-summary-report-data";
    private static final String KEY_PA_SUMMARY_REPORT_DATA = "pa-summary-report-data";
    private static final String KEY_PA_DATEWISE_REPORT_DATA = "pa-datewise-report-data";
    private IOnScreenDisplay osd;
    private IResourceBundleContext rbCtxt;
    private UnsavedTracker tracker;
    private IReportDAO report;
    private EODReportData eodReportData;
    private HoldRejectReportData integrityFailedReportData;
    private IUIPreference uiPref;
    private IServerSyncDAO serverSyncDAO;
    private IOnboardingService onboardingService;
    private ISessionService sessionService;
    private IRegistrationService registrationService;
    private EnrollmentService enrollmentService;

    public void populateOnScreenDisplay(IOnScreenDisplay osd) {
        this.osd = osd;
    }

    public final void setUnsavedTracker(UnsavedTracker tracker) {
        this.tracker = tracker;
    }

    public final void setResourceBundleContext(IResourceBundleContext ctxt) {
        this.rbCtxt = ctxt;
    }

    public final void setReport(IReportDAO report) {
        this.report = report;
    }

    public void setSessionService(ISessionService iSessionService) {
        this.sessionService = iSessionService;
    }

    public final void setUIPreference(IUIPreference pref) {
        this.uiPref = pref;
    }

    public void setServSyncDAO(IServerSyncDAO serverSyncDAO) {
        this.serverSyncDAO = serverSyncDAO;
    }

    public void setOnboardingService(IOnboardingService onboardingService) {
        this.onboardingService = onboardingService;
    }

    @EventHandler(name="hID_Report_ToolBut_Sel", method="actionPerformed")
    public void onReportSelect(ILiteEvent evt) {
        LOGGER.debug("report tab selected");
        if (!this.tracker.selectOther(evt)) {
            return;
        }
        String scafId = this.osd.recompose(evt.getScaffoldId(), "reportView");
        ILiteScaffold scaffold = this.osd.getScaffold(scafId);
        ((IViewElement)scaffold.getElementMap().get("hID_MainWin_Header")).set("text", (Object)LabelKeysMainWin.PROCESS_REPORT);
        ILiteView view = this.osd.getView(scaffold.getViewId());
        Map eMap = view.getElementMap();
        Date fromDate = new Date(System.currentTimeMillis() - 86400000L);
        ((IViewElement)eMap.get("eID_Report_EODDateFrom")).set("dateValue", (Object)fromDate);
        ((IViewElement)eMap.get("eID_Report_EODDateTo")).set("dateValue", (Object)new Date());
        long lastSyncOn = this.serverSyncDAO.getServerSyncDetails("LAST_SYNC");
        if (lastSyncOn != 0L) {
            Date lastSyncDate = new Date(lastSyncOn);
            ((IViewElement)eMap.get("eID_Report_EODLastSyncDate")).set("value", (Object)ECMPDateFormatHelper.getDateStr((Date)lastSyncDate, (ECMPDateFormats)ECMPDateFormats.FULL_DELIM_DATE_FORMAT));
        }
    }

    @EventHandler(name="hID_Report_ToolBut_Sel_for_UC", method="actionPerformed")
    public void onReportSelectForUC(ILiteEvent evt) {
        LOGGER.debug("report tab selected");
        if (!this.tracker.selectOther(evt)) {
            return;
        }
        String scafId = this.osd.recompose(evt.getScaffoldId(), "reportView");
        ILiteScaffold scaffold = this.osd.getScaffold(scafId);
        ((IViewElement)scaffold.getElementMap().get("hID_MainWin_Header")).set("text", (Object)LabelKeysMainWin.PROCESS_REPORT);
        ILiteView view = this.osd.getView(scaffold.getViewId());
        Map eMap = view.getElementMap();
        Date fromDate = new Date(System.currentTimeMillis() - 86400000L);
        ((IViewElement)eMap.get("eID_Report_EODDateFrom")).set("dateValue", (Object)fromDate);
        ((IViewElement)eMap.get("eID_Report_EODDateTo")).set("dateValue", (Object)new Date());
    }

    @EventHandler(name="hID_Report_TabSwitch", method="stateChanged")
    public void onReportTabSwitch(ILiteEvent evt) {
        LOGGER.debug("handling report tab switch");
        ILiteView view = this.osd.getView(evt.getViewId());
        if (view == null || !view.isValid()) {
            LOGGER.debug("view not found");
            return;
        }
        Map eMap = view.getElementMap();
        if (eMap == null || eMap.isEmpty()) {
            return;
        }
        TabbedPaneElement tabElement = (TabbedPaneElement)eMap.get("dID_Report_TabPane");
        int tabIndex = (Integer)tabElement.get("selected-index");
        if (tabIndex == 2) {
            IViewElement opIdElement = (IViewElement)view.getElementMap().get("eID_Report_UserCombo");
            opIdElement.set("options", this.getUserBEList(this.onboardingService.getAllUsers()));
            long lastSyncOn = this.serverSyncDAO.getServerSyncDetails("LAST_SYNC");
            if (lastSyncOn != 0L) {
                Date lastSyncDate = new Date(lastSyncOn);
                ((IViewElement)eMap.get("eID_Report_BELastSyncDate")).set("value", (Object)ECMPDateFormatHelper.getDateStr((Date)lastSyncDate, (ECMPDateFormats)ECMPDateFormats.FULL_DELIM_DATE_FORMAT));
            }
            Date fromDate = new Date(System.currentTimeMillis() - 604800000L);
            ((IViewElement)eMap.get("eID_Report_BEDateFrom")).set("dateValue", (Object)fromDate);
            ((IViewElement)eMap.get("eID_Report_BEDateTo")).set("dateValue", (Object)new Date());
            return;
        }
        if (tabIndex == 3) {
            long lastSyncOn = this.serverSyncDAO.getServerSyncDetails("LAST_SYNC");
            if (lastSyncOn != 0L) {
                Date lastSyncDate = new Date(lastSyncOn);
                ((IViewElement)eMap.get("eID_Report_BESummaryLastSyncDate")).set("value", (Object)ECMPDateFormatHelper.getDateStr((Date)lastSyncDate, (ECMPDateFormats)ECMPDateFormats.FULL_DELIM_DATE_FORMAT));
            }
            Date fromDate = new Date(System.currentTimeMillis() - 604800000L);
            ((IViewElement)eMap.get("eID_Report_BESummaryDateFrom")).set("dateValue", (Object)fromDate);
            ((IViewElement)eMap.get("eID_Report_BESummaryDateTo")).set("dateValue", (Object)new Date());
        }
        if (tabIndex == 4) {
            ((IViewElement)eMap.get("pa_Report_DateFrom")).set("dateValue", (Object)new Date());
            ((IViewElement)eMap.get("pa_Report_DateTo")).set("dateValue", (Object)new Date(System.currentTimeMillis()));
        }
    }

    @EventHandler(name="hID_Report_EODGen", method="actionPerformed")
    public void onEODReportGo(ILiteEvent evt) {
        LOGGER.trace("loading EOD report data");
        long start = System.currentTimeMillis();
        Window msgPeer = this.osd.getWindowForScaffold(evt.getScaffoldId());
        ILiteView view = this.osd.getView(evt.getViewId());
        Map eMap = view.getElementMap();
        IVisualExecutionContext veCtxt = view.getVisualExecutionContext();
        if (veCtxt != null) {
            veCtxt.reset();
            veCtxt.setMessage(this.rbCtxt.getMessage((Object)MsgKeysReport.PLEASE_WAIT, new Object[0]));
        }
        Date fromDateVal = (Date)((IViewElement)eMap.get("eID_Report_EODDateFrom")).get("dateValue");
        Date toDateVal = (Date)((IViewElement)eMap.get("eID_Report_EODDateTo")).get("dateValue");
        long fromDate = fromDateVal.getTime();
        GregorianCalendar calender = new GregorianCalendar();
        calender.setTime(toDateVal);
        calender.set(11, 23);
        calender.set(12, 59);
        calender.set(13, 59);
        long toDate = calender.getTimeInMillis();
        if (!this.validateDates(fromDateVal, toDateVal, msgPeer, "10d")) {
            if (veCtxt != null) {
                veCtxt.cancel();
            }
            ((IViewElement)eMap.get("eID_Report_EODDateSummary")).set("value", new ArrayList());
            ((IViewElement)eMap.get("eID_Report_EODDetails")).set("value", new ArrayList());
            return;
        }
        LOGGER.trace("loading from date " + fromDateVal + " to date " + toDateVal);
        this.eodReportData = this.report.loadEODReport(fromDateVal, calender.getTime());
        this.addStationDetails(msgPeer, view, veCtxt, fromDateVal, toDateVal, KEY_EOD_REPORT_DATA);
        ((IViewElement)eMap.get("eID_Report_EODDateSummary")).set("value", (Object)this.eodReportData.getDatewiseSummary());
        ((IViewElement)eMap.get("eID_Report_EODDetails")).set("value", (Object)this.eodReportData.getDetailsSummary());
        if (veCtxt != null) {
            veCtxt.cancel();
        }
        LOGGER.debug("Time taken to generate the EOD Report: " + (System.currentTimeMillis() - start) / 1000L + " Seconds");
    }

    @EventHandler(name="hID_Report_EODGen_for_UC", method="actionPerformed")
    public void onEODReportGoForUC(ILiteEvent evt) {
        LOGGER.trace("loading EOD report data");
        long start = System.currentTimeMillis();
        Window msgPeer = this.osd.getWindowForScaffold(evt.getScaffoldId());
        ILiteView view = this.osd.getView(evt.getViewId());
        Map eMap = view.getElementMap();
        IVisualExecutionContext veCtxt = view.getVisualExecutionContext();
        if (veCtxt != null) {
            veCtxt.reset();
            veCtxt.setMessage(this.rbCtxt.getMessage((Object)MsgKeysReport.PLEASE_WAIT, new Object[0]));
        }
        Date fromDateVal = (Date)((IViewElement)eMap.get("eID_Report_EODDateFrom")).get("dateValue");
        Date toDateVal = (Date)((IViewElement)eMap.get("eID_Report_EODDateTo")).get("dateValue");
        long fromDate = fromDateVal.getTime();
        GregorianCalendar calender = new GregorianCalendar();
        calender.setTime(toDateVal);
        calender.set(11, 23);
        calender.set(12, 59);
        calender.set(13, 59);
        long toDate = calender.getTimeInMillis();
        if (!this.validateDates(fromDateVal, toDateVal, msgPeer, "10d")) {
            if (veCtxt != null) {
                veCtxt.cancel();
            }
            ((IViewElement)eMap.get("eID_Report_EODDateSummary")).set("value", new ArrayList());
            ((IViewElement)eMap.get("eID_Report_EODDetails")).set("value", new ArrayList());
            return;
        }
        LOGGER.trace("loading from date " + fromDateVal + " to date " + toDateVal);
        this.fetchEodReport(evt, start, this.registrationService.getRegisteredMachineCode(), fromDateVal, calender.getTime());
    }

    private void fetchEodReport(ILiteEvent evt, long startTimeForFetchEod, String machineId, Date fromDate, Date toDate) {
        Window msgPeer = this.osd.getWindowForScaffold(evt.getScaffoldId());
        String transactionId = UUID.randomUUID().toString();
        GrpcService.getInst().setTransactionId(transactionId);
        this.eodReportData = new EODReportData();
        UcDemographicServiceProto.FetchEodReportDetailsRequest fetchEodReportDetailsRequest = UcDemographicServiceProto.FetchEodReportDetailsRequest.newBuilder().setFromTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(fromDate)).setToTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(toDate)).setStationMachineCode(machineId).build();
        ArrayList detailsList = new ArrayList();
        GrpcService.getInst().fetchEodReportDetails(fetchEodReportDetailsRequest, response -> {
            if (!response.getSuccess()) {
                TelemetryService.getTelemetryServiceInstance().postDebugData(response.getErrorDetail().getErrorMessage() + " " + response.getErrorDetail().getErrorCode(), new String[0]);
                L10nOptionPaneBuilder.getInstance().showErrorUC(response.getErrorDetail().getErrorMessage(), msgPeer, response.getErrorDetail().getErrorCode(), transactionId, new Object[0]);
                this.setDetailsList(evt, startTimeForFetchEod, fromDate, toDate, detailsList);
                return;
            }
            int[] serialNum = new int[]{1};
            response.getData().getReportsList().forEach(eodReportDetails -> {
                EODDetailsSummary detailsSummary = new EODDetailsSummary();
                detailsSummary.setSerialNum(serialNum[0]);
                detailsSummary.setEnrolIdDate(eodReportDetails.getSid());
                detailsSummary.setAppointmentId(eodReportDetails.getAppointmentId());
                detailsSummary.setType(eodReportDetails.getType());
                detailsSummary.setOnlyMandatoryBiometricUpdate(this.getYesOrNo(eodReportDetails.getIsMBU()));
                detailsSummary.setIsNRI(this.getYesOrNo(eodReportDetails.getIsNRI()));
                detailsSummary.setForeignResident(this.getYesOrNo(eodReportDetails.getIsForeignResident()));
                detailsSummary.setOpId(eodReportDetails.getOperatorId());
                detailsSummary.setAmountChargedForNewEnrolment(0.0f);
                detailsSummary.setAmountChargedForUpdateEnrolment((float)eodReportDetails.getPayableAmount());
                detailsSummary.setGstApplied((float)eodReportDetails.getGST());
                detailsSummary.setIsPacketSkipped(this.getYesOrNo(eodReportDetails.getPacketSkipped()));
                detailsSummary.setTotalAmountCharged((float)eodReportDetails.getTotalPayableAmount());
                detailsSummary.setProcessingStateDesc(eodReportDetails.getStage());
                String packetStatusType = eodReportDetails.getStageStatus().toLowerCase().replace("_", "");
                detailsSummary.setStatus(PacketStatusType.fromString((String)packetStatusType));
                detailsSummary.setRejectReasonDesc(eodReportDetails.getRejectReason());
                serialNum[0] = serialNum[0] + 1;
                detailsList.add(detailsSummary);
            });
            this.setDetailsList(evt, startTimeForFetchEod, fromDate, toDate, detailsList);
        }, errorResponse -> {
            this.setDetailsList(evt, startTimeForFetchEod, fromDate, toDate, detailsList);
            L10nOptionPaneBuilder.getInstance().showErrorUC(CommonUtilsUC.getErrorMessage(errorResponse), msgPeer, errorResponse.getErrorCode(), transactionId, new Object[0]);
        });
    }

    private void setDetailsList(ILiteEvent evt, long startTimeForFetchEod, Date fromDateVal, Date toDateVal, List<EODDetailsSummary> detailsSummaryList) {
        Window msgPeer = this.osd.getWindowForScaffold(evt.getScaffoldId());
        ILiteView view = this.osd.getView(evt.getViewId());
        Map eMap = view.getElementMap();
        IVisualExecutionContext veCtxt = view.getVisualExecutionContext();
        this.eodReportData.setDetailsSummary(detailsSummaryList);
        this.addStationDetails(msgPeer, view, veCtxt, fromDateVal, toDateVal, KEY_EOD_REPORT_DATA);
        ((IViewElement)eMap.get("eID_Report_EODDateSummary")).set("value", (Object)this.eodReportData.getDatewiseSummary());
        ((IViewElement)eMap.get("eID_Report_EODDetails")).set("value", (Object)this.eodReportData.getDetailsSummary());
        if (veCtxt != null) {
            veCtxt.cancel();
        }
        LOGGER.debug("Time taken to generate the EOD Report: " + (System.currentTimeMillis() - startTimeForFetchEod) / 1000L + " Seconds");
    }

    private String getYesOrNo(boolean value) {
        return value ? "Yes" : "No";
    }

    @EventHandler(name="hID_Report_EODSave", method="actionPerformed")
    public void onEODReportSave(ILiteEvent evt) {
        LOGGER.debug("generating EOD report");
        LOGGER.debug("scaffold is: " + evt.getScaffoldId());
        Window msgPeer = this.osd.getWindowForScaffold(evt.getScaffoldId());
        ILiteView view = this.osd.getView(evt.getViewId());
        EODReportData rptData = (EODReportData)view.getExtraDataMap().get(KEY_EOD_REPORT_DATA);
        if (rptData == null) {
            L10nOptionPaneBuilder.getInstance().showError((Object)MsgKeysReport.EOD_NOGEN, (Component)msgPeer, new Object[0]);
            return;
        }
        String loadPath = ".";
        JFileChooser chooser = new JFileChooser(new File("."));
        FileNameExtensionFilter htmlFilter = new FileNameExtensionFilter("HTML (*.html)", "html");
        FileNameExtensionFilter csvFilter = new FileNameExtensionFilter("Comma Separated Values (*.csv)", "csv");
        chooser.setFileFilter(htmlFilter);
        chooser.setFileFilter(csvFilter);
        int returnVal = chooser.showSaveDialog(this.osd.getWindowForScaffold(evt.getScaffoldId()));
        if (returnVal != 0) {
            return;
        }
        String reportFileName = chooser.getSelectedFile().getAbsolutePath();
        if (StringUtils.isBlank((String)reportFileName)) {
            L10nOptionPaneBuilder.getInstance().showError((Object)MsgKeysReport.EOD_NOFILE, (Component)msgPeer, new Object[0]);
            return;
        }
        String fileName = reportFileName;
        String zipPassword = this.showPasswordDialog(false);
        if (zipPassword.isEmpty()) {
            return;
        }
        if (chooser.getFileFilter().getDescription().equals(htmlFilter.getDescription())) {
            if (!reportFileName.endsWith(".html")) {
                fileName = reportFileName + ".html";
            }
            Date fromDate = (Date)view.getExtraDataMap().get("fromDate");
            Date toDate = (Date)view.getExtraDataMap().get("toDate");
            String fromDateStr = ECMPDateFormatHelper.getDateStr((Date)fromDate, (ECMPDateFormats)ECMPDateFormats.STANDARD_DATE_FORMAT);
            String toDateStr = ECMPDateFormatHelper.getDateStr((Date)toDate, (ECMPDateFormats)ECMPDateFormats.STANDARD_DATE_FORMAT);
            VelocityHelper helper = new VelocityHelper();
            try {
                helper.generateEODReportFile(rptData, fromDateStr, toDateStr, fileName, "conf/eodreport.vm");
                L10nOptionPaneBuilder.getInstance().showInfo((Object)MsgKeysReport.EOD_SUCCESS, (Component)msgPeer, new Object[0]);
            }
            catch (Exception e) {
                LOGGER.warn("", (Throwable)e);
                L10nOptionPaneBuilder.getInstance().showError((Object)MsgKeysReport.EOD_ERROR, (Component)msgPeer, new Object[0]);
                return;
            }
        }
        this.exportToCSV(msgPeer, rptData.getDetailsSummary(), chooser, csvFilter, reportFileName, fileName, zipPassword, "eodreport.csv.properties", MsgKeysReport.EOD_SUCCESS, MsgKeysReport.EOD_ERROR);
    }

    @EventHandler(name="hID_Report_BESave", method="actionPerformed")
    public void onBEEODReportSave(ILiteEvent evt) {
        LOGGER.debug("generating BE EOD report");
        LOGGER.debug("scaffold is: " + evt.getScaffoldId());
        Window msgPeer = this.osd.getWindowForScaffold(evt.getScaffoldId());
        ILiteView view = this.osd.getView(evt.getViewId());
        EODReportData rptData = (EODReportData)view.getExtraDataMap().get(KEY_EOD_BE_REPORT_DATA);
        if (rptData == null) {
            L10nOptionPaneBuilder.getInstance().showError((Object)MsgKeysReport.BE_NOGEN, (Component)msgPeer, new Object[0]);
            return;
        }
        String loadPath = ".";
        JFileChooser chooser = new JFileChooser(new File("."));
        FileNameExtensionFilter htmlFilter = new FileNameExtensionFilter("HTML (*.html)", "html");
        FileNameExtensionFilter csvFilter = new FileNameExtensionFilter("Comma Separated Values (*.csv)", "csv");
        chooser.setFileFilter(htmlFilter);
        chooser.setFileFilter(csvFilter);
        int returnVal = chooser.showSaveDialog(this.osd.getWindowForScaffold(evt.getScaffoldId()));
        if (returnVal != 0) {
            return;
        }
        String reportFileName = chooser.getSelectedFile().getAbsolutePath();
        if (StringUtils.isBlank((String)reportFileName)) {
            L10nOptionPaneBuilder.getInstance().showError((Object)MsgKeysReport.BE_NOFILE, (Component)msgPeer, new Object[0]);
            return;
        }
        String fileName = reportFileName;
        String zipPassword = this.showPasswordDialog(false);
        if (zipPassword.isEmpty()) {
            return;
        }
        if (chooser.getFileFilter().getDescription().equals(htmlFilter.getDescription())) {
            if (!reportFileName.endsWith(".html")) {
                fileName = reportFileName + ".html";
            }
            Date fromDate = (Date)view.getExtraDataMap().get("fromDate");
            Date toDate = (Date)view.getExtraDataMap().get("toDate");
            String fromDateStr = ECMPDateFormatHelper.getDateStr((Date)fromDate, (ECMPDateFormats)ECMPDateFormats.STANDARD_DATE_FORMAT);
            String toDateStr = ECMPDateFormatHelper.getDateStr((Date)toDate, (ECMPDateFormats)ECMPDateFormats.STANDARD_DATE_FORMAT);
            VelocityHelper helper = new VelocityHelper();
            try {
                helper.generateEODReportFile(rptData, fromDateStr, toDateStr, fileName, "conf/bereport.vm");
                L10nOptionPaneBuilder.getInstance().showInfo((Object)MsgKeysReport.BE_SUCCESS, (Component)msgPeer, new Object[0]);
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
                L10nOptionPaneBuilder.getInstance().showError((Object)MsgKeysReport.BE_ERROR, (Component)msgPeer, new Object[0]);
                return;
            }
        }
        this.exportToCSV(msgPeer, rptData.getDetailsSummary(), chooser, csvFilter, reportFileName, fileName, zipPassword, "bereport.csv.properties", MsgKeysReport.BE_SUCCESS, MsgKeysReport.BE_ERROR);
    }

    @EventHandler(name="hID_Report_Operator_BESummarySave", method="actionPerformed")
    public void onBESummaryOperatorReportSave(ILiteEvent evt) {
        LOGGER.debug("generating BE EOD report");
        LOGGER.debug("scaffold is: " + evt.getScaffoldId());
        Window msgPeer = this.osd.getWindowForScaffold(evt.getScaffoldId());
        ILiteView view = this.osd.getView(evt.getViewId());
        EODReportData rptData = (EODReportData)view.getExtraDataMap().get(KEY_EOD_BE_SUMMARY_REPORT_DATA);
        if (rptData == null) {
            L10nOptionPaneBuilder.getInstance().showError((Object)MsgKeysReport.BESUMMARY_NOGEN, (Component)msgPeer, new Object[0]);
            return;
        }
        String loadPath = ".";
        JFileChooser chooser = new JFileChooser(new File("."));
        FileNameExtensionFilter htmlFilter = new FileNameExtensionFilter("HTML (*.html)", "html");
        FileNameExtensionFilter csvFilter = new FileNameExtensionFilter("Comma Separated Values (*.csv)", "csv");
        chooser.setFileFilter(htmlFilter);
        chooser.setFileFilter(csvFilter);
        int returnVal = chooser.showSaveDialog(this.osd.getWindowForScaffold(evt.getScaffoldId()));
        if (returnVal != 0) {
            return;
        }
        String reportFileName = chooser.getSelectedFile().getAbsolutePath();
        if (StringUtils.isBlank((String)reportFileName)) {
            L10nOptionPaneBuilder.getInstance().showError((Object)MsgKeysReport.OPERAT_NOFILE, (Component)msgPeer, new Object[0]);
            return;
        }
        String fileName = reportFileName;
        String zipPassword = this.showPasswordDialog(false);
        if (zipPassword.isEmpty()) {
            return;
        }
        if (chooser.getFileFilter().getDescription().equals(htmlFilter.getDescription())) {
            if (!reportFileName.endsWith(".html")) {
                fileName = reportFileName + ".html";
            }
            Date fromDate = (Date)view.getExtraDataMap().get("fromDate");
            Date toDate = (Date)view.getExtraDataMap().get("toDate");
            String fromDateStr = ECMPDateFormatHelper.getDateStr((Date)fromDate, (ECMPDateFormats)ECMPDateFormats.STANDARD_DATE_FORMAT);
            String toDateStr = ECMPDateFormatHelper.getDateStr((Date)toDate, (ECMPDateFormats)ECMPDateFormats.STANDARD_DATE_FORMAT);
            VelocityHelper helper = new VelocityHelper();
            try {
                helper.generateEODReportFile(rptData, fromDateStr, toDateStr, fileName, "conf/bereport.vm");
                L10nOptionPaneBuilder.getInstance().showInfo((Object)MsgKeysReport.OPERAT_SUCCESS, (Component)msgPeer, new Object[0]);
            }
            catch (Exception e) {
                LOGGER.warn("", (Throwable)e);
                L10nOptionPaneBuilder.getInstance().showError((Object)MsgKeysReport.OPERAT_ERROR, (Component)msgPeer, new Object[0]);
                return;
            }
        }
        this.exportToCSV(msgPeer, rptData.getOperatorBeSummaryReport(), chooser, csvFilter, reportFileName, fileName, zipPassword, "bereportsummaryoperator.csv.properties", MsgKeysReport.OPERAT_SUCCESS, MsgKeysReport.OPERAT_ERROR);
    }

    @EventHandler(name="hID_Report_INT_FAILEDGen", method="actionPerformed")
    public void onIntegrityFailedGen(ILiteEvent evt) {
        LOGGER.debug("loading Integrity Failed Report data");
        Window msgPeer = this.osd.getWindowForScaffold(evt.getScaffoldId());
        ILiteView view = this.osd.getView(evt.getViewId());
        Map eMap = view.getElementMap();
        IVisualExecutionContext veCtxt = view.getVisualExecutionContext();
        Date fromDateVal = (Date)((IViewElement)eMap.get("hID_Report_INT_DateFrom")).get("dateValue");
        String toDateStr = (String)((IViewElement)eMap.get("hID_Report_INT_DateTo")).get("value");
        if (StringUtils.isBlank((String)toDateStr) || toDateStr.equalsIgnoreCase("00000000")) {
            ((IViewElement)eMap.get("hID_Report_INT_DateTo")).set("dateValue", (Object)new Date());
        }
        Date toDateVal = (Date)((IViewElement)eMap.get("hID_Report_INT_DateTo")).get("dateValue");
        long fromDate = fromDateVal.getTime();
        long toDate = this.getRoundOfTime(toDateVal);
        if (!this.validateIntegrityFailedDates(eMap, msgPeer)) {
            return;
        }
        boolean reEnrolledStatus = (Boolean)((IViewElement)eMap.get("hID_Report_INT_Status")).get("isSelected");
        if (veCtxt != null) {
            veCtxt.reset();
            veCtxt.setMessage(this.rbCtxt.getMessage((Object)MsgKeysReport.PLEASE_WAIT, new Object[0]));
        }
        this.integrityFailedReportData = this.report.loadIntegrityFailedReport(fromDate, toDate, reEnrolledStatus);
        if (this.integrityFailedReportData.getDetailsSummary().isEmpty()) {
            if (veCtxt != null) {
                veCtxt.cancel();
            }
            L10nOptionPaneBuilder.getInstance().showInfo((Object)MsgKeysReport.INTEGRITY_EMPTY, (Component)msgPeer, new Object[0]);
        }
        view.getExtraDataMap().put(KEY_INT_FAILED_REPORT_DATA, this.integrityFailedReportData);
        ((IViewElement)eMap.get("eID_Report_Int_Failed_Details")).set("value", (Object)this.integrityFailedReportData.getDetailsSummary());
        if (veCtxt != null) {
            veCtxt.cancel();
        }
    }

    @EventHandler(name="eID_Report_SelectionChanged", method="valueChanged")
    public void onBEReportListSelectionChanged(ILiteEvent evt) {
        if (((ListSelectionEvent)evt.getEvent()).getValueIsAdjusting()) {
            return;
        }
        ILiteView view = this.osd.getView(evt.getViewId());
        Map eMap = view.getElementMap();
        ArrayList<BiometricPosition> missingFingers = new ArrayList<BiometricPosition>();
        ArrayList<BiometricPosition> missingEyes = new ArrayList<BiometricPosition>();
        List selRow = (List)((IViewElement)eMap.get("eID_Report_BEDetails")).get("selectedRows");
        StringBuffer missingPositions = new StringBuffer("<html> Missing Positions: ");
        if (selRow != null && !selRow.isEmpty()) {
            List eodDetailsSummary = this.eodReportData.getDetailsSummary();
            String enrolId = ((EODDetailsSummary)eodDetailsSummary.get((Integer)selRow.get(0))).getEnrolIdDate();
            if ("E".equalsIgnoreCase(((EODDetailsSummary)eodDetailsSummary.get((Integer)selRow.get(0))).getType())) {
                EnrolSummary enrolSummary = this.report.getBioException(enrolId);
                if (enrolSummary != null) {
                    this.biometricException(missingFingers, missingEyes, missingPositions, enrolSummary.getBioException());
                }
            } else {
                UenrolSummary uenrolSummary = this.report.getBioExceptionForEnrolment(enrolId);
                if (uenrolSummary != null) {
                    this.biometricException(missingFingers, missingEyes, missingPositions, uenrolSummary.getBioException());
                }
            }
            missingPositions.replace(missingPositions.length() - 2, missingPositions.length() - 1, "");
        }
        missingPositions.append(" </html>");
        ((IViewElement)eMap.get("Biox_LeftHand")).set("missing", missingFingers);
        ((IViewElement)eMap.get("Biox_RightHand")).set("missing", missingFingers);
        ((IViewElement)eMap.get("Biox_LeftEye")).set("missing", missingEyes);
        ((IViewElement)eMap.get("Biox_RightEye")).set("missing", missingEyes);
        ((IViewElement)eMap.get("eID_Report_MissingPosition")).set("text", (Object)missingPositions);
    }

    private void biometricException(List<BiometricPosition> missingFingers, List<BiometricPosition> missingEyes, StringBuffer missigPositions, String bioException) {
        if ('0' == bioException.charAt(0)) {
            missingEyes.add(BiometricPosition.RIGHT_IRIS);
            missigPositions.append(BiometricPosition.RIGHT_IRIS + ", ");
        }
        if ('0' == bioException.charAt(1)) {
            missingEyes.add(BiometricPosition.LEFT_IRIS);
            missigPositions.append(BiometricPosition.LEFT_IRIS + ", ");
        }
        if ('0' == bioException.charAt(2)) {
            missingFingers.add(BiometricPosition.RIGHT_THUMB);
            missigPositions.append(BiometricPosition.RIGHT_THUMB + ", ");
        }
        if ('0' == bioException.charAt(3)) {
            missingFingers.add(BiometricPosition.RIGHT_INDEX);
            missigPositions.append(BiometricPosition.RIGHT_INDEX + ", ");
        }
        if ('0' == bioException.charAt(4)) {
            missingFingers.add(BiometricPosition.RIGHT_MIDDLE);
            missigPositions.append(BiometricPosition.RIGHT_MIDDLE + ", ");
        }
        if ('0' == bioException.charAt(5)) {
            missingFingers.add(BiometricPosition.RIGHT_RING);
            missigPositions.append(BiometricPosition.RIGHT_RING + ", ");
        }
        if ('0' == bioException.charAt(6)) {
            missingFingers.add(BiometricPosition.RIGHT_LITTLE);
            missigPositions.append(BiometricPosition.RIGHT_LITTLE + ", ");
        }
        if ('0' == bioException.charAt(7)) {
            missingFingers.add(BiometricPosition.LEFT_THUMB);
            missigPositions.append(BiometricPosition.LEFT_THUMB + ", ");
        }
        if ('0' == bioException.charAt(8)) {
            missingFingers.add(BiometricPosition.LEFT_INDEX);
            missigPositions.append(BiometricPosition.LEFT_INDEX + ", ");
        }
        if ('0' == bioException.charAt(9)) {
            missingFingers.add(BiometricPosition.LEFT_MIDDLE);
            missigPositions.append(BiometricPosition.LEFT_MIDDLE + ", ");
        }
        if ('0' == bioException.charAt(10)) {
            missingFingers.add(BiometricPosition.LEFT_RING);
            missigPositions.append(BiometricPosition.LEFT_RING + ", ");
        }
        if ('0' == bioException.charAt(11)) {
            missingFingers.add(BiometricPosition.LEFT_LITTLE);
            missigPositions.append(BiometricPosition.LEFT_LITTLE + ", ");
        }
    }

    @EventHandler(name="hID_Report_INT_ReEnrol", method="actionPerformed")
    public void onIntegrityFailedReEnrolUpdate(ILiteEvent evt) {
        LOGGER.debug("loading Integrity Failed Report data");
        Window msgPeer = this.osd.getWindowForScaffold(evt.getScaffoldId());
        ILiteView view = this.osd.getView(evt.getViewId());
        Map eMap = view.getElementMap();
        List selRows = (List)((IViewElement)eMap.get("eID_Report_Int_Failed_Details")).get("selectedRows");
        HoldRejectReportData rptData = (HoldRejectReportData)view.getExtraDataMap().get(KEY_INT_FAILED_REPORT_DATA);
        if (rptData != null) {
            List detailsSummary = rptData.getDetailsSummary();
            if (selRows != null && !selRows.isEmpty()) {
                for (Integer selRow : selRows) {
                    this.report.updateReEnrolledStatusPktStatus(((HoldRejectDetailsSummary)detailsSummary.get(selRow)).getEnrolIdDate());
                }
                L10nOptionPaneBuilder.getInstance().showInfo((Object)MsgKeysReport.INTEGRITY_REENROLED_RECORD, (Component)msgPeer, new Object[0]);
                rptData = new HoldRejectReportData();
                view.getExtraDataMap().put(KEY_INT_FAILED_REPORT_DATA, null);
                ((IViewElement)eMap.get("eID_Report_Int_Failed_Details")).set("value", (Object)rptData.getDetailsSummary());
            } else if (detailsSummary.size() > 0) {
                L10nOptionPaneBuilder.getInstance().showError((Object)MsgKeysReport.INTEGRITY_SELECT_RECORD, (Component)msgPeer, new Object[0]);
            } else {
                L10nOptionPaneBuilder.getInstance().showError((Object)MsgKeysReport.INTEGRITY_NO_RECORD, (Component)msgPeer, new Object[0]);
            }
        } else {
            L10nOptionPaneBuilder.getInstance().showError((Object)MsgKeysReport.INTEGRITY_NOGEN, (Component)msgPeer, new Object[0]);
        }
    }

    @EventHandler(name="hID_Report_INT_FAILEDSave", method="actionPerformed")
    public void onIntegrityFailedSave(ILiteEvent evt) {
        LOGGER.trace("generating Integrity Failed report");
        LOGGER.trace("scaffold is: " + evt.getScaffoldId());
        Window msgPeer = this.osd.getWindowForScaffold(evt.getScaffoldId());
        ILiteView view = this.osd.getView(evt.getViewId());
        HoldRejectReportData rptData = (HoldRejectReportData)view.getExtraDataMap().get(KEY_INT_FAILED_REPORT_DATA);
        if (rptData == null) {
            L10nOptionPaneBuilder.getInstance().showError((Object)MsgKeysReport.INTEGRITY_NOGEN, (Component)msgPeer, new Object[0]);
            return;
        }
        String loadPath = ".";
        JFileChooser chooser = new JFileChooser(new File("."));
        FileNameExtensionFilter htmlFilter = new FileNameExtensionFilter("HTML (*.html)", "html");
        FileNameExtensionFilter csvFilter = new FileNameExtensionFilter("Comma Separated Values (*.csv)", "csv");
        chooser.removeChoosableFileFilter(chooser.getFileFilter());
        chooser.setFileFilter(htmlFilter);
        chooser.setFileFilter(csvFilter);
        int returnVal = chooser.showSaveDialog(this.osd.getWindowForScaffold(evt.getScaffoldId()));
        if (returnVal != 0) {
            return;
        }
        String reportFileName = chooser.getSelectedFile().getAbsolutePath();
        if (StringUtils.isBlank((String)reportFileName)) {
            L10nOptionPaneBuilder.getInstance().showError((Object)MsgKeysReport.INTEGRITY_NOFILE, (Component)msgPeer, new Object[0]);
            return;
        }
        String fileName = reportFileName;
        String zipPassword = this.showPasswordDialog(false);
        if (zipPassword.isEmpty()) {
            return;
        }
        if (chooser.getFileFilter().getDescription().equals(htmlFilter.getDescription())) {
            if (!reportFileName.endsWith(".html")) {
                fileName = reportFileName + ".html";
            }
            VelocityHelper helper = new VelocityHelper();
            try {
                helper.generateIntegrityFailedReportFile(rptData, fileName);
                L10nOptionPaneBuilder.getInstance().showInfo((Object)MsgKeysReport.INTEGRITY_SUCCESS, (Component)msgPeer, new Object[0]);
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
                L10nOptionPaneBuilder.getInstance().showError((Object)MsgKeysReport.INTEGRITY_ERROR, (Component)msgPeer, new Object[0]);
                return;
            }
        }
        this.exportToCSV(msgPeer, rptData.getDetailsSummary(), chooser, csvFilter, reportFileName, fileName, zipPassword, "integrityfailedreport.csv.properties", MsgKeysReport.INTEGRITY_SUCCESS, MsgKeysReport.INTEGRITY_ERROR);
    }

    @EventHandler(name="hID_Report_BEGen", method="actionPerformed")
    public void onBEEODReportGo(ILiteEvent evt) {
        LOGGER.trace("loading EOD report data");
        long start = System.currentTimeMillis();
        Window msgPeer = this.osd.getWindowForScaffold(evt.getScaffoldId());
        ILiteView view = this.osd.getView(evt.getViewId());
        Map eMap = view.getElementMap();
        IVisualExecutionContext veCtxt = view.getVisualExecutionContext();
        if (veCtxt != null) {
            veCtxt.reset();
            veCtxt.setMessage(this.rbCtxt.getMessage((Object)MsgKeysReport.PLEASE_WAIT, new Object[0]));
        }
        Date fromDateVal = (Date)((IViewElement)eMap.get("eID_Report_BEDateFrom")).get("dateValue");
        Date toDateVal = (Date)((IViewElement)eMap.get("eID_Report_BEDateTo")).get("dateValue");
        GregorianCalendar calender = new GregorianCalendar();
        calender.setTime(toDateVal);
        calender.set(11, 23);
        calender.set(12, 59);
        calender.set(13, 59);
        if (!this.validateDates(fromDateVal, toDateVal, msgPeer, "30d")) {
            if (veCtxt != null) {
                veCtxt.cancel();
            }
            return;
        }
        LOGGER.trace("loading from date " + fromDateVal + " to date " + toDateVal);
        IViewElement opIdElement = (IViewElement)view.getElementMap().get("eID_Report_UserCombo");
        String userId = (String)opIdElement.get("selectedItem");
        this.eodReportData = this.report.loadBEEODReport(fromDateVal, calender.getTime(), userId);
        this.addStationDetails(msgPeer, view, veCtxt, fromDateVal, toDateVal, KEY_EOD_BE_REPORT_DATA);
        ((IViewElement)eMap.get("eID_Report_BEDateSummary")).set("value", (Object)this.eodReportData.getDatewiseSummary());
        ((IViewElement)eMap.get("eID_Report_BEDetails")).set("value", (Object)this.eodReportData.getDetailsSummary());
        if (veCtxt != null) {
            veCtxt.cancel();
        }
        LOGGER.debug("Time taken to generate the EOD Report: " + (System.currentTimeMillis() - start) / 1000L + " Seconds");
    }

    private void addStationDetails(Component msgPeer, ILiteView view, IVisualExecutionContext veCtxt, Date fromDateVal, Date toDateVal, String keyEodBeReportData) {
        this.addStationDetails(view, fromDateVal, toDateVal, keyEodBeReportData);
        if (this.eodReportData.getDetailsSummary().isEmpty()) {
            if (veCtxt != null) {
                veCtxt.cancel();
            }
            L10nOptionPaneBuilder.getInstance().showInfo((Object)MsgKeysReport.EOD_EMPTY, msgPeer, new Object[0]);
        }
    }

    private void addStationDetails(ILiteView view, Date fromDateVal, Date toDateVal, String keyEodBeReportData) {
        this.eodReportData.setRegistrarId(this.uiPref.getRegistrarId("0"));
        this.eodReportData.setEnrolmentAgencyId(this.uiPref.getAgencyId("0"));
        this.eodReportData.setStationId(this.uiPref.getStationId("0"));
        if (this.enrollmentService.isUniversalClientTrnx()) {
            this.eodReportData.setOperatorId(this.enrollmentService.getOAuthSessionService().getOperatorDetails().getOperatorId());
        } else {
            this.eodReportData.setOperatorId(this.sessionService.getOperatorCredentials().getOperatorId());
        }
        this.eodReportData.setClientVersion(ApplicationVersion.VERSION);
        view.getExtraDataMap().put(keyEodBeReportData, this.eodReportData);
        view.getExtraDataMap().put("fromDate", fromDateVal);
        view.getExtraDataMap().put("toDate", toDateVal);
    }

    @EventHandler(name="hID_Report_BESummaryGen", method="actionPerformed")
    public void onBEEODReportSummaryGo(ILiteEvent evt) {
        LOGGER.trace("loading EOD report data");
        long start = System.currentTimeMillis();
        Window msgPeer = this.osd.getWindowForScaffold(evt.getScaffoldId());
        ILiteView view = this.osd.getView(evt.getViewId());
        Map eMap = view.getElementMap();
        IVisualExecutionContext veCtxt = view.getVisualExecutionContext();
        if (veCtxt != null) {
            veCtxt.reset();
            veCtxt.setMessage(this.rbCtxt.getMessage((Object)MsgKeysReport.PLEASE_WAIT, new Object[0]));
        }
        Date fromDateVal = (Date)((IViewElement)eMap.get("eID_Report_BESummaryDateFrom")).get("dateValue");
        Date toDateVal = (Date)((IViewElement)eMap.get("eID_Report_BESummaryDateTo")).get("dateValue");
        GregorianCalendar calender = new GregorianCalendar();
        calender.setTime(toDateVal);
        calender.set(11, 23);
        calender.set(12, 59);
        calender.set(13, 59);
        if (!this.validateDates(fromDateVal, toDateVal, msgPeer, "30d")) {
            if (veCtxt != null) {
                veCtxt.cancel();
            }
            return;
        }
        LOGGER.trace("loading from date " + fromDateVal + " to date " + toDateVal);
        this.eodReportData = this.report.loadBEEODReportSummary(fromDateVal, calender.getTime(), this.getUserList(this.onboardingService.getAllUsers()));
        this.addStationDetails(view, fromDateVal, toDateVal, KEY_EOD_BE_SUMMARY_REPORT_DATA);
        if (this.eodReportData.getDetailsSummary().isEmpty()) {
            if (veCtxt != null) {
                veCtxt.cancel();
            }
            L10nOptionPaneBuilder.getInstance().showInfo((Object)MsgKeysReport.EOD_EMPTY, (Component)msgPeer, new Object[0]);
            return;
        }
        ((IViewElement)eMap.get("eID_Report_BESummaryDateSummary")).set("value", (Object)this.eodReportData.getDatewiseSummary());
        ((IViewElement)eMap.get("eID_Report_BEOperatorSummaryDetails")).set("value", (Object)this.eodReportData.getOperatorBeSummaryReport());
        if (veCtxt != null) {
            veCtxt.cancel();
        }
        LOGGER.debug("Time taken to generate the EOD Report: " + (System.currentTimeMillis() - start) / 1000L + " Seconds");
    }

    @EventHandler(name="pa_Report_SummaryGen", method="actionPerformed")
    public void onPrintAadhaarSummaryGo(ILiteEvent evt) {
        LOGGER.trace("loading Print Aadhaar Report data");
        long start = System.currentTimeMillis();
        Window msgPeer = this.osd.getWindowForScaffold(evt.getScaffoldId());
        ILiteView view = this.osd.getView(evt.getViewId());
        Map eMap = view.getElementMap();
        IVisualExecutionContext veCtxt = view.getVisualExecutionContext();
        if (veCtxt != null) {
            veCtxt.reset();
            veCtxt.setMessage(this.rbCtxt.getMessage((Object)MsgKeysReport.PLEASE_WAIT, new Object[0]));
        }
        Date fromDateVal = (Date)((IViewElement)eMap.get("pa_Report_DateFrom")).get("dateValue");
        Date toDateVal = (Date)((IViewElement)eMap.get("pa_Report_DateTo")).get("dateValue");
        long fromDate = fromDateVal.getTime();
        GregorianCalendar calender = new GregorianCalendar();
        calender.setTime(toDateVal);
        calender.set(11, 23);
        calender.set(12, 59);
        calender.set(13, 59);
        long toDate = calender.getTimeInMillis();
        if (!this.validateDates(fromDateVal, toDateVal, msgPeer, "30d")) {
            if (veCtxt != null) {
                veCtxt.cancel();
            }
            return;
        }
        LOGGER.trace("loading from date " + fromDateVal + " to date " + toDateVal);
        view.getExtraDataMap().put("fromDate", fromDateVal);
        view.getExtraDataMap().put("toDate", toDateVal);
        List printAadhaarReportData = this.report.getPrintAadhaarReportData(fromDate, toDate);
        view.getExtraDataMap().put(KEY_PA_SUMMARY_REPORT_DATA, printAadhaarReportData);
        if (printAadhaarReportData.isEmpty()) {
            if (veCtxt != null) {
                veCtxt.cancel();
            }
            L10nOptionPaneBuilder.getInstance().showInfo((Object)MsgKeysReport.EOD_EMPTY, (Component)msgPeer, new Object[0]);
            return;
        }
        List printAadhaarDateWiseSummary = this.report.getPrintAadhaarDateWiseSummary();
        view.getExtraDataMap().put(KEY_PA_DATEWISE_REPORT_DATA, printAadhaarDateWiseSummary);
        ((IViewElement)eMap.get("pa_Report_DateSummary")).set("value", (Object)printAadhaarDateWiseSummary);
        ((IViewElement)eMap.get("pa_Report_Summary")).set("value", (Object)printAadhaarReportData);
        if (veCtxt != null) {
            veCtxt.cancel();
        }
        LOGGER.debug("Time taken to generate the Print Aadhaar Report: " + (System.currentTimeMillis() - start) / 1000L + " Seconds");
    }

    @EventHandler(name="pa_Report_SummarySave", method="actionPerformed")
    public void onPrintAadhaarSummarySave(ILiteEvent evt) {
        LOGGER.debug("generating Print Aadhaar report");
        LOGGER.debug("scaffold is: " + evt.getScaffoldId());
        Window msgPeer = this.osd.getWindowForScaffold(evt.getScaffoldId());
        ILiteView view = this.osd.getView(evt.getViewId());
        List attemptSummary = (List)view.getExtraDataMap().get(KEY_PA_SUMMARY_REPORT_DATA);
        List dateWiseSummaries = (List)view.getExtraDataMap().get(KEY_PA_DATEWISE_REPORT_DATA);
        if (attemptSummary == null || dateWiseSummaries == null) {
            L10nOptionPaneBuilder.getInstance().showError((Object)MsgKeysReport.PA_NOGEN, (Component)msgPeer, new Object[0]);
            return;
        }
        String loadPath = ".";
        JFileChooser chooser = new JFileChooser(new File("."));
        FileNameExtensionFilter htmlFilter = new FileNameExtensionFilter("HTML (*.html)", "html");
        FileNameExtensionFilter csvFilter = new FileNameExtensionFilter("Comma Separated Values (*.csv)", "csv");
        chooser.setFileFilter(htmlFilter);
        chooser.setFileFilter(csvFilter);
        int returnVal = chooser.showSaveDialog(this.osd.getWindowForScaffold(evt.getScaffoldId()));
        if (returnVal != 0) {
            return;
        }
        String reportFileName = chooser.getSelectedFile().getAbsolutePath();
        if (StringUtils.isBlank((String)reportFileName)) {
            L10nOptionPaneBuilder.getInstance().showError((Object)MsgKeysReport.PA_NOFILE, (Component)msgPeer, new Object[0]);
            return;
        }
        String fileName = reportFileName;
        String zipPassword = this.showPasswordDialog(false);
        if (zipPassword.isEmpty()) {
            return;
        }
        if (chooser.getFileFilter().getDescription().equals(htmlFilter.getDescription())) {
            if (!reportFileName.endsWith(".html")) {
                fileName = reportFileName + ".html";
            }
            Date fromDate = (Date)view.getExtraDataMap().get("fromDate");
            Date toDate = (Date)view.getExtraDataMap().get("toDate");
            String fromDateStr = ECMPDateFormatHelper.getDateStr((Date)fromDate, (ECMPDateFormats)ECMPDateFormats.STANDARD_DATE_FORMAT);
            String toDateStr = ECMPDateFormatHelper.getDateStr((Date)toDate, (ECMPDateFormats)ECMPDateFormats.STANDARD_DATE_FORMAT);
            VelocityHelper helper = new VelocityHelper();
            try {
                helper.generatePrintAadhaarReportFile(attemptSummary, dateWiseSummaries, fromDateStr, toDateStr, fileName);
                L10nOptionPaneBuilder.getInstance().showInfo((Object)MsgKeysReport.PA_SUCCESS, (Component)msgPeer, new Object[0]);
            }
            catch (Exception e) {
                LOGGER.warn("", (Throwable)e);
                L10nOptionPaneBuilder.getInstance().showError((Object)MsgKeysReport.PA_ERROR, (Component)msgPeer, new Object[0]);
                return;
            }
        }
        this.exportToCSV(msgPeer, attemptSummary, chooser, csvFilter, reportFileName, fileName, zipPassword, "pareport.csv.properties", MsgKeysReport.PA_SUCCESS, MsgKeysReport.PA_ERROR);
    }

    private boolean validateDates(Date fromDateVal, Date toDateVal, Component msgPeer, String defRange) {
        long fromDate = fromDateVal.getTime();
        GregorianCalendar calender = new GregorianCalendar();
        calender.setTime(toDateVal);
        calender.set(11, 23);
        calender.set(12, 59);
        calender.set(13, 59);
        long toDate = calender.getTimeInMillis();
        if (fromDate == -62170176600000L) {
            L10nOptionPaneBuilder.getInstance().showError((Object)MsgKeysReport.DATE_FROM_EMPTY, msgPeer, new Object[0]);
            return false;
        }
        if (toDate == -62170090201000L) {
            L10nOptionPaneBuilder.getInstance().showError((Object)MsgKeysReport.DATE_TO_EMPTY, msgPeer, new Object[0]);
            return false;
        }
        if (fromDate == System.currentTimeMillis()) {
            L10nOptionPaneBuilder.getInstance().showError((Object)MsgKeysReport.DATE_FROM_EMPTY, msgPeer, new Object[0]);
            return false;
        }
        if (toDateVal.getTime() == System.currentTimeMillis()) {
            L10nOptionPaneBuilder.getInstance().showError((Object)MsgKeysReport.DATE_TO_EMPTY, msgPeer, new Object[0]);
            return false;
        }
        if (fromDate > toDate) {
            L10nOptionPaneBuilder.getInstance().showError((Object)MsgKeysReport.DATE_FROM_AFTERTO, msgPeer, new Object[0]);
            return false;
        }
        if (System.currentTimeMillis() - fromDate > new TimeInterval(defRange).getValue()) {
            L10nOptionPaneBuilder.getInstance().showError((Object)("The date range between From-date and To-date cannot be greater than past " + defRange), msgPeer, new Object[0]);
            return false;
        }
        if (fromDate > System.currentTimeMillis()) {
            L10nOptionPaneBuilder.getInstance().showError((Object)MsgKeysReport.DATE_FROM_FUTURE, msgPeer, new Object[0]);
            return false;
        }
        Date currDateVal = new Date();
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(currDateVal);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        long currDate = cal.getTimeInMillis();
        if (toDateVal.getTime() > currDate) {
            L10nOptionPaneBuilder.getInstance().showError((Object)MsgKeysReport.DATE_TO_FUTURE, msgPeer, new Object[0]);
            return false;
        }
        return true;
    }

    private boolean validateIntegrityFailedDates(Map<String, IViewElement> eMap, Component msgPeer) {
        Date fromDateVal = (Date)eMap.get("hID_Report_INT_DateFrom").get("dateValue");
        String fromDateStr = (String)eMap.get("hID_Report_INT_DateFrom").get("value");
        if (StringUtils.isBlank((String)fromDateStr) || fromDateStr.equalsIgnoreCase("00000000")) {
            L10nOptionPaneBuilder.getInstance().showError((Object)MsgKeysReport.DATE_FROM_EMPTY, msgPeer, new Object[0]);
            return false;
        }
        Date toDateVal = (Date)eMap.get("hID_Report_INT_DateTo").get("dateValue");
        long fromDate = this.getRoundOfTime(fromDateVal);
        long toDate = this.getRoundOfTime(toDateVal);
        long currDate = this.getRoundOfTime(new Date());
        if (fromDate >= currDate) {
            L10nOptionPaneBuilder.getInstance().showError((Object)"From date cannot be a current/future date.", msgPeer, new Object[0]);
            return false;
        }
        if (toDate > currDate) {
            L10nOptionPaneBuilder.getInstance().showError((Object)"To date cannot be a future date.", msgPeer, new Object[0]);
            return false;
        }
        if (fromDate > toDate) {
            L10nOptionPaneBuilder.getInstance().showError((Object)"From date cannot be greater than To date.", msgPeer, new Object[0]);
            return false;
        }
        return true;
    }

    private long getRoundOfTime(Date dateTime) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(dateTime);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    private List<SupervisorBeSummaryReport> getUserList(List<UserCredentials> credList) {
        ArrayList<SupervisorBeSummaryReport> userNameList = new ArrayList<SupervisorBeSummaryReport>();
        for (UserCredentials cred : credList) {
            String operatorId = cred.getOperatorId();
            SupervisorBeSummaryReport newReportItem = new SupervisorBeSummaryReport();
            newReportItem.setSupervisorId(operatorId);
            newReportItem.setSupervisorName(cred.getFullName());
            userNameList.add(newReportItem);
        }
        return userNameList;
    }

    private ArrayList<String> getUserBEList(List<UserCredentials> credList) {
        ArrayList<String> userIdList = new ArrayList<String>();
        userIdList.add("ALL");
        for (UserCredentials cred : credList) {
            userIdList.add(cred.getOperatorId());
        }
        return userIdList;
    }

    private String showPasswordDialog(boolean initialFlag) {
        JFrame frame = new JFrame("Input Dialog");
        JPasswordField passwordField = new JPasswordField();
        JLabel mandatoryLabel = new JLabel("You must have to enter the password to save the Report.");
        mandatoryLabel.setVisible(initialFlag);
        String zipPassword = "";
        JComponent[] INITIAL_INPUTS = new JComponent[]{new JLabel("Please enter the password to save the Report"), passwordField, mandatoryLabel};
        int x = JOptionPane.showConfirmDialog(frame, INITIAL_INPUTS, "Enter Password.", 2, 1);
        if (x == 0 && (zipPassword = passwordField.getText()).equals("")) {
            zipPassword = this.showPasswordDialog(true);
        }
        return zipPassword;
    }

    private <T> void exportToCSV(Component component, List<T> rptData, JFileChooser chooser, FileNameExtensionFilter filter, String reportFileName, String fileName, String zipPassword, String fieldNamePropertyFile, MsgKeysReport infoKey, MsgKeysReport errorKey) {
        if (chooser.getFileFilter().getDescription().equals(filter.getDescription())) {
            if (!reportFileName.endsWith(".csv")) {
                fileName = reportFileName + ".csv";
            }
            try {
                CsvReportWriter writer = new CsvReportWriter(fileName, fieldNamePropertyFile);
                writer.storeData(rptData);
                L10nOptionPaneBuilder.getInstance().showInfo((Object)infoKey, component, new Object[0]);
            }
            catch (Exception e) {
                LOGGER.warn("", (Throwable)e);
                L10nOptionPaneBuilder.getInstance().showError((Object)errorKey, component, new Object[0]);
                return;
            }
        }
        String zipPath = reportFileName + ".zip";
        ProtectedZipUtil.doZipWithPassword(fileName, zipPath, zipPassword);
        boolean del = new File(fileName).delete();
        if (del) {
            LOGGER.info("File deleted");
        } else {
            LOGGER.info("File not deleted");
        }
    }

    public void setRegistrationService(IRegistrationService registrationService) {
        this.registrationService = registrationService;
    }

    public void setEnrollmentService(EnrollmentService enrollmentService) {
        this.enrollmentService = enrollmentService;
    }
}

