/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.report;

import in.gov.uidai.ec.ui.report.BioxToggleField;
import in.gov.uidai.qssitv.model.BiometricPosition;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class RightEyeField
extends BioxToggleField {
    public RightEyeField() {
        this.setTitle("Right Eye");
        this.setBioPic("res/images/eye-right.png");
        this.setMissingBioPic("res/images/eye-right-miss.png");
        this.addHierarchyListener(evt -> this.createKeyboardBinding());
    }

    @Override
    public List<BiometricPosition> available(List<BiometricPosition> posList) {
        List<BiometricPosition> result = posList;
        if (result == null) {
            result = new ArrayList<BiometricPosition>();
        }
        if (this.isBioPresent()) {
            result.add(BiometricPosition.RIGHT_IRIS);
        }
        return result;
    }

    @Override
    public List<BiometricPosition> missing(List<BiometricPosition> posList) {
        List<BiometricPosition> result = posList;
        if (result == null) {
            result = new ArrayList<BiometricPosition>();
        }
        if (!this.isBioPresent()) {
            result.add(BiometricPosition.RIGHT_IRIS);
        }
        return result;
    }

    @Override
    public void setMissing(List<BiometricPosition> posList) {
        this.setBioPresent(!posList.contains(BiometricPosition.RIGHT_IRIS));
    }

    private void createKeyboardBinding() {
        JRootPane root = SwingUtilities.getRootPane(this);
        if (root == null) {
            return;
        }
        root.getInputMap().put(KeyStroke.getKeyStroke("control F11"), "right-eye");
        AbstractAction axn = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RightEyeField.this.toggleBioPresent();
            }
        };
        root.getActionMap().put("right-eye", axn);
    }
}

