/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.sessionlogout;

import in.gov.uidai.ec.ecmpapi.EcmpApiException;
import in.gov.uidai.ec.ecmpapi.EcmpApiService;
import in.gov.uidai.ec.ecmpapi.EcmpRequest;
import in.gov.uidai.ec.ecmpapi.json.sessionlogout.SessionLogoutRequest;
import in.gov.uidai.ec.ecmpapi.json.sessionlogout.SessionLogoutResponse;
import in.gov.uidai.ec.ecmpapi.json.sessionvalidation.SessionValidationRequest;
import in.gov.uidai.ec.ecmpapi.json.sessionvalidation.SessionValidationResponse;
import in.gov.uidai.ec.service.session.ISessionService;
import in.gov.uidai.ec.ui.main.UnsavedTracker;
import in.gov.uidai.ec.ui.shared.ShutdownHook;
import in.gov.uidai.litef.devapi.EventHandler;
import in.gov.uidai.litef.devapi.ILiteEvent;
import in.gov.uidai.litef.devapi.IOnScreenDisplay;
import in.gov.uidai.litef.devapi.IOnScreenDisplayAware;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.litef.devapi.ScaffoldPlacement;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import java.awt.Component;
import java.io.IOException;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionLogoutControl
implements IOnScreenDisplayAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionLogoutControl.class);
    private IOnScreenDisplay osd;
    private EcmpApiService ecmpApiService;
    private ISessionService sessionService;
    private UnsavedTracker tracker;
    private ShutdownHook shutdownHook;

    public void populateOnScreenDisplay(IOnScreenDisplay osd) {
        this.osd = osd;
    }

    public final void setUnsavedTracker(UnsavedTracker tracker) {
        this.tracker = tracker;
    }

    public void setEcmpApiService(EcmpApiService ecmpApiService) {
        this.ecmpApiService = ecmpApiService;
    }

    public void setSessionService(ISessionService sessionService) {
        this.sessionService = sessionService;
    }

    public void setShutdownHook(ShutdownHook shutdownHook) {
        this.shutdownHook = shutdownHook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @EventHandler(name="hID_Session_Logout", method="actionPerformed")
    public void onClickLogout(ILiteEvent evt) {
        if (!this.tracker.selectLogout(evt)) {
            return;
        }
        IVisualExecutionContext veCtxt = this.osd.getView(this.osd.getScaffold(evt.getScaffoldId()).getViewId()).getVisualExecutionContext();
        if (veCtxt != null) {
            veCtxt.reset();
            veCtxt.setMessage("Logout in progress ");
        }
        try {
            int sessionId = new Integer(this.sessionService.getUserSessionId());
            SessionValidationRequest sessionValidationRequest = new SessionValidationRequest(sessionId);
            String sessionKey = new String(Base64.getEncoder().encode(this.sessionService.getSessionKey()));
            SessionValidationResponse sessionValidationResponse = this.ecmpApiService.validateSessionRequest((EcmpRequest)sessionValidationRequest, sessionKey);
            switch (sessionValidationResponse.getErrorShortName()) {
                case "": {
                    LOGGER.info("Session validation successful");
                    this.clearSession();
                    this.doLogout(evt, sessionId, sessionKey, veCtxt);
                    return;
                }
                case "SESSION_NOT_FOUND": 
                case "SESSION_NOT_ACTIVE": 
                case "SESSION_SIGNATURE_INVALID": {
                    LOGGER.error("Failed to log out. Description: " + sessionValidationResponse.getErrorDescription());
                    this.clearSession();
                    this.disposeScreen(evt);
                    return;
                }
                case "CLIENT_VERIFICATION_FAILURE": {
                    LOGGER.error("This client version is obsolete. Upgrade to latest client version");
                    this.showErrorMessage(evt, veCtxt, "This client version is obsolete. Please keep your system online to upgrade to latest version");
                    return;
                }
                default: {
                    LOGGER.error("Failed to log out. Description: " + sessionValidationResponse.getErrorDescription());
                    this.showErrorMessage(evt, veCtxt, "Failed to log out due to server error.");
                    return;
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to log out due to network issue: ", (Throwable)e);
            this.showErrorMessage(evt, veCtxt, "Failed to log out due to network issue. Please check your internet connection and try again.");
            return;
        }
        catch (EcmpApiException e) {
            LOGGER.error(e.getMessage());
            this.showErrorMessage(evt, veCtxt, e.getMessage());
            return;
        }
        catch (Exception e) {
            LOGGER.error("Failed to log out due to internal error, ", (Throwable)e);
            this.showErrorMessage(evt, veCtxt, "Failed to log out due to internal error. Please try again.");
            return;
        }
        finally {
            if (veCtxt != null) {
                veCtxt.cancel();
            }
        }
    }

    private void clearSession() {
        this.sessionService.clearCurrentSession();
        this.sessionService.resetOperatorLoginDetails();
    }

    private void doLogout(ILiteEvent evt, int sessionId, String sessionKey, IVisualExecutionContext veCtxt) throws IOException {
        SessionLogoutRequest sessionLogoutRequest = new SessionLogoutRequest(sessionId);
        SessionLogoutResponse sessionLogoutResponse = this.ecmpApiService.doSessionLogout((EcmpRequest)sessionLogoutRequest, sessionKey);
        switch (sessionLogoutResponse.getErrorShortName()) {
            case "": {
                LOGGER.info("Session logout successful");
                this.tracker.setCurrentStatusToOther();
                this.disposeScreen(evt);
                break;
            }
            case "SESSION_NOT_FOUND": 
            case "SESSION_NOT_ACTIVE": 
            case "SESSION_SIGNATURE_INVALID": {
                LOGGER.error("Failed to log out. Description: " + sessionLogoutResponse.getErrorDescription());
                this.disposeScreen(evt);
                break;
            }
            case "CLIENT_VERIFICATION_FAILURE": {
                LOGGER.error("This client version is obsolete. Upgrade to latest client version");
                this.showErrorMessage(evt, veCtxt, "This client version is obsolete. Please keep your system online to upgrade to latest version");
                break;
            }
            default: {
                this.showErrorMessage(evt, veCtxt, "Failed to log out due to server error. Do Operator Sync to continue");
            }
        }
    }

    private void showErrorMessage(ILiteEvent evt, IVisualExecutionContext veCtxt, String message) {
        if (veCtxt != null) {
            veCtxt.cancel();
        }
        L10nOptionPaneBuilder.getInstance().showError((Object)message, (Component)this.osd.getWindowForScaffold(evt.getScaffoldId()), new Object[0]);
    }

    private void disposeScreen(ILiteEvent evt) {
        this.shutdownHook.cleanupFindAadhaarGeneratedFile();
        this.osd.dispose(evt.getScaffoldId());
        this.tracker.reset();
        String sId = this.osd.compose("loginWin", "loginView");
        this.osd.display(sId, ScaffoldPlacement.CENTERED);
    }
}

