/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.shared;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.ui.shared.l10n.MsgKeysILV;
import in.gov.uidai.swing.tilv.FBExcludePatternDocument;
import in.gov.uidai.swing.tilv.FBMobileNumberMaxLengthDocument;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class InlineValidations {
    private static final int MAX_NAME_FIELD_LENGTH = 99;
    private static final int MAX_ADDR_FIELD_LENGTH = 60;
    private final IResourceBundleContext resBundleCtxt;

    public InlineValidations(IResourceBundleContext rbc) {
        this.resBundleCtxt = rbc;
    }

    public void applyFullNameILV(JTextField nameField) {
        this.applyFullNameILV(nameField, 99);
    }

    public void applyFullNameILV(JTextField nameField, int maxNameLength) {
        FBExcludePatternDocument doc = new FBExcludePatternDocument(nameField, maxNameLength);
        doc.excludePattern(".*[[^a-z]&&[^A-Z]&&[^ \\.'()]].*", this.resBundleCtxt.getMessage((Object)MsgKeysILV.FULLNAME, new Object[0]));
        doc.excludePattern(".*[ ]{2,}.*", this.resBundleCtxt.getMessage((Object)MsgKeysILV.DOUBLE_SPACE, new Object[0]));
        doc.excludePattern(".*[\\.]{2,}.*", this.resBundleCtxt.getMessage((Object)MsgKeysILV.DOUBLE_DOT, new Object[0]));
        doc.excludePattern(".*[']{2,}.*", this.resBundleCtxt.getMessage((Object)MsgKeysILV.DOUBLE_QUOTE, new Object[0]));
        doc.excludePattern(new String[]{".*[(]{1,}.*", ".*[)]{1,}.*"}, this.resBundleCtxt.getMessage((Object)MsgKeysILV.DOUBLE_BRACKET, new Object[0]));
        nameField.setDocument((Document)doc);
    }

    public void applyAppointmentIdILV(JTextField appointmentField) {
        FBExcludePatternDocument doc = new FBExcludePatternDocument(appointmentField, 30);
        doc.excludePattern("[^A-Z0-9]", this.resBundleCtxt.getMessage((Object)MsgKeysILV.ALPHA_NUMERIC, new Object[0]));
        appointmentField.setDocument((Document)doc);
    }

    public void applyFreeAddressILV(JTextField addrField) {
        FBExcludePatternDocument doc = new FBExcludePatternDocument(addrField, 60);
        doc.excludePattern(".*[[^a-z]&&[^A-Z]&&[^0-9]&&[^ \\.\\\\/#\\-,()]].*", this.resBundleCtxt.getMessage((Object)MsgKeysILV.ADDR, new Object[0]));
        doc.excludePattern(".*[ ]{2,}.*", this.resBundleCtxt.getMessage((Object)MsgKeysILV.DOUBLE_SPACE, new Object[0]));
        doc.excludePattern(".*[\\.]{2,}.*", this.resBundleCtxt.getMessage((Object)MsgKeysILV.DOUBLE_DOT, new Object[0]));
        doc.excludePattern(".*[#]{2,}.*", this.resBundleCtxt.getMessage((Object)MsgKeysILV.DOUBLE_HASH, new Object[0]));
        doc.excludePattern(".*[-]{2,}.*", this.resBundleCtxt.getMessage((Object)MsgKeysILV.DOUBLE_HYPHEN, new Object[0]));
        doc.excludePattern(".*[,]{2,}.*", this.resBundleCtxt.getMessage((Object)MsgKeysILV.DOUBLE_COMMA, new Object[0]));
        addrField.setDocument((Document)doc);
    }

    public void applyEmailILV(JTextField emailField) {
        FBExcludePatternDocument doc = new FBExcludePatternDocument(emailField, 50);
        doc.excludePattern(".*[[^a-z]&&[^A-Z]&&[^0-9]&&[^@+-\\.\\^_]]+.*", this.resBundleCtxt.getMessage((Object)MsgKeysILV.EMAIL_BAD, new Object[0]));
        doc.excludePattern("[@+-\\.\\^_].*", this.resBundleCtxt.getMessage((Object)MsgKeysILV.EMAIL_LCHAR, new Object[0]));
        doc.excludePattern(".*[@].*[@].*", this.resBundleCtxt.getMessage((Object)MsgKeysILV.EMAIL_DOUBLE_AT, new Object[0]));
        doc.excludePattern(".*[,]{2,}.*", this.resBundleCtxt.getMessage((Object)MsgKeysILV.DOUBLE_COMMA, new Object[0]));
        emailField.setDocument((Document)doc);
    }

    public void applyMobileILV(JTextField mobileField, JComboBox isdCodeField) {
        FBMobileNumberMaxLengthDocument doc = new FBMobileNumberMaxLengthDocument(mobileField, isdCodeField, "+91");
        doc.setMaxLength(15);
        doc.excludePattern(".*[^0-9].*", this.resBundleCtxt.getMessage((Object)MsgKeysILV.NUMERIC, new Object[0]));
        doc.excludePattern("[0].*", this.resBundleCtxt.getMessage((Object)MsgKeysILV.MOBILE_LZERO, new Object[0]));
        mobileField.setDocument((Document)doc);
    }

    public void applyAadhaarNumberILV(JTextField field) {
        FBExcludePatternDocument doc = new FBExcludePatternDocument(field, 12);
        doc.excludePattern(".*[^0-9].*", this.resBundleCtxt.getMessage((Object)MsgKeysILV.NUMERIC, new Object[0]));
        field.setDocument((Document)doc);
    }

    public void applyPIN(JTextField value, int maxLength) {
        FBExcludePatternDocument doc = new FBExcludePatternDocument(value, maxLength);
        doc.excludePattern(".*[^0-9].*", this.resBundleCtxt.getMessage((Object)MsgKeysILV.NUMERIC, new Object[0]));
        value.setDocument((Document)doc);
    }

    public void applyTransliteratedFullNameILV(JTextField nameField, int maxNameLength) {
        FBExcludePatternDocument doc = new FBExcludePatternDocument(nameField, maxNameLength);
        doc.excludePattern(".*(?![ \\.'()])[\\p{P}\\p{S}].*", this.resBundleCtxt.getMessage((Object)MsgKeysILV.FULLNAME, new Object[0]));
        doc.excludePattern(".*[ ]{2,}.*", this.resBundleCtxt.getMessage((Object)MsgKeysILV.DOUBLE_SPACE, new Object[0]));
        doc.excludePattern(".*[\\.]{2,}.*", this.resBundleCtxt.getMessage((Object)MsgKeysILV.DOUBLE_DOT, new Object[0]));
        doc.excludePattern(".*[']{2,}.*", this.resBundleCtxt.getMessage((Object)MsgKeysILV.DOUBLE_QUOTE, new Object[0]));
        doc.excludePattern(new String[]{".*[(]{1,}.*", ".*[)]{1,}.*"}, this.resBundleCtxt.getMessage((Object)MsgKeysILV.DOUBLE_BRACKET, new Object[0]));
        nameField.setDocument((Document)doc);
    }

    public void applyTransliteratedFullNameILV(JTextField nameField) {
        this.applyTransliteratedFullNameILV(nameField, 99);
    }

    public void applyTransliteratedFreeAddressILV(JTextField addrField) {
        FBExcludePatternDocument doc = new FBExcludePatternDocument(addrField, 60);
        doc.excludePattern(".*[ ]{2,}.*", this.resBundleCtxt.getMessage((Object)MsgKeysILV.DOUBLE_SPACE, new Object[0]));
        doc.excludePattern(".*[\\.]{2,}.*", this.resBundleCtxt.getMessage((Object)MsgKeysILV.DOUBLE_DOT, new Object[0]));
        doc.excludePattern(".*[#]{2,}.*", this.resBundleCtxt.getMessage((Object)MsgKeysILV.DOUBLE_HASH, new Object[0]));
        doc.excludePattern(".*[-]{2,}.*", this.resBundleCtxt.getMessage((Object)MsgKeysILV.DOUBLE_HYPHEN, new Object[0]));
        doc.excludePattern(".*[,]{2,}.*", this.resBundleCtxt.getMessage((Object)MsgKeysILV.DOUBLE_COMMA, new Object[0]));
        addrField.setDocument((Document)doc);
    }
}

