/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.shared;

import in.gov.uidai.ec.escapi.StationInfoStoreException;
import in.gov.uidai.ec.icas.preference.PreferencesPostProcessor;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.security.sapi.SecurityProvider;
import in.gov.uidai.ec.service.presync.IPreSyncPreference;
import in.gov.uidai.ec.service.verification.ClientChecksumVerificationFailedException;
import in.gov.uidai.ec.service.verification.ClientNotRegisteredException;
import in.gov.uidai.ec.service.verification.ClientVersionMismatchException;
import in.gov.uidai.ec.service.verification.DayLimitReachedException;
import in.gov.uidai.ec.service.verification.DeRegisteredException;
import in.gov.uidai.ec.service.verification.DeRegistrationInProgressException;
import in.gov.uidai.ec.service.verification.EnrolServiceClientStatusVerificationException;
import in.gov.uidai.ec.service.verification.ForceShutDownException;
import in.gov.uidai.ec.service.verification.GpsUpdateRequiredException;
import in.gov.uidai.ec.service.verification.JarIntegrityCheckFailedException;
import in.gov.uidai.ec.service.verification.LVSChecksumVerificationFailedException;
import in.gov.uidai.ec.service.verification.MachineCodeCalculationException;
import in.gov.uidai.ec.service.verification.MachineCodeChangedException;
import in.gov.uidai.ec.service.verification.MaxUnUploadedCountReachedException;
import in.gov.uidai.ec.service.verification.OTAUpdateAvailableException;
import in.gov.uidai.ec.service.verification.OperatorInactiveException;
import in.gov.uidai.ec.service.verification.OperatorSuspendedException;
import in.gov.uidai.ec.service.verification.PendingUploadsException;
import in.gov.uidai.ec.service.verification.PendingUploadsForTodayException;
import in.gov.uidai.ec.service.verification.SessionExpiredException;
import in.gov.uidai.ec.service.verification.SessionNotFoundException;
import in.gov.uidai.ec.service.verification.SystemBackDatedException;
import in.gov.uidai.ec.service.verification.UnUploadedMaxAllowedDaysReachedException;
import in.gov.uidai.ec.service.verification.VerificationException;
import in.gov.uidai.ec.service.verification.VerificationService;
import in.gov.uidai.ec.ui.main.IMainWinProvider;
import in.gov.uidai.ec.ui.main.MainWinDecorator;
import in.gov.uidai.ec.ui.shared.ApplicationUIControl;
import in.gov.uidai.ec.ui.shared.VerificationMessages;
import in.gov.uidai.ec.ui.shared.l10n.MsgKeysLogin;
import in.gov.uidai.litef.devapi.ILiteEvent;
import in.gov.uidai.litef.devapi.ILiteScaffold;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.litef.devapi.IOnScreenDisplay;
import in.gov.uidai.litef.devapi.IOnScreenDisplayAware;
import in.gov.uidai.litef.devapi.IViewElement;
import in.gov.uidai.litef.widgets.ToolBarElement;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerificationGuard
implements IOnScreenDisplayAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(VerificationGuard.class);
    private VerificationService verificationService;
    private IOnScreenDisplay osd;
    private IMainWinProvider mainWinProv;
    private IPreSyncPreference preSyncPref;
    private IResourceBundleContext rbCtxt;

    public void setVerificationService(VerificationService verificationService) {
        this.verificationService = verificationService;
    }

    public VerificationService getVerificationService() {
        return this.verificationService;
    }

    public final void setMainWinProvider(IMainWinProvider mwp) {
        this.mainWinProv = mwp;
    }

    public void populateOnScreenDisplay(IOnScreenDisplay osd) {
        this.osd = osd;
    }

    public final void setPreSyncPreference(IPreSyncPreference preSyncPref) {
        this.preSyncPref = preSyncPref;
        SecurityProvider.getInst().setKeySize(this.preSyncPref.getKeySize());
    }

    public void setResourceBundleContext(IResourceBundleContext ctxt) {
        this.rbCtxt = ctxt;
    }

    public void verifyPropertyLoadError() {
        if (PreferencesPostProcessor.PropertiesLoadError) {
            this.showErrorAndExit(PreferencesPostProcessor.PropertiesLoadErrorDesc, new VerificationException());
        }
    }

    public void verifyIntegrity() {
        try {
            this.verificationService.verifyJarIntegrity();
            this.verificationService.isLVSCheckSumValid();
        }
        catch (JarIntegrityCheckFailedException e) {
            this.showErrorAndExit(VerificationMessages.getJarIntegrityFailed(), new VerificationException((Exception)((Object)e)));
        }
        catch (LVSChecksumVerificationFailedException e) {
            this.showErrorAndExit(VerificationMessages.getLVSCheckSumVerificationFailed(), (VerificationException)e);
        }
        catch (Exception e) {
            LOGGER.error(VerificationMessages.getUnknownJarIntegrityError(), (Throwable)e);
            this.showErrorAndExit(VerificationMessages.getUnknownJarIntegrityError(), new VerificationException(e));
        }
    }

    public void verifyAppRegistration() {
        try {
            this.verificationService.isDeRegistered();
            this.verificationService.isRegistered();
            this.verificationService.verifyAppVersion();
        }
        catch (DeRegisteredException e) {
            this.showErrorAndExit(VerificationMessages.getDeRegistered(), (VerificationException)e);
        }
        catch (ClientNotRegisteredException e) {
            this.showErrorAndExit(this.rbCtxt.getMessage((Object)MsgKeysLogin.CLIENT_NOT_REGISTERED, new Object[0]), (VerificationException)e);
        }
        catch (ClientVersionMismatchException e) {
            this.showErrorAndExit(this.rbCtxt.getMessage((Object)MsgKeysLogin.CONFIG_VERSION_MISMATCH, new Object[0]), (VerificationException)e);
        }
        catch (Exception e) {
            LOGGER.error(VerificationMessages.getUnknownAppRegistrationError(), (Throwable)e);
            this.showErrorAndExit(VerificationMessages.getUnknownAppRegistrationError(), new VerificationException(e));
        }
    }

    public void verifyEnrolServiceClientStatus() {
        try {
            this.verificationService.verifyEnrolServiceClientStatus();
        }
        catch (EnrolServiceClientStatusVerificationException e) {
            this.showErrorAndExit(VerificationMessages.getEnrolServiceClientPing(), (VerificationException)e);
        }
        catch (Exception e) {
            LOGGER.error(VerificationMessages.getUnknownStartupVerificationError(), (Throwable)e);
        }
    }

    public boolean verifyOnStartUp(VerificationService.Type type, ILiteEvent evt) {
        try {
            this.verificationService.verifyOnStartup(type);
        }
        catch (OTAUpdateAvailableException e) {
            this.showMessageAndCloseApplication(VerificationMessages.getOTAUpdateAvailable(), (Exception)((Object)e), evt);
            return false;
        }
        catch (MachineCodeCalculationException | MachineCodeChangedException e) {
            this.disableEnrolmentForMachineCodeChanged(VerificationMessages.getMachineCodeChanged());
            return false;
        }
        catch (SessionExpiredException e) {
            this.disableEnrolment("Operator Sync Notification", VerificationMessages.getSessionExpired(e.getInterval(), e.getStartTime()), false);
            return false;
        }
        catch (SessionNotFoundException e) {
            this.launchOpSync();
            return false;
        }
        catch (ClientChecksumVerificationFailedException e) {
            this.showErrorAndCloseApplication(VerificationMessages.getClientCheckSumVerificationFailed(), (Exception)((Object)e), evt);
            return false;
        }
        catch (LVSChecksumVerificationFailedException e) {
            this.showErrorAndCloseApplication(VerificationMessages.getLVSCheckSumVerificationFailed(), (Exception)((Object)e), evt);
            return false;
        }
        catch (DeRegistrationInProgressException e) {
            this.disableEnrolment("DeRegistration in Progress Notification", VerificationMessages.getDeRegistrationInProgress(), true);
            return false;
        }
        catch (ForceShutDownException e) {
            this.disableEnrolment("Force Shutdown Notification", VerificationMessages.getForceClosed(this.preSyncPref.getClientMessage()), false);
            return false;
        }
        catch (MaxUnUploadedCountReachedException e) {
            this.disableEnrolment("Force Close Notification", VerificationMessages.getMaxUnUploadedCountReached(e.getUnUploadCount(), e.getMaxUnUploadCount()), false);
            return false;
        }
        catch (UnUploadedMaxAllowedDaysReachedException e) {
            this.disableEnrolment("Force Close Notification", VerificationMessages.getUnUploadedMaxAllowedDaysReached(e.getMaxAllowedDays()), false);
            return false;
        }
        catch (EnrolServiceClientStatusVerificationException e) {
            this.showErrorAndCloseApplication(VerificationMessages.getEnrolServiceClientPing(), (Exception)((Object)e), evt);
            return false;
        }
        catch (PendingUploadsException e) {
            this.disableEnrolment("Force Close Notification", VerificationMessages.getPendingUploads(e.getOldestUnUploadedDate(), e.getOldestUnUploadedEid()), false);
            return false;
        }
        catch (PendingUploadsForTodayException e) {
            this.showWarning(VerificationMessages.getPendingUploadsForToday(e.getPendingUploadCountForToday()));
            return true;
        }
        catch (DayLimitReachedException e) {
            this.disableEnrolment("Force Close Notification", VerificationMessages.getDayLimitReached(e.getPacketsAsOfToday(), e.getMaxPacketsPerDay()), false);
            return false;
        }
        catch (SystemBackDatedException e) {
            this.disableEnrolment("System Backdated Notification", VerificationMessages.getSystemBackDated(e.getAppStartTime(), e.getLastTransTime()), false);
            return false;
        }
        catch (GpsUpdateRequiredException e) {
            this.disableEnrolmentForGPS(e.getPeriod());
            return false;
        }
        catch (OperatorSuspendedException e) {
            this.disableEnrolment("Force Close Notification", VerificationMessages.getSuspendedOperator(), false);
            return false;
        }
        catch (OperatorInactiveException e) {
            this.disableEnrolment("Force Close Notification", VerificationMessages.getInactiveOperator(), false);
            return false;
        }
        catch (IOException e) {
            LOGGER.info("Failed to connect to Enrol Service Client!!!");
            this.showError("Failed to connect to Enrol Service Client. Make sure it is running");
            return false;
        }
        catch (StationInfoStoreException e) {
            LOGGER.info("Error storing/retrieving parameters in Enrol Service Client", (Object[])e.getStackTrace());
            this.showError("Failed to fetch details from Enrol Service Client");
            return false;
        }
        catch (Exception e) {
            LOGGER.error(VerificationMessages.getUnknownStartupVerificationError(), (Throwable)e);
            return false;
        }
        return true;
    }

    private void showErrorAndExit(String userMsg, VerificationException e) {
        LOGGER.error(userMsg + ": " + e.getMessage());
        LOGGER.debug(userMsg, (Throwable)e);
        L10nOptionPaneBuilder.getInstance().showError((Object)userMsg, null, new Object[0]);
        System.exit(0);
    }

    private void showErrorAndCloseApplication(String userMsg, Exception e, ILiteEvent evt) {
        LOGGER.error(userMsg + ": " + e.getMessage());
        LOGGER.debug(userMsg, (Throwable)e);
        L10nOptionPaneBuilder.getInstance().showError((Object)userMsg, null, new Object[0]);
        this.osd.dispose(evt.getScaffoldId());
        System.exit(0);
    }

    private void showWarning(String userMsg) {
        LOGGER.warn(userMsg);
        L10nOptionPaneBuilder.getInstance().showWarning((Object)userMsg, null);
    }

    private void showError(String userMsg) {
        L10nOptionPaneBuilder.getInstance().showError((Object)userMsg, null, new Object[0]);
    }

    private void showMessageAndCloseApplication(String userMsg, Exception e, ILiteEvent evt) {
        LOGGER.error(userMsg + ": " + e.getMessage());
        LOGGER.debug(userMsg, (Throwable)e);
        L10nOptionPaneBuilder.getInstance().showInfo((Object)userMsg, null, new Object[0]);
        this.osd.dispose(evt.getScaffoldId());
        System.exit(0);
    }

    private void disableEnrolment(String header, String msg, boolean enableDeReg) {
        ApplicationUIControl.disableEnrolments(this.osd, this.osd.getScaffold(this.mainWinProv.getMainWinId()), header, msg, enableDeReg);
    }

    private void disableEnrolmentForMachineCodeChanged(String msg) {
        String viewId = this.osd.compose("mainWin", "machineCodeChangedViewPeer");
        ILiteView view = this.osd.getView(this.osd.getScaffold(viewId).getViewId());
        ((IViewElement)view.getElementMap().get("eID_OpSync_MachineCode")).set("text", (Object)msg);
        ILiteScaffold scaf = this.osd.getScaffold(this.mainWinProv.getMainWinId());
        Map eMap = scaf.getElementMap();
        ((IViewElement)eMap.get("hID_MainWin_Header")).set("text", (Object)"Enrolment blocked");
    }

    private void disableEnrolmentForGPS(long gpsUpdatePeriod) {
        String viewId = this.osd.compose("mainWin", "gpsNotifyView");
        ILiteScaffold scaf = this.osd.getScaffold(viewId);
        ((IViewElement)scaf.getElementMap().get("hID_MainWin_Header")).set("text", (Object)"GPS Notification");
        long days = TimeUnit.DAYS.convert(gpsUpdatePeriod, TimeUnit.MILLISECONDS);
        String msg = days > 1L ? VerificationMessages.getGpsUpdateRequiredSince(days) : VerificationMessages.getGpsUpdatedRequired();
        ILiteView view = this.osd.getView(scaf.getViewId());
        ((IViewElement)view.getElementMap().get("eID_Gps_Notify")).set("text", (Object)msg);
    }

    public void launchOpSync() {
        Map eMap = this.osd.getScaffold(this.mainWinProv.getMainWinId()).getElementMap();
        ((IViewElement)eMap.get("hID_OpSync_ToolBut")).call("click");
        this.removeKeyBindings(eMap);
    }

    private void removeKeyBindings(Map<String, IViewElement> elementMap) {
        ToolBarElement toolbarEl = (ToolBarElement)elementMap.get("hID_MainWin_ToolBar");
        MainWinDecorator.getEnrolKeys().forEach(key -> toolbarEl.set("removeKeyBinding", key));
    }
}

