/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.shared.displayimage;

import in.gov.uidai.ec.service.document.DocumentType;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.ui.ControllerBase;
import in.gov.uidai.ec.ui.shared.displayimage.DisplayImageView;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.SwingUtilities;

public class DisplayImageController
extends ControllerBase {
    private final DisplayImageView viewElements;
    protected EnrollmentService enrollmentService;
    private int currentPageNo;
    private final DocumentType docType;
    private final int totalPage;

    public DisplayImageController(DisplayImageView viewElement) {
        super(viewElement.getView());
        this.viewElements = viewElement;
        this.enrollmentService = viewElement.enrollmentService;
        this.docType = this.enrollmentService.getDocManager().getPreviewDocType();
        this.currentPageNo = 1;
        boolean bytesNotPresent = this.enrollmentService.getDocManager().getScannedDoc() != null && this.enrollmentService.getDocManager().getScannedDoc().getConvertedBytes(0).length == 0;
        this.totalPage = bytesNotPresent || this.docType == null ? 1 : this.enrollmentService.getDocManager().getScannedDoc().getTotalScannedPages();
        this.viewElements.nextPage.setEnabled(this.totalPage > 1);
        this.viewElements.prevPage.setEnabled(false);
        this.addActionListener(this.viewElements.nextPage, this::onClickNextPage);
        this.addActionListener(this.viewElements.prevPage, this::onClickPreviousPage);
        this.addActionListener(this.viewElements.saveBut, this::onClickSaveButton);
    }

    private void onClickNextPage(ActionEvent event) {
        this.viewElements.prevPage.setEnabled(true);
        if (this.totalPage != this.currentPageNo) {
            this.viewElements.nextPage.setEnabled(true);
            ++this.currentPageNo;
            this.viewElements.pageNumber.setText("Page No. " + this.currentPageNo);
            this.viewElements.viewer.setImage(this.enrollmentService.getDocManager().getScannedDoc().getConvertedBytes(this.currentPageNo - 1));
        } else {
            this.viewElements.nextPage.setEnabled(false);
        }
    }

    private void onClickPreviousPage(ActionEvent event) {
        if (this.currentPageNo != 1) {
            this.viewElements.nextPage.setEnabled(true);
            this.viewElements.prevPage.setEnabled(true);
            --this.currentPageNo;
            this.viewElements.pageNumber.setText("Page No. " + this.currentPageNo);
            this.viewElements.viewer.setImage(this.enrollmentService.getDocManager().getScannedDoc().getConvertedBytes(this.currentPageNo - 1));
        } else {
            this.viewElements.prevPage.setEnabled(false);
        }
    }

    private void onClickSaveButton(ActionEvent actionEvent) {
        SwingUtilities.getWindowAncestor((JButton)actionEvent.getSource()).dispose();
    }
}

