/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.shared.displayimage;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.swing.imgvu.ImageViewer;
import in.gov.uidai.ec.swing.imgvu.ImageViewerElementFactory;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.ec.ui.shared.displayimage.DisplayImageController;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysAction;
import in.gov.uidai.litef.beans.stdview.ExportViewElement;
import in.gov.uidai.litef.beans.stdview.StandardViewPeer;
import in.gov.uidai.swing.TransparentBox;
import in.gov.uidai.swing.l10n.L10nDecorator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class DisplayImageView
extends StandardViewPeer {
    private IResourceBundleContext resBundleCtxt;
    protected EnrollmentService enrollmentService;
    private IUIPreference uiPref;
    protected JButton prevPage;
    protected JButton nextPage;
    protected JLabel pageNumber;
    protected JButton saveBut;
    @ExportViewElement(as="eID_display_image_preview", using=ImageViewerElementFactory.class)
    protected ImageViewer viewer;

    public void setResourceBundleContext(IResourceBundleContext ctxt) {
        this.resBundleCtxt = ctxt;
    }

    public void setUIPreference(IUIPreference pref) {
        this.uiPref = pref;
    }

    public void setEnrollmentService(EnrollmentService enrollmentService) {
        this.enrollmentService = enrollmentService;
    }

    protected void prepareImpl() {
        L10nDecorator ldeco = new L10nDecorator(this.resBundleCtxt, this.uiPref.getApplicationLocalize(false));
        this.viewer = new ImageViewer();
        TransparentBox tbox = new TransparentBox();
        tbox.setLayout((LayoutManager)new BorderLayout());
        Dimension resolution = Toolkit.getDefaultToolkit().getScreenSize();
        tbox.setPreferredSize(new Dimension((int)resolution.getWidth() - 200, (int)resolution.getHeight() - 200));
        tbox.setLocation((int)resolution.getWidth() / 4, 0);
        TransparentBox axnPanel = new TransparentBox((LayoutManager)new FlowLayout(0, 0, 2));
        axnPanel.add(Box.createHorizontalStrut(20));
        axnPanel.add((Component)new JLabel("Zoom Levels: "));
        axnPanel.add((Component)this.viewer.getNormalSizeButton());
        axnPanel.add((Component)this.viewer.getAutoFitButton());
        axnPanel.add(Box.createHorizontalStrut(30));
        TransparentBox bottomPanel = new TransparentBox((LayoutManager)new FlowLayout(1, 0, 2));
        this.pageNumber = new JLabel("Page No. 1");
        bottomPanel.add((Component)this.pageNumber);
        bottomPanel.add(Box.createHorizontalStrut(30));
        this.nextPage = new JButton("Next Page");
        this.nextPage.setEnabled(false);
        this.saveBut = new JButton(this.resBundleCtxt.getMessage((Object)LabelKeysAction.SAVE, new Object[0]));
        this.saveBut.setEnabled(true);
        bottomPanel.add(Box.createHorizontalStrut(20));
        this.prevPage = new JButton("Previous Page");
        this.prevPage.setEnabled(false);
        bottomPanel.add((Component)this.saveBut);
        tbox.add((Component)axnPanel, (Object)"North");
        tbox.add((Component)bottomPanel, (Object)"South");
        tbox.add((Component)this.viewer, (Object)"Center");
        this.setContentPane((JComponent)tbox);
        new DisplayImageController(this);
    }

    protected void enableImpl(boolean flag) {
    }

    protected void disposeImpl() {
    }
}

